/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;
import paulscode.sound.Vector3D;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound;

public class SourceJavaSound
extends Source {
    protected ChannelJavaSound channelJavaSound;
    public ListenerData listener;
    private float pan;

    public SourceJavaSound(ListenerData listenerData, boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f2, float f3, float f4, int n2, float f5, boolean bl5) {
        super(bl2, bl3, bl4, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, bl5);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, Source source, SoundBuffer soundBuffer) {
        super(source, soundBuffer);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listenerData, AudioFormat audioFormat, boolean bl2, String string, float f2, float f3, float f4, int n2, float f5) {
        super(audioFormat, bl2, string, f2, f3, f4, n2, f5);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listenerData;
        this.positionChanged();
    }

    public void cleanup() {
        super.cleanup();
    }

    public void changeSource(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f2, float f3, float f4, int n2, float f5, boolean bl5) {
        super.changeSource(bl2, bl3, bl4, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, bl5);
        if (this.channelJavaSound != null) {
            this.channelJavaSound.setLooping(bl4);
        }
        this.positionChanged();
    }

    public void listenerMoved() {
        this.positionChanged();
    }

    public void setPosition(float f2, float f3, float f4) {
        super.setPosition(f2, f3, f4);
        this.positionChanged();
    }

    public void positionChanged() {
        this.calculateGain();
        this.calculatePan();
        this.calculatePitch();
    }

    public void setPitch(float f2) {
        super.setPitch(f2);
        this.calculatePitch();
    }

    public void setAttenuation(int n2) {
        super.setAttenuation(n2);
        this.calculateGain();
    }

    public void setDistOrRoll(float f2) {
        super.setDistOrRoll(f2);
        this.calculateGain();
    }

    public void play(Channel channel) {
        boolean bl2;
        if (!this.active()) {
            if (this.toLoop) {
                this.toPlay = true;
            }
            return;
        }
        if (channel == null) {
            this.errorMessage("Unable to play source, because channel was null");
            return;
        }
        boolean bl3 = bl2 = this.channel != channel;
        if (this.channel != null && this.channel.attachedSource != this) {
            bl2 = true;
        }
        boolean bl4 = this.paused();
        boolean bl5 = this.stopped();
        super.play(channel);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        if (bl2) {
            if (this.channelJavaSound != null) {
                this.channelJavaSound.setLooping(this.toLoop);
            }
            if (!this.toStream) {
                if (this.soundBuffer == null) {
                    this.errorMessage("No sound buffer to play");
                    return;
                }
                this.channelJavaSound.attachBuffer(this.soundBuffer);
            }
        }
        this.positionChanged();
        if (bl5 || !this.playing()) {
            if (this.toStream && !bl4) {
                this.preLoad = true;
            }
            this.channel.play();
        }
    }

    public boolean preLoad() {
        if (this.codec == null) {
            return false;
        }
        this.codec.initialize(this.filenameURL.getURL());
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (int i2 = 0; i2 < SoundSystemConfig.getNumberStreamingBuffers(); ++i2) {
            this.soundBuffer = this.codec.read();
            if (this.soundBuffer == null || this.soundBuffer.audioData == null) break;
            linkedList.add(this.soundBuffer.audioData);
        }
        this.channelJavaSound.resetStream(this.codec.getAudioFormat());
        this.positionChanged();
        this.channel.preLoadBuffers(linkedList);
        this.preLoad = false;
        return true;
    }

    public void calculateGain() {
        float f2 = this.position.x - this.listener.position.x;
        float f3 = this.position.y - this.listener.position.y;
        float f4 = this.position.z - this.listener.position.z;
        this.distanceFromListener = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        switch (this.attModel) {
            case 2: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                if (this.distanceFromListener >= this.distOrRoll) {
                    this.gain = 0.0f;
                    break;
                }
                this.gain = 1.0f - this.distanceFromListener / this.distOrRoll;
                break;
            }
            case 1: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                float f5 = 5.0E-4f;
                float f6 = this.distOrRoll * this.distanceFromListener * this.distanceFromListener * f5;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                }
                this.gain = 1.0f / (1.0f + f6);
                break;
            }
            default: {
                this.gain = 1.0f;
            }
        }
        if (this.gain > 1.0f) {
            this.gain = 1.0f;
        }
        if (this.gain < 0.0f) {
            this.gain = 0.0f;
        }
        this.gain *= this.sourceVolume * SoundSystemConfig.getMasterGain() * Math.abs(this.fadeOutGain) * this.fadeInGain;
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setGain(this.gain);
        }
    }

    public void calculatePan() {
        Vector3D vector3D = this.listener.up.cross(this.listener.lookAt);
        vector3D.normalize();
        float f2 = this.position.dot(this.position.subtract(this.listener.position), vector3D);
        float f3 = this.position.dot(this.position.subtract(this.listener.position), this.listener.lookAt);
        vector3D = null;
        float f4 = (float)Math.atan2(f2, f3);
        this.pan = (float)(-Math.sin(f4));
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (this.attModel == 0) {
                this.channelJavaSound.setPan(0.0f);
            } else {
                this.channelJavaSound.setPan(this.pan);
            }
        }
    }

    public void calculatePitch() {
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setPitch(this.pitch);
        }
    }
}

