/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.render;

import net.minecraft.client.Minecraft;
import net.minecraft.move.SmartMoving;
import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.SmartMovingFactory;
import net.minecraft.move.SmartMovingSelf;
import net.minecraft.move.render.IRenderPlayer;
import net.minecraft.move.render.SmartMovingModel;
import org.lwjgl.opengl.GL11;

public class SmartMovingRender
extends SmartMovingContext {
    public IRenderPlayer irp;
    public SmartMovingModel modelBipedMain;
    public SmartMovingModel modelArmorChestplate;
    public SmartMovingModel modelArmor;
    protected SmartMovingModel[] modelPlayers;
    private static int _iOffset;
    private static int _jOffset;
    private static Minecraft _minecraft;

    public SmartMovingRender(IRenderPlayer irp) {
        this.irp = irp;
        this.modelBipedMain = irp.createModel(irp.getModelBipedMain(), 0.0f, 0, 0).getModel();
        this.modelArmorChestplate = irp.createModel(irp.getModelArmorChestplate(), 1.0f, 1, 2).getModel();
        this.modelArmor = irp.createModel(irp.getModelArmor(), 0.5f, 1, 0).getModel();
        irp.initialize(this.modelBipedMain.mp, this.modelArmorChestplate.mp, this.modelArmor.mp, 0.5f);
        this.modelPlayers = new SmartMovingModel[]{this.modelBipedMain, this.modelArmorChestplate, this.modelArmor};
    }

    public void renderPlayer(of entityplayer, double d2, double d1, double d22, float f2, float renderPartialTicks) {
        SmartMoving moving = SmartMovingFactory.getInstance(entityplayer);
        if (moving != null) {
            boolean isInventory = d2 == 0.0 && d1 == 0.0 && d22 == 0.0 && f2 == 0.0f && renderPartialTicks == 1.0f;
            boolean isClimb = moving.isClimbing && !moving.isCrawling && !moving.isCrawlClimbing && !moving.isClimbJumping;
            boolean isClimbJump = moving.isClimbJumping;
            int handsClimbType = moving.actualHandsClimbType;
            int feetClimbType = moving.actualFeetClimbType;
            boolean isHandsVineClimbing = moving.isHandsVineClimbing;
            boolean isFeetVineClimbing = moving.isFeetVineClimbing;
            boolean isCeilingClimb = moving.isCeilingClimbing;
            boolean isSwim = moving.isSwimming && !moving.isDipping;
            boolean isDive = moving.isDiving;
            boolean isLevitate = moving.isLevitating;
            boolean isCrawl = moving.isCrawling && !moving.isClimbing;
            boolean isCrawlClimb = moving.isCrawlClimbing || moving.isClimbing && moving.isCrawling;
            boolean isJump = moving.isJumping();
            boolean isHeadJump = moving.isHeadJumping;
            boolean isFlying = moving.doFlyingAnimation();
            boolean isSlide = moving.isSliding;
            boolean isFalling = moving.doFallingAnimation();
            boolean isGenericSneaking = moving.isSlow;
            boolean isAngleJumping = moving.isAngleJumping();
            int angleJumpType = moving.angleJumpType;
            boolean isSleeping = moving.sp.bn();
            float smallOverGroundHeight = isCrawlClimb || isHeadJump ? (float)moving.getOverGroundHeight(5.0) : 0.0f;
            int overGroundBlockId = isHeadJump && smallOverGroundHeight < 5.0f ? moving.getOverGroundBlockId(smallOverGroundHeight) : -1;
            float totalVerticalDistance = moving.field_703_S_vertical - moving.field_704_R_vertical * (1.0f - renderPartialTicks);
            float currentVerticalSpeed = Math.min(1.0f, moving.field_705_Q_vertical + (moving.field_704_R_vertical - moving.field_705_Q_vertical) * renderPartialTicks);
            float totalDistance = moving.field_703_S_all - moving.field_704_R_all * (1.0f - renderPartialTicks);
            float currentSpeed = Math.min(1.0f, moving.field_705_Q_all + (moving.field_704_R_all - moving.field_705_Q_all) * renderPartialTicks);
            double distance = 0.0;
            double verticalDistance = 0.0;
            double horizontalDistance = 0.0;
            float currentCameraAngle = 0.0f;
            float currentVerticalAngle = 0.0f;
            float currentHorizontalAngle = 0.0f;
            if (!isInventory && (isFlying || isSwim || isDive || isCeilingClimb || isHeadJump || isSlide || isAngleJumping)) {
                double xDiff = moving.sp.t - moving.sp.q;
                double yDiff = moving.sp.u - moving.sp.r;
                double zDiff = moving.sp.v - moving.sp.s;
                verticalDistance = Math.abs(yDiff);
                horizontalDistance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                distance = Math.sqrt(horizontalDistance * horizontalDistance + verticalDistance * verticalDistance);
                currentCameraAngle = moving.sp.z / 57.295776f;
                currentVerticalAngle = (float)Math.atan(yDiff / horizontalDistance);
                if (Float.isNaN(currentVerticalAngle)) {
                    currentVerticalAngle = 1.5707964f;
                }
                if (Float.isNaN(currentHorizontalAngle = (float)(-Math.atan(xDiff / zDiff))) || isLevitate) {
                    currentHorizontalAngle = currentCameraAngle;
                } else if (zDiff < 0.0) {
                    currentHorizontalAngle = (float)((double)currentHorizontalAngle + Math.PI);
                }
            }
            for (int i2 = 0; i2 < this.modelPlayers.length; ++i2) {
                this.modelPlayers[i2].isInventory = isInventory;
                this.modelPlayers[i2].isClimb = isClimb;
                this.modelPlayers[i2].isClimbJump = isClimbJump;
                this.modelPlayers[i2].handsClimbType = handsClimbType;
                this.modelPlayers[i2].feetClimbType = feetClimbType;
                this.modelPlayers[i2].isHandsVineClimbing = isHandsVineClimbing;
                this.modelPlayers[i2].isFeetVineClimbing = isFeetVineClimbing;
                this.modelPlayers[i2].isCeilingClimb = isCeilingClimb;
                this.modelPlayers[i2].isSwim = isSwim;
                this.modelPlayers[i2].isDive = isDive;
                this.modelPlayers[i2].isCrawl = isCrawl;
                this.modelPlayers[i2].isCrawlClimb = isCrawlClimb;
                this.modelPlayers[i2].isJump = isJump;
                this.modelPlayers[i2].isHeadJump = isHeadJump;
                this.modelPlayers[i2].isSlide = isSlide;
                this.modelPlayers[i2].isFlying = isFlying;
                this.modelPlayers[i2].isLevitate = isLevitate;
                this.modelPlayers[i2].isFalling = isFalling;
                this.modelPlayers[i2].isGenericSneaking = isGenericSneaking;
                this.modelPlayers[i2].isAngleJumping = isAngleJumping;
                this.modelPlayers[i2].angleJumpType = angleJumpType;
                this.modelPlayers[i2].smallOverGroundHeight = smallOverGroundHeight;
                this.modelPlayers[i2].overGroundBlockId = overGroundBlockId;
                this.modelPlayers[i2].totalVerticalDistance = totalVerticalDistance;
                this.modelPlayers[i2].currentVerticalSpeed = currentVerticalSpeed;
                this.modelPlayers[i2].totalDistance = totalDistance;
                this.modelPlayers[i2].currentSpeed = currentSpeed;
                this.modelPlayers[i2].distance = distance;
                this.modelPlayers[i2].verticalDistance = verticalDistance;
                this.modelPlayers[i2].horizontalDistance = horizontalDistance;
                this.modelPlayers[i2].currentCameraAngle = currentCameraAngle;
                this.modelPlayers[i2].currentVerticalAngle = currentVerticalAngle;
                this.modelPlayers[i2].currentHorizontalAngle = currentHorizontalAngle;
                this.modelPlayers[i2].prevOuterRenderData = moving.prevOuterRenderData;
                this.modelPlayers[i2].isSleeping = isSleeping;
            }
            if (entityplayer.af() && !(entityplayer instanceof aup) && isCrawl) {
                d1 += 0.125;
            }
        }
        this.irp.superRenderPlayer(entityplayer, d2, d1, d22, f2, renderPartialTicks);
    }

    public void drawFirstPersonHand() {
        this.modelBipedMain.firstPerson = true;
        this.irp.superDrawFirstPersonHand();
        this.modelBipedMain.firstPerson = false;
    }

    public void rotatePlayer(of entityplayer, float totalTime, float actualRotation, float f2) {
        SmartMoving moving = SmartMovingFactory.getInstance(entityplayer);
        if (moving != null) {
            boolean isInventory;
            boolean bl2 = isInventory = f2 == 1.0f && moving.isp != null && moving.isp.getMcField().r instanceof aqt;
            if (!isInventory) {
                float workingAngle;
                float forwardRotation = entityplayer.B + (entityplayer.z - entityplayer.B) * f2;
                if (moving.isClimbing || moving.isClimbCrawling || moving.isCrawlClimbing || moving.isFlying || moving.isSwimming || moving.isDiving || moving.isCeilingClimbing || moving.isHeadJumping || moving.isSliding || moving.isAngleJumping()) {
                    entityplayer.aq = forwardRotation;
                }
                if (moving.sp.bn()) {
                    actualRotation = 0.0f;
                    forwardRotation = 0.0f;
                }
                if (moving.isp == null) {
                    Minecraft minecraft = SmartMovingRender.GetMinecraft();
                    workingAngle = -moving.sp.z;
                    workingAngle += minecraft.h.z;
                    if (minecraft.y.O == 2 && !minecraft.h.bn()) {
                        workingAngle += 180.0f;
                    }
                } else {
                    workingAngle = actualRotation - moving.prevOuterRenderData.rotateAngleY * 57.295776f;
                }
                for (int i2 = 0; i2 < this.modelPlayers.length; ++i2) {
                    this.modelPlayers[i2].actualRotation = actualRotation;
                    this.modelPlayers[i2].forwardRotation = forwardRotation;
                    this.modelPlayers[i2].workingAngle = workingAngle;
                }
                actualRotation = 0.0f;
            }
        }
        this.irp.superRotatePlayer(entityplayer, totalTime, actualRotation, f2);
    }

    public void renderPlayerAt(of entityplayer, double d2, double d1, double d22) {
        SmartMoving moving;
        if (entityplayer instanceof auq && (moving = SmartMovingFactory.getOtherSmartMoving(entityplayer.k)) != null && moving.heightOffset != 0.0f) {
            d1 += (double)moving.heightOffset;
        }
        this.irp.superRenderPlayerAt(entityplayer, d2, d1, d22);
    }

    public void renderName(of entityPlayer, double d2, double d1, double d22) {
        SmartMoving moving;
        boolean changedIsSneaking = false;
        boolean originalIsSneaking = false;
        if (Minecraft.s() && entityPlayer != this.irp.getRenderManager().h && (moving = SmartMovingFactory.getInstance(entityPlayer)) != null) {
            boolean temporaryIsSneaking = originalIsSneaking = entityPlayer.af();
            if (moving.isCrawling && !moving.isClimbing) {
                temporaryIsSneaking = (Boolean)SmartMovingRender.Config._crawlNameTag.value == false;
            } else if (originalIsSneaking) {
                temporaryIsSneaking = (Boolean)SmartMovingRender.Config._sneakNameTag.value == false;
            }
            boolean bl2 = changedIsSneaking = temporaryIsSneaking != originalIsSneaking;
            if (changedIsSneaking) {
                entityPlayer.a(temporaryIsSneaking);
            }
            if (moving.heightOffset == -1.0f) {
                d1 -= temporaryIsSneaking ? 1.0 : (double)1.3f;
            }
        }
        this.irp.superRenderName(entityPlayer, d2, d1, d22);
        if (changedIsSneaking) {
            entityPlayer.a(originalIsSneaking);
        }
    }

    public void renderSpecials(of entityplayer, float f2) {
        this.modelBipedMain.bipedCloak.setCurrent(entityplayer, f2);
        this.modelBipedMain.bipedCloak.doPopPush = true;
        this.modelBipedMain.bipedEars.doPopPush = true;
        this.irp.superRenderSpecials(entityplayer, f2);
        this.modelBipedMain.bipedEars.doPopPush = false;
        this.modelBipedMain.bipedCloak.doPopPush = false;
    }

    public static void renderGuiIngame(Minecraft minecraft) {
        SmartMovingSelf moving = (SmartMovingSelf)SmartMovingFactory.getInstance(minecraft.g);
        if (moving != null && (((Boolean)SmartMovingRender.Options._displayExhaustionBar.value).booleanValue() || ((Boolean)SmartMovingRender.Options._displayJumpChargeBar.value).booleanValue())) {
            apn scaledresolution = new apn(minecraft.y, minecraft.c, minecraft.d);
            int width = scaledresolution.a();
            int height = scaledresolution.b();
            if (minecraft.b.b()) {
                float maxExhaustion = Config.getMaxExhaustion();
                float exhaustion = Math.min(moving.exhaustion, maxExhaustion);
                boolean drawExhaustion = exhaustion > 0.0f && exhaustion <= maxExhaustion;
                float maxStillJumpCharge = ((Float)SmartMovingRender.Config._jumpChargeMaximum.value).floatValue();
                float stillJumpCharge = Math.min(moving.jumpCharge, maxStillJumpCharge);
                float maxRunJumpCharge = ((Float)SmartMovingRender.Config._headJumpChargeMaximum.value).floatValue();
                float runJumpCharge = Math.min(moving.headJumpCharge, maxRunJumpCharge);
                boolean drawJumpCharge = stillJumpCharge > 0.0f || runJumpCharge > 0.0f;
                float maxJumpCharge = stillJumpCharge > runJumpCharge ? maxStillJumpCharge : maxRunJumpCharge;
                float jumpCharge = Math.max(stillJumpCharge, runJumpCharge);
                if (drawExhaustion || drawJumpCharge) {
                    GL11.glBindTexture((int)3553, (int)minecraft.o.b("/gui/move/icons.png"));
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    _minecraft = minecraft;
                }
                if (drawExhaustion) {
                    float maxExhaustionForAction = Math.min(moving.maxExhaustionForAction, maxExhaustion);
                    float maxExhaustionToStartAction = Math.min(moving.maxExhaustionToStartAction, maxExhaustion);
                    float fitness = maxExhaustion - exhaustion;
                    float minFitnessForAction = Float.isNaN(maxExhaustionForAction) ? 0.0f : maxExhaustion - maxExhaustionForAction;
                    float minFitnessToStartAction = Float.isNaN(maxExhaustionToStartAction) ? 0.0f : maxExhaustion - maxExhaustionToStartAction;
                    float maxFitnessDrawn = Math.max(Math.max(minFitnessToStartAction, fitness), minFitnessForAction);
                    int halfs = (int)Math.floor(maxFitnessDrawn / maxExhaustion * 21.0f);
                    int fulls = halfs / 2;
                    int half = halfs % 2;
                    int fitnessHalfs = (int)Math.floor(fitness / maxExhaustion * 21.0f);
                    int fitnessFulls = fitnessHalfs / 2;
                    int fitnessHalf = fitnessHalfs % 2;
                    int minFitnessForActionHalfs = (int)Math.floor(minFitnessForAction / maxExhaustion * 21.0f);
                    int minFitnessForActionFulls = minFitnessForActionHalfs / 2;
                    int minFitnessForActionHalf = minFitnessForActionHalfs % 2;
                    int minFitnessToStartActionHalfs = (int)Math.floor(minFitnessToStartAction / maxExhaustion * 21.0f);
                    int minFitnessToStartActionFulls = minFitnessToStartActionHalfs / 2;
                    _jOffset = height - 39 - 10 - (minecraft.g.a(acn.g) ? 10 : 0);
                    for (int i2 = 0; i2 < Math.min(fulls + half, 10); ++i2) {
                        _iOffset = width / 2 + 90 - (i2 + 1) * 8;
                        if (i2 < fitnessFulls) {
                            if (i2 < minFitnessForActionFulls) {
                                SmartMovingRender.drawIcon(2, 2);
                                continue;
                            }
                            if (i2 == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                                SmartMovingRender.drawIcon(3, 2);
                                continue;
                            }
                            SmartMovingRender.drawIcon(0, 0);
                            continue;
                        }
                        if (i2 == fitnessFulls && fitnessHalf > 0) {
                            if (i2 < minFitnessForActionFulls) {
                                SmartMovingRender.drawIcon(1, 2);
                                continue;
                            }
                            if (i2 == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                                if (i2 < minFitnessToStartActionFulls) {
                                    SmartMovingRender.drawIcon(3, 1);
                                    continue;
                                }
                                SmartMovingRender.drawIcon(4, 2);
                                continue;
                            }
                            if (i2 < minFitnessToStartActionFulls) {
                                SmartMovingRender.drawIcon(1, 1);
                                continue;
                            }
                            SmartMovingRender.drawIcon(1, 0);
                            continue;
                        }
                        if (i2 < minFitnessForActionFulls) {
                            SmartMovingRender.drawIcon(0, 2);
                            continue;
                        }
                        if (i2 == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                            if (i2 < minFitnessToStartActionFulls) {
                                SmartMovingRender.drawIcon(2, 1);
                                continue;
                            }
                            SmartMovingRender.drawIcon(5, 2);
                            continue;
                        }
                        if (i2 < minFitnessToStartActionFulls) {
                            SmartMovingRender.drawIcon(0, 1);
                            continue;
                        }
                        SmartMovingRender.drawIcon(4, 1);
                    }
                }
                if (drawJumpCharge) {
                    boolean max = jumpCharge == maxJumpCharge;
                    int fulls = max ? 10 : (int)Math.ceil((double)(jumpCharge - 2.0f) * 10.0 / (double)maxJumpCharge);
                    int half = max ? 0 : (int)Math.ceil((double)jumpCharge * 10.0 / (double)maxJumpCharge) - fulls;
                    _jOffset = height - 39 - 10 - (minecraft.g.aO() > 0 ? 10 : 0);
                    for (int i3 = 0; i3 < fulls + half; ++i3) {
                        _iOffset = width / 2 - 91 + i3 * 8;
                        SmartMovingRender.drawIcon(i3 < fulls ? 2 : 3, 0);
                    }
                }
            }
            GL11.glDisable((int)32826);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
    }

    private static void drawIcon(int x2, int y2) {
        SmartMovingRender._minecraft.v.b(_iOffset, _jOffset, x2 * 9, y2 * 9, 9, 9);
    }
}

