/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.render;

import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.render.IModelPlayer;
import net.minecraft.move.render.ModelCapeRenderer;
import net.minecraft.move.render.ModelEarsRenderer;
import net.minecraft.move.render.ModelRotationRenderer;
import net.minecraft.move.render.RendererData;

public class SmartMovingModel
extends SmartMovingContext {
    public IModelPlayer imp;
    public aro mp;
    public boolean isInventory;
    public boolean isClimb;
    public boolean isClimbJump;
    public int feetClimbType;
    public int handsClimbType;
    public boolean isHandsVineClimbing;
    public boolean isFeetVineClimbing;
    public boolean isCeilingClimb;
    public boolean isSwim;
    public boolean isDive;
    public boolean isCrawl;
    public boolean isCrawlClimb;
    public boolean isJump;
    public boolean isHeadJump;
    public boolean isFlying;
    public boolean isSlide;
    public boolean isLevitate;
    public boolean isFalling;
    public boolean isGenericSneaking;
    public boolean isAngleJumping;
    public int angleJumpType;
    public float smallOverGroundHeight;
    public int overGroundBlockId;
    public int scaleArmType;
    public int scaleLegType;
    public float totalVerticalDistance;
    public float currentVerticalSpeed;
    public float totalDistance;
    public float currentSpeed;
    public double distance;
    public double verticalDistance;
    public double horizontalDistance;
    public float currentCameraAngle;
    public float currentVerticalAngle;
    public float currentHorizontalAngle;
    public float actualRotation;
    public float forwardRotation;
    public float workingAngle;
    public ModelRotationRenderer bipedOuter;
    public ModelRotationRenderer bipedTorso;
    public ModelRotationRenderer bipedBody;
    public ModelRotationRenderer bipedBreast;
    public ModelRotationRenderer bipedNeck;
    public ModelRotationRenderer bipedHead;
    public ModelRotationRenderer bipedHeadwear;
    public ModelRotationRenderer bipedRightShoulder;
    public ModelRotationRenderer bipedRightArm;
    public ModelRotationRenderer bipedLeftShoulder;
    public ModelRotationRenderer bipedLeftArm;
    public ModelRotationRenderer bipedPelvic;
    public ModelRotationRenderer bipedRightLeg;
    public ModelRotationRenderer bipedLeftLeg;
    public ModelEarsRenderer bipedEars;
    public ModelCapeRenderer bipedCloak;
    public boolean wasSwim;
    public boolean wasDive;
    public boolean wasFlying;
    public boolean wasCeilingClimb;
    public boolean disabled;
    public boolean attemptToCallRenderCape;
    public RendererData prevOuterRenderData;
    public boolean isSleeping;
    public boolean firstPerson;

    public SmartMovingModel(float f2, aro mp2, IModelPlayer imp, int scaleArmType, int scaleLegType) {
        this.imp = imp;
        this.mp = mp2;
        this.bipedOuter = new ModelRotationRenderer(mp2, -1, -1, null);
        this.bipedOuter.a(0.0f, 0.0f, 0.0f);
        this.bipedOuter.fadeEnabled = true;
        this.bipedTorso = new ModelRotationRenderer(mp2, 16, 16, this.bipedOuter);
        this.bipedTorso.a(0.0f, 0.0f, 0.0f);
        this.bipedBody = new ModelRotationRenderer(mp2, 16, 16, this.bipedTorso);
        this.bipedBody.a(-4.0f, 0.0f, -2.0f, 8, 12, 4, f2);
        this.bipedBody.a(0.0f, 0.0f, 0.0f);
        this.bipedBreast = new ModelRotationRenderer(mp2, -1, -1, this.bipedTorso);
        this.bipedBreast.a(0.0f, 0.0f, 0.0f);
        this.bipedNeck = new ModelRotationRenderer(mp2, -1, -1, this.bipedBreast);
        this.bipedNeck.a(0.0f, 0.0f, 0.0f);
        this.bipedCloak = new ModelCapeRenderer(mp2, 0, 0, this.bipedBreast);
        this.bipedCloak.a(-5.0f, 0.0f, -1.0f, 10, 16, 1, f2);
        this.bipedCloak.a(0.0f, 0.0f, 2.0f);
        this.bipedHead = new ModelRotationRenderer(mp2, 0, 0, this.bipedNeck);
        this.bipedHead.a(-4.0f, -8.0f, -4.0f, 8, 8, 8, f2);
        this.bipedHead.a(0.0f, 0.0f, 0.0f);
        this.bipedEars = new ModelEarsRenderer(mp2, 24, 0, this.bipedHead);
        this.bipedEars.a(-3.0f, -6.0f, -1.0f, 6, 6, 1, f2);
        this.bipedEars.a(0.0f, 0.0f, 0.0f);
        this.bipedHeadwear = new ModelRotationRenderer(mp2, 32, 0, this.bipedHead);
        this.bipedHeadwear.a(-4.0f, -8.0f, -4.0f, 8, 8, 8, f2 + 0.5f);
        this.bipedHeadwear.a(0.0f, 0.0f, 0.0f);
        this.bipedRightShoulder = new ModelRotationRenderer(mp2, 40, 16, this.bipedBreast);
        this.bipedRightShoulder.a(-3.0f, -2.0f, -2.0f, 8, 8, 8, f2);
        this.bipedRightShoulder.a(-5.0f, 2.0f, 0.0f);
        this.bipedRightArm = new ModelRotationRenderer(mp2, 40, 16, this.bipedRightShoulder);
        this.bipedRightArm.a(-3.0f, -2.0f, -2.0f, 4, 12, 4, f2);
        this.bipedLeftShoulder = new ModelRotationRenderer(mp2, -1, -1, this.bipedBreast);
        this.bipedLeftShoulder.i = true;
        this.bipedLeftShoulder.a(5.0f, 2.0f, 0.0f);
        this.bipedLeftArm = new ModelRotationRenderer(mp2, 40, 16, this.bipedLeftShoulder);
        this.bipedLeftArm.i = true;
        this.bipedLeftArm.a(-1.0f, -2.0f, -2.0f, 4, 12, 4, f2);
        this.bipedPelvic = new ModelRotationRenderer(mp2, -1, -1, this.bipedTorso);
        this.bipedPelvic.a(0.0f, 12.0f, 0.0f);
        this.bipedRightLeg = new ModelRotationRenderer(mp2, 0, 16, this.bipedPelvic);
        this.bipedRightLeg.a(-2.0f, 0.0f, -2.0f, 4, 12, 4, f2);
        this.bipedRightLeg.a(-2.0f, 0.0f, 0.0f);
        this.bipedLeftLeg = new ModelRotationRenderer(mp2, 0, 16, this.bipedPelvic);
        this.bipedLeftLeg.i = true;
        this.bipedLeftLeg.a(-2.0f, 0.0f, -2.0f, 4, 12, 4, f2);
        this.bipedLeftLeg.a(2.0f, 0.0f, 0.0f);
        imp.initialize(this.bipedBody, this.bipedCloak, this.bipedHead, this.bipedEars, this.bipedHeadwear, this.bipedRightArm, this.bipedLeftArm, this.bipedRightLeg, this.bipedLeftLeg);
        this.scaleArmType = scaleArmType;
        this.scaleLegType = scaleLegType;
    }

    public void render(jm entity, float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        this.imp.superRender(entity, totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.bipedOuter.m != null) {
            this.bipedOuter.a(factor);
        }
        if (this.bipedTorso.m != null) {
            this.bipedTorso.a(factor);
        }
        if (this.bipedBreast.m != null) {
            this.bipedBreast.a(factor);
        }
        if (this.bipedNeck.m != null) {
            this.bipedNeck.a(factor);
        }
        if (this.bipedRightShoulder.m != null) {
            this.bipedRightShoulder.a(factor);
        }
        if (this.bipedLeftShoulder.m != null) {
            this.bipedLeftShoulder.a(factor);
        }
        if (this.bipedPelvic.m != null) {
            this.bipedPelvic.a(factor);
        }
    }

    public void setRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        float angle;
        float currentHorizontalAngle;
        float standFactor;
        float walkFactor;
        float distance;
        boolean isWorking;
        this.reset();
        if (this.firstPerson || this.isInventory) {
            this.bipedTorso.ignoreBase = true;
            this.bipedHead.ignoreBase = true;
            this.bipedHeadwear.ignoreBase = true;
            this.bipedEars.ignoreBase = true;
            this.bipedCloak.ignoreBase = true;
            this.bipedRightArm.ignoreBase = true;
            this.bipedLeftArm.ignoreBase = true;
            this.bipedRightLeg.ignoreBase = true;
            this.bipedLeftLeg.ignoreBase = true;
            this.bipedRightArm.a(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm.a(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg.a(-2.0f, 12.0f, 0.0f);
            this.bipedLeftLeg.a(2.0f, 12.0f, 0.0f);
            this.imp.superSetRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
            return;
        }
        if (this.isSleeping) {
            this.prevOuterRenderData.rotateAngleX = 0.0f;
            this.prevOuterRenderData.rotateAngleY = 0.0f;
            this.prevOuterRenderData.rotateAngleZ = 0.0f;
        }
        this.bipedOuter.previous = this.prevOuterRenderData;
        this.bipedOuter.g = this.actualRotation / 57.295776f;
        this.bipedOuter.fadeRotateAngleY = true;
        boolean isStandard = false;
        boolean bl2 = isWorking = this.mp.p > 0.0f;
        if (this.isClimb || this.isCrawlClimb) {
            float feetDistanceSideOffset;
            float feetDistanceSideFactor;
            float feetFrequenceSideFactor;
            float feetDistanceUpOffset;
            float feetDistanceUpFactor;
            float feetFrequenceUpFactor;
            float handsDistanceUpOffset;
            float handsDistanceUpFactor;
            float handsFrequenceUpFactor;
            float handsDistanceSideOffset;
            float handsDistanceSideFactor;
            float handsFrequenceSideFactor;
            this.bipedOuter.g = this.forwardRotation / 57.295776f;
            this.bipedHead.g = 0.0f;
            this.bipedHead.f = viewVerticalAngelOffset / 57.295776f;
            this.bipedLeftLeg.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedRightLeg.rotationOrder = ModelRotationRenderer.YZX;
            int handsClimbType = this.handsClimbType;
            if (this.isHandsVineClimbing && handsClimbType == 2) {
                handsClimbType = 1;
            }
            switch (handsClimbType) {
                case 2: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 2.0f;
                    handsDistanceUpOffset = -1.5707964f;
                    break;
                }
                case 1: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 2.0f;
                    handsDistanceUpOffset = -2.5f;
                    break;
                }
                default: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 0.0f;
                    handsDistanceUpOffset = -0.5f;
                }
            }
            switch (this.feetClimbType) {
                case 1: {
                    feetFrequenceUpFactor = 0.6662f;
                    feetDistanceUpFactor = 3.0f;
                    feetDistanceUpOffset = -0.5f;
                    feetFrequenceSideFactor = 0.6662f;
                    feetDistanceSideFactor = 0.5f;
                    feetDistanceSideOffset = 0.0f;
                    break;
                }
                default: {
                    feetFrequenceUpFactor = 0.6662f;
                    feetDistanceUpFactor = 0.0f;
                    feetDistanceUpOffset = 0.0f;
                    feetFrequenceSideFactor = 0.6662f;
                    feetDistanceSideFactor = 0.0f;
                    feetDistanceSideOffset = 0.0f;
                }
            }
            float verticalSpeed = Math.min(0.5f, this.currentVerticalSpeed);
            float horizontalSpeed = Math.min(0.5f, currentHorizontalSpeed);
            this.bipedRightArm.f = ig.b(this.totalVerticalDistance * handsFrequenceUpFactor + (float)Math.PI) * verticalSpeed * handsDistanceUpFactor + handsDistanceUpOffset;
            this.bipedLeftArm.f = ig.b(this.totalVerticalDistance * handsFrequenceUpFactor) * verticalSpeed * handsDistanceUpFactor + handsDistanceUpOffset;
            this.bipedRightArm.g = ig.b(totalHorizontalDistance * handsFrequenceSideFactor + 1.5707964f) * horizontalSpeed * handsDistanceSideFactor + handsDistanceSideOffset;
            this.bipedLeftArm.g = ig.b(totalHorizontalDistance * handsFrequenceSideFactor) * horizontalSpeed * handsDistanceSideFactor + handsDistanceSideOffset;
            if (this.isHandsVineClimbing) {
                this.bipedLeftArm.g *= 1.0f + handsFrequenceSideFactor;
                this.bipedRightArm.g *= 1.0f + handsFrequenceSideFactor;
                this.bipedLeftArm.g += 0.7853982f;
                this.bipedRightArm.g -= 0.7853982f;
                this.setArmScales(Math.abs(ig.b(this.bipedRightArm.f)), Math.abs(ig.b(this.bipedLeftArm.f)));
            }
            if (!this.isFeetVineClimbing) {
                this.bipedRightLeg.f = ig.b(this.totalVerticalDistance * feetFrequenceUpFactor) * feetDistanceUpFactor * verticalSpeed + feetDistanceUpOffset;
                this.bipedLeftLeg.f = ig.b(this.totalVerticalDistance * feetFrequenceUpFactor + (float)Math.PI) * feetDistanceUpFactor * verticalSpeed + feetDistanceUpOffset;
            }
            this.bipedRightLeg.h = -(ig.b(totalHorizontalDistance * feetFrequenceSideFactor) - 1.0f) * horizontalSpeed * feetDistanceSideFactor + feetDistanceSideOffset;
            this.bipedLeftLeg.h = -(ig.b(totalHorizontalDistance * feetFrequenceSideFactor + 1.5707964f) + 1.0f) * horizontalSpeed * feetDistanceSideFactor + feetDistanceSideOffset;
            if (this.isFeetVineClimbing) {
                float total = (ig.b(this.totalDistance + (float)Math.PI) + 1.0f) * 0.19634955f + 0.3926991f;
                this.bipedRightLeg.f = -total;
                this.bipedLeftLeg.f = -total;
                float difference = Math.max(0.0f, ig.b(this.totalDistance - 1.5707964f)) * 0.09817477f;
                this.bipedLeftLeg.h += -difference;
                this.bipedRightLeg.h += difference;
                this.setLegScales(Math.abs(ig.b(this.bipedRightLeg.f)), Math.abs(ig.b(this.bipedLeftLeg.f)));
            }
            if (this.isCrawlClimb) {
                float legAngleZ;
                float legAngleX;
                float bodyAngleX;
                float height = this.smallOverGroundHeight + 0.25f;
                float bodyLength = 0.7f;
                float legLength = 0.55f;
                if (height < bodyLength) {
                    bodyAngleX = Math.max(0.0f, (float)Math.acos(height / bodyLength));
                    legAngleX = 1.5707964f - bodyAngleX;
                    legAngleZ = 0.19634955f;
                } else if (height < bodyLength + legLength) {
                    bodyAngleX = 0.0f;
                    legAngleX = Math.max(0.0f, (float)Math.acos((height - bodyLength) / legLength));
                    legAngleZ = 0.19634955f * (legAngleX / 1.537f);
                } else {
                    bodyAngleX = 0.0f;
                    legAngleX = 0.0f;
                    legAngleZ = 0.0f;
                }
                this.bipedTorso.f = bodyAngleX;
                this.bipedRightShoulder.f = -bodyAngleX;
                this.bipedLeftShoulder.f = -bodyAngleX;
                this.bipedHead.f = -bodyAngleX;
                this.bipedRightLeg.f = legAngleX;
                this.bipedLeftLeg.f = legAngleX;
                this.bipedRightLeg.h = legAngleZ;
                this.bipedLeftLeg.h = -legAngleZ;
            }
            if (handsClimbType == 0 && this.feetClimbType != 0) {
                this.bipedTorso.f = 0.5f;
                this.bipedHead.f -= 0.5f;
                this.bipedTorso.e = -4.0f;
                this.bipedLeftArm.e = -4.0f;
                this.bipedRightArm.e = -4.0f;
            }
        } else if (this.isClimbJump) {
            this.bipedRightArm.f = 3.5342917f;
            this.bipedLeftArm.f = 3.5342917f;
            this.bipedRightArm.h = -0.19634955f;
            this.bipedLeftArm.h = 0.19634955f;
        } else if (this.isCeilingClimb) {
            distance = totalHorizontalDistance * 0.7f;
            walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 0.12951545f);
            standFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.12951545f, 0.0f);
            currentHorizontalAngle = this.horizontalDistance < (double)0.015f ? this.currentCameraAngle : this.currentHorizontalAngle;
            this.bipedLeftArm.f = (ig.b(distance) * 0.52f + (float)Math.PI) * walkFactor + (float)Math.PI * standFactor;
            this.bipedRightArm.f = (ig.b(distance + (float)Math.PI) * 0.52f - (float)Math.PI) * walkFactor - (float)Math.PI * standFactor;
            this.bipedLeftLeg.f = -ig.b(distance) * 0.12f * walkFactor;
            this.bipedRightLeg.f = -ig.b(distance + (float)Math.PI) * 0.32f * walkFactor;
            float rotateY = ig.b(distance) * 0.44f * walkFactor;
            this.bipedOuter.g = rotateY + currentHorizontalAngle;
            this.bipedRightArm.g = this.bipedLeftArm.g = -rotateY;
            this.bipedRightLeg.g = this.bipedLeftLeg.g = -rotateY;
            this.bipedHead.g = -rotateY;
        } else if (this.isSwim) {
            float rotateFeetAngleZ;
            distance = totalHorizontalDistance;
            walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.15679921f, 0.52264464f);
            float sneakFactor = Math.min(SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 0.15679921f), SmartMovingModel.Factor(currentHorizontalSpeed, 0.52264464f, 0.15679921f));
            float standFactor2 = SmartMovingModel.Factor(currentHorizontalSpeed, 0.15679921f, 0.0f);
            float standSneakFactor = standFactor2 + sneakFactor;
            float currentHorizontalAngle2 = this.horizontalDistance < (this.isGenericSneaking ? 0.005 : (double)0.015f) ? this.currentCameraAngle : this.currentHorizontalAngle;
            this.bipedHead.rotationOrder = ModelRotationRenderer.YXZ;
            this.bipedHead.g = ig.b(distance / 2.0f - 1.5707964f) * walkFactor;
            this.bipedHead.f = -0.7853982f * standSneakFactor;
            this.bipedHead.e = -2.0f;
            this.bipedOuter.fadeRotateAngleX = true;
            this.bipedOuter.f = 1.5707964f - 0.3926991f * standSneakFactor;
            this.bipedOuter.g = currentHorizontalAngle2;
            this.bipedBreast.g = this.bipedBody.g = ig.b(distance / 2.0f - 1.5707964f) * walkFactor;
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedRightArm.h = 2.3561945f + ig.b(totalTime * 0.1f) * standSneakFactor * 0.8f;
            this.bipedLeftArm.h = -2.3561945f - ig.b(totalTime * 0.1f) * standSneakFactor * 0.8f;
            this.bipedRightArm.f = (distance * 0.5f % ((float)Math.PI * 2) - (float)Math.PI) * walkFactor + 0.3926991f * standSneakFactor;
            this.bipedLeftArm.f = ((distance * 0.5f + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI) * walkFactor + 0.3926991f * standSneakFactor;
            this.bipedRightLeg.f = ig.b(distance) * 0.52264464f * walkFactor;
            this.bipedLeftLeg.f = ig.b(distance + (float)Math.PI) * 0.52264464f * walkFactor;
            this.bipedRightLeg.h = rotateFeetAngleZ = 0.3926991f * standSneakFactor + ig.b(totalTime * 0.1f) * 0.4f * (standFactor2 - sneakFactor);
            this.bipedLeftLeg.h = -rotateFeetAngleZ;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (ig.b(totalTime * 0.1f + 1.5707964f) - 1.0f) * 0.15f * sneakFactor, 1.0f + (ig.b(totalTime * 0.1f + 1.5707964f) - 1.0f) * 0.15f * sneakFactor);
            }
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (ig.b(totalTime * 0.1f - 1.5707964f) - 1.0f) * 0.15f * sneakFactor, 1.0f + (ig.b(totalTime * 0.1f - 1.5707964f) - 1.0f) * 0.15f * sneakFactor);
            }
        } else if (this.isDive) {
            distance = this.totalDistance * 0.7f;
            walkFactor = SmartMovingModel.Factor(this.currentSpeed, 0.0f, 0.15679921f);
            standFactor = SmartMovingModel.Factor(this.currentSpeed, 0.15679921f, 0.0f);
            currentHorizontalAngle = (double)this.totalDistance < (this.isGenericSneaking ? 0.005 : (double)0.015f) ? this.currentCameraAngle : this.currentHorizontalAngle;
            this.bipedHead.f = -0.7853982f;
            this.bipedHead.e = -2.0f;
            this.bipedOuter.fadeRotateAngleX = true;
            this.bipedOuter.f = this.isLevitate ? 1.1780972f : (this.isJump ? 0.0f : 1.5707964f - this.currentVerticalAngle);
            this.bipedOuter.g = currentHorizontalAngle;
            this.bipedRightLeg.h = (ig.b(distance) + 1.0f) * 0.52264464f * walkFactor + 0.3926991f * standFactor;
            this.bipedLeftLeg.h = (ig.b(distance + (float)Math.PI) - 1.0f) * 0.52264464f * walkFactor - 0.3926991f * standFactor;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (ig.b(distance - 1.5707964f) - 1.0f) * 0.25f * walkFactor, 1.0f + (ig.b(distance - 1.5707964f) - 1.0f) * 0.25f * walkFactor);
            }
            this.bipedRightArm.h = (ig.b(distance + (float)Math.PI) * 0.52264464f * 2.5f + 1.5707964f) * walkFactor + 2.3561945f * standFactor;
            this.bipedLeftArm.h = (ig.b(distance) * 0.52264464f * 2.5f - 1.5707964f) * walkFactor - 2.3561945f * standFactor;
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (ig.b(distance + 1.5707964f) - 1.0f) * 0.15f * walkFactor, 1.0f + (ig.b(distance + 1.5707964f) - 1.0f) * 0.15f * walkFactor);
            }
        } else if (this.isCrawl) {
            distance = totalHorizontalDistance * 1.3f;
            walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 0.12951545f);
            standFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.12951545f, 0.0f);
            this.bipedHead.h = -viewHorizontalAngelOffset / 57.295776f;
            this.bipedHead.f = -0.7853982f;
            this.bipedHead.e = -2.0f;
            this.bipedTorso.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedTorso.f = 1.3744469f;
            this.bipedTorso.d = 3.0f;
            this.bipedTorso.h = ig.b(distance + 1.5707964f) * 0.09817477f * walkFactor;
            this.bipedBody.g = ig.b(distance + (float)Math.PI) * 0.09817477f * walkFactor;
            this.bipedRightLeg.f = (ig.b(distance - 1.5707964f) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            this.bipedLeftLeg.f = (ig.b(distance - (float)Math.PI - 1.5707964f) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            this.bipedRightLeg.h = (ig.b(distance - 1.5707964f) + 1.0f) * 0.25f * walkFactor + 0.19634955f * standFactor;
            this.bipedLeftLeg.h = (ig.b(distance - 1.5707964f) - 1.0f) * 0.25f * walkFactor - 0.19634955f * standFactor;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (ig.b(distance + 1.5707964f - 1.5707964f) - 1.0f) * 0.25f * walkFactor, 1.0f + (ig.b(distance - 1.5707964f - 1.5707964f) - 1.0f) * 0.25f * walkFactor);
            }
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedRightArm.f = 3.926991f;
            this.bipedLeftArm.f = 3.926991f;
            this.bipedRightArm.h = (ig.b(distance + (float)Math.PI) * 0.09817477f + 0.19634955f) * walkFactor + 0.3926991f * standFactor;
            this.bipedLeftArm.h = (ig.b(distance + (float)Math.PI) * 0.09817477f - 0.19634955f) * walkFactor - 0.3926991f * standFactor;
            this.bipedRightArm.g = -1.5707964f;
            this.bipedLeftArm.g = 1.5707964f;
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (ig.b(distance + 1.5707964f) - 1.0f) * 0.15f * walkFactor, 1.0f + (ig.b(distance - 1.5707964f) - 1.0f) * 0.15f * walkFactor);
            }
        } else if (this.isSlide) {
            distance = totalHorizontalDistance * 0.7f;
            walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 1.0f) * 0.8f;
            this.bipedHead.h = -viewHorizontalAngelOffset / 57.295776f;
            this.bipedHead.f = -1.1780972f;
            this.bipedHead.e = -2.0f;
            this.bipedOuter.fadeRotateAngleY = false;
            this.bipedOuter.g = this.currentHorizontalAngle;
            this.bipedOuter.d = 5.0f;
            this.bipedOuter.f = 1.5707964f;
            this.bipedBody.rotationOrder = ModelRotationRenderer.YXZ;
            this.bipedBody.offsetY = -0.4f;
            this.bipedBody.d = 6.5f;
            this.bipedBody.f = ig.b(distance - 0.7853982f) * 0.09817477f * walkFactor;
            this.bipedBody.g = ig.b(distance + 0.7853982f) * 0.09817477f * walkFactor;
            this.bipedRightLeg.f = ig.b(distance + (float)Math.PI) * 0.09817477f * walkFactor + 0.09817477f;
            this.bipedLeftLeg.f = ig.b(distance + 1.5707964f) * 0.09817477f * walkFactor + 0.09817477f;
            this.bipedRightLeg.h = 0.19634955f;
            this.bipedLeftLeg.h = -0.19634955f;
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            this.bipedRightArm.f = ig.b(distance + 1.5707964f) * 0.09817477f * walkFactor + (float)Math.PI - 0.09817477f;
            this.bipedLeftArm.f = ig.b(distance - (float)Math.PI) * 0.09817477f * walkFactor + (float)Math.PI - 0.09817477f;
            this.bipedRightArm.h = 0.3926991f;
            this.bipedLeftArm.h = -0.3926991f;
            this.bipedRightArm.g = -1.5707964f;
            this.bipedLeftArm.g = 1.5707964f;
        } else if (this.isFlying) {
            distance = this.totalDistance * 0.08f;
            walkFactor = SmartMovingModel.Factor(this.currentSpeed, 0.0f, 1.0f);
            standFactor = SmartMovingModel.Factor(this.currentSpeed, 1.0f, 0.0f);
            float time = totalTime * 0.15f;
            float currentVerticalAngle = this.isJump ? Math.abs(this.currentVerticalAngle) : this.currentVerticalAngle;
            float currentHorizontalAngle3 = this.horizontalDistance < (double)0.05f ? this.currentCameraAngle : this.currentHorizontalAngle;
            this.bipedOuter.fadeRotateAngleX = true;
            this.bipedOuter.f = (1.5707964f - currentVerticalAngle) * walkFactor;
            this.bipedOuter.g = currentHorizontalAngle3;
            this.bipedHead.f = -this.bipedOuter.f / 2.0f;
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.XZY;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.XZY;
            this.bipedRightArm.g = ig.b(time) * 0.3926991f * standFactor;
            this.bipedLeftArm.g = ig.b(time) * 0.3926991f * standFactor;
            this.bipedRightArm.h = (ig.b(distance + (float)Math.PI) * 0.09817477f + 2.7488937f) * walkFactor + 1.5707964f * standFactor;
            this.bipedLeftArm.h = (ig.b(distance) * 0.09817477f - 2.7488937f) * walkFactor - 1.5707964f * standFactor;
            this.bipedRightLeg.f = ig.b(distance) * 0.09817477f * walkFactor + ig.b(time + (float)Math.PI) * 0.09817477f * standFactor;
            this.bipedLeftLeg.f = ig.b(distance + (float)Math.PI) * 0.09817477f * walkFactor + ig.b(time) * 0.09817477f * standFactor;
            this.bipedRightLeg.h = 0.09817477f;
            this.bipedLeftLeg.h = -0.09817477f;
        } else if (this.isHeadJump) {
            this.bipedOuter.fadeRotateAngleX = true;
            this.bipedOuter.f = 1.5707964f - this.currentVerticalAngle;
            this.bipedOuter.g = this.currentHorizontalAngle;
            this.bipedHead.f = -this.bipedOuter.f / 2.0f;
            float bendFactor = Math.min(SmartMovingModel.Factor(this.currentVerticalAngle, 1.5707964f, 0.0f), SmartMovingModel.Factor(this.currentVerticalAngle, -1.5707964f, 0.0f));
            this.bipedRightArm.f = bendFactor * -0.7853982f;
            this.bipedLeftArm.f = bendFactor * -0.7853982f;
            this.bipedRightLeg.f = bendFactor * -0.7853982f;
            this.bipedLeftLeg.f = bendFactor * -0.7853982f;
            float armFactorZ = SmartMovingModel.Factor(this.currentVerticalAngle, 1.5707964f, -1.5707964f);
            if (this.overGroundBlockId > 0 && aif.m[this.overGroundBlockId].cp.a()) {
                armFactorZ = Math.min(armFactorZ, this.smallOverGroundHeight / 5.0f);
            }
            this.bipedRightArm.h = 2.7488937f + armFactorZ * 0.7853982f;
            this.bipedLeftArm.h = -2.7488937f - armFactorZ * 0.7853982f;
            float legFactorZ = SmartMovingModel.Factor(this.currentVerticalAngle, -1.5707964f, 1.5707964f);
            this.bipedRightLeg.h = 0.09817477f * legFactorZ;
            this.bipedLeftLeg.h = -0.09817477f * legFactorZ;
        } else if (this.isFalling) {
            distance = this.totalDistance * 0.1f;
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.XZY;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.XZY;
            this.bipedRightArm.g = ig.b(distance + 1.5707964f) * 0.7853982f;
            this.bipedLeftArm.g = ig.b(distance + 1.5707964f) * 0.7853982f;
            this.bipedRightArm.h = ig.b(distance) * 0.7853982f + 1.5707964f;
            this.bipedLeftArm.h = ig.b(distance) * 0.7853982f - 1.5707964f;
            this.bipedRightLeg.f = ig.b(distance + (float)Math.PI + 1.5707964f) * 0.3926991f + 0.19634955f;
            this.bipedLeftLeg.f = ig.b(distance + 1.5707964f) * 0.3926991f + 0.19634955f;
            this.bipedRightLeg.h = ig.b(distance) * 0.3926991f + 0.19634955f;
            this.bipedLeftLeg.h = ig.b(distance) * 0.3926991f - 0.19634955f;
        } else {
            isStandard = true;
        }
        if (isStandard) {
            this.bipedNeck.ignoreBase = true;
            this.bipedHead.g = (this.actualRotation + viewHorizontalAngelOffset) / 57.295776f;
            this.bipedHead.f = viewVerticalAngelOffset / 57.295776f;
            if (this.isSleeping) {
                this.bipedNeck.ignoreBase = false;
                this.bipedHead.g = 0.0f;
                this.bipedHead.f = 0.7853982f;
                this.bipedTorso.e = -17.0f;
            }
            if (this.isAngleJumping) {
                angle = (float)this.angleJumpType * 0.7853982f;
                this.bipedPelvic.g -= this.bipedOuter.g;
                this.bipedPelvic.g += this.currentCameraAngle;
                float backness = 1.0f - Math.abs(angle - (float)Math.PI) / 1.5707964f;
                float leftness = -Math.min(angle - (float)Math.PI, 0.0f) / 1.5707964f;
                float rightness = Math.max(angle - (float)Math.PI, 0.0f) / 1.5707964f;
                this.bipedLeftLeg.f = 0.19634955f * (1.0f + rightness);
                this.bipedRightLeg.f = 0.19634955f * (1.0f + leftness);
                this.bipedLeftLeg.g = -angle;
                this.bipedRightLeg.g = -angle;
                this.bipedLeftLeg.h = 0.19634955f * backness;
                this.bipedRightLeg.h = -0.19634955f * backness;
                this.bipedLeftLeg.rotationOrder = ModelRotationRenderer.ZXY;
                this.bipedRightLeg.rotationOrder = ModelRotationRenderer.ZXY;
                this.bipedLeftArm.h = -0.3926991f * rightness;
                this.bipedRightArm.h = 0.3926991f * leftness;
                this.bipedLeftArm.f = -0.7853982f * backness;
                this.bipedRightArm.f = -0.7853982f * backness;
            } else {
                this.bipedRightArm.f = ig.b(totalHorizontalDistance * 0.6662f + (float)Math.PI) * 2.0f * currentHorizontalSpeed * 0.5f;
                this.bipedLeftArm.f = ig.b(totalHorizontalDistance * 0.6662f) * 2.0f * currentHorizontalSpeed * 0.5f;
                this.bipedRightLeg.f = ig.b(totalHorizontalDistance * 0.6662f) * 1.4f * currentHorizontalSpeed;
                this.bipedLeftLeg.f = ig.b(totalHorizontalDistance * 0.6662f + (float)Math.PI) * 1.4f * currentHorizontalSpeed;
            }
            if (this.mp.q) {
                this.bipedRightArm.f += -0.6283185f;
                this.bipedLeftArm.f += -0.6283185f;
                this.bipedRightLeg.f = -1.256637f;
                this.bipedLeftLeg.f = -1.256637f;
                this.bipedRightLeg.g = 0.3141593f;
                this.bipedLeftLeg.g = -0.3141593f;
            }
            if (this.mp.l != 0) {
                this.bipedLeftArm.f = this.bipedLeftArm.f * 0.5f - 0.3141593f * (float)this.mp.l;
            }
            if (this.mp.m != 0) {
                this.bipedRightArm.f = this.bipedRightArm.f * 0.5f - 0.3141593f * (float)this.mp.m;
            }
        }
        if (this.mp.p > -9990.0f) {
            angle = ig.a(ig.c(this.mp.p) * ((float)Math.PI * 2)) * 0.2f;
            if (isStandard) {
                this.bipedBreast.g = this.bipedBody.g += angle;
                this.bipedBreast.rotationOrder = this.bipedBody.rotationOrder = ModelRotationRenderer.YXZ;
                this.bipedLeftArm.f += angle;
            } else if (isWorking) {
                this.bipedRightShoulder.ignoreSuperRotation = true;
                this.bipedRightShoulder.f = viewVerticalAngelOffset / 57.295776f;
                this.bipedRightShoulder.g = this.workingAngle / 57.295776f;
                this.bipedRightShoulder.h = (float)Math.PI;
                this.bipedRightShoulder.rotationOrder = ModelRotationRenderer.ZYX;
                this.bipedRightArm.reset();
            }
            if (isStandard || isWorking) {
                float f6 = 1.0f - this.mp.p;
                f6 = 1.0f - f6 * f6 * f6;
                float f7 = ig.a(f6 * (float)Math.PI);
                float f8 = ig.a(this.mp.p * (float)Math.PI) * -(this.bipedHead.f - 0.7f) * 0.75f;
                this.bipedRightArm.f = (float)((double)this.bipedRightArm.f - ((double)f7 * 1.2 + (double)f8));
                this.bipedRightArm.g += angle * 2.0f;
                this.bipedRightArm.h -= ig.a(this.mp.p * (float)Math.PI) * 0.4f;
            }
        }
        if (isStandard) {
            if (this.mp.n && !this.isAngleJumping) {
                this.bipedTorso.f += 0.5f;
                this.bipedRightLeg.f += -0.5f;
                this.bipedLeftLeg.f += -0.5f;
                this.bipedRightArm.f += -0.1f;
                this.bipedLeftArm.f += -0.1f;
                this.bipedPelvic.offsetY = -0.137f;
                this.bipedPelvic.offsetZ = -0.051f;
                this.bipedBreast.offsetY = -0.014f;
                this.bipedBreast.offsetZ = -0.057f;
                this.bipedNeck.offsetY = 0.0621f;
            }
            this.bipedRightArm.h += ig.b(totalTime * 0.09f) * 0.05f + 0.05f;
            this.bipedLeftArm.h -= ig.b(totalTime * 0.09f) * 0.05f + 0.05f;
            this.bipedRightArm.f += ig.a(totalTime * 0.067f) * 0.05f;
            this.bipedLeftArm.f -= ig.a(totalTime * 0.067f) * 0.05f;
            if (this.mp.o) {
                this.bipedRightArm.h = 0.0f;
                this.bipedLeftArm.h = 0.0f;
                this.bipedRightArm.g = -0.1f + this.bipedHead.g - this.bipedOuter.g;
                this.bipedLeftArm.g = 0.1f + this.bipedHead.g + 0.4f - this.bipedOuter.g;
                this.bipedRightArm.f = -1.570796f + this.bipedHead.f;
                this.bipedLeftArm.f = -1.570796f + this.bipedHead.f;
                this.bipedRightArm.h += ig.b(totalTime * 0.09f) * 0.05f + 0.05f;
                this.bipedLeftArm.h -= ig.b(totalTime * 0.09f) * 0.05f + 0.05f;
                this.bipedRightArm.f += ig.a(totalTime * 0.067f) * 0.05f;
                this.bipedLeftArm.f -= ig.a(totalTime * 0.067f) * 0.05f;
            }
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleX) {
            this.bipedOuter.previous.rotateAngleX = this.bipedOuter.f;
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleY) {
            this.bipedOuter.previous.rotateAngleY = this.bipedOuter.g;
        }
        this.bipedOuter.fadeIntermediate(totalTime);
        this.bipedOuter.fadeStore(totalTime);
        this.wasSwim = this.isSwim;
        this.wasDive = this.isDive;
        this.wasFlying = this.isFlying;
        this.wasCeilingClimb = this.isCeilingClimb;
        this.bipedCloak.ignoreBase = false;
        this.bipedCloak.f = 0.09817477f;
    }

    private void setArmScales(float rightScale, float leftScale) {
        if (this.scaleArmType == 0) {
            this.bipedRightArm.scaleY = rightScale;
            this.bipedLeftArm.scaleY = leftScale;
        } else if (this.scaleArmType == 2) {
            this.bipedRightArm.offsetY -= (1.0f - rightScale) * 0.5f;
            this.bipedLeftArm.offsetY -= (1.0f - leftScale) * 0.5f;
        }
    }

    private void setLegScales(float rightScale, float leftScale) {
        if (this.scaleLegType == 0) {
            this.bipedRightLeg.scaleY = rightScale;
            this.bipedLeftLeg.scaleY = leftScale;
        } else if (this.scaleLegType == 2) {
            this.bipedRightLeg.offsetY -= (1.0f - rightScale) * 0.5f;
            this.bipedLeftLeg.offsetY -= (1.0f - leftScale) * 0.5f;
        }
    }

    private static float Factor(float x2, float x0, float x1) {
        if (x0 > x1) {
            if (x2 <= x1) {
                return 1.0f;
            }
            if (x2 >= x0) {
                return 0.0f;
            }
            return (x0 - x2) / (x0 - x1);
        }
        if (x2 >= x1) {
            return 1.0f;
        }
        if (x2 <= x0) {
            return 0.0f;
        }
        return (x2 - x0) / (x1 - x0);
    }

    public void reset() {
        this.bipedOuter.reset();
        this.bipedTorso.reset();
        this.bipedBody.reset();
        this.bipedBreast.reset();
        this.bipedNeck.reset();
        this.bipedHead.reset();
        this.bipedHeadwear.reset();
        this.bipedEars.reset();
        this.bipedCloak.reset();
        this.bipedRightShoulder.reset();
        this.bipedRightArm.reset();
        this.bipedLeftShoulder.reset();
        this.bipedLeftArm.reset();
        this.bipedPelvic.reset();
        this.bipedRightLeg.reset();
        this.bipedLeftLeg.reset();
        this.bipedRightShoulder.a(-5.0f, 2.0f, 0.0f);
        this.bipedLeftShoulder.a(5.0f, 2.0f, 0.0f);
        this.bipedPelvic.a(0.0f, 12.0f, 0.0f);
        this.bipedRightLeg.a(-2.0f, 0.0f, 0.0f);
        this.bipedLeftLeg.a(2.0f, 0.0f, 0.0f);
        this.bipedCloak.a(0.0f, 0.0f, 2.0f);
    }

    public void renderCloak(float f2) {
        this.attemptToCallRenderCape = true;
        if (!this.disabled) {
            this.imp.superRenderCloak(f2);
        }
    }
}

