/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.render;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import net.minecraft.move.Reflect;
import net.minecraft.move.render.RendererData;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelRotationRenderer
extends ass {
    protected static final float RadiantToAngle = 57.295776f;
    protected static final float Whole = (float)Math.PI * 2;
    protected static final float Half = (float)Math.PI;
    private static Field _compiled = Reflect.GetField(ass.class, "compiled", "q");
    private static Method _compileDisplayList = Reflect.GetMethod(ass.class, "compileDisplayList", "d", Float.TYPE);
    private static Field _displayList = Reflect.GetField(ass.class, "displayList", "r");
    protected ModelRotationRenderer base;
    public boolean compiled = false;
    public int displayList;
    public int rotationOrder = XYZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public boolean ignoreBase;
    public boolean ignoreSuperRotation;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public static int XYZ = 0;
    public static int XZY = 1;
    public static int YXZ = 2;
    public static int YZX = 3;
    public static int ZXY = 4;
    public static int ZYX = 5;
    public boolean fadeEnabled;
    public boolean fadeOffsetX;
    public boolean fadeOffsetY;
    public boolean fadeOffsetZ;
    public boolean fadeRotateAngleX;
    public boolean fadeRotateAngleY;
    public boolean fadeRotateAngleZ;
    public boolean fadeRotationPointX;
    public boolean fadeRotationPointY;
    public boolean fadeRotationPointZ;
    public RendererData previous;
    private static FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private static float[] array = new float[16];

    public ModelRotationRenderer(ars modelBase, int i2, int j2, ModelRotationRenderer baseRenderer) {
        super(modelBase, i2, j2);
        this.base = baseRenderer;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.fadeEnabled = false;
    }

    @Override
    public void a(float f2) {
        if (!this.preRender(f2)) {
            return;
        }
        this.preTransform(f2, true, null);
        GL11.glCallList((int)this.displayList);
        if (this.m != null) {
            for (int i2 = 0; i2 < this.m.size(); ++i2) {
                ((ass)this.m.get(i2)).a(f2);
            }
        }
        this.postTransform(f2, true, null);
    }

    public boolean preRender(float f2) {
        if (this.k) {
            return false;
        }
        if (!this.j) {
            return false;
        }
        if (!this.compiled) {
            this.UpdateCompiled();
        }
        if (!this.compiled) {
            Reflect.Invoke(_compileDisplayList, this, Float.valueOf(f2));
            this.UpdateDisplayList();
            this.compiled = true;
        }
        return true;
    }

    public void preTransform(float f2, boolean push, ModelRotationRenderer top) {
        if (this.base != null && !this.ignoreBase) {
            this.base.preTransform(f2, push, this);
        }
        if (this.f != 0.0f || this.g != 0.0f || this.h != 0.0f || this.ignoreSuperRotation) {
            if (push) {
                GL11.glPushMatrix();
            }
            GL11.glTranslatef((float)(this.c * f2), (float)(this.d * f2), (float)(this.e * f2));
            if (this.ignoreSuperRotation) {
                buffer.rewind();
                GL11.glGetFloat((int)2982, (FloatBuffer)buffer);
                buffer.get(array);
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)(array[12] / array[15]), (float)(array[13] / array[15]), (float)(array[14] / array[15]));
            }
            boolean doRotationX = true;
            boolean doRotationY = true;
            boolean doRotationZ = true;
            ModelRotationRenderer.rotate(this.rotationOrder, this.f, this.g, this.h);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        } else if (this.c != 0.0f || this.d != 0.0f || this.e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.c * f2), (float)(this.d * f2), (float)(this.e * f2));
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        }
    }

    private static void rotate(int rotationOrder, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        if (rotationOrder == ZXY && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationOrder == YXZ && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == YZX || rotationOrder == YXZ || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if ((rotationOrder == XZY || rotationOrder == ZYX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY || rotationOrder == YZX || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == YXZ || rotationOrder == YZX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    public void postTransform(float f2, boolean pop, ModelRotationRenderer top) {
        if (this.f != 0.0f || this.g != 0.0f || this.h != 0.0f || this.ignoreSuperRotation) {
            if (pop) {
                GL11.glPopMatrix();
            }
        } else if (this.c != 0.0f || this.d != 0.0f || this.e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(-this.offsetX), (float)(-this.offsetY), (float)(-this.offsetZ));
            GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
            GL11.glTranslatef((float)(-this.c * f2), (float)(-this.d * f2), (float)(-this.e * f2));
        }
        if (this.base != null && !this.ignoreBase) {
            this.base.postTransform(f2, pop, this);
        }
    }

    public void reset() {
        this.rotationOrder = XYZ;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.c = 0.0f;
        this.d = 0.0f;
        this.e = 0.0f;
        this.f = 0.0f;
        this.g = 0.0f;
        this.h = 0.0f;
        this.ignoreBase = false;
        this.ignoreSuperRotation = false;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.offsetZ = 0.0f;
        this.fadeOffsetX = false;
        this.fadeOffsetY = false;
        this.fadeOffsetZ = false;
        this.fadeRotateAngleX = false;
        this.fadeRotateAngleY = false;
        this.fadeRotateAngleZ = false;
        this.fadeRotationPointX = false;
        this.fadeRotationPointY = false;
        this.fadeRotationPointZ = false;
        this.previous = null;
    }

    @Override
    public void b(float f2) {
        boolean update = !this.compiled;
        super.b(f2);
        if (update) {
            this.UpdateLocals();
        }
    }

    @Override
    public void c(float f2) {
        boolean update;
        boolean bl2 = update = !this.compiled;
        if (!this.preRender(f2)) {
            return;
        }
        if (update) {
            this.UpdateLocals();
        }
        this.preTransform(f2, false, null);
    }

    private void UpdateLocals() {
        this.UpdateCompiled();
        if (this.compiled) {
            this.UpdateDisplayList();
        }
    }

    private void UpdateCompiled() {
        this.compiled = (Boolean)Reflect.GetField(_compiled, this);
    }

    private void UpdateDisplayList() {
        this.displayList = (Integer)Reflect.GetField(_displayList, this);
    }

    public void fadeStore(float totalTime) {
        if (this.previous != null) {
            this.previous.offsetX = this.offsetX;
            this.previous.offsetY = this.offsetY;
            this.previous.offsetZ = this.offsetZ;
            this.previous.rotateAngleX = this.f;
            this.previous.rotateAngleY = this.g;
            this.previous.rotateAngleZ = this.h;
            this.previous.rotationPointX = this.c;
            this.previous.rotationPointY = this.d;
            this.previous.rotationPointZ = this.e;
            this.previous.totalTime = totalTime;
        }
    }

    public void fadeIntermediate(float totalTime) {
        if (this.previous != null && totalTime - this.previous.totalTime <= 2.0f) {
            this.offsetX = this.GetIntermediatePosition(this.previous.offsetX, this.offsetX, this.fadeOffsetX, this.previous.totalTime, totalTime);
            this.offsetY = this.GetIntermediatePosition(this.previous.offsetY, this.offsetY, this.fadeOffsetY, this.previous.totalTime, totalTime);
            this.offsetZ = this.GetIntermediatePosition(this.previous.offsetZ, this.offsetZ, this.fadeOffsetZ, this.previous.totalTime, totalTime);
            this.f = this.GetIntermediateAngle(this.previous.rotateAngleX, this.f, this.fadeRotateAngleX, this.previous.totalTime, totalTime);
            this.g = this.GetIntermediateAngle(this.previous.rotateAngleY, this.g, this.fadeRotateAngleY, this.previous.totalTime, totalTime);
            this.h = this.GetIntermediateAngle(this.previous.rotateAngleZ, this.h, this.fadeRotateAngleZ, this.previous.totalTime, totalTime);
            this.c = this.GetIntermediatePosition(this.previous.rotationPointX, this.c, this.fadeRotationPointX, this.previous.totalTime, totalTime);
            this.d = this.GetIntermediatePosition(this.previous.rotationPointY, this.d, this.fadeRotationPointY, this.previous.totalTime, totalTime);
            this.e = this.GetIntermediatePosition(this.previous.rotationPointZ, this.e, this.fadeRotationPointZ, this.previous.totalTime, totalTime);
        }
    }

    private float GetIntermediatePosition(float prevPosition, float shouldPosition, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldPosition == prevPosition) {
            return shouldPosition;
        }
        return prevPosition + (shouldPosition - prevPosition) * (totalTime - lastTotalTime) * 0.2f;
    }

    private float GetIntermediateAngle(float prevAngle, float shouldAngle, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldAngle == prevAngle) {
            return shouldAngle;
        }
        while (prevAngle >= (float)Math.PI * 2) {
            prevAngle -= (float)Math.PI * 2;
        }
        while (prevAngle < 0.0f) {
            prevAngle += (float)Math.PI * 2;
        }
        while (shouldAngle >= (float)Math.PI * 2) {
            shouldAngle -= (float)Math.PI * 2;
        }
        while (shouldAngle < 0.0f) {
            shouldAngle += (float)Math.PI * 2;
        }
        if (shouldAngle > prevAngle && shouldAngle - prevAngle > (float)Math.PI) {
            prevAngle += (float)Math.PI * 2;
        }
        if (shouldAngle < prevAngle && prevAngle - shouldAngle > (float)Math.PI) {
            shouldAngle += (float)Math.PI * 2;
        }
        return prevAngle + (shouldAngle - prevAngle) * (totalTime - lastTotalTime) * 0.2f;
    }
}

