/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.move.Reflect;
import net.minecraft.move.config.Properties;

public class Value {
    private int type;
    private Object value;
    private Dictionary keyValues;
    private List unparsableStrings;
    public static final String Null = "null";
    private static final List _allkeys = new LinkedList();
    public static final Class keyboard = Reflect.LoadClass(Value.class, "org.lwjgl.input.Keyboard", null, false);
    public static final Class mouse = Reflect.LoadClass(Value.class, "org.lwjgl.input.Mouse", null, false);
    public static final Method _getKeyName = keyboard != null ? Reflect.GetMethod(keyboard, "getKeyName", null, Integer.TYPE) : null;
    public static final Method _getKeyIndex = keyboard != null ? Reflect.GetMethod(keyboard, "getKeyIndex", null, String.class) : null;
    public static final Method _getButtonName = mouse != null ? Reflect.GetMethod(mouse, "getButtonName", null, Integer.TYPE) : null;
    public static final Method _getButtonIndex = mouse != null ? Reflect.GetMethod(mouse, "getButtonIndex", null, String.class) : null;

    public Value(int type) {
        this.type = type;
    }

    public Value(Object value) {
        this.value = value;
    }

    public Value(Value value) {
        this.type = value.type;
        this.value = value.value;
        if (value.keyValues != null) {
            this.keyValues = new Hashtable();
            Enumeration keys = value.keyValues.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.keyValues.put(key, value.keyValues.get(key));
            }
        }
    }

    public Value put(Object value) {
        return this.put(null, value);
    }

    public Object get(String key) {
        Object value;
        if (key != null && this.keyValues != null && (value = this.keyValues.get(key)) != null) {
            return value;
        }
        return this.value;
    }

    public Object getStored(String key) {
        if (key == null || key == Null) {
            return this.value;
        }
        if (this.keyValues != null) {
            return this.keyValues.get(key);
        }
        return null;
    }

    private Object get(String key, Value defaultValue) {
        Object result = this.get(key);
        if (result == null && (result = this.value) == null) {
            result = defaultValue.value;
        }
        return result;
    }

    public Value put(String key, Object value) {
        if (key == null || key == Null || key.isEmpty()) {
            this.value = value;
        } else {
            if (this.keyValues == null) {
                this.keyValues = new Hashtable();
            }
            this.keyValues.put(key, value);
        }
        return this;
    }

    public void withDependency(Value dependency, Value defaultValue) {
        Iterator iterator = Value.GetAllKeys(this, dependency);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!this.get(key, defaultValue).equals(true) || !dependency.get(key).equals(false)) continue;
            this.put(key, false);
        }
    }

    public void withMinimum(Value minimum, Value defaultValue) {
        Iterator iterator = Value.GetAllKeys(this, minimum);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.put(key, Float.valueOf(Math.max(((Float)this.get(key, defaultValue)).floatValue(), ((Float)minimum.get(key)).floatValue())));
        }
    }

    public void withMaximum(Value maximum, Value defaultValue) {
        Iterator iterator = Value.GetAllKeys(this, maximum);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.put(key, Float.valueOf(Math.min(((Float)this.get(key, defaultValue)).floatValue(), ((Float)maximum.get(key)).floatValue())));
        }
    }

    public Value is(Value right) {
        Value result = new Value(Properties.Boolean);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object leftValue = this.get(key);
            Object rightValue = right.get(key);
            result.put(key, leftValue == null && rightValue == null || leftValue != null && rightValue != null && leftValue.equals(rightValue));
        }
        return result;
    }

    public Value and(Value right) {
        Value result = new Value(Properties.Boolean);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = (String)iterator.next()) != false && (Boolean)right.get(key) != false);
        }
        return result;
    }

    public Value or(Value right) {
        Value result = new Value(Properties.Boolean);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = (String)iterator.next()) != false || (Boolean)right.get(key) != false);
        }
        return result;
    }

    public Value not() {
        Value result = new Value(Properties.Boolean);
        Iterator iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = (String)iterator.next()) == false);
        }
        return result;
    }

    public Value plus(Value right) {
        Value result = new Value(Properties.Float);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Float.valueOf(((Float)this.get(key)).floatValue() + ((Float)right.get(key)).floatValue()));
        }
        return result;
    }

    public Value eitherOr(Value left, Value right) {
        Value result = new Value(Properties.getBaseType(left.type));
        Iterator iterator = Value.GetAllKeys(this, left, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = (String)iterator.next()) != false ? left.get(key) : right.get(key));
        }
        return result;
    }

    public Value maximum(Value right) {
        Value result = new Value(Properties.Float);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Float.valueOf(Math.max(((Float)this.get(key)).floatValue(), ((Float)right.get(key)).floatValue())));
        }
        return result;
    }

    public Value minimum(Value right) {
        Value result = new Value(Properties.Float);
        Iterator iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Float.valueOf(Math.min(((Float)this.get(key)).floatValue(), ((Float)right.get(key)).floatValue())));
        }
        return result;
    }

    public Value toKeyName() {
        Value result = new Value(Properties.String);
        Iterator iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Value.toKeyName((Integer)this.get(key)));
        }
        return result;
    }

    public Value toKeyCode() {
        Value result = new Value(Properties.Integer);
        Iterator iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Value.toKeyCode((String)this.get(key)));
        }
        return result;
    }

    public Value toBlockConfig() {
        Value result = new Value(Properties.Strings);
        Iterator iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result.put(key, Value.toBlockConfig((String[])this.get(key)));
        }
        return result;
    }

    public Value clone() {
        return new Value(this);
    }

    public static Iterator GetAllKeys(Value ... values) {
        return Value.GetAllKeys(null, values);
    }

    public static Iterator GetAllKeys(String[] sorted, Value ... values) {
        int i2;
        _allkeys.clear();
        for (i2 = 0; i2 < values.length; ++i2) {
            Value value = values[i2];
            if (value.keyValues == null) continue;
            Enumeration keys = value.keyValues.keys();
            while (keys.hasMoreElements()) {
                _allkeys.add(keys.nextElement());
            }
        }
        Collections.sort(_allkeys);
        _allkeys.add(0, Null);
        int n2 = 1;
        for (i2 = 0; sorted != null && i2 < sorted.length; ++i2) {
            String sort = sorted[i2];
            if (sort == null || sort == Null || !_allkeys.remove(sort)) continue;
            _allkeys.add(n2++, sort);
        }
        return _allkeys.iterator();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value otherValue = (Value)other;
        if (this.value == null != (otherValue.value == null)) {
            return false;
        }
        if (this.value != null && !this.valuesEqual(this.value, otherValue.value)) {
            return false;
        }
        if ((this.keyValues == null ? 0 : this.keyValues.size()) != (otherValue.keyValues == null ? 0 : otherValue.keyValues.size())) {
            return false;
        }
        if (this.keyValues != null && this.keyValues.size() != 0) {
            Enumeration keys = this.keyValues.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object otherKeyValue = otherValue.keyValues.get(key);
                if (otherKeyValue == null) {
                    return false;
                }
                Object keyValue = this.keyValues.get(key);
                if (this.valuesEqual(keyValue, otherKeyValue)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean valuesEqual(Object first, Object second) {
        if (!(first instanceof Object[])) {
            return first.equals(second);
        }
        Object[] firstArray = (Object[])first;
        Object[] secondArray = (Object[])second;
        if (firstArray.length != secondArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < firstArray.length; ++i2) {
            if (firstArray[i2].equals(secondArray[i2])) continue;
            return false;
        }
        return true;
    }

    public Value load(String content, boolean singular) {
        if (content == null || singular) {
            this.value = this.parsePropertyElement(content);
            return this;
        }
        String[] elements = content.split(";");
        for (int i2 = 0; i2 < elements.length; ++i2) {
            String element = elements[i2];
            int seperatorIndex = element.indexOf(58);
            String key = null;
            String keyValue = null;
            if (seperatorIndex > 0) {
                key = element.substring(0, seperatorIndex);
                keyValue = element.substring(seperatorIndex + 1);
            } else {
                keyValue = element;
            }
            Object value = this.parsePropertyElement(keyValue);
            if (value != null) {
                this.put(key, value);
                continue;
            }
            if (this.unparsableStrings == null) {
                this.unparsableStrings = new ArrayList();
            }
            this.unparsableStrings.add(keyValue);
        }
        return this;
    }

    public Iterator getUnparsableStrings() {
        if (this.unparsableStrings != null) {
            return this.unparsableStrings.iterator();
        }
        return null;
    }

    public void print(PrintStream printer, String[] sorted) {
        boolean first = true;
        Iterator keys = Value.GetAllKeys(sorted, this);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key == Null && this.value == null) continue;
            if (!first) {
                printer.print(";");
            } else {
                first = false;
            }
            if (key != Null) {
                printer.print(key);
                printer.print(":");
            }
            this.printDisplayString(printer, this.get(key));
        }
    }

    public String toString() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.print(new PrintStream(result), null);
        return new String(result.toByteArray());
    }

    private void printDisplayString(PrintStream printer, Object value) {
        if (value instanceof String[]) {
            boolean first = true;
            String[] values = (String[])value;
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (first) {
                    first = false;
                } else {
                    printer.print(",");
                }
                printer.print(this.getDisplayString(values[i2]));
            }
        } else {
            printer.print(this.getDisplayString(value));
        }
    }

    private String getDisplayString(Object value) {
        String result = value.toString();
        if (result.endsWith(".0")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private Object parsePropertyElement(String stringToParse) {
        int baseType = Properties.getBaseType(this.type);
        if (baseType == Properties.Boolean) {
            return Value.tryParseBoolean(stringToParse);
        }
        if (baseType == Properties.Float) {
            return Value.tryParseFloat(stringToParse);
        }
        if (baseType == Properties.Integer) {
            return Value.tryParseInteger(stringToParse);
        }
        if (baseType == Properties.Strings) {
            return Value.tryParseStrings(stringToParse);
        }
        if (baseType == Properties.String) {
            return Value.tryParseString(stringToParse);
        }
        return null;
    }

    public static Boolean tryParseBoolean(String value) {
        try {
            if (value != null) {
                return value.equals("true") ? true : (value.equals("false") ? Boolean.valueOf(false) : null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Float tryParseFloat(String value) {
        try {
            if (value != null) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Integer tryParseInteger(String value) {
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String tryParseString(String value) {
        return value == null ? null : value;
    }

    public static String[] tryParseStrings(String value) {
        return value == null ? null : (value.isEmpty() ? new String[]{} : value.split(","));
    }

    public Value e(Object e2) {
        return this.put("e", e2);
    }

    public Value m(Object m2) {
        return this.put("m", m2);
    }

    public Value h(Object h2) {
        return this.put("h", h2);
    }

    public Value c(Object c2) {
        return this.put("c", c2);
    }

    public static String toKeyName(Integer keyCode) {
        if (keyCode == null) {
            return null;
        }
        if (keyCode >= 0) {
            return (String)Reflect.Invoke(_getKeyName, null, keyCode);
        }
        return (String)Reflect.Invoke(_getButtonName, null, keyCode);
    }

    private static Integer toKeyCode(String keyName) {
        if (keyName == null) {
            return null;
        }
        keyName = keyName.toUpperCase();
        int keyCode = (Integer)Reflect.Invoke(_getKeyIndex, null, keyName);
        if (keyCode > 0) {
            return keyCode;
        }
        keyCode = (Integer)Reflect.Invoke(_getButtonIndex, null, keyName) - 100;
        if (keyCode > 0) {
            return keyCode - 100;
        }
        return null;
    }

    private static Dictionary toBlockConfig(String[] config) {
        if (config == null) {
            return null;
        }
        Hashtable result = new Hashtable();
        for (int i2 = 0; i2 < config.length; ++i2) {
            String[] elements = config[i2].split("/");
            if (elements.length <= 0) continue;
            HashSet<Integer> metaDatas = new HashSet<Integer>();
            String blockName = elements[0];
            ((Dictionary)result).put(blockName, metaDatas);
            if (blockName.matches("[0-9]+")) {
                ((Dictionary)result).put(Integer.parseInt(blockName), metaDatas);
            }
            for (int n2 = 1; n2 < elements.length; ++n2) {
                String metaDataText = elements[n2];
                if (!metaDataText.matches("[0-9]+")) continue;
                metaDatas.add(Integer.parseInt(metaDataText));
            }
        }
        return result;
    }
}

