/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.move.config.Properties;
import net.minecraft.move.config.Property;
import net.minecraft.move.config.SmartMovingConfig;

public class SmartMovingServerOptions
extends SmartMovingConfig {
    public final Property _enabled = SmartMovingServerOptions.Unmodified("move.enable", new String[0]).singular().comment("To switch on/off smart moving on this server").book("Configuration Management", "Below you find the options to define multiple configuration option and how to communicate them to the clients");
    public final Property _configKey = SmartMovingServerOptions.String("move.config.key", new String[0]).defaults("m", new String[0]).singular().comment("The key of the option configuration to transfer to the clients when they connect to this server").section(new String[0]);
    public final Property _configKeyName = SmartMovingServerOptions.String("move.config.key.name", new String[0]).defaults(this.Value((String)null).c("Creative").e("Easy").m("Medium").h("Hard"), new String[0]).defaults(this.Value((String)null).e("Easy").m("Medium").h("Hard"), _pre_sm_2_3).comment("The display names of the option configuration keys");
    public final Property _configSend = SmartMovingServerOptions.Modified("move.config.overwrite", new String[0]).key("move.config.send", _pre_sm_2_2).singular().comment("To switch on/off overriding client configurations while connected to this server").section(new String[0]);

    public SmartMovingServerOptions(File optionsPath, Logger logger, boolean isClientServer) {
        this.loadFromOptionsFile(optionsPath, isClientServer);
        this.saveToOptionsFile(optionsPath, isClientServer);
        String message = "Smart Moving ";
        if (((Boolean)this._configSend.value).booleanValue()) {
            logger.info(message + "overrides client configurations");
            if (((Boolean)this._enabled.value).booleanValue()) {
                message = message + "uses ";
                if (((String)this._configKey.value).isEmpty()) {
                    logger.info(message + "default server configuration");
                } else {
                    this.setKeys(new String[]{(String)this._configKey.value});
                    this.setCurrentKey((String)this._configKey.value);
                    message = message + "server configuration ";
                    if (((String)this._configKeyName.value).isEmpty()) {
                        logger.info(message + "with key \"" + (String)this._configKey.value + "\"");
                    } else {
                        logger.info(message + "\"" + (String)this._configKeyName.value + "\"");
                    }
                }
            } else {
                this.setCurrentKey(null);
                logger.info(message + "disabled");
            }
        } else {
            logger.info(message + "allows client configurations");
        }
    }

    public String[] writeToProperties() {
        Properties properties = new Properties();
        this.writeToProperties(properties, this.getProperties(SmartMovingServerOptions.class));
        String[] result = new String[properties.size() * 2];
        Iterator<Map.Entry<Object, Object>> keys = properties.entrySet().iterator();
        int i2 = 0;
        while (keys.hasNext()) {
            Map.Entry<Object, Object> entry = keys.next();
            result[i2++] = entry.getKey().toString();
            result[i2++] = entry.getValue().toString();
        }
        return result;
    }
}

