/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.move.config.Properties;
import net.minecraft.move.config.Property;

public abstract class SmartMovingProperties
extends Properties {
    private static final String[] _defaultKeys = new String[1];
    private int toggler = -2;
    private String[] keys = _defaultKeys;
    public boolean enabled;

    protected void load(Properties ... propertiesList) throws Exception {
        Iterator iterator;
        List propertiesToLoad = this.getProperties();
        if (this.toggler != -2) {
            iterator = propertiesToLoad.iterator();
            while (iterator.hasNext()) {
                ((Property)iterator.next()).reset();
            }
        }
        while (propertiesToLoad.size() > 0) {
            iterator = propertiesToLoad.iterator();
            while (iterator.hasNext()) {
                if (!((Property)iterator.next()).load(propertiesList)) continue;
                iterator.remove();
            }
        }
        this.toggler = 0;
        this.update();
    }

    protected void save(File file, String version, boolean header, boolean comments) throws Exception {
        List propertiesToSave = this.getProperties();
        FileOutputStream stream = new FileOutputStream(file);
        PrintStream printer = new PrintStream(stream);
        if (header) {
            this.printHeader(printer);
        }
        if (version != null) {
            this.printVersion(printer, version, comments);
        }
        for (int i2 = 0; i2 < propertiesToSave.size(); ++i2) {
            if (!((Property)propertiesToSave.get(i2)).print(printer, this.keys, version, comments) || i2 >= propertiesToSave.size() - 1) continue;
            printer.println();
        }
        printer.close();
    }

    protected abstract void printVersion(PrintStream var1, String var2, boolean var3);

    protected abstract void printHeader(PrintStream var1);

    public void toggle() {
        int length = this.keys == null ? 0 : this.keys.length;
        ++this.toggler;
        if (this.toggler == length) {
            this.toggler = -1;
        }
        this.update();
    }

    public void setKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            keys = _defaultKeys;
        }
        this.keys = keys;
        this.toggler = 0;
        this.update();
    }

    public void setCurrentKey(String key) {
        if (key == null) {
            this.toggler = -1;
        } else if (this.keys.length == 1 && this.keys[0] == null && key.equals("enabled")) {
            this.toggler = 0;
        } else {
            this.toggler = 0;
            while (!(this.toggler >= this.keys.length || key == null && this.keys[this.toggler] == null || key != null && key.equals(this.keys[this.toggler]))) {
                ++this.toggler;
            }
            if (this.toggler == this.keys.length) {
                this.toggler = -1;
            }
        }
        this.update();
    }

    public String getCurrentKey() {
        if (this.toggler == -1) {
            return null;
        }
        return this.keys[this.toggler];
    }

    public int getKeyCount() {
        return this.keys.length;
    }

    protected void update() {
        List properties = this.getProperties();
        Iterator iterator = properties.iterator();
        String currentKey = this.getCurrentKey();
        while (iterator.hasNext()) {
            ((Property)iterator.next()).update(currentKey);
        }
        this.enabled = this.toggler != -1;
    }
}

