/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.config.Property;
import net.minecraft.move.config.SmartMovingClientConfig;
import net.minecraft.move.config.Value;

public class SmartMovingOptions
extends SmartMovingClientConfig {
    public final Property _perspectiveFadeFactor = SmartMovingOptions.PositiveFactor("move.perspective.fade.factor", new String[0]).values(java.lang.Float.valueOf(0.5f), java.lang.Float.valueOf(0.1f), java.lang.Float.valueOf(1.0f)).comment("Fading speed factor between the different perspectives (>= 0.1, <= 1, set to '1' to switch off)").book("Viewpoint perspective", "Below you find the options to manipulate the viewpoint perspective");
    public final Property _perspectiveRunFactor = SmartMovingOptions.Float("move.perspective.run.factor", new String[0]).key("move.run.perspective.factor", _pre_sm_2_1).defaults(java.lang.Float.valueOf(1.0f), new String[0]).comment("Standard sprinting perspective (set to '0' to switch off)");
    public final Property _perspectiveSprintFactor = SmartMovingOptions.Float("move.perspective.sprint.factor", new String[0]).key("move.sprint.perspective.factor", _pre_sm_2_1).defaults(java.lang.Float.valueOf(1.5f), new String[0]).comment("Smart on ground sprinting perspective (set to '0' to switch off)");
    public final Property _angleJumpDoubleClickTicks = SmartMovingOptions.Positive("move.jump.angle.double.click.ticks", new String[0]).singular().up(java.lang.Float.valueOf(3.0f), java.lang.Float.valueOf(2.0f)).comment("The maximum number of ticks between two clicks to trigger a side or back jump (>= 2)").book("User interface", "Below you find the options to manipulate Smart Moving's user interface");
    public final Property _displayExhaustionBar = SmartMovingOptions.Unmodified("move.gui.exhaustion.bar", new String[0]).singular().comment("Whether to display the exhaustion bar in the game overlay").section(new String[0]);
    public final Property _displayJumpChargeBar = SmartMovingOptions.Unmodified("move.gui.jump.charge.bar", new String[0]).singular().comment("Whether to display the jump charge bar in the game overlay");
    public final Property _sneakToggle = SmartMovingOptions.Modified("move.sneak.toggle", new String[0]).comment("To switch on/off sneak toggling").section(new String[0]);
    public final Property _crawlToggle = SmartMovingOptions.Modified("move.crawl.toggle", new String[0]).comment("To switch on/off crawl toggling");
    private final Property _old_toggleKeyCode = SmartMovingOptions.Integer("move.toggle.key", _pre_sm_1_7).singular().defaults(67, new String[0]);
    public final Property _toggleKeyName = SmartMovingOptions.String("move.toggle.key.name", new String[0]).singular().defaults("F9", new String[0]).source(this._old_toggleKeyCode.toKeyName(), _pre_sm_1_7).singular().comment("Key name to toggle Smart Moving features in-game (default: \"F9\")").section(new String[0]);
    public final Property _toggleKeyCode = this._toggleKeyName.toKeyCode(67);
    public final Property _survivalConfigKeys = SmartMovingOptions.Strings("move.config.survival.keys", new String[0]).singular().defaults(new String[]{"e", "m", "h"}, new String[0]).comment("A list of survival option configuration keys, entries seperated by ','").book("Configuration Management", "Below you find the options to define multiple configuration option sets");
    public final Property _survivalDefaultConfigKey = SmartMovingOptions.String("move.config.survival.keys.default", new String[0]).singular().defaults("m", new String[0]).comment("The option configuration to start the next minecraft survival game with (can also be modified via in-game option configuration toggling)");
    public final Property _creativeConfigKeys = SmartMovingOptions.Strings("move.config.creative.keys", new String[0]).singular().defaults(new String[]{"c"}, new String[0]).defaults(new String[0], _pre_sm_2_3).comment("A list of creative option configuration keys, entries seperated by ','").section(new String[0]);
    public final Property _creativeDefaultConfigKey = SmartMovingOptions.String("move.config.creative.keys.default", new String[0]).singular().defaults("c", new String[0]).defaults("", _pre_sm_2_3).comment("The option configuration to start the next minecraft creative game with (can also be modified via in-game option configuration toggling)");
    public final Property _configKeyName = SmartMovingOptions.String("move.config.key.name", new String[0]).defaults(this.Value((String)null).e("Easy").m("Medium").h("Hard"), new String[0]).comment("The display names of the option configuration keys").section(new String[0]);
    public final Property _configChat = SmartMovingOptions.Unmodified("move.config.chat", new String[0]).singular().comment("To switch on/off option status messages via chat system").book("Message Management", "Below you find the options to define in which case Smart Moving should write messages about its current behavior to the ingame chat");
    public final Property _configChatInit = SmartMovingOptions.Unmodified("move.config.chat.init", new String[0]).depends(this._configChat).singular().comment("To switch on/off the initial option status message when starting a game (Relevant only if \"move.config.chat\" is not false)");
    public final Property _configChatInitHelp = SmartMovingOptions.Unmodified("move.config.chat.init", new String[0]).depends(this._configChatInit).singular().comment("To switch on/off the initial option help message (Relevant only if \"move.config.chat.init\" is not false)");
    public final Property _configChatServer = SmartMovingOptions.Unmodified("move.config.chat.server", new String[0]).depends(this._configChat).singular().comment("To switch on/off the server config overridden status message when joining a multiplayer game (Relevant only if \"move.config.chat\" is not false)");
    public ane keyBindGrab;
    public ane keyBindSprint;
    public static final File optionsPath = Minecraft.b();
    public static boolean hasRedPowerWire = false;
    public static boolean hasBuildCraftTransportation = false;
    public static boolean hasFiniteLiquid = false;
    public static boolean hasBetterThanWolves = false;
    public static boolean hasSinglePlayerCommands = false;
    public static boolean hasRopesPlus = false;
    public static boolean hasASGrapplingHook = false;
    public static boolean hasBetterMisc = false;
    private Field ropesPlus;
    public int gameType;
    private static final int Unknown = -1;
    private static final int Survival = 0;
    private static final int Creative = 1;

    public SmartMovingOptions() {
        this.loadFromOptionsFile(optionsPath, false);
        this.saveToOptionsFile(optionsPath, false);
        this.keyBindGrab = new ane("key.climb", 29);
        this.keyBindSprint = new ane("key.sprint", 15);
        this.gameType = -1;
    }

    public boolean isSneakToggleEnabled() {
        return (Boolean)this._sneakToggle.value != false && this.enabled;
    }

    public boolean isCrawlToggleEnabled() {
        return (Boolean)this._crawlToggle.value != false && this.enabled;
    }

    public int angleJumpDoubleClickTicks() {
        return (int)Math.ceil(((Float)this._angleJumpDoubleClickTicks.value).floatValue());
    }

    @Override
    public void toggle() {
        super.toggle();
        if (((Boolean)this._configChat.value).booleanValue()) {
            this.writeClientConfigMessageToChat();
        }
        Property defaultKey = null;
        switch (this.gameType) {
            case 0: {
                defaultKey = this._survivalDefaultConfigKey;
                break;
            }
            case 1: {
                defaultKey = this._creativeDefaultConfigKey;
            }
        }
        if (defaultKey != null) {
            String currentKey = this.getCurrentKey();
            if (currentKey == null) {
                currentKey = this.enabled ? "enabled" : "disabled";
            }
            defaultKey.setValue(currentKey);
            this.saveToOptionsFile(optionsPath, false);
        }
    }

    private void writeClientConfigMessageToChat() {
        String prefix = "move.config.chat.client.";
        if (this.enabled) {
            boolean unnamed;
            String name = (String)this._configKeyName.value;
            if (name.isEmpty()) {
                name = null;
            }
            boolean bl2 = unnamed = name == null;
            if (unnamed) {
                name = this.getCurrentKey();
            }
            if (name == null || unnamed && this.getKeyCount() == 1) {
                SmartMovingOptions.writeToChat(prefix + "enabled", new Object[0]);
            } else {
                SmartMovingOptions.writeToChat(prefix + (unnamed ? "unnamed" : "named"), name);
            }
        } else {
            SmartMovingOptions.writeToChat(prefix + "disabled", new Object[0]);
        }
    }

    public void writeServerConfigMessageToChat() {
        if (((Boolean)this._configChatServer.value).booleanValue()) {
            SmartMovingOptions.writeToChat(SmartMovingContext.Config.enabled ? "move.config.chat.server.overwrite" : "move.config.chat.server.disable", new Object[0]);
        }
    }

    public void writeServerReconfigMessageToChat(boolean wasEnabled) {
        if (((Boolean)this._configChatServer.value).booleanValue()) {
            if (SmartMovingContext.Config.enabled) {
                if (wasEnabled) {
                    SmartMovingOptions.writeToChat("move.config.chat.server.update", new Object[0]);
                } else {
                    SmartMovingOptions.writeToChat("move.config.chat.server.enable", new Object[0]);
                }
            } else if (wasEnabled) {
                SmartMovingOptions.writeToChat("move.config.chat.server.disable", new Object[0]);
            }
        }
    }

    public void writeServerDeconfigMessageToChat() {
        if (((Boolean)this._configChatServer.value).booleanValue()) {
            SmartMovingOptions.writeToChat("move.config.chat.server.free", new Object[0]);
        }
    }

    private static void writeToChat(String key, Object ... parameters) {
        ak translator = ak.a();
        String message = parameters == null || parameters.length == 0 ? translator.b(key) : translator.a(key, parameters);
        SmartMovingContext.GetMinecraft().v.b().a(message, new Object[0]);
    }

    public static void initialize(boolean redPowerWiring, boolean buildCraftTransportation, boolean finiteLiquid, boolean betterThanWolves, boolean singlePlayerCommands, boolean ropesPlus, boolean aSGrapplingHook, boolean betterMisc) {
        hasRedPowerWire = redPowerWiring;
        hasBuildCraftTransportation = buildCraftTransportation;
        hasFiniteLiquid = finiteLiquid;
        hasBetterThanWolves = betterThanWolves;
        hasSinglePlayerCommands = singlePlayerCommands;
        hasRopesPlus = ropesPlus;
        hasASGrapplingHook = aSGrapplingHook;
        hasBetterMisc = betterMisc;
    }

    public void initializeForGame() {
        atb controller = SmartMovingContext.GetMinecraft().b;
        this.gameType = controller.g() ? 0 : (controller.h() ? 1 : -1);
        String[] keys = null;
        String defaultKey = null;
        switch (this.gameType) {
            case 0: {
                keys = (String[])this._survivalConfigKeys.value;
                defaultKey = (String)this._survivalDefaultConfigKey.value;
                break;
            }
            case 1: {
                keys = (String[])this._creativeConfigKeys.value;
                defaultKey = (String)this._creativeDefaultConfigKey.value;
                break;
            }
            default: {
                defaultKey = "";
            }
        }
        this.setKeys(keys);
        if (!defaultKey.isEmpty()) {
            this.setCurrentKey(defaultKey);
        }
        if (((Boolean)this._configChatInit.value).booleanValue()) {
            this.writeClientConfigMessageToChat();
        }
        if (((Boolean)this._configChatInitHelp.value).booleanValue()) {
            SmartMovingOptions.writeToChat("move.config.chat.client.help", Value.toKeyName((Integer)this._toggleKeyCode.value));
        }
    }
}

