/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.move.config.Properties;
import net.minecraft.move.config.Value;

public class Property {
    private static final int printWidth = 69;
    private String comment;
    private String[] header;
    private int gap;
    private boolean explicitlyModified;
    private boolean implicitlyModified;
    private String aquiredString;
    private boolean singular;
    private final int type;
    private String currentVersion;
    private Map versionSources;
    private Map versionDefaults;
    private static int i = 0;
    private static final int Is = i++;
    private static final int And = i++;
    private static final int Or = i++;
    private static final int Not = i++;
    private static final int Plus = i++;
    private static final int EitherOr = i++;
    private static final int Maximum = i++;
    private static final int Minimum = i++;
    private static final int ToKeyName = i++;
    private static final int ToKeyCode = i++;
    private static final int ToBlockConfig = i++;
    public Object value;
    private Value systemValue;
    private Value aquiredValue;
    private Object minValue;
    private Object maxValue;
    private Object local;
    private Object left;
    private int operator;
    private Object right;
    private List depends = null;
    private static final String Current = "";
    private static final String[] CurrentArray = new String[]{""};

    public Property(int type) {
        this.type = type;
    }

    private Property(String key) {
        this(Properties.Key);
        this.set(new Value(key));
    }

    private Property(Object left, int operator, Object right) {
        this(Properties.Operator);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    private Property(Object local, int operator, Object left, Object right) {
        this(Properties.Operator);
        this.local = local;
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public void update(String key) {
        this.value = this.getKeyValue(key);
    }

    public void setValue(Object value) {
        this.value = value;
        this.systemValue = new Value(value);
        this.aquiredValue = new Value(value);
        this.implicitlyModified = false;
        this.explicitlyModified = false;
    }

    public Property singular() {
        this.singular = true;
        return this;
    }

    public Property is(Object value) {
        return new Property(this, Is, value);
    }

    public Property and(Object value) {
        return new Property(this, And, value);
    }

    public Property or(Object value) {
        return new Property(this, Or, value);
    }

    public Property andNot(Property value) {
        return this.and(value.not());
    }

    public Property not() {
        return new Property(this, Not, null);
    }

    public Property plus(Object value) {
        return new Property(this, Plus, value);
    }

    public Property eitherOr(Object either, Object or2) {
        return new Property(this, EitherOr, either, or2);
    }

    public Property maximum(Object value) {
        return new Property(this, Maximum, value);
    }

    public Property minimum(Object value) {
        return new Property(this, Minimum, value);
    }

    public Property toKeyName() {
        return new Property(this, ToKeyName, null);
    }

    public Property toKeyCode(Integer defaultValue) {
        return new Property(this, ToKeyCode, null).defaults(defaultValue, new String[0]);
    }

    public Property toBlockConfig() {
        return new Property(this, ToBlockConfig, null);
    }

    public Property depends(Property ... conditions) {
        if (this.depends == null) {
            this.depends = new LinkedList();
        }
        for (int i2 = 0; i2 < conditions.length; ++i2) {
            this.depends.add(conditions[i2]);
        }
        return this;
    }

    public Property values(Object defaultValue, Object minValue, Object maxValue) {
        return this.defaults(defaultValue, new String[0]).range(minValue, maxValue);
    }

    public Property up(Object defaultValue, Object minValue) {
        return this.defaults(defaultValue, new String[0]).min(minValue);
    }

    public Property down(Object defaultValue, Object maxValue) {
        return this.defaults(defaultValue, new String[0]).max(maxValue);
    }

    public Property range(Object minValue, Object maxValue) {
        return this.min(minValue).max(maxValue);
    }

    public Property defaults(Object defaultValue, String ... versions) {
        this.versionDefaults = this.addVersioned(this.versionDefaults, defaultValue, versions);
        return this;
    }

    public Property min(Object minValue) {
        this.minValue = minValue;
        return this;
    }

    public Property max(Object maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public Property key(String key, String ... versions) {
        if (this.currentVersion == null) {
            this.currentVersion = versions != null && versions.length > 0 ? versions[0] : Current;
        }
        return this.source(new Property(key), versions);
    }

    public Property source(Object source, String ... versions) {
        this.versionSources = this.addVersioned(this.versionSources, source, versions);
        return this;
    }

    public Property comment(String comment) {
        this.comment = comment;
        return this;
    }

    public Property section(String ... header) {
        this.gap = 1;
        this.header = header;
        return this;
    }

    public Property chapter(String ... header) {
        this.gap = 2;
        this.header = header;
        return this;
    }

    public Property book(String ... header) {
        this.gap = 3;
        this.header = header;
        return this;
    }

    public void reset() {
        this.explicitlyModified = false;
        this.implicitlyModified = false;
        this.value = null;
        this.systemValue = null;
        this.aquiredValue = null;
        this.reset(this.minValue);
        this.reset(this.maxValue);
        this.reset(this.left);
        this.reset(this.right);
        if (this.depends != null) {
            for (int i2 = 0; i2 < this.depends.size(); ++i2) {
                this.reset(this.depends.get(i2));
            }
        }
    }

    private void reset(Object value) {
        if (value instanceof Property) {
            ((Property)value).reset();
        }
    }

    public boolean load(Properties ... propertiesList) {
        if (this.systemValue != null) {
            return true;
        }
        if (this.type == Properties.Constant) {
            return true;
        }
        if (this.type == Properties.Operator) {
            if (this.operator == EitherOr && (this.getValue(this.left) == null || this.getValue(this.right) == null || this.getValue(this.local) == null)) {
                return false;
            }
            if (!(this.operator != Is && this.operator != And && this.operator != Or && this.operator != Plus && this.operator != Maximum && this.operator != Minimum || this.getValue(this.left) != null && this.getValue(this.right) != null)) {
                return false;
            }
            if ((this.operator == Not || this.operator == ToKeyName || this.operator == ToKeyCode || this.operator == ToBlockConfig) && this.getValue(this.left) == null) {
                return false;
            }
            Value operatorValue = null;
            if (this.operator == Is) {
                operatorValue = this.getValue(this.left).is(this.getValue(this.right));
            } else if (this.operator == And) {
                operatorValue = this.getValue(this.left).and(this.getValue(this.right));
            } else if (this.operator == Or) {
                operatorValue = this.getValue(this.left).or(this.getValue(this.right));
            } else if (this.operator == Not) {
                operatorValue = this.getValue(this.left).not();
            } else if (this.operator == Plus) {
                operatorValue = this.getValue(this.left).plus(this.getValue(this.right));
            } else if (this.operator == EitherOr) {
                operatorValue = this.getValue(this.local).eitherOr(this.getValue(this.left), this.getValue(this.right));
            } else if (this.operator == Maximum) {
                operatorValue = this.getValue(this.left).maximum(this.getValue(this.right));
            } else if (this.operator == Minimum) {
                operatorValue = this.getValue(this.left).minimum(this.getValue(this.right));
            } else if (this.operator == ToKeyName) {
                operatorValue = this.getValue(this.left).toKeyName();
            } else if (this.operator == ToKeyCode) {
                operatorValue = this.getValue(this.left).toKeyCode();
            } else if (this.operator == ToBlockConfig) {
                operatorValue = this.getValue(this.left).toBlockConfig();
            }
            if (operatorValue == null) {
                throw new RuntimeException("Unknown operator '" + this.operator + "' found");
            }
            return this.set(this.getValue(operatorValue));
        }
        if (propertiesList == null || this.versionSources == null) {
            return false;
        }
        if (this.depends != null) {
            for (int i2 = 0; i2 < this.depends.size(); ++i2) {
                if (this.getValue(this.depends.get(i2)) != null) continue;
                return false;
            }
        }
        Object minObject = this.getMinimumValue();
        Value minValue = this.getValue(minObject);
        if (minObject != null && minValue == null) {
            return false;
        }
        Object maxObject = this.getMaximumValue();
        Value maxValue = this.getValue(maxObject);
        if (maxObject != null && maxValue == null) {
            return false;
        }
        Value defaultValue = this.getValue(this.getDefaultValue());
        for (int i3 = 0; i3 < propertiesList.length; ++i3) {
            Properties properties = propertiesList[i3];
            Object source = this.getVersionSource(properties.version);
            if (source == null) continue;
            String key = this.getKey(source);
            Value value = this.aquiredValue = key != null ? this.getPropertyValue(properties, key) : this.getValue(source);
            if (this.aquiredValue != null) {
                Value initValue = this.aquiredValue.clone();
                if (this.depends != null) {
                    for (int n2 = 0; n2 < this.depends.size(); ++n2) {
                        initValue.withDependency(this.getValue(this.depends.get(n2)), defaultValue);
                    }
                }
                if (minObject != null) {
                    initValue.withMinimum(minValue, defaultValue);
                }
                if (maxObject != null) {
                    initValue.withMaximum(maxValue, defaultValue);
                }
                return this.set(initValue);
            }
            if (key != null) continue;
            return false;
        }
        return this.set(defaultValue);
    }

    private boolean set(Value initValue) {
        this.systemValue = initValue;
        this.update(null);
        return true;
    }

    private Map addVersioned(Map versioned, Object value, String ... versions) {
        if (versioned == null) {
            versioned = new Hashtable<String, Object>(1);
        }
        if (versions == null || versions.length == 0) {
            versions = CurrentArray;
        }
        for (int i2 = 0; i2 < versions.length; ++i2) {
            versioned.put(versions[i2], value);
        }
        return versioned;
    }

    private Object getKeyValue(String key) {
        Object value = this.systemValue.get(key);
        if (value == null) {
            value = this.getValue(this.getDefaultValue()).get(null);
        }
        if (value == null) {
            value = Properties.getDefaultValue(this.type);
        }
        return value;
    }

    private Value getValue(Object value) {
        if (value instanceof Property) {
            Property property = (Property)value;
            property.load(null);
            return property.systemValue;
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        return new Value(value);
    }

    private Object getDefaultValue(String version) {
        Object defaultValue = null;
        if (this.versionDefaults != null) {
            if (version != null) {
                defaultValue = this.versionDefaults.get(version);
            }
            if (defaultValue == null) {
                defaultValue = this.versionDefaults.get(Current);
            }
        }
        if (defaultValue == null) {
            defaultValue = Properties.getDefaultValue(this.type);
        }
        return defaultValue;
    }

    private Object getDefaultValue() {
        return this.getDefaultValue(Current);
    }

    private Object getMinimumValue() {
        if (this.minValue != null) {
            return this.minValue;
        }
        return Properties.getMinimumValue(this.type);
    }

    private Object getMaximumValue() {
        if (this.maxValue != null) {
            return this.maxValue;
        }
        return Properties.getMaximumValue(this.type);
    }

    private Object getVersionSource(String version) {
        if (this.versionSources == null) {
            return null;
        }
        Object source = null;
        if (version != null) {
            source = this.versionSources.get(version);
        }
        if (source == null) {
            source = this.versionSources.get(Current);
        }
        return source;
    }

    private Value getPropertyValue(Properties properties, String key) {
        String propertyString = properties.getProperty(key);
        if (propertyString != null) {
            this.aquiredString = propertyString;
        }
        String stringToParse = propertyString;
        if (propertyString != null) {
            stringToParse = propertyString.trim();
            this.explicitlyModified = stringToParse.endsWith("!");
            if (this.explicitlyModified) {
                stringToParse = stringToParse.substring(0, stringToParse.length() - 1);
            }
            stringToParse = stringToParse.trim();
        }
        Value value = this.parsePropertyValue(stringToParse);
        boolean bl2 = this.implicitlyModified = stringToParse != null && (value == null || !value.equals(this.getValue(this.getDefaultValue(properties.version))));
        if (!this.explicitlyModified && !this.implicitlyModified) {
            return this.getValue(this.getDefaultValue());
        }
        return value;
    }

    private Value parsePropertyValue(String stringToParse) {
        if (stringToParse != null) {
            return new Value(this.type).load(stringToParse, this.singular);
        }
        return null;
    }

    public boolean print(PrintStream printer, String[] sorted, String version, boolean comments) {
        if (!this.isPersistent() || this.systemValue == null) {
            return false;
        }
        if (this.getVersionSource(version) == null) {
            return false;
        }
        int gap = this.gap + (this.comment == null ? -1 : 1);
        for (int i2 = 0; i2 < gap; ++i2) {
            printer.println();
        }
        if (this.header != null && this.header.length > 0) {
            this.printHeader(printer);
        }
        if (this.comment != null && comments) {
            printer.print("# ");
            printer.print(this.comment);
            printer.println();
        }
        boolean error = false;
        Iterator unparsed = this.aquiredValue.getUnparsableStrings();
        while (unparsed != null && unparsed.hasNext()) {
            String unparsableString = (String)unparsed.next();
            this.printErrorPrefix(printer);
            printer.print("Could not interpret string \"");
            printer.print(unparsableString);
            printer.print("\" as ");
            printer.print(Properties.getBaseTypeName(Properties.getBaseType(this.type)));
            printer.print(" value, used ");
            printer.print(!this.aquiredString.isEmpty() && this.aquiredValue.get(null) != null ? "local" : "system");
            printer.print(" default");
            this.printValuePostfix(printer, null);
            this.printErrorPostfix(printer);
            error = true;
        }
        Object minObject = this.getMinimumValue();
        Value minValue = this.getValue(minObject);
        Object maxObject = this.getMaximumValue();
        Value maxValue = this.getValue(maxObject);
        Iterator keys = Value.GetAllKeys(this.systemValue);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object parsedSingleValue = this.aquiredValue.getStored(key);
            Object aquiredSingleValue = this.aquiredValue.get(key);
            Object usedSingleValue = this.systemValue.getStored(key);
            if (parsedSingleValue != null ? parsedSingleValue.equals(usedSingleValue) : aquiredSingleValue == null || aquiredSingleValue.equals(usedSingleValue)) continue;
            if (Properties.getBaseType(this.type) == Properties.Boolean && this.depends != null && !this.depends.isEmpty()) {
                String dependKey = null;
                for (int i3 = 0; i3 < this.depends.size(); ++i3) {
                    Property depend = (Property)this.depends.get(i3);
                    String currentDependKey = depend.getCurrentKey();
                    if (currentDependKey == null || ((Boolean)depend.getKeyValue(key)).booleanValue()) continue;
                    dependKey = currentDependKey;
                    break;
                }
                this.printWarnPrefix(printer);
                this.printValuePrefix(printer, key);
                printer.print("is ignored because ");
                if (dependKey != null) {
                    printer.print("the ");
                    if (key == "null") {
                        printer.print("default");
                    } else {
                        printer.print("\"" + key + "\"");
                    }
                    printer.print(" value of property \"");
                    printer.print(dependKey);
                    printer.print("\" is \"false\"");
                } else {
                    printer.print("one of the restricting expressions evaluated to \"false\"");
                }
                this.printWarnPostfix(printer);
                error = true;
                continue;
            }
            this.printErrorPrefix(printer);
            this.printValuePrefix(printer, key);
            printer.print("was out of range, used ");
            if (minValue != null && usedSingleValue.equals(minValue.get(key))) {
                printer.print("minimum");
            } else if (maxValue != null && usedSingleValue.equals(maxValue.get(key))) {
                printer.print("maximum");
            } else {
                printer.print("in-range");
            }
            this.printValuePostfix(printer, key);
            this.printErrorPostfix(printer);
            error = true;
        }
        printer.print(this.getCurrentKey());
        printer.print(":");
        if (this.aquiredString != null && (error || this.explicitlyModified)) {
            printer.print(this.aquiredString);
        } else if (this.implicitlyModified && this.systemValue.equals(this.getValue(this.getDefaultValue()))) {
            printer.print(this.aquiredString);
            printer.print("!");
        } else {
            this.systemValue.print(printer, sorted);
        }
        return true;
    }

    private void printHeader(PrintStream printer) {
        String body;
        String title = this.header[0];
        String string = body = this.header.length > 1 ? this.header[1] : null;
        char separator = this.gap == 3 ? (char)'=' : (this.gap == 2 ? (char)'-' : ' ');
        this.printSeparation(printer, separator, 69);
        printer.print("# ");
        printer.println(title);
        if (body != null) {
            this.printSeparation(printer, '-', title.length());
            int lineWidth = 67;
            while (true) {
                int i2;
                printer.print("# ");
                if (body.length() <= lineWidth) {
                    printer.println(body);
                    break;
                }
                for (i2 = lineWidth; i2 > 0 && body.charAt(i2) != ' '; --i2) {
                }
                printer.println(body.substring(0, i2));
                body = body.substring(i2 + 1);
            }
        }
        this.printSeparation(printer, separator, 69);
        printer.println();
    }

    private void printSeparation(PrintStream printer, char seperator, int length) {
        printer.print("# ");
        for (int i2 = 0; i2 < length; ++i2) {
            printer.print(seperator);
        }
        printer.println();
    }

    private void printValuePrefix(PrintStream printer, String key) {
        printer.print("Interpreted ");
        if (key != "null") {
            printer.print("\"");
            printer.print(key);
            printer.print("\" ");
        }
        printer.print("value \"");
        printer.print(this.aquiredValue.get(key));
        printer.print("\" ");
    }

    private void printValuePostfix(PrintStream printer, String key) {
        printer.print(" value \"");
        printer.print(this.aquiredString == null || this.aquiredString.isEmpty() ? this.getValue(this.getDefaultValue()) : this.getKeyValue(key));
        printer.print("\" instead");
    }

    private void printErrorPrefix(PrintStream printer) {
        this.printErrorPrefix(printer, false);
    }

    private void printWarnPrefix(PrintStream printer) {
        this.printErrorPrefix(printer, true);
    }

    private void printErrorPrefix(PrintStream printer, boolean warning) {
        printer.print("#");
        if (!warning) {
            printer.print("!!");
        }
        printer.print("! ");
    }

    private void printErrorPostfix(PrintStream printer) {
        this.printErrorPostfix(printer, false);
    }

    private void printWarnPostfix(PrintStream printer) {
        this.printErrorPostfix(printer, true);
    }

    private void printErrorPostfix(PrintStream printer, boolean warning) {
        printer.print(" !");
        if (!warning) {
            printer.print("!!");
        }
        printer.println("#");
    }

    public boolean isPersistent() {
        return this.versionSources != null && this.versionSources.size() > 0;
    }

    public String getCurrentKey() {
        if (this.isPersistent()) {
            return this.getKey(this.getVersionSource(this.currentVersion));
        }
        return null;
    }

    private String getKey(Object candidate) {
        if (candidate instanceof Property) {
            Property property = (Property)candidate;
            if (property.type == Properties.Key) {
                return (String)property.value;
            }
        }
        return null;
    }

    public String toString() {
        if (this.isPersistent()) {
            return this.getCurrentKey();
        }
        return super.toString();
    }
}

