/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move.config;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.move.Reflect;
import net.minecraft.move.config.Property;
import net.minecraft.move.config.Value;

public class Properties
extends java.util.Properties {
    private static final long serialVersionUID = 5319578641402091067L;
    private static int i = 0;
    public static final int Boolean = i++;
    public static final int Unmodified = i++;
    public static final int Modified = i++;
    public static final int Float = i++;
    public static final int Positive = i++;
    public static final int Negative = i++;
    public static final int PositiveFactor = i++;
    public static final int NegativeFactor = i++;
    public static final int IncreasingFactor = i++;
    public static final int DecreasingFactor = i++;
    public static final int Integer = i++;
    public static final int String = i++;
    public static final int Strings = i++;
    public static final int Operator = i++;
    public static final int Constant = i++;
    public static final int Key = i++;
    public final String version;

    protected Properties() {
        this.version = null;
    }

    public Properties(File file) {
        this.load(file);
        this.version = this.getProperty("move.options.version");
    }

    public Properties(String version, File file) {
        this.load(file);
        this.version = version;
    }

    protected List getProperties() {
        return this.getProperties(null);
    }

    protected List getProperties(Class type) {
        ArrayList properties = new ArrayList();
        if (type != null) {
            return this.addProperties(properties, type, false);
        }
        return this.addProperties(properties, this.getClass(), true);
    }

    private List addProperties(List list, Class type, boolean base) {
        if (base && type.getSuperclass() != null) {
            this.addProperties(list, type.getSuperclass(), base);
        }
        Field[] fields = type.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fields[i2].setAccessible(true);
            Object value = Reflect.GetField(fields[i2], this);
            this.addProperties(list, value);
        }
        return list;
    }

    private void addProperties(List list, Object value) {
        if (value instanceof Property) {
            list.add((Property)value);
        } else if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            while (iterator.hasNext()) {
                this.addProperties(list, iterator.next());
            }
        }
    }

    protected void write(Properties properties) {
        List propertiesToWrite = this.getProperties();
        for (int i2 = 0; i2 < propertiesToWrite.size(); ++i2) {
            Property property = (Property)propertiesToWrite.get(i2);
            if (!property.isPersistent()) continue;
            properties.put(property.getCurrentKey(), property.value);
        }
    }

    private boolean load(File file) {
        try {
            if (file.exists()) {
                this.load(new FileInputStream(file));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getBaseType(int type) {
        if (type == Boolean || type == Unmodified || type == Modified) {
            return Boolean;
        }
        if (type == Float || type == Positive || type == Negative || type == PositiveFactor || type == NegativeFactor || type == IncreasingFactor || type == DecreasingFactor) {
            return Float;
        }
        if (type == Integer) {
            return Integer;
        }
        if (type == Strings) {
            return Strings;
        }
        return String;
    }

    public static String getBaseTypeName(int baseType) {
        if (baseType == Boolean) {
            return "boolean";
        }
        if (baseType == Float) {
            return "floating point";
        }
        if (baseType == Integer) {
            return "integer";
        }
        return "string";
    }

    public static Object getDefaultValue(int type) {
        if (type == Boolean) {
            return false;
        }
        if (type == Unmodified) {
            return true;
        }
        if (type == Modified) {
            return false;
        }
        if (type == Integer) {
            return 0;
        }
        if (type == Float) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == Positive) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == Negative) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == PositiveFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == NegativeFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == IncreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == String) {
            return "";
        }
        if (type == Strings) {
            return new String[0];
        }
        return null;
    }

    public static Object getMinimumValue(int type) {
        if (type == Positive) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == PositiveFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == IncreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        return null;
    }

    public static Object getMaximumValue(int type) {
        if (type == Negative) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == NegativeFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        return null;
    }

    public static Property Unmodified() {
        return Properties.Property(Unmodified);
    }

    public static Property Unmodified(String key, String ... versions) {
        return Properties.Unmodified().key(key, versions);
    }

    public static Property Modified() {
        return Properties.Property(Modified);
    }

    public static Property Modified(String key, String ... versions) {
        return Properties.Modified().key(key, versions);
    }

    public static Property Integer() {
        return Properties.Property(Integer);
    }

    public static Property Integer(String key, String ... versions) {
        return Properties.Integer().key(key, versions);
    }

    public static Property Float() {
        return Properties.Property(Float);
    }

    public static Property Float(String key, String ... versions) {
        return Properties.Float().key(key, versions);
    }

    public static Property Positive() {
        return Properties.Property(Positive);
    }

    public static Property Positive(String key, String ... versions) {
        return Properties.Positive().key(key, versions);
    }

    public static Property Negative() {
        return Properties.Property(Negative);
    }

    public static Property Negative(String key, String ... versions) {
        return Properties.Negative().key(key, versions);
    }

    public static Property PositiveFactor() {
        return Properties.Property(PositiveFactor);
    }

    public static Property PositiveFactor(String key, String ... versions) {
        return Properties.PositiveFactor().key(key, versions);
    }

    public static Property NegativeFactor() {
        return Properties.Property(NegativeFactor);
    }

    public static Property NegativeFactor(String key, String ... versions) {
        return Properties.NegativeFactor().key(key, versions);
    }

    public static Property IncreasingFactor() {
        return Properties.Property(IncreasingFactor);
    }

    public static Property IncreasingFactor(String key, String ... versions) {
        return Properties.IncreasingFactor().key(key, versions);
    }

    public static Property DecreasingFactor() {
        return Properties.Property(DecreasingFactor);
    }

    public static Property DecreasingFactor(String key, String ... versions) {
        return Properties.DecreasingFactor().key(key, versions);
    }

    public static Property String() {
        return Properties.Property(String);
    }

    public static Property String(String key, String ... versions) {
        return Properties.String().key(key, versions);
    }

    public static Property Strings() {
        return Properties.Property(Strings);
    }

    public static Property Strings(String key, String ... versions) {
        return Properties.Strings().key(key, versions);
    }

    private static Property Property(int type) {
        return new Property(type);
    }

    public Value Value(Boolean base) {
        return new Value(Boolean).put(base);
    }

    public Value Value(Float base) {
        return new Value(Float).put(base);
    }

    public Value Value(String base) {
        return new Value(String).put(base);
    }

    protected static String[] concat(String left, String[] right) {
        return Properties.concat(new String[]{left}, right);
    }

    protected static String[] concat(String[] left, String[] right) {
        int i2;
        String[] result = new String[left.length + right.length];
        for (i2 = 0; i2 < left.length; ++i2) {
            result[i2] = left[i2];
        }
        while (i2 < result.length) {
            result[i2] = right[i2 - left.length];
            ++i2;
        }
        return result;
    }
}

