/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.io.File;
import java.util.logging.Logger;
import net.minecraft.move.IEntityPlayerMP;
import net.minecraft.move.Info;
import net.minecraft.move.SmartMovingPacketStream;
import net.minecraft.move.config.SmartMovingConfig;
import net.minecraft.move.config.SmartMovingServerOptions;

public class SmartMovingServer {
    protected final IEntityPlayerMP mp;
    private boolean resetFallDistance = false;
    private boolean initialized = false;
    public boolean crawlingInitialized;
    public int crawlingCooldown;
    public boolean isCrawling;
    public static SmartMovingServerOptions Options = null;

    public SmartMovingServer(IEntityPlayerMP mp2, boolean onTheFly) {
        this.mp = mp2;
        if (onTheFly) {
            this.initialize(true);
        }
    }

    public void initialize(boolean alwaysSendMessage) {
        if (((Boolean)SmartMovingServer.Options._configSend.value).booleanValue()) {
            SmartMovingPacketStream.sendConfigContent(this.mp, SmartMovingServer.Options.enabled ? Options.writeToProperties() : null);
        } else if (alwaysSendMessage) {
            SmartMovingPacketStream.sendConfigContent(this.mp, SmartMovingServer.Options.enabled ? new String[]{} : null);
        }
        this.initialized = true;
    }

    public void processStatePacket(Object packet, long state) {
        if (!this.initialized) {
            this.initialize(false);
        }
        boolean isCrawling = (state >>> 13 & 1L) != 0L;
        this.setCrawling(isCrawling);
        boolean isSmall = (state >>> 15 & 1L) != 0L;
        this.setSmall(isSmall);
        boolean isClimbing = (state >>> 14 & 1L) != 0L;
        boolean isCrawlClimbing = (state >>> 12 & 1L) != 0L;
        boolean isCeilingClimbing = (state >>> 18 & 1L) != 0L;
        this.resetFallDistance = isClimbing || isCrawlClimbing || isCeilingClimbing;
        this.mp.sendPacketToTrackedPlayers(packet);
    }

    public void processConfigPacket(String clientConfigurationVersion) {
        boolean warn = true;
        String type = "unknown";
        if (clientConfigurationVersion != null) {
            for (int i2 = 0; i2 < SmartMovingConfig._all.length; ++i2) {
                if (!clientConfigurationVersion.equals(SmartMovingConfig._all[i2])) continue;
                warn = i2 > 0;
                type = warn ? "outdated" : "matching";
                break;
            }
        }
        String message = "Smart Moving player \"" + this.mp.getUsername() + "\" connected with " + type + " configuration system";
        if (clientConfigurationVersion != null) {
            message = message + " version \"" + clientConfigurationVersion + "\"";
        }
        if (warn) {
            this.mp.getLogger().warning(message);
        } else {
            this.mp.getLogger().info(message);
        }
    }

    public void afterOnUpdate() {
        if (this.resetFallDistance) {
            this.mp.resetFallDistance();
        }
    }

    public static void initialize(File optionsPath, Logger logger, boolean isClientServer) {
        Options = new SmartMovingServerOptions(optionsPath, logger, isClientServer);
        String message = Info.getModComMessage();
        logger.info(message);
    }

    public void setCrawling(boolean crawling) {
        if (!crawling && this.isCrawling) {
            this.crawlingCooldown = 10;
        }
        this.isCrawling = crawling;
    }

    public void setSmall(boolean isSmall) {
        this.mp.setHeight(isSmall ? 0.8f : 1.8f);
    }

    public void afterSetPosition(double d2, double d1, double d22) {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight() - 1.0);
        }
    }

    public void beforeIsPlayerSleeping() {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight());
            this.crawlingInitialized = true;
        }
    }

    public void beforeOnUpdate() {
        if (this.crawlingCooldown > 0) {
            --this.crawlingCooldown;
        }
    }

    public boolean isEntityInsideOpaqueBlock() {
        if (this.crawlingCooldown > 0) {
            return false;
        }
        return this.mp.localIsEntityInsideOpaqueBlock();
    }
}

