/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.move.Button;
import net.minecraft.move.ClimbGap;
import net.minecraft.move.FeetClimbing;
import net.minecraft.move.HandsClimbing;
import net.minecraft.move.IEntityPlayerSP;
import net.minecraft.move.Orientation;
import net.minecraft.move.Reflect;
import net.minecraft.move.SmartMoving;
import net.minecraft.move.SmartMovingComm;
import net.minecraft.move.SmartMovingPacketStream;
import net.minecraft.move.config.SmartMovingOptions;
import net.minecraft.move.render.SmartMovingRender;

public class SmartMovingSelf
extends SmartMoving {
    private boolean initialized = false;
    private int multiPlayerInitialized;
    private int updateCounter;
    private static ClimbGap out_handsClimbGap = new ClimbGap();
    private static ClimbGap out_feetClimbGap = new ClimbGap();
    private static HandsClimbing[] inout_handsClimbing = new HandsClimbing[1];
    private static FeetClimbing[] inout_feetClimbing = new FeetClimbing[1];
    public boolean wantClimbUp;
    public boolean wantClimbDown;
    public boolean wantSprint;
    public boolean wantCrawlNotClimb;
    public boolean wantClimbCeiling;
    public boolean isStanding;
    public boolean wouldIsSneaking;
    public boolean isVineOnlyClimbing;
    public boolean isVineAnyClimbing;
    public boolean isClimbingStill;
    public boolean isClimbHolding;
    public boolean isNeighborClimbing;
    public boolean hasClimbGap;
    public boolean hasClimbCrawlGap;
    public boolean hasNeighborClimbGap;
    public boolean hasNeighborClimbCrawlGap;
    public float dippingDepth;
    public boolean isJumping;
    public boolean isJumpingOutOfWater;
    public boolean isShallowDiveOrSwim;
    public boolean isFakeShallowWaterSneaking;
    public boolean isStillSwimmingJump;
    public boolean isGroundSprinting;
    public boolean isSprintJump;
    public boolean isAerodynamic;
    public int handsEdgeBlockId;
    public int handsEdgeMeta;
    public int feetEdgeBlockId;
    public int feetEdgeMeta;
    public int waterMovementTicks;
    public float exhaustion = 0.0f;
    public float jumpCharge;
    public float headJumpCharge;
    public boolean blockJumpTillButtonRelease;
    public float maxExhaustionForAction;
    public float maxExhaustionToStartAction;
    public float prevMaxExhaustionForAction = Float.NaN;
    public float prevMaxExhaustionToStartAction = Float.NaN;
    public double lastHorizontalCollisionX = 0.0;
    public double lastHorizontalCollisionZ = 0.0;
    private double beforeMoveEntityPosX;
    private double beforeMoveEntityPosY;
    private double beforeMoveEntityPosZ;
    private float beforeDistanceWalkedModified;
    boolean wasOnGround;
    private float fadingPerspectiveFactor = -1.0f;
    private float localLandMovementFactor = -1.0f;
    private boolean wasInventory;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public final Button forwardButton = new Button();
    public final Button leftButton = new Button();
    public final Button rightButton = new Button();
    public final Button backButton = new Button();
    public final Button jumpButton = new Button();
    public final Button sneakButton = new Button();
    public final Button grabButton = new Button();
    public final Button sprintButton = new Button();
    public final Button toggleButton = new Button();
    public boolean wasRunning;
    public boolean wasLevitating;
    public boolean wasCrawling;
    public boolean wasHeadJumping;
    private boolean contextContinueCrawl;
    private boolean ignoreNextStopSneakButtonPressed;
    private int collidedHorizontallyTickCount;
    private int climbIntoCount;
    private int leftJumpCount;
    private int rightJumpCount;
    private int backJumpCount;
    private int nextClimbDistance = 0;
    public float distanceClimbedModified = 0.0f;
    private boolean sneakToggled = false;
    private boolean crawlToggled = false;
    private int lastWorldPlayerEntitiesSize = -1;
    private int lastWorldPlayerLastEnttyId = -1;
    private long prevPacketState = -1L;
    public static final Field _chatMessageList = Reflect.GetField(aoh.class, "field_73771_c", "c");

    public SmartMovingSelf(of sp2, IEntityPlayerSP isp) {
        super(sp2, isp);
    }

    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.sp.bZ.b && !Config.isFlyingEnabled()) {
            double d3 = this.sp.x;
            float f2 = this.sp.aH;
            this.sp.aH = 0.05f;
            this.superMoveEntityWithHeading(moveStrafing, moveForward);
            this.sp.x = d3 * 0.6;
            this.sp.aH = f2;
        } else {
            this.superMoveEntityWithHeading(moveStrafing, moveForward);
        }
    }

    private void superMoveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.isp.localIsSprinting() && !Config.isRunningEnabled()) {
            this.sp.b(false);
        }
        boolean wasShortInWater = this.isSwimming || this.isDiving;
        boolean wasSwimming = this.isSwimming;
        boolean wasClimbing = this.isClimbing;
        boolean wasDiving = this.isDiving;
        boolean wasCeilingClimbing = this.isCeilingClimbing;
        boolean wasJumpingOutOfWater = this.isJumpingOutOfWater;
        this.handleJumping();
        double d_S = this.sp.t;
        double d1_S = this.sp.u;
        double d2_S = this.sp.v;
        if (this.sp.F) {
            this.lastHorizontalCollisionX = this.sp.t;
            this.lastHorizontalCollisionZ = this.sp.v;
        }
        float speedFactor = this.getSpeedFactor(moveForward, moveStrafing);
        boolean isLiquidClimbing = Config.isFreeClimbingEnabled() && (double)this.sp.R <= 3.0 && this.wantClimbUp && this.sp.F && !this.isDiving;
        boolean handledSwimming = this.handleSwimming(moveForward, moveStrafing, speedFactor, wasSwimming, wasDiving, isLiquidClimbing, wasJumpingOutOfWater);
        boolean handledLava = this.handleLava(moveForward, moveStrafing, handledSwimming, isLiquidClimbing);
        boolean handledAlternativeFlying = this.handleAlternativeFlying(moveForward, moveStrafing, speedFactor, handledSwimming, handledLava);
        this.handleLand(moveForward, moveStrafing, speedFactor, handledSwimming, handledLava, handledAlternativeFlying, wasShortInWater, wasClimbing, wasCeilingClimbing);
        this.calculateAllStats(true);
        double diffX = this.sp.t - d_S;
        double diffY = this.sp.u - d1_S;
        double diffZ = this.sp.v - d2_S;
        this.sp.j(diffX, diffY, diffZ);
        this.handleExhaustion(diffX, diffY, diffZ);
    }

    private float getSpeedFactor(float moveForward, float moveStrafing) {
        float speedFactor = 1.0f;
        if (this.sp.bw()) {
            float itemFactor = 0.2f;
            if (SmartMovingSelf.Config.enabled) {
                rg item = rg.e[this.sp.bu().c];
                itemFactor = item instanceof sm ? ((Float)SmartMovingSelf.Config._usageSwordSpeedFactor.value).floatValue() : (item instanceof py ? ((Float)SmartMovingSelf.Config._usageBowSpeedFactor.value).floatValue() : (item instanceof rc ? ((Float)SmartMovingSelf.Config._usageFoodSpeedFactor.value).floatValue() : ((Float)SmartMovingSelf.Config._usageSpeedFactor.value).floatValue()));
            }
            speedFactor *= itemFactor;
        }
        if (this.isCrawling || this.isCrawlClimbing && !this.isClimbCrawling) {
            speedFactor = ((Float)SmartMovingSelf.Config._crawlFactor.value).floatValue();
        } else if (this.isSlow) {
            speedFactor = ((Float)SmartMovingSelf.Config._sneakFactor.value).floatValue();
        }
        if (this.isFast) {
            speedFactor *= ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue();
        }
        if (this.isClimbing) {
            if (moveStrafing != 0.0f || moveForward != 0.0f) {
                speedFactor *= ((Float)SmartMovingSelf.Config._freeClimbingHorizontalSpeedFactor.value).floatValue();
            } else if (this.wantClimbDown && this.isNeighborClimbing && (!(Math.abs(this.sp.t - this.lastHorizontalCollisionX) < 0.05) || !(Math.abs(this.sp.v - this.lastHorizontalCollisionZ) < 0.05))) {
                moveForward = 0.3f;
                if (this.isVineOnlyClimbing) {
                    if (this.handsEdgeMeta != 0 && this.feetEdgeMeta != 0) {
                        moveForward = 0.0f;
                    } else {
                        Orientation orientation = Orientation.getOrientation(this.sp, 45.0f, true, false);
                        if (orientation != null) {
                            float gap = (float)orientation.getHorizontalBorderGap(this.sp);
                            float minGap = this.sp.N / 2.0f;
                            float factor = Math.max(0.0f, gap * (1.0f + minGap) - minGap);
                            moveForward = factor * factor * 0.3f;
                        }
                    }
                }
            }
        }
        if (this.isCeilingClimbing) {
            speedFactor *= ((Float)SmartMovingSelf.Config._ceilingClimbingSpeedFactor.value).floatValue();
        }
        return speedFactor;
    }

    private boolean handleSwimming(float moveForward, float moveStrafing, float speedFactor, boolean wasSwimming, boolean wasDiving, boolean isLiquidClimbing, boolean wasJumpingOutOfWater) {
        boolean handleSwimming;
        boolean handleSwimmingRejected = false;
        boolean bl2 = handleSwimming = !this.isFlying && !isLiquidClimbing && (this.sp.H() || wasSwimming && this.isInLiquid() || Config.isLavaLikeWaterEnabled() && this.sp.J());
        if (handleSwimming) {
            boolean useStandard;
            this.resetClimbing();
            float wasHeightOffset = this.heightOffset;
            boolean bl3 = useStandard = !Config.isSwimmingEnabled() && !Config.isDivingEnabled();
            if (this.sp.o != null) {
                this.resetSwimming();
                useStandard = true;
            }
            if (useStandard && this.isCrawling) {
                this.standupIfPossible();
            } else {
                this.resetHeightOffset();
            }
            if (!useStandard) {
                boolean wantShallowSwim;
                this.resetSwimming();
                int i2 = ig.c(this.sp.t);
                int j2 = ig.c(this.sp.D.b);
                int k2 = ig.c(this.sp.v);
                boolean swimming = false;
                boolean diving = false;
                boolean dipping = false;
                double j_offset = this.sp.D.b - (double)j2;
                double totalSwimWaterBorder = this.getMaxPlayerLiquidBetween(this.sp.D.e - 1.8, this.sp.D.e + 1.2);
                double minPlayerSwimWaterDepth = totalSwimWaterBorder - this.getMaxPlayerSolidBetween(totalSwimWaterBorder - 2.0, totalSwimWaterBorder, 0.0);
                double playerSwimWaterBorder = totalSwimWaterBorder - (double)j2 - j_offset;
                if (this.isCrawling && playerSwimWaterBorder > (double)0.65f) {
                    this.standupIfPossible();
                }
                double motionYDiff = 0.0;
                boolean couldStandUp = playerSwimWaterBorder >= 0.0 && minPlayerSwimWaterDepth <= 1.5;
                boolean diveUp = this.isp.getIsJumpingField();
                boolean diveDown = this.esp.b.d && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false;
                boolean swimDown = this.esp.b.d && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false;
                boolean bl4 = wantShallowSwim = couldStandUp && (wasSwimming || wasDiving);
                if (wantShallowSwim) {
                    HashSet orientations = Orientation.getClimbingOrientations(this.sp, true, true);
                    Iterator iterator = orientations.iterator();
                    while (iterator.hasNext() && (wantShallowSwim &= !((Orientation)iterator.next()).isTunnelAhead(this.sp.p, i2, j2, k2))) {
                    }
                }
                if (wasSwimming && wantShallowSwim && swimDown) {
                    swimDown = false;
                    this.isFakeShallowWaterSneaking = true;
                }
                if (this.isDiving && diveUp && diveDown) {
                    diveDown = false;
                    diveUp = false;
                }
                if (this.isCrawling || this.isClimbCrawling || this.isCrawlClimbing) {
                    this.isDipping = true;
                } else if (playerSwimWaterBorder >= 0.0 && playerSwimWaterBorder <= 2.0) {
                    boolean moveSwim;
                    double offset = playerSwimWaterBorder + 0.1625;
                    boolean bl5 = moveSwim = this.sp.A < 0.0f && this.esp.b.b > 0.0f || this.sp.A > 0.0f && this.esp.b.b < 0.0f;
                    if (diveUp || moveSwim || wantShallowSwim) {
                        if (offset < 1.4) {
                            dipping = true;
                            motionYDiff = offset < 1.0 ? -0.02 : -0.01;
                        } else if (offset < 1.9) {
                            swimming = true;
                            if (swimDown) {
                                motionYDiff = -0.05 * (double)(this.isFast ? ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 1.0f);
                            } else if (offset < 1.5) {
                                motionYDiff = -0.02;
                            }
                            motionYDiff = offset < 1.6 ? -0.01 : (offset < 1.62 ? -0.005 : (offset < 1.64 ? -0.0025 : (offset < 1.66 ? -0.00125 : (offset < 1.664 ? -6.25E-4 : (offset < 1.668 ? 0.0 : (offset < 1.672 ? 6.25E-4 : (offset < 1.676 ? 0.00125 : (offset < 1.68 ? 0.0025 : (offset < 1.7 ? 0.005 : (offset < 1.8 ? 0.01 : 0.02))))))))));
                        } else {
                            diving = true;
                            motionYDiff = diveUp ? 0.05 * (double)(this.isFast ? ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 1.0f) : (diveDown ? 0.01 - 0.1 * (double)speedFactor : (moveSwim ? 0.04 : 0.02));
                        }
                    } else if (offset < 1.5) {
                        dipping = true;
                        motionYDiff = offset < 1.0 ? -0.02 : -0.02;
                    } else {
                        diving = true;
                        motionYDiff = diveDown ? 0.01 - 0.1 * (double)speedFactor : (offset < 1.8 ? -0.02 : (offset < 1.82 ? -0.01 : (offset < 1.84 ? -0.005 : (offset < 1.86 ? -0.0025 : (offset < 1.864 ? -0.00125 : (offset < 1.868 ? 0.0 : (offset < 1.872 ? 0.00125 : (offset < 1.876 ? 0.0025 : (offset < 1.88 ? 0.005 : (offset < 1.9 ? 0.01 : 0.01))))))))));
                    }
                } else if (playerSwimWaterBorder > 2.0) {
                    diving = true;
                    motionYDiff = diveUp ? (this.isFast && playerSwimWaterBorder < 2.5 && this.sp.p.c(i2, j2 + 3, k2) ? 0.11 / (double)((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 0.01 + 0.1 * (double)speedFactor) : (diveDown ? 0.01 - 0.1 * (double)speedFactor : 0.01);
                } else {
                    handleSwimmingRejected = true;
                }
                this.dippingDepth = (float)playerSwimWaterBorder;
                float playerCrawlWaterBorder = this.dippingDepth + wasHeightOffset;
                if ((this.isCrawling || this.isSliding) && playerCrawlWaterBorder < 1.0f) {
                    if (playerCrawlWaterBorder < 0.65f) {
                        this.setHeightOffset(wasHeightOffset);
                        handleSwimmingRejected = true;
                    } else {
                        if (wantShallowSwim) {
                            this.sp.d(0.0, 0.1, 0.0);
                        }
                        this.isCrawling = false;
                        this.isDiving = false;
                        this.isSwimming = true;
                        this.isDipping = false;
                    }
                }
                if (!handleSwimmingRejected) {
                    swimming = !useStandard && swimming && Config.isSwimmingEnabled();
                    diving = !useStandard && diving && Config.isDivingEnabled();
                    dipping = !useStandard && dipping && Config.isSwimmingEnabled();
                    boolean bl6 = useStandard = !swimming && !diving && !dipping;
                    if (!useStandard) {
                        boolean levitating;
                        if (diveUp) {
                            this.sp.x -= (double)0.04f;
                        }
                        if (swimming) {
                            this.sp.w *= 0.85;
                            this.sp.x *= 0.85;
                            this.sp.y *= 0.85;
                        } else if (diving) {
                            this.sp.w *= 0.83;
                            this.sp.x *= 0.83;
                            this.sp.y *= 0.83;
                        } else if (dipping) {
                            this.sp.w *= 0.8;
                            this.sp.x *= 0.83;
                            this.sp.y *= 0.8;
                        } else {
                            this.sp.w *= 0.9;
                            this.sp.x *= 0.85;
                            this.sp.y *= 0.9;
                        }
                        boolean moveFlying = true;
                        boolean bl7 = levitating = diving && !diveUp && !diveDown && moveStrafing == 0.0f && moveForward == 0.0f;
                        if (diving) {
                            speedFactor *= ((Float)SmartMovingSelf.Config._diveSpeedFactor.value).floatValue();
                        }
                        if (swimming) {
                            speedFactor *= ((Float)SmartMovingSelf.Config._swimSpeedFactor.value).floatValue();
                        }
                        this.waterMovementTicks = swimming || diving ? ++this.waterMovementTicks : 0;
                        boolean wantJumpOutOfWater = (moveForward != 0.0f || moveStrafing != 0.0f) && this.sp.F && diveUp && !this.isSlow;
                        boolean bl8 = this.isJumpingOutOfWater = wantJumpOutOfWater && (this.waterMovementTicks > 10 || this.sp.E || wasJumpingOutOfWater);
                        if (diving) {
                            if (diveUp || diveDown || levitating) {
                                this.sp.x = (this.sp.x + motionYDiff) * 0.6;
                            } else {
                                this.moveFlying((float)motionYDiff, moveStrafing, moveForward, 0.02f * speedFactor);
                            }
                            moveFlying = false;
                        } else {
                            this.sp.x = swimming && swimDown ? (this.sp.x + motionYDiff) * 0.6 : (this.isJumpingOutOfWater ? (double)0.3f : (this.sp.x += motionYDiff));
                        }
                        this.isDiving = diving;
                        this.isLevitating = levitating;
                        this.isSwimming = swimming;
                        this.isShallowDiveOrSwim = couldStandUp && (this.isDiving || this.isSwimming);
                        this.isDipping = dipping;
                        if (this.isDiving || this.isSwimming) {
                            this.setHeightOffset(-1.0f);
                        }
                        if (this.isShallowDiveOrSwim && minPlayerSwimWaterDepth < (double)0.55f) {
                            if (this.isSlow) {
                                this.setHeightOffset(-1.0f);
                                this.isCrawling = true;
                                this.isDiving = false;
                                this.isSwimming = false;
                                this.isShallowDiveOrSwim = false;
                                this.isDipping = true;
                            } else {
                                this.resetHeightOffset();
                                this.sp.d(0.0, this.getMaxPlayerSolidBetween(this.sp.D.b, this.sp.D.e, 0.0) - this.sp.D.b, 0.0);
                                this.isCrawling = false;
                                this.isDiving = false;
                                this.isSwimming = false;
                                this.isShallowDiveOrSwim = false;
                                this.isDipping = true;
                            }
                        }
                        if (moveFlying) {
                            this.sp.a(moveStrafing, moveForward, 0.02f * speedFactor);
                        }
                        this.sp.d(this.sp.w, this.sp.x, this.sp.y);
                    }
                }
            } else {
                this.isDiving = false;
                this.isSwimming = false;
                this.isShallowDiveOrSwim = false;
                this.isDipping = false;
                this.isStillSwimmingJump = false;
            }
            if (useStandard) {
                this.resetSwimming();
                if (this.isCrawling) {
                    this.setHeightOffset(wasHeightOffset);
                }
                double dY = this.sp.u;
                this.sp.a(moveStrafing, moveForward, 0.02f * speedFactor);
                this.sp.d(this.sp.w, this.sp.x, this.sp.y);
                this.sp.w *= (double)0.8f;
                this.sp.x *= (double)0.8f;
                this.sp.y *= (double)0.8f;
                this.sp.x -= 0.02;
                if (this.sp.F && this.sp.c(this.sp.w, this.sp.x + (double)0.6f - this.sp.u + dY, this.sp.y)) {
                    this.sp.x = 0.3f;
                }
            }
        }
        return handleSwimming && !handleSwimmingRejected;
    }

    private boolean handleLava(float moveForward, float moveStrafing, boolean handledSwimming, boolean isLiquidClimbing) {
        boolean handleLava;
        boolean bl2 = handleLava = !this.isFlying && !handledSwimming && !isLiquidClimbing && this.sp.J();
        if (handleLava) {
            this.standupIfPossible();
            this.resetClimbing();
            this.resetSwimming();
            double d1 = this.sp.u;
            this.sp.a(moveStrafing, moveForward, 0.02f);
            this.sp.d(this.sp.w, this.sp.x, this.sp.y);
            this.sp.w *= 0.5;
            this.sp.x *= 0.5;
            this.sp.y *= 0.5;
            this.sp.x -= 0.02;
            if (this.sp.F && this.sp.c(this.sp.w, this.sp.x + (double)0.6f - this.sp.u + d1, this.sp.y)) {
                this.sp.x = 0.3f;
            }
        }
        return handleLava;
    }

    private boolean handleAlternativeFlying(float moveForward, float moveStrafing, float speedFactor, boolean handledSwimming, boolean handledLava) {
        boolean handleAlternativeFlying;
        boolean bl2 = handleAlternativeFlying = !handledSwimming && !handledLava && this.sp.bZ.b && Config.isFlyingEnabled();
        if (handleAlternativeFlying) {
            this.resetSwimming();
            this.resetClimbing();
            float moveUpward = 0.0f;
            if (this.esp.b.d) {
                this.sp.x += 0.15;
                moveUpward -= 0.98f;
            }
            if (this.esp.b.c) {
                this.sp.x -= 0.15;
                moveUpward += 0.98f;
            }
            this.moveFlying(moveUpward, moveStrafing, moveForward, speedFactor * 0.05f * ((Float)SmartMovingSelf.Config._flyingSpeedFactor.value).floatValue());
            this.sp.d(this.sp.w, this.sp.x, this.sp.y);
            this.sp.w *= (double)0.91f;
            this.sp.x *= (double)0.91f;
            this.sp.y *= (double)0.91f;
        }
        return handleAlternativeFlying;
    }

    private void handleLand(float moveForward, float moveStrafing, float speedFactor, boolean handledSwimming, boolean handledLava, boolean handledAlternativeFlying, boolean wasShortInWater, boolean wasClimbing, boolean wasCeilingClimbing) {
        if (!(handledSwimming || handledLava || handledAlternativeFlying)) {
            this.resetSwimming();
            if (!this.grabButton.Pressed) {
                this.fromSwimmingOrDiving(wasShortInWater);
            }
            boolean isOnLadder = this.isOnLadder(this.isClimbCrawling);
            boolean isOnVine = this.isOnVine(this.isClimbCrawling);
            float horizontalDamping = this.landMotion(moveForward, moveStrafing, speedFactor, isOnLadder, isOnVine);
            this.sp.d(this.sp.w, this.sp.x, this.sp.y);
            this.handleClimbing(isOnLadder, isOnVine, wasClimbing);
            this.handleCeilingClimbing(wasCeilingClimbing);
            this.setLandMotions(horizontalDamping);
        }
        this.landMotionPost(wasShortInWater);
    }

    private float landMotion(float moveForward, float moveStrafing, float speedFactor, boolean isOnLadder, boolean isOnVine) {
        int k2;
        int i2;
        double jGap;
        int j2;
        float horizontalDamping;
        if (this.sp.E && !this.isJumping) {
            int i3 = this.sp.p.a(ig.c(this.sp.t), ig.c(this.sp.D.b) - 1, ig.c(this.sp.v));
            horizontalDamping = i3 > 0 ? aif.m[i3].cq * 0.91f : 0.546f;
            if (this.esp.b.c && this.isFast) {
                if (Config.isJumpingEnabled(0, 0)) {
                    speedFactor *= ((Float)SmartMovingSelf.Config._sprintJumpVerticalFactor.value).floatValue();
                }
            }
        } else {
            horizontalDamping = 0.91f;
        }
        if (this.isClimbing && this.climbingUpIsBlockedByLadder()) {
            this.sp.a(0.0f, -1.0f, 0.07f);
        } else if (this.isClimbing && this.climbingUpIsBlockedByTrapDoor()) {
            if (this.sp.f_()) {
                this.sp.a(0.0f, -1.0f, 0.09f);
            } else {
                this.sp.a(0.0f, -1.0f, 0.09f);
            }
        } else if (!this.isSliding) {
            float rawSpeed;
            if (this.isHeadJumping) {
                speedFactor *= ((Float)SmartMovingSelf.Config._headJumpControlFactor.value).floatValue();
            } else if (SmartMovingSelf.Config.enabled && !this.sp.E && !this.sp.bZ.b && !this.isFlying) {
                speedFactor *= ((Float)SmartMovingSelf.Config._jumpControlFactor.value).floatValue();
            }
            float f3 = 0.1627714f / (horizontalDamping * horizontalDamping * horizontalDamping);
            float f4 = this.sp.E ? this.sp.aG * f3 : this.sp.aH;
            float f2 = rawSpeed = this.isp.localIsSprinting() ? f4 / 1.3f : f4;
            if (Config.isRunningEnabled() && this.isp.localIsSprinting() && !this.isFast) {
                speedFactor *= ((Float)SmartMovingSelf.Config._runFactor.value).floatValue();
            }
            this.sp.a(moveStrafing, moveForward, rawSpeed * speedFactor);
        }
        if (this.sp.E && !this.isJumping) {
            j2 = this.sp.p.a(ig.c(this.sp.t), ig.c(this.sp.D.b) - 1, ig.c(this.sp.v));
            if (j2 > 0) {
                float slipperiness = aif.m[j2].cq;
                if (this.isSliding) {
                    double angle;
                    horizontalDamping = 1.0f / ((1.0f / slipperiness - 1.0f) / 25.0f * ((Float)SmartMovingSelf.Config._slideSlipperinessFactor.value).floatValue() + 1.0f) * 0.98f;
                    if (moveStrafing != 0.0f && ((Float)SmartMovingSelf.Config._slideControlDegrees.value).floatValue() > 0.0f && !Double.isNaN(angle = -Math.atan(this.sp.w / this.sp.y))) {
                        if (this.sp.y < 0.0) {
                            angle += Math.PI;
                        }
                        double hMotion = Math.sqrt(this.sp.w * this.sp.w + this.sp.y * this.sp.y);
                        this.sp.w = hMotion * -Math.sin(angle -= (double)(((Float)SmartMovingSelf.Config._slideControlDegrees.value).floatValue() / 57.295776f * Math.signum(moveStrafing)));
                        this.sp.y = hMotion * Math.cos(angle);
                    }
                } else {
                    horizontalDamping = slipperiness * 0.91f;
                }
            } else {
                horizontalDamping = 0.546f;
            }
        } else {
            horizontalDamping = this.isAerodynamic ? 0.999f : 0.91f;
        }
        if (isOnLadder || isOnVine) {
            boolean notTotalFreeClimbing;
            float f4 = 0.15f;
            if (this.sp.w < (double)(-f4)) {
                this.sp.w = -f4;
            }
            if (this.sp.w > (double)f4) {
                this.sp.w = f4;
            }
            if (this.sp.y < (double)(-f4)) {
                this.sp.y = -f4;
            }
            if (this.sp.y > (double)f4) {
                this.sp.y = f4;
            }
            boolean bl2 = notTotalFreeClimbing = isOnLadder && !Config.isTotalFreeLadderClimb() || isOnVine && !Config.isTotalFreeVineClimb();
            if (notTotalFreeClimbing) {
                this.sp.R = 0.0f;
                if (this.sp.x < -0.15) {
                    this.sp.x = -0.15;
                }
            }
            if (Config.isFreeBaseClimb()) {
                if (!this.isClimbing && this.esp.b.d && this.sp.x < 0.0 && !this.sp.E && notTotalFreeClimbing) {
                    this.sp.x = 0.0;
                }
            } else if (this.isp.localIsSneaking() && this.sp.x < 0.0) {
                this.sp.x = 0.0;
            }
        } else if (Config.isFreeClimbAutoLaddderEnabled() && moveForward > 0.0f && (jGap = this.sp.D.b - (double)(j2 = ig.c(this.sp.D.b))) < 0.1 && Orientation.isLadder(this.sp.p.a(i2 = ig.c(this.sp.t), j2 - 1, k2 = ig.c(this.sp.v)))) {
            this.sp.x = Math.max(this.sp.x, 0.0);
        }
        return horizontalDamping;
    }

    private void handleClimbing(boolean isOnLadder, boolean isOnVine, boolean wasClimbing) {
        block48: {
            block49: {
                FeetClimbing feetClimbing;
                HandsClimbing handsClimbing;
                block52: {
                    block50: {
                        block56: {
                            block57: {
                                block55: {
                                    block54: {
                                        block53: {
                                            block51: {
                                                float rotation;
                                                boolean isSmallClimbing;
                                                boolean isOnLadderOrVine;
                                                this.resetClimbing();
                                                boolean bl2 = isOnLadderOrVine = isOnLadder || isOnVine;
                                                if (Config.isStandardBaseClimb() && this.sp.F && isOnLadderOrVine) {
                                                    this.sp.x = 0.2;
                                                }
                                                if (Config.isSimpleBaseClimb() && this.sp.F && isOnLadderOrVine) {
                                                    int i2 = ig.c(this.sp.t);
                                                    int j2 = ig.c(this.sp.D.b);
                                                    int k2 = ig.c(this.sp.v);
                                                    boolean feet = Orientation.isClimbable(this.sp.p, i2, j2, k2);
                                                    boolean hands = Orientation.isClimbable(this.sp.p, i2, j2 + 1, k2);
                                                    this.sp.x = feet && hands ? 0.2 : (feet ? 0.2 : (hands ? 0.1 : 0.0));
                                                }
                                                if (!Config.isSmartBaseClimb() && !Config.isFreeClimbingEnabled()) break block48;
                                                double id = this.sp.t;
                                                double jd2 = this.sp.D.b;
                                                double kd2 = this.sp.v;
                                                int i3 = ig.c(id);
                                                int j3 = ig.c(jd2);
                                                int k3 = ig.c(kd2);
                                                if (Config.isSmartBaseClimb() && isOnLadderOrVine && this.sp.F) {
                                                    boolean feet = Orientation.isClimbable(this.sp.p, i3, j3, k3);
                                                    boolean hands = Orientation.isClimbable(this.sp.p, i3, j3 + 1, k3);
                                                    if (feet && hands) {
                                                        this.sp.x = 0.2;
                                                    } else if (feet) {
                                                        boolean handsSubstitute;
                                                        boolean bl3 = handsSubstitute = Orientation.PZ.isHandsLadderSubstitute(this.sp.p, i3, j3 + 1, k3) || Orientation.NZ.isHandsLadderSubstitute(this.sp.p, i3, j3 + 1, k3) || Orientation.ZP.isHandsLadderSubstitute(this.sp.p, i3, j3 + 1, k3) || Orientation.ZN.isHandsLadderSubstitute(this.sp.p, i3, j3 + 1, k3);
                                                        this.sp.x = handsSubstitute ? 0.2 : 0.1;
                                                    } else if (hands) {
                                                        boolean feetSubstitute;
                                                        boolean bl4 = feetSubstitute = Orientation.ZZ.isFeetLadderSubstitute(this.sp.p, i3, j3, k3) || Orientation.PZ.isFeetLadderSubstitute(this.sp.p, i3, j3, k3) || Orientation.NZ.isFeetLadderSubstitute(this.sp.p, i3, j3, k3) || Orientation.ZP.isFeetLadderSubstitute(this.sp.p, i3, j3, k3) || Orientation.ZN.isFeetLadderSubstitute(this.sp.p, i3, j3, k3);
                                                        this.sp.x = feetSubstitute ? 0.2 : 0.1;
                                                    } else {
                                                        this.sp.x = 0.0;
                                                    }
                                                }
                                                if (!Config.isFreeClimbingEnabled() || !(this.sp.R <= ((Float)SmartMovingSelf.Config._freeClimbFallMaximumDistance.value).floatValue()) || isOnLadderOrVine && !Config.isFreeBaseClimb()) break block48;
                                                boolean exhaustionAllowsClimbing = !Config.isClimbExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._climbExhaustionStop.value).floatValue() && (wasClimbing || this.exhaustion <= ((Float)SmartMovingSelf.Config._climbExhaustionStart.value).floatValue());
                                                boolean preferClimb = false;
                                                if (this.wantClimbUp || this.wantClimbDown) {
                                                    if (Config.isClimbExhaustionEnabled()) {
                                                        this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._climbExhaustionStop.value).floatValue());
                                                        this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._climbExhaustionStart.value).floatValue());
                                                    }
                                                    if (exhaustionAllowsClimbing) {
                                                        preferClimb = true;
                                                    }
                                                }
                                                if (!preferClimb) break block49;
                                                boolean bl5 = isSmallClimbing = this.isCrawling || this.isSliding;
                                                if (this.isClimbCrawling || this.isCrawlClimbing || isSmallClimbing) {
                                                    jd2 += -1.0;
                                                }
                                                if ((rotation = this.sp.z % 360.0f) < 0.0f) {
                                                    rotation += 360.0f;
                                                }
                                                double jh2 = jd2 * 2.0 + 1.0;
                                                handsClimbing = HandsClimbing.None;
                                                feetClimbing = FeetClimbing.None;
                                                SmartMovingSelf.inout_handsClimbing[0] = handsClimbing;
                                                SmartMovingSelf.inout_feetClimbing[0] = feetClimbing;
                                                out_handsClimbGap.reset();
                                                out_feetClimbGap.reset();
                                                Orientation.PZ.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.NZ.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.ZP.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.ZN.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                handsClimbing = inout_handsClimbing[0];
                                                feetClimbing = inout_feetClimbing[0];
                                                this.isNeighborClimbing = handsClimbing != HandsClimbing.None || feetClimbing != FeetClimbing.None;
                                                this.hasNeighborClimbGap = SmartMovingSelf.out_handsClimbGap.CanStand || SmartMovingSelf.out_feetClimbGap.CanStand;
                                                boolean bl6 = this.hasNeighborClimbCrawlGap = SmartMovingSelf.out_handsClimbGap.MustCrawl || SmartMovingSelf.out_feetClimbGap.MustCrawl;
                                                if (!isSmallClimbing) {
                                                    Orientation.PP.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.NP.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.NN.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.PN.seekClimbGap(rotation, this.sp.p, i3, id, jh2, k3, kd2, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                }
                                                handsClimbing = inout_handsClimbing[0];
                                                feetClimbing = inout_feetClimbing[0];
                                                this.hasClimbGap = SmartMovingSelf.out_handsClimbGap.CanStand || SmartMovingSelf.out_feetClimbGap.CanStand;
                                                boolean bl7 = this.hasClimbCrawlGap = SmartMovingSelf.out_handsClimbGap.MustCrawl || SmartMovingSelf.out_feetClimbGap.MustCrawl;
                                                if (handsClimbing == HandsClimbing.BottomHold && Orientation.isLadder(this.sp.p.a(i3, j3 + 2, k3))) {
                                                    Orientation ladderOrientation = Orientation.getLadderOrientation(this.sp.p, i3, j3 + 2, k3);
                                                    int remote_i = i3 + ladderOrientation._i;
                                                    int remote_k = k3 + ladderOrientation._k;
                                                    if (!this.sp.p.f(remote_i, j3, remote_k).a() && !this.sp.p.f(remote_i, j3 + 1, remote_k).a()) {
                                                        handsClimbing = HandsClimbing.None;
                                                    }
                                                }
                                                if (!this.grabButton.Pressed && handsClimbing == HandsClimbing.Up && feetClimbing == FeetClimbing.None && !this.sp.F && this.sp.p.c(i3, j3, k3) && this.sp.p.c(i3, j3 + 1, k3)) {
                                                    handsClimbing = HandsClimbing.None;
                                                }
                                                if (!feetClimbing.IsRelevant() && !handsClimbing.IsRelevant()) break block49;
                                                if (!this.wantClimbUp) break block50;
                                                if (this.isSliding && handsClimbing.IsRelevant()) {
                                                    this.isSliding = false;
                                                    this.isCrawling = true;
                                                }
                                                handsClimbing = handsClimbing.ToUp();
                                                if (feetClimbing != FeetClimbing.FastUp || handsClimbing == HandsClimbing.None && this.sp.E && SmartMovingSelf.out_feetClimbGap.BlockId != aif.S.ca) break block51;
                                                this.setShouldClimbSpeed(0.2, 0, 1);
                                                break block52;
                                            }
                                            if (!this.hasClimbGap && !this.hasClimbCrawlGap || handsClimbing != HandsClimbing.FastUp || feetClimbing != FeetClimbing.None && feetClimbing != FeetClimbing.BaseWithHands) break block53;
                                            this.setShouldClimbSpeed(feetClimbing == FeetClimbing.None ? 0.1 : 0.2, 2, 1);
                                            break block52;
                                        }
                                        if (!feetClimbing.IsRelevant() || !handsClimbing.IsRelevant() || feetClimbing == FeetClimbing.BaseHold && handsClimbing == HandsClimbing.Sink || handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.TopWithHands || handsClimbing == HandsClimbing.TopHold && feetClimbing == FeetClimbing.TopWithHands) break block54;
                                        this.setShouldClimbSpeed(0.14, !(!this.hasClimbGap && !this.hasClimbCrawlGap || handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.BaseWithHands) ? 2 : 1, 1);
                                        break block52;
                                    }
                                    if (!handsClimbing.IsUp()) break block55;
                                    this.setShouldClimbSpeed(0.1);
                                    break block52;
                                }
                                if (handsClimbing != HandsClimbing.TopHold && feetClimbing != FeetClimbing.BaseHold && (feetClimbing != FeetClimbing.SlowUpWithHoldWithoutHands || handsClimbing != HandsClimbing.None)) break block56;
                                if (!this.jumpButton.StartPressed) break block57;
                                this.isClimbJumping = this.tryJump(feetClimbing != FeetClimbing.None ? 5 : 6, null, null, null);
                                if (this.isClimbJumping) break block52;
                            }
                            if (handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.BaseHold || handsClimbing == HandsClimbing.TopHold && feetClimbing == FeetClimbing.TopWithHands) {
                                this.setShouldClimbSpeed(0.08, 2, 1);
                            } else {
                                this.setShouldClimbSpeed(0.08);
                            }
                            break block52;
                        }
                        if (handsClimbing == HandsClimbing.Sink || feetClimbing == FeetClimbing.SlowUpWithSinkWithoutHands && handsClimbing == HandsClimbing.None) {
                            this.setShouldClimbSpeed(0.05);
                        }
                        break block52;
                    }
                    if (this.wantClimbDown) {
                        if ((handsClimbing = handsClimbing.ToDown()) == HandsClimbing.BottomHold && !feetClimbing.IsIndependentlyRelevant()) {
                            this.setShouldClimbSpeed(0.08);
                        } else if (handsClimbing.IsRelevant()) {
                            if (feetClimbing == FeetClimbing.FastUp) {
                                this.setShouldClimbSpeed(0.01, 0, 1);
                            } else if (feetClimbing == FeetClimbing.SlowUpWithHoldWithoutHands) {
                                this.setShouldClimbSpeed(0.01);
                            } else if (feetClimbing == FeetClimbing.TopWithHands) {
                                this.setShouldClimbSpeed(0.01);
                            } else if (feetClimbing == FeetClimbing.BaseWithHands || feetClimbing == FeetClimbing.BaseHold) {
                                if (handsClimbing != HandsClimbing.None && handsClimbing != HandsClimbing.Up || handsClimbing == HandsClimbing.Up && feetClimbing == FeetClimbing.BaseHold) {
                                    this.setShouldClimbSpeed(0.01);
                                } else {
                                    this.setShouldClimbSpeed(0.05);
                                }
                            } else {
                                this.setShouldClimbSpeed(0.05, handsClimbing == HandsClimbing.FastUp ? 2 : 1, 0);
                            }
                        }
                        if (this.isClimbHolding) {
                            this.setOnlyShouldClimbSpeed(0.08);
                            if (this.jumpButton.StartPressed) {
                                int type;
                                boolean handsOnly = feetClimbing != FeetClimbing.None;
                                boolean head = !this.grabButton.Pressed;
                                this.sp.z += 180.0f;
                                int n2 = head ? (handsOnly ? 9 : 10) : (handsOnly ? 7 : (type = 8));
                                if (this.tryJump(type, null, null, Float.valueOf(0.0f))) {
                                    this.onStartClimbBackJump();
                                } else {
                                    this.sp.z -= 180.0f;
                                }
                            }
                        }
                    }
                }
                if (this.isClimbing) {
                    this.handleCrash(((Float)SmartMovingSelf.Config._freeClimbFallDamageStartDistance.value).floatValue(), ((Float)SmartMovingSelf.Config._freeClimbFallDamageFactor.value).floatValue());
                }
                if (this.wantClimbUp || this.wantClimbDown) {
                    if (handsClimbing == HandsClimbing.None) {
                        this.actualHandsClimbType = 0;
                    } else if (feetClimbing == FeetClimbing.None) {
                        this.actualFeetClimbType = 0;
                    }
                    this.handsEdgeBlockId = SmartMovingSelf.out_handsClimbGap.BlockId;
                    this.handsEdgeMeta = SmartMovingSelf.out_handsClimbGap.Meta;
                    this.feetEdgeBlockId = SmartMovingSelf.out_feetClimbGap.BlockId;
                    this.feetEdgeMeta = SmartMovingSelf.out_feetClimbGap.Meta;
                }
            }
            if (SmartMovingOptions.hasRedPowerWire && !this.isClimbing && this.wantClimbUp && wasClimbing) {
                this.sp.x = 0.15;
            }
            this.isHandsVineClimbing = this.isClimbing && this.handsEdgeBlockId == aif.bu.ca;
            this.isFeetVineClimbing = this.isClimbing && this.feetEdgeBlockId == aif.bu.ca;
            this.isVineAnyClimbing = this.isHandsVineClimbing || this.isFeetVineClimbing;
            this.isVineOnlyClimbing = !(!this.isVineAnyClimbing || this.handsEdgeBlockId != -1 && this.handsEdgeBlockId != aif.bu.ca || this.feetEdgeBlockId != -1 && this.feetEdgeBlockId != aif.bu.ca);
        }
    }

    private void handleCeilingClimbing(boolean wasCeilingClimbing) {
        boolean couldClimbCeiling;
        boolean exhaustionAllowsClimbCeiling = !Config.isCeilingClimbExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStop.value).floatValue() && (wasCeilingClimbing || this.exhaustion <= ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStart.value).floatValue());
        boolean climbCeilingCrawlingStartConflict = !Config.isFreeClimbingEnabled() && this.isCrawling && !this.wasCrawling;
        boolean bl2 = couldClimbCeiling = this.wantClimbCeiling && !this.isClimbing && (!this.isCrawling || climbCeilingCrawlingStartConflict) && !this.isCrawlClimbing;
        if (couldClimbCeiling && Config.isCeilingClimbExhaustionEnabled()) {
            this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStop.value).floatValue());
            this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStart.value).floatValue());
        }
        if (couldClimbCeiling && exhaustionAllowsClimbCeiling) {
            boolean bottomCeilingClimbing;
            double id = this.sp.t;
            double jd2 = this.sp.D.e + (double)(climbCeilingCrawlingStartConflict ? 1.0f : 0.0f);
            double kd2 = this.sp.v;
            int i2 = ig.c(id);
            int j2 = ig.c(jd2);
            int k2 = ig.c(kd2);
            int topBlockId = this.supportsCeilingClimbing(i2, j2, k2);
            int bottomBlockId = this.supportsCeilingClimbing(i2, j2 + 1, k2);
            boolean topCeilingClimbing = topBlockId > -1;
            boolean bl3 = bottomCeilingClimbing = bottomBlockId > -1;
            if (topCeilingClimbing || bottomCeilingClimbing) {
                double jgap = 1.0 - jd2 + (double)j2;
                if (bottomCeilingClimbing) {
                    jgap += 1.0;
                }
                double actuallySolidHeight = this.getMinPlayerSolidBetween(jd2, jd2 + 0.6, 0.2);
                if (jgap < 1.9 && actuallySolidHeight < jd2 + 0.5) {
                    this.sp.x = jgap > 1.2 ? 0.12 : (jgap > 1.115 ? 0.08 : 0.04);
                    this.sp.R = 0.0f;
                    this.isCeilingClimbing = true;
                    int n2 = this.handsEdgeBlockId = topCeilingClimbing ? topBlockId : bottomBlockId;
                }
            }
        }
        if (this.isCeilingClimbing && climbCeilingCrawlingStartConflict) {
            this.isCrawling = false;
            this.resetHeightOffset();
            this.sp.d(0.0, 1.0, 0.0);
        }
    }

    private void setLandMotions(float horizontalDamping) {
        this.sp.x -= 0.08;
        this.sp.x *= (double)0.98f;
        this.sp.w *= (double)horizontalDamping;
        this.sp.y *= (double)horizontalDamping;
    }

    private void handleExhaustion(double diffX, double diffY, double diffZ) {
        if (this.sp.o == null && SmartMovingSelf.Config.enabled) {
            boolean isStill;
            boolean isSmartWaterMovement;
            float horizontalMovement = ig.a(diffX * diffX + diffZ * diffZ);
            float movement = ig.a((double)(horizontalMovement * horizontalMovement) + diffY * diffY);
            int relevantHorizontalMovementFactor = Math.round(horizontalMovement * 100.0f);
            int relevantMovementFactor = Math.round(movement * 100.0f);
            boolean bl2 = isSmartWaterMovement = this.isDipping || this.isSwimming || this.isDiving;
            if (this.sp.a(acn.g) && isSmartWaterMovement) {
                if (relevantMovementFactor > 0) {
                    this.sp.j(0.015f * (float)relevantMovementFactor * -0.01f);
                }
            } else if (this.sp.H() && isSmartWaterMovement) {
                if (relevantHorizontalMovementFactor > 0) {
                    this.sp.j(0.015f * (float)relevantHorizontalMovementFactor * -0.01f);
                }
            } else if (this.sp.E && relevantHorizontalMovementFactor > 0) {
                this.sp.j((this.sp.ag() ? 0.09999999f : 0.01f) * (float)relevantHorizontalMovementFactor * -0.01f);
            }
            boolean isRunning = this.isp.localIsSprinting();
            boolean isVerticalStill = Math.abs(diffY) < 0.007;
            boolean bl3 = isStill = this.isStanding && isVerticalStill;
            if (Config.isHungerGainEnabled()) {
                float hungerGainFactor = Config.getFactor(true, this.sp.E, this.isStanding, isStill, this.isSlow, isRunning, this.isFast, this.isClimbing, this.isClimbCrawling, this.isCeilingClimbing, this.isDipping, this.isSwimming, this.isDiving, this.isCrawling, this.isCrawlClimbing);
                this.sp.j(((Float)SmartMovingSelf.Config._alwaysHungerGain.value).floatValue() + (float)relevantMovementFactor * 1.0E-4f * hungerGainFactor);
            }
            float additionalExhaustion = 0.0f;
            if (this.isClimbing && !isStill && Config.isClimbExhaustionEnabled()) {
                float climbingExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                climbingExhaustion = isVerticalStill ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeExhaustionGain.value).floatValue()) : (!this.isStanding ? (this.wantClimbUp ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeUpExhaustionGain.value).floatValue()) : (this.wantClimbDown ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeDownExhaustionGain.value).floatValue()) : (climbingExhaustion *= 0.0f))) : (this.wantClimbUp ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbUpExhaustionGain.value).floatValue()) : (this.wantClimbDown ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbDownExhaustionGain.value).floatValue()) : (climbingExhaustion *= 0.0f))));
                additionalExhaustion += climbingExhaustion;
            }
            if (this.isCeilingClimbing && !this.isStanding && Config.isCeilingClimbExhaustionEnabled()) {
                additionalExhaustion += ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue() * ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionGain.value).floatValue();
            }
            if (this.isFast && Config.isSprintExhaustionEnabled()) {
                if (additionalExhaustion == 0.0f) {
                    additionalExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                }
                additionalExhaustion *= ((Float)SmartMovingSelf.Config._sprintExhaustionGainFactor.value).floatValue();
            }
            if (this.isp.localIsSprinting() && Config.isRunExhaustionEnabled()) {
                if (additionalExhaustion == 0.0f) {
                    additionalExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                }
                additionalExhaustion *= ((Float)SmartMovingSelf.Config._runExhaustionGainFactor.value).floatValue();
            }
            this.exhaustion += additionalExhaustion;
            if (this.exhaustion > 0.0f) {
                boolean exhaustionLossPossible;
                boolean bl4 = exhaustionLossPossible = !Config.isExhaustionLossHungerEnabled() || (float)this.sp.bL().a() > ((Float)SmartMovingSelf.Config._exhaustionLossFoodLevelMinimum.value).floatValue();
                if (exhaustionLossPossible) {
                    float exhaustionLossFactor = Config.getFactor(false, this.sp.E, this.isStanding, isStill, this.isSlow, isRunning, this.isFast, this.isClimbing, this.isClimbCrawling, this.isCeilingClimbing, this.isDipping, this.isSwimming, this.isDiving, this.isCrawling, this.isCrawlClimbing);
                    float exhaustionLoss = 1.0f * exhaustionLossFactor;
                    this.exhaustion -= exhaustionLoss;
                    if (Config.isExhaustionLossHungerEnabled()) {
                        this.sp.j(((Float)SmartMovingSelf.Config._exhaustionLossHungerFactor.value).floatValue() * exhaustionLoss);
                    }
                }
            }
            if (this.exhaustion < 0.0f) {
                this.exhaustion = 0.0f;
            }
            if (this.exhaustion == 0.0f) {
                this.maxExhaustionToStartAction = Float.NaN;
                this.maxExhaustionForAction = Float.NaN;
            }
            if (this.maxExhaustionForAction == Float.MAX_VALUE) {
                this.maxExhaustionForAction = this.prevMaxExhaustionForAction;
            }
            if (this.maxExhaustionToStartAction == Float.MAX_VALUE) {
                this.maxExhaustionToStartAction = this.prevMaxExhaustionToStartAction;
            }
        }
    }

    private void landMotionPost(boolean wasShortInWater) {
        if (this.grabButton.Pressed) {
            this.fromSwimmingOrDiving(wasShortInWater);
        }
        if (this.heightOffset != 0.0f && this.isp.getSleepingField()) {
            this.resetInternalHeightOffset();
        }
    }

    private void fromSwimmingOrDiving(boolean wasShortInWater) {
        boolean isShortInWater;
        boolean bl2 = isShortInWater = this.isSwimming || this.isDiving;
        if (wasShortInWater && !isShortInWater && !this.isp.getSleepingField()) {
            this.setHeightOffset(-1.0f);
            double crawlStandUpBottom = this.getMaxPlayerSolidBetween(this.sp.D.b - 1.0, this.sp.D.b, 0.0);
            double crawlStandUpLiquidCeiling = this.getMinPlayerLiquidBetween(this.sp.D.e, this.sp.D.e + 1.1);
            double crawlStandUpCeiling = this.getMinPlayerSolidBetween(this.sp.D.e, this.sp.D.e + 1.1, 0.0);
            this.resetHeightOffset();
            if (crawlStandUpCeiling - crawlStandUpBottom < (double)this.sp.O) {
                this.isCrawling = true;
                this.isDipping = false;
                this.setHeightOffset(-1.0f);
            } else if (crawlStandUpLiquidCeiling - crawlStandUpBottom < (double)this.sp.O) {
                this.isCrawling = true;
                this.contextContinueCrawl = true;
                this.isDipping = false;
                this.setHeightOffset(-1.0f);
            } else if (crawlStandUpBottom > this.sp.D.b) {
                if (this.isSlow && crawlStandUpBottom > this.sp.D.b + 0.5) {
                    this.isCrawling = true;
                    this.isDipping = false;
                    this.setHeightOffset(-1.0f);
                }
                this.sp.d(0.0, crawlStandUpBottom - this.sp.D.b, 0.0);
            }
        }
    }

    public boolean canTriggerWalking() {
        return !this.isClimbing && !this.isDiving;
    }

    private void resetClimbing() {
        this.isClimbing = false;
        this.isHandsVineClimbing = false;
        this.isFeetVineClimbing = false;
        this.isVineOnlyClimbing = false;
        this.isVineAnyClimbing = false;
        this.isClimbingStill = false;
        this.isNeighborClimbing = false;
        this.actualHandsClimbType = 0;
        this.actualFeetClimbType = 0;
        this.isCeilingClimbing = false;
    }

    private void resetSwimming() {
        this.dippingDepth = -1.0f;
        this.isDipping = false;
        this.isSwimming = false;
        this.isDiving = false;
        this.isLevitating = false;
        this.isShallowDiveOrSwim = false;
        this.isFakeShallowWaterSneaking = false;
        this.isJumpingOutOfWater = false;
    }

    private void setShouldClimbSpeed(double value) {
        this.setShouldClimbSpeed(value, 1, 1);
    }

    private void setShouldClimbSpeed(double value, int handsClimbType, int feetClimbType) {
        this.setOnlyShouldClimbSpeed(value);
        this.actualHandsClimbType = handsClimbType;
        this.actualFeetClimbType = feetClimbType;
    }

    private void setOnlyShouldClimbSpeed(double value) {
        boolean relevant;
        this.isClimbing = true;
        if (this.climbIntoCount > 0) {
            value = 0.08;
        }
        if (value != 0.08) {
            float factor = ((Float)SmartMovingSelf.Config._freeClimbingUpSpeedFactor.value).floatValue();
            if (this.isFast) {
                factor *= ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue();
            }
            if (Config.isFreeBaseClimb() && value == 0.14) {
                switch (this.getOnLadder(Integer.MAX_VALUE, false, this.isClimbCrawling)) {
                    case 1: {
                        factor *= ((Float)SmartMovingSelf.Config._freeOneLadderClimbUpSpeedFactor.value).floatValue();
                        break;
                    }
                    case 2: {
                        factor *= ((Float)SmartMovingSelf.Config._freeBothLadderClimbUpSpeedFactor.value).floatValue();
                    }
                }
            }
            value = value > 0.08 ? (value - 0.08) * (double)factor + 0.08 : 0.08 - (0.08 - value) * (double)factor;
            if (this.hasClimbCrawlGap && this.isClimbCrawling && value > 0.08) {
                value = Math.min(0.17, value);
            }
        } else {
            this.isClimbingStill = true;
        }
        boolean bl2 = relevant = value >= this.sp.x;
        if (relevant) {
            this.sp.x = value;
        }
        this.isClimbJumping = !relevant && !this.isClimbHolding;
    }

    public boolean isOnLadderOrVine() {
        return this.isOnLadderOrVine(this.isClimbCrawling);
    }

    public void beforeMoveEntity(double d2, double d1, double d22) {
        this.beforeMoveEntityPosX = this.sp.t;
        this.beforeMoveEntityPosY = this.sp.v;
        this.beforeMoveEntityPosZ = this.sp.u;
        if (this.esp.b.d || this.sneakToggled) {
            this.sp.V = this.isSwimming || this.isDiving || this.isCrawling || this.isClimbing || !Config.isSneakingEnabled() && !this.isSneaking() ? 0.0f : (this.isSlow ? 0.6f : 0.0f);
        }
        if (this.isSliding || this.isCrawling) {
            this.beforeDistanceWalkedModified = this.sp.Q;
            this.sp.Q = Float.MIN_VALUE;
        }
    }

    public void moveEntity(double d2, double d1, double d22) {
        this.beforeMoveEntity(d2, d1, d22);
        this.isp.localMoveEntity(d2, d1, d22);
        this.afterMoveEntity(d2, d1, d22);
    }

    public void afterMoveEntity(double d2, double d1, double d22) {
        if (this.isSliding || this.isCrawling) {
            this.sp.Q = this.beforeDistanceWalkedModified;
        }
        if (this.heightOffset != 0.0f) {
            this.sp.u += (double)this.heightOffset;
        }
        this.wasOnGround = this.sp.E;
        double d10 = this.sp.t - this.beforeMoveEntityPosX;
        double d12 = this.sp.v - this.beforeMoveEntityPosY;
        double d13 = this.sp.u - this.beforeMoveEntityPosZ;
        double distance = ig.a(d10 * d10 + d12 * d12 + d13 * d13);
        if (this.isClimbing || this.isCeilingClimbing) {
            this.distanceClimbedModified = (float)((double)this.distanceClimbedModified + distance * (this.isClimbing ? 1.2 : 0.9));
            if (this.distanceClimbedModified > (float)this.nextClimbDistance) {
                aii stepsound;
                aif stepBlock;
                int blockId = this.isClimbing ? (this.handsEdgeBlockId == -1 ? (this.feetEdgeBlockId == -1 ? aif.w.ca : this.feetEdgeBlockId) : (this.feetEdgeBlockId == -1 ? this.handsEdgeBlockId : (this.nextClimbDistance % 2 != 0 ? this.feetEdgeBlockId : this.handsEdgeBlockId))) : this.handsEdgeBlockId;
                ++this.nextClimbDistance;
                if (blockId >= 0 && blockId < aif.m.length && (stepBlock = aif.m[blockId]) != null && (stepsound = aif.m[blockId].cn) != null) {
                    this.sp.p.a((jm)this.sp, stepsound.d(), stepsound.b() * 0.15f, stepsound.c());
                }
            }
        }
        this.playSounds(distance);
    }

    public void beforeSleepInBedAt(int i2, int j2, int k2) {
        if (!this.isp.getSleepingField()) {
            this.updateEntityActionState(true);
        }
    }

    public og sleepInBedAt(int i2, int j2, int k2) {
        this.beforeSleepInBedAt(i2, j2, k2);
        return this.isp.localSleepInBedAt(i2, j2, k2);
    }

    private void resetHeightOffset() {
        this.sp.D.b += (double)this.heightOffset;
        this.sp.O -= this.heightOffset;
        this.heightOffset = 0.0f;
    }

    private void resetInternalHeightOffset() {
        this.sp.O -= this.heightOffset;
        this.heightOffset = 0.0f;
    }

    private void setHeightOffset(float offset) {
        this.resetHeightOffset();
        if (offset == 0.0f) {
            return;
        }
        this.heightOffset = offset;
        this.sp.D.b -= (double)this.heightOffset;
        this.sp.O += this.heightOffset;
    }

    public float getBrightness(float f2) {
        this.sp.u -= (double)this.heightOffset;
        float result = this.isp.localGetBrightness(f2);
        this.sp.u += (double)this.heightOffset;
        return result;
    }

    public int getBrightnessForRender(float f2) {
        this.sp.u -= (double)this.heightOffset;
        int result = this.isp.localGetBrightnessForRender(f2);
        this.sp.u += (double)this.heightOffset;
        return result;
    }

    public boolean pushOutOfBlocks(double d2, double d1, double d22) {
        if (this.multiPlayerInitialized > 0) {
            return false;
        }
        boolean top = false;
        if (this.heightOffset != 0.0f) {
            top = this.sp.O > 1.0f;
        }
        return this.pushOutOfBlocks(d2, d1, d22, top);
    }

    public void beforeOnUpdate() {
        this.isJumping = false;
        this.sp.aG = this.localLandMovementFactor;
        if (this.isFast && !this.isClimbing && !this.isCrawling && !this.isp.localIsSprinting()) {
            this.sp.aG = (float)((double)this.sp.aG - 0.03);
        }
        if (this.sp.p.K && this.updateCounter < 10) {
            List chatMessageList = (List)Reflect.GetField(_chatMessageList, this.isp.getMcField().v.b());
            for (int i2 = 0; i2 < chatMessageList.size(); ++i2) {
                if (!SmartMovingComm.processBlockCode(((and)chatMessageList.get(i2)).a())) continue;
                chatMessageList.remove(i2--);
            }
            ++this.updateCounter;
        }
    }

    public void afterOnUpdate() {
        this.correctOnUpdate(this.isSwimming || this.isDiving || this.isDipping || this.isCrawling, this.isSwimming);
        this.spawnParticles(this.isp.getMcField(), this.sp.w, this.sp.y);
        this.localLandMovementFactor = this.sp.aG;
        if (SmartMovingSelf.Config.enabled) {
            float perspectiveFactor = this.sp.aG;
            if (this.isFast || this.isSprintJump || this.isp.localIsSprinting()) {
                if (this.isFast || this.isp.localIsSprinting()) {
                    perspectiveFactor -= 0.03f;
                }
                if (this.isFast || this.isSprintJump) {
                    perspectiveFactor += 0.03f * ((Float)SmartMovingSelf.Options._perspectiveSprintFactor.value).floatValue();
                } else if (this.isp.localIsSprinting()) {
                    perspectiveFactor += 0.03f * ((Float)SmartMovingSelf.Options._perspectiveRunFactor.value).floatValue();
                }
            }
            if (this.fadingPerspectiveFactor != -1.0f) {
                this.sp.aG = this.fadingPerspectiveFactor + (perspectiveFactor - this.fadingPerspectiveFactor) * ((Float)SmartMovingSelf.Options._perspectiveFadeFactor.value).floatValue();
            }
            this.fadingPerspectiveFactor = this.sp.aG;
        }
        if (this.sp.bZ.a) {
            this.exhaustion = 0.0f;
        }
        if (this.sp.bZ.b) {
            this.sp.R = 0.0f;
        }
        this.collidedHorizontallyTickCount = this.sp.F ? ++this.collidedHorizontallyTickCount : 0;
        this.addToSendQueue();
        if (this.wasInventory) {
            this.sp.at = this.sp.as;
        }
        this.wasInventory = this.isp.getMcField().r instanceof aqt;
    }

    public void handleJumping() {
        boolean jump;
        if (this.blockJumpTillButtonRelease && !this.esp.b.c) {
            this.blockJumpTillButtonRelease = false;
        }
        if (this.isSwimming || this.isDiving) {
            return;
        }
        boolean bl2 = jump = this.sp.al && this.sp.E && this.isp.getIsJumpingField() && !this.sp.H() && !this.sp.J();
        if (jump) {
            if (this.sp.D.b - this.getMaxPlayerSolidBetween(this.sp.D.b - 0.2, this.sp.D.b, 0.0) >= 0.01) {
                return;
            }
            this.sp.w = this.prevMotionX;
            this.sp.x = this.prevMotionY;
            this.sp.y = this.prevMotionZ;
            this.sp.a(ht.u, -1);
            this.sp.j(this.sp.ag() ? -0.8f : -0.2f);
            this.sp.al = false;
        }
        boolean isJumpCharging = false;
        if (Config.isJumpChargingEnabled()) {
            boolean actualJumpCharging;
            boolean isJumpChargingPossible = this.sp.E && this.isStanding;
            isJumpCharging = isJumpChargingPossible && this.wouldIsSneaking;
            boolean bl3 = actualJumpCharging = isJumpChargingPossible && ((Boolean)SmartMovingSelf.Config._jumpChargeCancelOnSneakRelease.value == false || this.wouldIsSneaking);
            if (actualJumpCharging) {
                if (this.esp.b.c && (((Boolean)SmartMovingSelf.Config._jumpChargeCancelOnSneakRelease.value).booleanValue() || this.wouldIsSneaking)) {
                    this.jumpCharge += 1.0f;
                } else {
                    if (this.jumpCharge > 0.0f) {
                        this.tryJump(1, null, null, null);
                    }
                    this.jumpCharge = 0.0f;
                }
            } else {
                if (this.jumpCharge > 0.0f) {
                    this.blockJumpTillButtonRelease = true;
                }
                this.jumpCharge = 0.0f;
            }
        }
        boolean isHeadJumpCharging = false;
        if (Config.isHeadJumpingEnabled()) {
            boolean bl4 = isHeadJumpCharging = this.grabButton.Pressed && (this.isGroundSprinting || this.isSprintJump || this.isp.localIsSprinting() && this.sp.E) && !this.isCrawling;
            if (isHeadJumpCharging) {
                if (this.esp.b.c) {
                    this.headJumpCharge += 1.0f;
                } else {
                    if (this.headJumpCharge > 0.0f && this.sp.E) {
                        this.tryJump(3, null, null, null);
                    }
                    this.headJumpCharge = 0.0f;
                }
            } else {
                if (this.headJumpCharge > 0.0f) {
                    this.blockJumpTillButtonRelease = true;
                }
                this.headJumpCharge = 0.0f;
            }
        }
        if (this.esp.b.c && this.sp.H() && this.isDipping) {
            double d2 = this.sp.u - (double)ig.c(this.sp.u);
            double d3 = this.isSlow ? 0.37 : 0.6;
            if (d2 > d3) {
                this.sp.x -= (double)0.04f;
                if (!this.isStillSwimmingJump && this.sp.E && this.jumpCharge == 0.0f) {
                    if (this.tryJump(0, true, null, null)) {
                        Random rand = this.sp.au();
                        this.sp.p.a((jm)this.sp, "random.splash", 0.05f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
                    }
                }
            }
        }
        if (!(!jump || this.blockJumpTillButtonRelease || isJumpCharging || isHeadJumpCharging || this.isVineAnyClimbing)) {
            this.tryJump(0, false, null, null);
        }
        int left = 0;
        int back = 0;
        if (this.leftJumpCount == -1) {
            ++left;
        }
        if (this.rightJumpCount == -1) {
            --left;
        }
        if (this.backJumpCount == -1) {
            ++back;
        }
        if (left != 0 || back != 0) {
            int angle = left > 0 ? (back == 0 ? 90 : 135) : (left < 0 ? (back == 0 ? 270 : 225) : 180);
            if (this.tryJump(2, null, null, Float.valueOf(angle))) {
                this.angleJumpType = angle / 45;
            }
            this.leftJumpCount = 0;
            this.rightJumpCount = 0;
            this.backJumpCount = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean tryJump(int type, Boolean inWaterOrNull, Boolean isRunningOrNull, Float angle) {
        inWater = inWaterOrNull != null ? inWaterOrNull : this.isDipping;
        isRunning = isRunningOrNull != null ? isRunningOrNull.booleanValue() : this.isp.localIsSprinting();
        charged = type == 1;
        if (type == 0) ** GOTO lbl-1000
        if (type == 1) ** GOTO lbl-1000
        if (type == 3) ** GOTO lbl-1000
        if (type == 5) ** GOTO lbl-1000
        if (type == 6) ** GOTO lbl-1000
        if (type == 7) ** GOTO lbl-1000
        if (type == 8) ** GOTO lbl-1000
        if (type == 9) ** GOTO lbl-1000
        if (type == 10) lbl-1000:
        // 9 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        up = v0;
        if (type == 3) ** GOTO lbl-1000
        if (type == 9) ** GOTO lbl-1000
        if (type == 10) lbl-1000:
        // 3 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        head = v1;
        speed = SmartMovingSelf.getJumpSpeed(this.isStanding, this.isSlow, isRunning, this.isFast, angle);
        enabled = SmartMovingSelf.Config.isJumpingEnabled(speed, type);
        if (enabled) {
            exhausionEnabled = SmartMovingSelf.Config.isJumpExhaustionEnabled(speed, type);
            if (exhausionEnabled) {
                maxExhausionForJump = SmartMovingSelf.Config.getJumpExhaustionStop(speed, type, this.jumpCharge);
                if (this.exhaustion > maxExhausionForJump) {
                    return false;
                }
                this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, maxExhausionForJump);
                this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, maxExhausionForJump + SmartMovingSelf.Config.getJumpExhaustionGain(speed, type, this.jumpCharge));
            }
            horizontalJumpFactor = SmartMovingSelf.Config.getJumpHorizontalFactor(speed, type);
            verticalJumpFactor = SmartMovingSelf.Config.getJumpVerticalFactor(speed, type);
            v2 = jumpChargeFactor = charged != false ? SmartMovingSelf.Config.getJumpChargeFactor(this.jumpCharge) : 1.0f;
            if (!up) {
                horizontalJumpFactor = ig.c(horizontalJumpFactor * horizontalJumpFactor + verticalJumpFactor * verticalJumpFactor);
                verticalJumpFactor = 0.0f;
            }
            maxHorizontalMotion = null;
            horizontalMotion = ig.a(this.sp.w * this.sp.w + this.sp.y * this.sp.y);
            verticalMotion = -0.078 + 0.498 * (double)verticalJumpFactor * (double)jumpChargeFactor;
            if (horizontalJumpFactor > 1.0f && !this.sp.F) {
                maxHorizontalMotion = SmartMovingSelf.Config.getMaxHorizontalMotion(speed, type, inWater);
            }
            if (head) {
                normalAngle = Math.atan(verticalMotion / horizontalMotion);
                totalMotion = Math.sqrt(verticalMotion * verticalMotion + horizontalMotion * horizontalMotion);
                newAngle = (double)SmartMovingSelf.Config.getHeadJumpFactor(this.headJumpCharge) * normalAngle;
                newVerticalMotion = totalMotion * Math.sin(newAngle);
                newHorizontalMotion = totalMotion * Math.cos(newAngle);
                if (maxHorizontalMotion != null) {
                    maxHorizontalMotion = maxHorizontalMotion * (newHorizontalMotion / horizontalMotion);
                }
                verticalMotion = newVerticalMotion;
                horizontalMotion = newHorizontalMotion;
            }
            if (angle != null) {
                jumpAngle = (angle.floatValue() - this.sp.z) / 57.295776f;
                horizontal = ((Float)SmartMovingSelf.Config._angleJumpHorizontalFactor.value).floatValue();
                horizontal = Math.max(horizontalMotion, horizontal);
                moveX = Math.sin(jumpAngle) * horizontal;
                moveZ = Math.cos(jumpAngle) * horizontal;
                this.sp.w += moveX;
                this.sp.y += moveZ;
                horizontalMotion = 0.0;
                if (type != 7) {
                    verticalMotion = ((Float)SmartMovingSelf.Config._angleJumpVerticalFactor.value).floatValue();
                }
                up = true;
            }
            if (horizontalMotion > 0.0) {
                absoluteMotionX = Math.abs(this.sp.w) * (double)horizontalJumpFactor;
                absoluteMotionZ = Math.abs(this.sp.y) * (double)horizontalJumpFactor;
                if (maxHorizontalMotion != null) {
                    absoluteMotionX = Math.min(absoluteMotionX, maxHorizontalMotion * ((double)horizontalJumpFactor * (Math.abs(this.sp.w) / horizontalMotion)));
                    absoluteMotionZ = Math.min(absoluteMotionZ, maxHorizontalMotion * ((double)horizontalJumpFactor * (Math.abs(this.sp.y) / horizontalMotion)));
                }
                this.sp.w = Math.signum(this.sp.w) * absoluteMotionX;
                this.sp.y = Math.signum(this.sp.y) * absoluteMotionZ;
            }
            if (up) {
                this.sp.x = verticalMotion;
                this.sp.a(ht.u, 1);
                this.isSprintJump = this.isFast;
            }
            if (exhausionEnabled) {
                exhaustionFromJump = SmartMovingSelf.Config.getJumpExhaustionGain(speed, type, this.jumpCharge);
                this.exhaustion += exhaustionFromJump;
            }
            if (head) {
                this.isHeadJumping = true;
                this.setHeightOffset(-1.0f);
            }
            this.isJumping = true;
        }
        return enabled;
    }

    private static int getJumpSpeed(boolean isStanding, boolean isSneaking, boolean isRunning, boolean isSprinting, Float angle) {
        isRunning &= angle == null;
        if (isSprinting &= angle == null) {
            return 0;
        }
        if (isRunning) {
            return 1;
        }
        if (isSneaking) {
            return 3;
        }
        if (isStanding) {
            return 4;
        }
        return 2;
    }

    private void standupIfPossible() {
        boolean groundClose;
        if (this.heightOffset >= 0.0f) {
            return;
        }
        double gapUnderneight = this.getGapUnderneight();
        boolean bl2 = groundClose = gapUnderneight < 1.0;
        if (!groundClose) {
            this.resetHeightOffset();
        } else {
            boolean standUpPossible;
            double gapOverneight = groundClose ? this.getGapOverneight() : -1.0;
            boolean bl3 = standUpPossible = gapUnderneight + gapOverneight >= 1.0;
            if (standUpPossible) {
                this.standUp(gapUnderneight);
            } else {
                this.toSlidingOrCrawling(gapUnderneight);
            }
        }
    }

    private void standupIfPossible(boolean tryLanding, boolean restoreFromFlying) {
        boolean standUpPossible;
        if (this.heightOffset >= 0.0f) {
            return;
        }
        double gapUnderneight = this.getGapUnderneight();
        boolean groundClose = gapUnderneight < 1.0;
        double gapOverneight = groundClose ? this.getGapOverneight() : -1.0;
        boolean bl2 = standUpPossible = gapUnderneight + gapOverneight >= 1.0;
        if (tryLanding && groundClose && standUpPossible) {
            this.isFlying = false;
            this.sp.bZ.b = false;
            restoreFromFlying = true;
        }
        if (!restoreFromFlying) {
            return;
        }
        if (!groundClose && !this.sneakButton.Pressed) {
            this.resetHeightOffset();
        } else if (!(!standUpPossible || this.sneakButton.Pressed && this.grabButton.Pressed)) {
            this.standUp(gapUnderneight);
        } else {
            this.toSlidingOrCrawling(gapUnderneight);
        }
    }

    private void standUp(double gapUnderneight) {
        this.sp.d(0.0, 1.0 - gapUnderneight, 0.0);
        this.isCrawling = false;
        this.isHeadJumping = false;
        this.resetHeightOffset();
    }

    private void toSlidingOrCrawling(double gapUnderneight) {
        this.sp.d(0.0, -gapUnderneight, 0.0);
        if (Config.isSlidingEnabled() && (this.grabButton.Pressed || this.wasHeadJumping)) {
            this.isSliding = true;
        } else {
            this.wasCrawling = this.toCrawling();
        }
    }

    private void handleCrash(float fallDamageStartDistance, float fallDamageFactor) {
        if (this.sp.R >= 2.0f) {
            this.sp.a(ht.n, (int)Math.round((double)this.sp.R * 100.0));
        }
        if (this.sp.R >= fallDamageStartDistance) {
            this.sp.a(jd.h, (int)Math.ceil((this.sp.R - fallDamageStartDistance) * fallDamageFactor));
            this.distanceClimbedModified = this.nextClimbDistance;
        }
        this.sp.R = 0.0f;
    }

    public void beforeSetPositionAndRotation() {
        if (this.sp.p.K) {
            this.initialized = false;
            this.multiPlayerInitialized = 5;
        }
    }

    public void updateEntityActionState(boolean startSleeping) {
        boolean canBackJump;
        boolean canClimbCrawling;
        boolean exhaustionAllowsSprinting;
        boolean exhaustionAllowsRunning;
        boolean tryLanding;
        boolean wantClimb;
        boolean inputContinueCrawl;
        this.prevMaxExhaustionForAction = this.maxExhaustionForAction;
        this.prevMaxExhaustionToStartAction = this.maxExhaustionToStartAction;
        this.maxExhaustionForAction = Float.MAX_VALUE;
        this.maxExhaustionToStartAction = Float.MAX_VALUE;
        boolean isLevitating = this.sp.bZ.b && !this.isFlying;
        boolean isRunning = this.isp.localIsSprinting();
        this.prevMotionX = this.sp.w;
        this.prevMotionZ = this.sp.y;
        this.toggleButton.update((Integer)SmartMovingSelf.Options._toggleKeyCode.value);
        if (this.toggleButton.StartPressed) {
            Config.toggle();
        }
        boolean initializeCrawling = false;
        if (!(this.initialized || this.sp.p.K && this.multiPlayerInitialized != 0)) {
            if (this.getMaxPlayerSolidBetween(this.sp.D.b, this.sp.D.e, 0.0) > this.sp.D.b) {
                initializeCrawling = true;
                this.toCrawling();
            }
            this.initialized = true;
        }
        if (this.multiPlayerInitialized > 0) {
            --this.multiPlayerInitialized;
        }
        if (!this.esp.b.c) {
            this.isStillSwimmingJump = false;
        }
        if (!startSleeping) {
            this.isp.localUpdateEntityActionState();
            this.isp.setMoveStrafingField(Math.signum(this.esp.b.a));
            this.isp.setMoveForwardField(Math.signum(this.esp.b.b));
            this.isp.setIsJumpingField(!(!this.esp.b.c || this.isCrawling || this.isSliding || Config.isHeadJumpingEnabled() && this.grabButton.Pressed && this.sp.ag() || Config.isJumpChargingEnabled() && this.wouldIsSneaking && this.sp.E && this.isStanding || this.blockJumpTillButtonRelease));
        }
        boolean isRiding = this.sp.o != null;
        boolean isSleeping = this.isp.getSleepingField();
        boolean disabled = !SmartMovingSelf.Config.enabled || isRiding || isSleeping || startSleeping;
        Minecraft minecraft = this.isp.getMcField();
        any gameSettings = minecraft.y;
        this.forwardButton.update(gameSettings.w);
        this.leftButton.update(gameSettings.x);
        this.rightButton.update(gameSettings.z);
        this.backButton.update(gameSettings.y);
        this.jumpButton.update(this.esp.b.c);
        this.sprintButton.update(SmartMovingSelf.Options.keyBindSprint);
        this.sneakButton.update(this.esp.b.d);
        this.grabButton.update(SmartMovingSelf.Options.keyBindGrab);
        double horizontalSpeedSquare = this.sp.w * this.sp.w + this.sp.y * this.sp.y;
        boolean blocked = minecraft.r != null && !minecraft.r.j;
        boolean mustCrawl = false;
        double crawlStandUpBottom = -1.0;
        if (this.isCrawling || this.isClimbCrawling) {
            crawlStandUpBottom = this.getMaxPlayerSolidBetween(this.sp.D.b - (initializeCrawling ? 0.0 : 1.0), this.sp.D.b, (Boolean)SmartMovingSelf.Config._crawlOverEdge.value != false ? 0.0 : -0.05);
            double crawlStandUpCeiling = this.getMinPlayerSolidBetween(this.sp.D.e, this.sp.D.e + 1.1, 0.0);
            boolean bl2 = mustCrawl = crawlStandUpCeiling - crawlStandUpBottom < (double)(this.sp.O - this.heightOffset);
        }
        if (this.esp.bZ.b && (Config.isFlyingEnabled() || Config.isLevitateSmallEnabled())) {
            mustCrawl = false;
        }
        boolean bl3 = Options.isCrawlToggleEnabled() ? this.crawlToggled : (inputContinueCrawl = this.sneakButton.Pressed || !Config.isFreeClimbingEnabled() && this.grabButton.Pressed);
        if (this.contextContinueCrawl) {
            double crawlStandUpLiquidCeiling;
            if (inputContinueCrawl || this.sp.H() || mustCrawl) {
                this.contextContinueCrawl = false;
            } else if (this.isCrawling && (crawlStandUpLiquidCeiling = this.getMinPlayerLiquidBetween(this.sp.D.e, this.sp.D.e + 1.1)) - crawlStandUpBottom >= (double)(this.sp.O + 1.0f)) {
                this.contextContinueCrawl = false;
            }
        }
        boolean wantCrawl = Config.isCrawlingEnabled() && !this.esp.bZ.b && (this.isCrawling && (inputContinueCrawl || this.contextContinueCrawl) || this.grabButton.StartPressed && (this.sneakToggled || this.sneakButton.Pressed || !Config.isFreeClimbingEnabled()) && this.sp.E);
        boolean canCrawl = !this.isSwimming && !this.isDiving && (!this.isDipping || this.dippingDepth + this.heightOffset < 0.65f) && !this.isClimbing && this.sp.R < ((Float)SmartMovingSelf.Config._fallingDistanceMinimum.value).floatValue();
        this.wasCrawling = this.isCrawling;
        boolean bl4 = this.isCrawling = canCrawl && (wantCrawl || mustCrawl);
        if (!this.isCrawling) {
            this.contextContinueCrawl = false;
        }
        if (this.wasCrawling && !this.isCrawling && this.esp.bZ.b) {
            this.tryJump(0, null, null, null);
        }
        this.wantCrawlNotClimb = (this.wantCrawlNotClimb || this.grabButton.StartPressed && !this.wasCrawling) && this.grabButton.Pressed && this.esp.b.b > 0.0f && this.isCrawling && this.sp.F;
        boolean bl5 = wantClimb = Config.isFreeClimbingEnabled() && (this.grabButton.Pressed || this.isClimbHolding && this.sneakButton.Pressed || Config.isFreeClimbAutoLaddderEnabled() && this.isFacedToLadder(this.isClimbCrawling) || Config.isFreeClimbAutoVineEnabled() && this.isFacedToSolidVine(this.isClimbCrawling)) && (!this.isSliding || this.grabButton.Pressed && this.esp.b.b > 0.0f) && !this.isHeadJumping && !this.wantCrawlNotClimb && !disabled;
        if (!wantClimb || this.sp.G) {
            this.isClimbJumping = false;
        }
        if (this.sp.H) {
            this.isClimbBackJumping = false;
        }
        this.wantClimbUp = wantClimb && this.esp.b.b > 0.0f || this.isVineAnyClimbing && this.jumpButton.Pressed && (!this.isCrawling || this.sp.F) && (!this.isSliding || this.sp.F);
        this.wantClimbDown = wantClimb && this.esp.b.b <= 0.0f && !wantCrawl;
        this.wantClimbCeiling = Config.isCeilingClimbingEnabled() && this.grabButton.Pressed && !this.wantCrawlNotClimb && !this.isSneaking() && !disabled;
        boolean restoreFromFlying = false;
        boolean wasFlying = this.isFlying;
        boolean bl6 = this.isFlying = Config.isFlyingEnabled() && this.sp.bZ.b && !this.isSwimming && !this.isDiving;
        if (this.isFlying && !wasFlying) {
            this.setHeightOffset(-1.0f);
        } else if (!this.isFlying && wasFlying) {
            restoreFromFlying = true;
        }
        if (!Config.isFlyingEnabled() && Config.isLevitateSmallEnabled()) {
            if (isLevitating && !this.wasLevitating) {
                this.setHeightOffset(-1.0f);
            } else if (!isLevitating && this.wasLevitating) {
                restoreFromFlying = true;
            }
        }
        this.wasHeadJumping = this.isHeadJumping;
        boolean bl7 = this.isHeadJumping = !(!this.isHeadJumping || this.sp.E || this.isSwimming || this.isDiving || this.isFlying || this.sp.bZ.b || this.sp.I() && this.sp.x < 0.0 || this.sp.J());
        if (!this.isHeadJumping) {
            this.isAerodynamic = false;
        }
        if (this.wasHeadJumping && !this.isHeadJumping && this.sp.E) {
            this.handleCrash(((Float)SmartMovingSelf.Config._headFallDamageStartDistance.value).floatValue(), ((Float)SmartMovingSelf.Config._headFallDamageFactor.value).floatValue());
            restoreFromFlying = true;
        }
        boolean bl8 = tryLanding = this.isFlying && horizontalSpeedSquare < 0.003 && this.sp.x > -0.03;
        if (restoreFromFlying || tryLanding) {
            this.standupIfPossible(tryLanding, restoreFromFlying);
        }
        if (this.isSliding && this.sp.R > 0.0f) {
            this.isSliding = false;
            this.isHeadJumping = true;
            this.isAerodynamic = true;
        }
        if (Config.isSlidingEnabled() && this.grabButton.Pressed && (this.isGroundSprinting || this.wasRunning && !isRunning && this.sp.E) && !this.isCrawling && this.sneakButton.StartPressed && !this.isDipping) {
            this.setHeightOffset(-1.0f);
            this.sp.d(0.0, -1.0, 0.0);
            this.tryJump(4, false, this.wasRunning, null);
            this.isSliding = true;
            this.isHeadJumping = false;
            this.isAerodynamic = false;
        }
        if (this.isSliding && (!this.sneakButton.Pressed || horizontalSpeedSquare < (double)((Float)SmartMovingSelf.Config._slidingSpeedStopFactor.value).floatValue() * 0.01)) {
            this.isSliding = false;
            this.wasCrawling = this.toCrawling();
        }
        if (this.isSliding && this.sp.R > ((Float)SmartMovingSelf.Config._fallingDistanceMinimum.value).floatValue()) {
            this.isSliding = false;
            this.wasCrawling = true;
            this.isCrawling = false;
        }
        boolean sneakContinueInput = Options.isSneakToggleEnabled() ? this.sneakToggled || this.sneakButton.StartPressed : this.sneakButton.Pressed;
        boolean wouldWantSneak = !(this.isFlying || this.isSliding || this.isHeadJumping || this.isDiving && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false || this.isSwimming && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false && !this.isFakeShallowWaterSneaking || !sneakContinueInput || wantCrawl || mustCrawl || Config.isCrawlingEnabled() && this.grabButton.Pressed);
        boolean wantSneak = Config.isSneakingEnabled() && wouldWantSneak;
        boolean moveButtonPressed = this.esp.b.b != 0.0f || this.esp.b.a != 0.0f;
        boolean moveForwardButtonPressed = this.esp.b.b > 0.0f;
        this.wantSprint = Config.isSprintingEnabled() && !this.isSliding && this.sprintButton.Pressed && (moveForwardButtonPressed || this.isClimbing || this.isSwimming && (moveButtonPressed || this.sneakButton.Pressed && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false) || this.isDiving && (moveButtonPressed || this.jumpButton.Pressed || this.sneakButton.Pressed && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false) || this.isFlying && (moveButtonPressed || this.jumpButton.Pressed || this.sneakButton.Pressed)) && !disabled;
        boolean bl9 = exhaustionAllowsRunning = !Config.isRunExhaustionEnabled() || this.exhaustion < ((Float)SmartMovingSelf.Config._runExhaustionStop.value).floatValue() && (this.wasRunning || this.exhaustion < ((Float)SmartMovingSelf.Config._runExhaustionStart.value).floatValue());
        if (isRunning && this.sp.E && Config.isRunExhaustionEnabled()) {
            this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._runExhaustionStop.value).floatValue());
            this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._runExhaustionStart.value).floatValue());
        }
        if (!exhaustionAllowsRunning && isRunning) {
            isRunning = false;
            this.sp.b(false);
        }
        if (!(this.sp.E || !this.isFast || this.isClimbing || this.isCeilingClimbing || this.isDiving || this.isSwimming)) {
            this.isSprintJump = true;
        }
        boolean bl10 = exhaustionAllowsSprinting = !Config.isSprintExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._sprintExhaustionStop.value).floatValue() && (this.isFast || this.isSprintJump || this.exhaustion <= ((Float)SmartMovingSelf.Config._sprintExhaustionStart.value).floatValue());
        if (this.sp.E || this.isFlying || this.isSwimming || this.isDiving || this.sp.J()) {
            this.isSprintJump = false;
        }
        boolean preferSprint = false;
        if (this.wantSprint && !wantSneak) {
            if (!this.isSprintJump && Config.isSprintExhaustionEnabled()) {
                this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._sprintExhaustionStop.value).floatValue());
                this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._sprintExhaustionStart.value).floatValue());
            }
            if (exhaustionAllowsSprinting) {
                preferSprint = true;
            }
        }
        boolean isClimbSprintSpeed = true;
        if (this.isClimbing && preferSprint) {
            double minTickDistance = this.wantClimbUp ? 0.07 * (double)((Float)SmartMovingSelf.Config._freeClimbingUpSpeedFactor.value).floatValue() : (this.wantClimbDown ? 0.11 * (double)((Float)SmartMovingSelf.Config._freeClimbingDownSpeedFactor.value).floatValue() : 0.07);
            isClimbSprintSpeed = (double)this.tickDistance >= minTickDistance;
        }
        boolean canAnySprint = preferSprint && !this.sp.ad() && ((Boolean)SmartMovingSelf.Config._sprintDuringItemUsage.value != false || !this.sp.bw());
        boolean canVerticallySprint = canAnySprint && !this.sp.G;
        boolean canHorizontallySprint = canAnySprint && this.collidedHorizontallyTickCount < 3;
        boolean canAllSprint = canHorizontallySprint && canVerticallySprint;
        this.isGroundSprinting = canHorizontallySprint && this.sp.E && !this.isSwimming && !this.isDiving && !this.isClimbing;
        boolean isSwimSprinting = canHorizontallySprint && this.isSwimming;
        boolean isDiveSprinting = canAllSprint && this.isDiving;
        boolean isCeilingSprinting = canHorizontallySprint && this.isCeilingClimbing;
        boolean isFlyingSprinting = canAllSprint && this.isFlying;
        boolean isClimbSprinting = canAnySprint && this.isClimbing && isClimbSprintSpeed;
        this.isFast = this.isGroundSprinting || isClimbSprinting || isSwimSprinting || isDiveSprinting || isCeilingSprinting || isFlyingSprinting || isClimbSprinting;
        this.wouldIsSneaking = wouldWantSneak && !this.wantSprint && !this.isClimbing;
        boolean wasSneaking = this.isSlow;
        this.isSlow = wantSneak && this.wouldIsSneaking;
        boolean wantClimbHolding = this.isClimbHolding && this.sneakButton.Pressed || this.isClimbing && blocked || wantClimb && !this.isSwimming && !this.isDiving && !this.isCrawling && (this.sneakButton.Pressed || this.crawlToggled);
        this.isClimbHolding = wantClimbHolding && this.isClimbing;
        this.isStanding = horizontalSpeedSquare < 5.0E-4;
        boolean wasCrawlClimbing = this.isCrawlClimbing;
        boolean bl11 = this.isCrawlClimbing = !(!this.wasCrawling && !this.isCrawlClimbing || !this.isClimbing || !this.isNeighborClimbing || !this.sneakButton.Pressed && !this.crawlToggled || !(this.esp.b.b > 0.0f));
        if (this.isCrawlClimbing) {
            boolean canStandUp;
            boolean bl12 = canStandUp = !this.isPlayerInSolidBetween(this.sp.D.b - (this.isClimbCrawling ? 0.95 : 1.0), this.sp.D.b);
            if (canStandUp) {
                wasCrawlClimbing = false;
                this.isCrawlClimbing = false;
                if (!this.isClimbCrawling) {
                    this.resetHeightOffset();
                }
            }
            if (!wasCrawlClimbing) {
                this.wasCrawling = false;
                this.isCrawling = false;
            }
        } else if (wasCrawlClimbing) {
            double minY;
            boolean toCrawling;
            boolean bl13 = toCrawling = this.sneakButton.Pressed || this.crawlToggled;
            if (!this.isClimbing) {
                this.wasCrawling = this.toCrawling();
                minY = this.sp.D.b;
                this.sp.d(0.0, -minY + Math.floor(minY), 0.0);
            } else if (this.esp.b.b <= 0.0f) {
                this.wasCrawling = toCrawling;
                this.isCrawling = toCrawling;
                this.wantClimbUp = false;
                this.wantClimbDown = false;
                if (!toCrawling) {
                    this.resetHeightOffset();
                }
                minY = this.sp.D.b;
                this.sp.d(0.0, -minY + Math.floor(minY) + (double)(toCrawling ? 0.0f : 1.0f), 0.0);
            } else if (!toCrawling) {
                this.resetHeightOffset();
                minY = this.sp.D.b;
                this.sp.d(0.0, Math.ceil(minY) - minY, 0.0);
            }
        }
        boolean wasClimbCrawling = this.isClimbCrawling;
        boolean needClimbCrawling = this.hasClimbCrawlGap || this.hasClimbGap && this.isClimbHolding;
        boolean bl14 = canClimbCrawling = wantClimbHolding && this.wantClimbUp;
        if (this.climbIntoCount > 1) {
            --this.climbIntoCount;
        } else if (this.isClimbCrawling && !needClimbCrawling && this.climbIntoCount == 0) {
            this.climbIntoCount = 6;
        }
        boolean bl15 = this.isClimbCrawling = canClimbCrawling && (needClimbCrawling && this.climbIntoCount == 0 || this.climbIntoCount > 1);
        if (this.isClimbCrawling && !wasClimbCrawling) {
            this.setHeightOffset(-1.0f);
            boolean wasCollidedHorizontally = this.sp.F;
            this.sp.d(0.0, 0.05, 0.0);
            this.sp.F = wasCollidedHorizontally;
        } else if (!this.isClimbCrawling && wasClimbCrawling) {
            this.climbIntoCount = 0;
            if (mustCrawl || this.sneakButton.Pressed || this.crawlToggled) {
                double gapUnderneight = this.sp.D.b - this.getMaxPlayerSolidBetween(this.sp.D.b - 1.0, this.sp.D.b, 0.0);
                if (gapUnderneight >= 0.0 && gapUnderneight < 1.0) {
                    this.wasCrawling = this.toCrawling();
                    this.sp.d(0.0, -gapUnderneight, 0.0);
                } else {
                    this.resetHeightOffset();
                }
            } else {
                this.resetHeightOffset();
            }
        }
        if (this.wasCrawling && !this.isCrawling && !initializeCrawling && !this.esp.bZ.b) {
            this.resetHeightOffset();
            this.sp.d(0.0, crawlStandUpBottom - this.sp.D.b, 0.0);
        } else if (this.isCrawling && !this.wasCrawling || initializeCrawling) {
            this.setHeightOffset(-1.0f);
            if (!initializeCrawling || this.sp.p.K) {
                this.sp.d(0.0, -1.0, 0.0);
            }
            if (initializeCrawling) {
                this.wasCrawling = this.toCrawling();
            }
        }
        if (this.grabButton.StartPressed) {
            if (this.isShallowDiveOrSwim && wantClimb) {
                this.resetHeightOffset();
                this.sp.d(0.0, this.getMaxPlayerSolidBetween(this.sp.D.b, this.sp.D.e, 0.0) - this.sp.D.b, 0.0);
                if (this.jumpButton.Pressed) {
                    this.isStillSwimmingJump = true;
                }
            } else if (this.isDipping && wantCrawl && this.dippingDepth >= 0.55f) {
                if (this.dippingDepth >= 0.6f) {
                    this.setHeightOffset(-1.0f);
                    this.sp.d(0.0, -1.6f + this.dippingDepth, 0.0);
                    this.isCrawling = false;
                } else {
                    this.setHeightOffset(-1.0f);
                    this.sp.d(0.0, -1.0, 0.0);
                    this.wasCrawling = this.toCrawling();
                }
            }
        }
        boolean canAngleJump = !isSleeping && this.sp.E && !this.isCrawling && !this.isClimbing && !this.isClimbCrawling && !this.isSwimming && !this.isDiving;
        boolean canSideJump = Config.isSideJumpEnabled() && canAngleJump;
        boolean canLeftJump = canSideJump && !this.rightButton.Pressed;
        boolean canRightJump = canSideJump && !this.leftButton.Pressed;
        boolean bl16 = canBackJump = Config.isBackJumpEnabled() && canAngleJump && !this.forwardButton.Pressed && !this.isSprinting();
        if (canLeftJump) {
            if (this.leftButton.StartPressed) {
                this.leftJumpCount = this.leftJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.leftJumpCount > 0) {
                --this.leftJumpCount;
            }
        } else {
            this.leftJumpCount = 0;
        }
        if (canRightJump) {
            if (this.rightButton.StartPressed) {
                this.rightJumpCount = this.rightJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.rightJumpCount > 0) {
                --this.rightJumpCount;
            }
        } else {
            this.rightJumpCount = 0;
        }
        if (canBackJump) {
            if (this.backButton.StartPressed) {
                this.backJumpCount = this.backJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.backJumpCount > 0) {
                --this.backJumpCount;
            }
        } else {
            this.backJumpCount = 0;
        }
        if (this.rightJumpCount == -2 && this.backJumpCount <= 0) {
            this.rightJumpCount = -1;
        }
        if (this.leftJumpCount == -2 && this.backJumpCount <= 0) {
            this.leftJumpCount = -1;
        }
        if (this.backJumpCount == -2 && (this.leftJumpCount <= 0 || this.rightJumpCount <= 0)) {
            this.backJumpCount = -1;
        }
        if (this.rightJumpCount == -1 && this.backJumpCount > 0) {
            this.rightJumpCount = -2;
        }
        if (this.leftJumpCount == -1 && this.backJumpCount > 0) {
            this.leftJumpCount = -2;
        }
        if (this.backJumpCount == -1 && (this.leftJumpCount > 0 || this.rightJumpCount > 0)) {
            this.backJumpCount = -2;
        }
        if (this.sp.E || this.sp.G) {
            this.angleJumpType = 0;
        }
        boolean isSneakToggleEnabled = Options.isSneakToggleEnabled();
        boolean isCrawlToggleEnabled = Options.isCrawlToggleEnabled();
        boolean willStopCrawl = false;
        boolean willStopCrawlStartSneak = false;
        if (isSneakToggleEnabled || isCrawlToggleEnabled) {
            if (this.isCrawling && this.jumpButton.StopPressed) {
                willStopCrawlStartSneak = true;
            }
            if (this.isCrawling && this.sneakButton.StopPressed && !this.ignoreNextStopSneakButtonPressed) {
                willStopCrawlStartSneak = true;
            }
            if (!(this.isCrawling || this.isCrawlClimbing || this.isClimbCrawling)) {
                willStopCrawl = true;
            }
            willStopCrawl |= willStopCrawlStartSneak;
        }
        boolean willStopSneak = false;
        if (isSneakToggleEnabled) {
            if (this.isCrawling && !willStopCrawlStartSneak) {
                willStopSneak = true;
            }
            if (wantSneak && this.wantSprint && this.sneakButton.StartPressed && this.sneakToggled) {
                willStopSneak = true;
                this.ignoreNextStopSneakButtonPressed = true;
            }
            if (wasSneaking && this.sneakButton.StartPressed) {
                willStopSneak = true;
            }
            if (!this.isSwimming && !this.isDiving && this.jumpButton.StopPressed) {
                willStopSneak = true;
            }
        }
        boolean willStartSneak = false;
        if (isSneakToggleEnabled) {
            if (willStopCrawlStartSneak && this.sneakButton.StopPressed) {
                willStartSneak = true;
            }
            if (this.isFast && this.sneakButton.StopPressed && !this.ignoreNextStopSneakButtonPressed) {
                willStartSneak = true;
            }
            if (this.isSlow && !wasSneaking) {
                willStartSneak = true;
            }
        }
        boolean willStartCrawl = false;
        if (isCrawlToggleEnabled) {
            if (this.isCrawling && !this.wasCrawling) {
                willStartCrawl = true;
            }
            if (this.isClimbCrawling && !wasClimbCrawling) {
                willStartCrawl = true;
            }
        }
        if (isSneakToggleEnabled) {
            if (willStartSneak) {
                this.sneakToggled = true;
            }
            if (willStopSneak) {
                this.sneakToggled = false;
            }
        }
        if (isCrawlToggleEnabled) {
            if (willStartCrawl) {
                this.crawlToggled = true;
                this.ignoreNextStopSneakButtonPressed = this.sneakButton.Pressed;
            }
            if (willStopCrawl) {
                this.crawlToggled = false;
            }
        }
        if (this.sneakButton.StopPressed) {
            this.ignoreNextStopSneakButtonPressed = false;
        }
        this.wasRunning = isRunning;
        this.wasLevitating = isLevitating;
    }

    private boolean toCrawling() {
        this.isCrawling = true;
        if (Options.isCrawlToggleEnabled()) {
            this.crawlToggled = true;
        }
        this.ignoreNextStopSneakButtonPressed = true;
        return true;
    }

    public void addToSendQueue() {
        if (!this.sp.p.K) {
            return;
        }
        boolean isSmall = this.sp.O < 1.0f;
        long state = 0L;
        state |= this.isFast ? 1L : 0L;
        state <<= 1;
        state |= this.isSlow ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbBackJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isHandsVineClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isFeetVineClimbing ? 1L : 0L;
        state <<= 3;
        state |= (long)this.angleJumpType;
        state <<= 1;
        state |= this.isSliding ? 1L : 0L;
        state <<= 1;
        state |= this.isHeadJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isLevitating ? 1L : 0L;
        state <<= 1;
        state |= this.isCeilingClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.doFlyingAnimation() ? 1L : 0L;
        state <<= 1;
        state |= this.doFallingAnimation() ? 1L : 0L;
        state <<= 1;
        state |= isSmall ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isCrawling ? 1L : 0L;
        state <<= 1;
        state |= this.isCrawlClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isSwimming ? 1L : 0L;
        state <<= 1;
        state |= this.isDipping ? 1L : 0L;
        state <<= 1;
        state |= this.isDiving ? 1L : 0L;
        state <<= 1;
        state |= this.isp.getIsJumpingField() ? 1L : 0L;
        state <<= 4;
        state |= (long)this.actualHandsClimbType;
        state <<= 4;
        boolean sendStatePacket = (state |= (long)this.actualFeetClimbType) != this.prevPacketState;
        int currentWorldPlayerEntitiesSize = this.sp.p.i.size();
        if (currentWorldPlayerEntitiesSize == 0) {
            sendStatePacket = false;
            this.lastWorldPlayerEntitiesSize = currentWorldPlayerEntitiesSize;
            this.lastWorldPlayerLastEnttyId = -1;
        } else {
            int currentWorldPlayerLastEnttyId = ((jm)this.sp.p.i.get((int)(currentWorldPlayerEntitiesSize - 1))).k;
            if (currentWorldPlayerEntitiesSize != this.lastWorldPlayerEntitiesSize) {
                if (currentWorldPlayerEntitiesSize > this.lastWorldPlayerEntitiesSize) {
                    sendStatePacket = true;
                }
                this.lastWorldPlayerEntitiesSize = currentWorldPlayerEntitiesSize;
                this.lastWorldPlayerLastEnttyId = currentWorldPlayerLastEnttyId;
            } else if (currentWorldPlayerLastEnttyId != this.lastWorldPlayerLastEnttyId) {
                sendStatePacket = true;
                this.lastWorldPlayerLastEnttyId = currentWorldPlayerLastEnttyId;
            }
        }
        if (sendStatePacket) {
            SmartMovingPacketStream.sendState(SmartMovingComm.instance, this.sp.k, state);
            this.prevPacketState = state;
        }
    }

    public boolean isSneaking() {
        return this.isSlow && this.sp.E || (Boolean)SmartMovingSelf.Config._sneak.value == false && this.wouldIsSneaking && this.jumpCharge > 0.0f || this.sp.o != null && this.isp.localIsSneaking() || (Boolean)SmartMovingSelf.Config._crawlOverEdge.value == false && this.isCrawling && !this.isClimbing;
    }

    public boolean isSprinting() {
        return this.isGroundSprinting && !this.isSliding && !this.isCrawling || this.isp.localIsSprinting();
    }

    public void beforeGetSleepTimer() {
        SmartMovingRender.renderGuiIngame(this.isp.getMcField());
    }

    public void writeEntityToNBT(an nBTTagCompound) {
        this.isp.localWriteEntityToNBT(nBTTagCompound);
        an abilities = nBTTagCompound.l("abilities");
        if (abilities != null && abilities.b("flying")) {
            abilities.a("flying", this.sp.bZ.b);
        }
    }

    @Override
    public boolean isJumping() {
        return this.isp.getIsJumpingField();
    }

    @Override
    public boolean doFlyingAnimation() {
        if (Config.isFlyingEnabled() || Config.isLevitationAnimationEnabled()) {
            return this.sp.bZ.b;
        }
        return false;
    }

    @Override
    public boolean doFallingAnimation() {
        if (Config.isFallAnimationEnabled()) {
            return !this.sp.E && this.sp.R > ((Float)SmartMovingSelf.Config._fallAnimationDistanceMinimum.value).floatValue();
        }
        return false;
    }
}

