/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.move.IPacketReceiver;
import net.minecraft.move.IPacketSender;
import net.minecraft.move.Info;

public class SmartMovingPacketStream {
    public static final String Id;
    public static final Set errors;

    public static void receivePacket(Object packet, IPacketReceiver comm, Object player, byte[] data) {
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(data);
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            byte packetId = objectInput.readByte();
            switch (packetId) {
                case 0: {
                    int entityId = objectInput.readInt();
                    long state = objectInput.readLong();
                    comm.processStatePacket(packet, player, entityId, state);
                    break;
                }
                case 1: {
                    String info = (String)objectInput.readObject();
                    comm.processConfigInfoPacket(packet, player, info);
                    break;
                }
                case 2: {
                    String[] content = (String[])objectInput.readObject();
                    comm.processConfigContentPacket(packet, player, content);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown packet id '" + packetId + "' found");
                }
            }
        }
        catch (Throwable t2) {
            if (errors.add(t2.getStackTrace()[0])) {
                t2.printStackTrace();
            }
            System.err.println(t2.getClass().getName() + ": " + t2.getMessage());
        }
    }

    public static void sendState(IPacketSender comm, int entityId, long state) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(0);
            objectOutput.writeInt(entityId);
            objectOutput.writeLong(state);
            objectOutput.flush();
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendConfigInfo(IPacketSender comm, String info) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(1);
            objectOutput.writeObject(info);
            objectOutput.flush();
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendConfigContent(IPacketSender comm, String[] content) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(2);
            objectOutput.writeObject(content);
            objectOutput.flush();
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    static {
        String id = Info.getModComId();
        if (id.length() > 15) {
            id = id.substring(0, 15);
        }
        Id = id;
        errors = new HashSet();
    }
}

