/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.util.Hashtable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.move.IEntityPlayerSP;
import net.minecraft.move.SmartMoving;
import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.SmartMovingOther;

public class SmartMovingFactory
extends SmartMovingContext {
    private static SmartMovingFactory factory;
    private Hashtable otherSmartMovings;

    public SmartMovingFactory() {
        if (factory != null) {
            throw new RuntimeException("FATAL: Can only create one instance of type 'SmartMovingFactory'");
        }
        factory = this;
    }

    protected static boolean isInitialized() {
        return factory != null;
    }

    public static void initialize() {
        if (!SmartMovingFactory.isInitialized()) {
            new SmartMovingFactory();
        }
    }

    public static void handleMultiPlayerTick(Minecraft minecraft) {
        factory.doHandleMultiPlayerTick(minecraft);
    }

    public static SmartMoving getInstance(of entityPlayer) {
        return factory.doGetInstance(entityPlayer);
    }

    public static SmartMoving getOtherSmartMoving(int entityId) {
        return factory.doGetOtherSmartMoving(entityId);
    }

    public static SmartMovingOther getOtherSmartMoving(auq entity) {
        return factory.doGetOtherSmartMoving(entity);
    }

    protected void doHandleMultiPlayerTick(Minecraft minecraft) {
        SmartMovingOther moving;
        for (jm player : minecraft.e.i) {
            if (!(player instanceof auq)) continue;
            auq otherPlayer = (auq)player;
            moving = this.doGetOtherSmartMoving(otherPlayer);
            moving.calculateAllStats(false);
            moving.spawnParticles(minecraft, otherPlayer.t - otherPlayer.q, otherPlayer.v - otherPlayer.s);
            moving.foundAlive = true;
        }
        if (this.otherSmartMovings == null || this.otherSmartMovings.isEmpty()) {
            return;
        }
        Iterator entityIds = this.otherSmartMovings.keySet().iterator();
        while (entityIds.hasNext()) {
            Integer entityId = (Integer)entityIds.next();
            moving = (SmartMovingOther)this.otherSmartMovings.get(entityId);
            if (moving.foundAlive) {
                moving.foundAlive = false;
                continue;
            }
            entityIds.remove();
        }
    }

    protected SmartMoving doGetInstance(of entityPlayer) {
        if (entityPlayer instanceof auq) {
            return this.doGetOtherSmartMoving(entityPlayer.k);
        }
        if (entityPlayer instanceof IEntityPlayerSP) {
            return ((IEntityPlayerSP)((Object)entityPlayer)).getMoving();
        }
        return null;
    }

    protected SmartMoving doGetOtherSmartMoving(int entityId) {
        jm entity;
        SmartMovingOther moving = this.tryGetOtherSmartMoving(entityId);
        if (moving == null && (entity = SmartMovingFactory.GetMinecraft().e.a(entityId)) != null && entity instanceof auq) {
            moving = this.addOtherSmartMoving((auq)entity);
        }
        return moving;
    }

    protected SmartMovingOther doGetOtherSmartMoving(auq entity) {
        SmartMovingOther moving = this.tryGetOtherSmartMoving(entity.k);
        if (moving == null) {
            moving = this.addOtherSmartMoving(entity);
        }
        return moving;
    }

    protected final SmartMovingOther tryGetOtherSmartMoving(int entityId) {
        if (this.otherSmartMovings == null) {
            this.otherSmartMovings = new Hashtable();
        }
        return (SmartMovingOther)this.otherSmartMovings.get(entityId);
    }

    protected final SmartMovingOther addOtherSmartMoving(auq entity) {
        SmartMovingOther moving = new SmartMovingOther(entity);
        this.otherSmartMovings.put(entity.k, moving);
        return moving;
    }
}

