/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.move.Info;
import net.minecraft.move.Reflect;
import net.minecraft.move.SmartMovingFactory;
import net.minecraft.move.SmartMovingServer;
import net.minecraft.move.config.SmartMovingClientConfig;
import net.minecraft.move.config.SmartMovingOptions;
import net.minecraft.move.config.SmartMovingServerConfig;
import net.minecraft.move.render.RenderPlayer;
import net.minecraft.server.MinecraftServer;

public abstract class SmartMovingContext {
    public static final float ClimbPullMotion = 0.3f;
    public static final double FastUpMotion = 0.2;
    public static final double MediumUpMotion = 0.14;
    public static final double SlowUpMotion = 0.1;
    public static final double HoldMotion = 0.08;
    public static final double SinkDownMotion = 0.05;
    public static final double ClimbDownMotion = 0.01;
    public static final double CatchCrawlGapMotion = 0.17;
    public static final float SwimCrawlWaterMaxBorder = 1.0f;
    public static final float SwimCrawlWaterTopBorder = 0.65f;
    public static final float SwimCrawlWaterMediumBorder = 0.6f;
    public static final float SwimCrawlWaterBottomBorder = 0.55f;
    public static final float HorizontalGroundDamping = 0.546f;
    public static final float HorizontalAirDamping = 0.91f;
    public static final float HorizontalAirodynamicDamping = 0.999f;
    public static final float SwimSoundDistance = 1.4285715f;
    public static final float Whole = (float)Math.PI * 2;
    public static final float Half = (float)Math.PI;
    public static final float Quarter = 1.5707964f;
    public static final float Eighth = 0.7853982f;
    public static final float Sixteenth = 0.3926991f;
    public static final float Thirtytwoth = 0.19634955f;
    public static final float Sixtyfourth = 0.09817477f;
    public static final float FrequenceFactor = 0.6662f;
    public static final float RadiantToAngle = 57.295776f;
    public static final int Scale = 0;
    public static final int NoScaleStart = 1;
    public static final int NoScaleEnd = 2;
    public static final SmartMovingOptions Options = new SmartMovingOptions();
    public static final SmartMovingServerConfig ServerConfig = new SmartMovingServerConfig();
    public static SmartMovingClientConfig Config = Options;
    private static boolean wasInitialized;
    private static Properties lastTranslateTable;
    private static final Field theMinecraft;

    public static Minecraft GetMinecraft() {
        return (Minecraft)Reflect.GetField(theMinecraft, null);
    }

    public static void initialize(any gameSettings, boolean addRenderer, Logger logger) {
        if (wasInitialized) {
            return;
        }
        SmartMovingFactory.initialize();
        SmartMovingServer.initialize(SmartMovingOptions.optionsPath, MinecraftServer.a, true);
        if (((Boolean)SmartMovingContext.Options._freeClimb.value).booleanValue() || ((Boolean)SmartMovingContext.Options._sprint.value).booleanValue() || ((Boolean)SmartMovingContext.Options._crawl.value).booleanValue()) {
            boolean needSneakButton = (Boolean)SmartMovingContext.Options._sneak.value != false || (Boolean)SmartMovingContext.Options._crawl.value != false && (Boolean)SmartMovingContext.Options._freeClimb.value != false;
            boolean needGrabButton = (Boolean)SmartMovingContext.Options._freeClimb.value != false || (Boolean)SmartMovingContext.Options._crawl.value != false || (Boolean)SmartMovingContext.Options._swim.value != false || (Boolean)SmartMovingContext.Options._dive.value != false;
            boolean needSprintButton = (Boolean)SmartMovingContext.Options._sprint.value;
            ane[] previous = gameSettings.K;
            gameSettings.K = new ane[previous.length - 1 + (needSneakButton ? 1 : 0) + (needGrabButton ? 1 : 0) + (needSprintButton ? 1 : 0)];
            ane[] current = gameSettings.K;
            int i2 = 0;
            int n2 = 0;
            while (i2 < previous.length) {
                ane binding = previous[i2];
                if (binding == gameSettings.E) {
                    if (needSneakButton) {
                        current[n2++] = gameSettings.E;
                    }
                    if (needGrabButton) {
                        current[n2++] = SmartMovingContext.Options.keyBindGrab;
                    }
                    if (needSprintButton) {
                        current[n2++] = SmartMovingContext.Options.keyBindSprint;
                    }
                    --n2;
                } else {
                    current[n2] = binding;
                }
                ++i2;
                ++n2;
            }
            if (addRenderer) {
                SmartMovingContext.registerAnimation(null);
            }
            wasInitialized = true;
        }
        SmartMovingContext.TranslateIfNecessary(gameSettings);
        String message = Info.getModComMessage();
        System.out.println(message);
        if (logger != null) {
            logger.fine(message);
        }
    }

    public static void TranslateIfNecessary(any gameSettings) {
        Properties translateTable = (Properties)Reflect.GetField(ak.class, ak.a(), "translateTable", "b");
        if (lastTranslateTable == translateTable) {
            return;
        }
        SmartMovingContext.loadLanguage("en_US", translateTable);
        String language = ak.a().c();
        if (language != null) {
            SmartMovingContext.loadLanguage(language, translateTable);
        }
        if (gameSettings == null) {
            gameSettings = SmartMovingContext.GetMinecraft().y;
        }
        if (!((Boolean)SmartMovingContext.Options._sneak.value).booleanValue()) {
            translateTable.setProperty(gameSettings.E.c, translateTable.getProperty("key.hold"));
        }
        lastTranslateTable = translateTable;
    }

    private static void loadLanguage(String language, Properties properties) {
        try {
            InputStream inputStream = ak.class.getResourceAsStream("/lang/move/" + language + ".lang");
            if (inputStream == null) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String line = bufferedreader.readLine();
            while (line != null) {
                String[] pair;
                if (!(line = line.trim()).startsWith("#") && (pair = line.split("=")) != null && pair.length == 2) {
                    properties.setProperty(pair[0], pair[1]);
                }
                line = bufferedreader.readLine();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static boolean registerAnimation(Map map) {
        if (map == null && avx.a != null) {
            map = (Map)Reflect.GetField(avx.class, avx.a, "entityRenderMap", "o");
        }
        if (map == null) {
            return false;
        }
        RenderPlayer renderPlayer = new RenderPlayer();
        map.put(aup.class, renderPlayer);
        map.put(auq.class, renderPlayer);
        ((avy)renderPlayer).a(avx.a);
        return true;
    }

    static {
        theMinecraft = Reflect.GetField(Minecraft.class, "theMinecraft", "P");
    }
}

