/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.move.IEntityPlayerSP;
import net.minecraft.move.Orientation;
import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.config.SmartMovingOptions;

public abstract class SmartMovingBase
extends SmartMovingContext {
    public final of sp;
    public final aup esp;
    public final IEntityPlayerSP isp;

    public SmartMovingBase(of sp2, IEntityPlayerSP isp) {
        this.sp = sp2;
        this.isp = isp;
        if (sp2 instanceof aup) {
            this.esp = (aup)sp2;
            if (SmartMovingBase.GetMinecraft().g == null) {
                Options.initializeForGame();
                Config = Options;
            }
        } else {
            this.esp = null;
        }
    }

    protected void moveFlying(float moveUpward, float moveStrafing, float moveForward, float speedFactor) {
        float diffMotionXStrafing = 0.0f;
        float diffMotionXForward = 0.0f;
        float diffMotionZStrafing = 0.0f;
        float diffMotionZForward = 0.0f;
        float total = ig.c(moveStrafing * moveStrafing + moveForward * moveForward);
        if (total >= 0.01f) {
            if (total < 1.0f) {
                total = 1.0f;
            }
            float moveStrafingFactor = moveStrafing / total;
            float moveForwardFactor = moveForward / total;
            float sin = ig.a(this.sp.z * 3.141593f / 180.0f);
            float cos = ig.b(this.sp.z * 3.141593f / 180.0f);
            diffMotionXStrafing = moveStrafingFactor * cos;
            diffMotionXForward = -moveForwardFactor * sin;
            diffMotionZStrafing = moveStrafingFactor * sin;
            diffMotionZForward = moveForwardFactor * cos;
        }
        float rotation = this.sp.A / 57.295776f;
        float divingHorizontalFactor = ig.b(rotation);
        float divingVerticalFactor = -ig.a(rotation) * Math.signum(moveForward);
        float diffMotionX = diffMotionXForward * divingHorizontalFactor + diffMotionXStrafing;
        float diffMotionY = ig.c(diffMotionXForward * diffMotionXForward + diffMotionZForward * diffMotionZForward) * divingVerticalFactor + moveUpward;
        float diffMotionZ = diffMotionZForward * divingHorizontalFactor + diffMotionZStrafing;
        float total2 = ig.c(ig.c(diffMotionX * diffMotionX + diffMotionZ * diffMotionZ) + diffMotionY * diffMotionY);
        if (total2 > 0.01f) {
            float factor = speedFactor / total2;
            this.sp.w += (double)(diffMotionX * factor);
            this.sp.x += (double)(diffMotionY * factor);
            this.sp.y += (double)(diffMotionZ * factor);
        }
    }

    protected int supportsCeilingClimbing(int i2, int j2, int k2) {
        String blockName;
        aif block;
        int blockId = this.sp.p.a(i2, j2, k2);
        if (blockId <= 0) {
            return -1;
        }
        Dictionary configuration = (Dictionary)SmartMovingBase.Config._ceilingClimbConfigurationObject.value;
        Set metaDatas = (Set)configuration.get(blockId);
        if (metaDatas == null && blockId >= 0 && (block = aif.m[blockId]) != null && (blockName = block.a()) != null && !blockName.isEmpty() && (metaDatas = (Set)configuration.get(blockName)) == null && blockName.startsWith("tile.") && blockName.length() > 5) {
            metaDatas = (Set)configuration.get(blockName.substring(5));
        }
        if (metaDatas == null) {
            return -1;
        }
        if (metaDatas.isEmpty()) {
            return blockId;
        }
        if (metaDatas.contains(this.sp.p.g(i2, j2, k2))) {
            return blockId;
        }
        return -1;
    }

    protected boolean isLava(int blockId) {
        if (blockId == aif.D.ca || blockId == aif.C.ca) {
            return true;
        }
        aif block = blockId > 0 ? aif.m[blockId] : null;
        return block != null && block.cp == acn.h;
    }

    protected float getLiquidBorder(int i2, int j2, int k2) {
        int blockId = this.sp.p.a(i2, j2, k2);
        if (blockId == aif.B.ca || blockId == aif.A.ca) {
            return this.getNormalWaterBorder(i2, j2, k2);
        }
        if (SmartMovingOptions.hasFiniteLiquid) {
            float f2;
            float finiteLiquidBorder = this.getFiniteLiquidWaterBorder(i2, j2, k2, blockId);
            if (f2 > 0.0f) {
                return finiteLiquidBorder;
            }
        }
        if (blockId == aif.D.ca || blockId == aif.C.ca) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? this.getNormalWaterBorder(i2, j2, k2) : 0.0f;
        }
        acn material = this.sp.p.f(i2, j2, k2);
        if (material == null || material == acn.h) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? 1.0f : 0.0f;
        }
        if (material == acn.g) {
            return this.getNormalWaterBorder(i2, j2, k2);
        }
        if (material.d()) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected float getNormalWaterBorder(int i2, int j2, int k2) {
        int blockMetaData = this.sp.p.g(i2, j2, k2);
        if (blockMetaData >= 8) {
            return 1.0f;
        }
        if (blockMetaData == 0) {
            if (this.sp.p.c(i2, j2 + 1, k2)) {
                return 0.8875f;
            }
            return 1.0f;
        }
        return (float)(8 - blockMetaData) / 8.0f;
    }

    protected float getFiniteLiquidWaterBorder(int i2, int j2, int k2, int blockId) {
        int type = Orientation.getFiniteLiquidWater(blockId);
        if (type > 0) {
            if (type == 2) {
                return 1.0f;
            }
            if (type == 1) {
                int aboveBlockId = this.sp.p.a(i2, j2 + 1, k2);
                if (Orientation.getFiniteLiquidWater(aboveBlockId) > 0) {
                    return 1.0f;
                }
                return (float)(this.sp.p.g(i2, j2, k2) + 1) / 16.0f;
            }
        }
        return 0.0f;
    }

    public boolean isFacedToLadder(boolean isSmall) {
        return this.getOnLadder(1, true, isSmall) > 0;
    }

    public boolean isFacedToSolidVine(boolean isSmall) {
        return this.getOnVine(1, true, isSmall) > 0;
    }

    public boolean isOnLadderOrVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, isSmall) > 0;
    }

    public boolean isOnVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, false, true, isSmall) > 0;
    }

    public boolean isOnLadder(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, true, false, isSmall) > 0;
    }

    protected int getOnLadder(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, false, isSmall);
    }

    protected int getOnVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, false, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean ladder, boolean vine, boolean isSmall) {
        int i2 = ig.c(this.sp.t);
        int minj = ig.c(this.sp.D.b);
        int k2 = ig.c(this.sp.v);
        if (Config.isStandardBaseClimb()) {
            int blockId = this.sp.p.a(i2, minj, k2);
            if (ladder) {
                if (vine) {
                    return Orientation.isClimbable(this.sp.p, i2, minj, k2) ? 1 : 0;
                }
                return blockId != aif.bu.ca && Orientation.isClimbable(this.sp.p, i2, minj, k2) ? 1 : 0;
            }
            if (vine) {
                return blockId == aif.bu.ca && Orientation.isClimbable(this.sp.p, i2, minj, k2) ? 1 : 0;
            }
            return 0;
        }
        if (isSmall) {
            --minj;
        }
        HashSet facedOnlyTo = null;
        if (faceOnly) {
            facedOnlyTo = Orientation.getClimbingOrientations(this.sp, true, false);
        }
        int result = 0;
        int maxj = ig.c(this.sp.D.b + Math.ceil(this.sp.D.e - this.sp.D.b)) - 1;
        for (int j2 = minj; j2 <= maxj; ++j2) {
            int blockId = this.sp.p.a(i2, j2, k2);
            if (ladder && Orientation.isLadder(blockId) && (facedOnlyTo == null || facedOnlyTo.contains(Orientation.getLadderOrientation(this.sp.p, i2, j2, k2)))) {
                ++result;
            }
            if (vine && Orientation.isVine(blockId)) {
                if (facedOnlyTo == null) {
                    ++result;
                } else {
                    for (Orientation climbOrientation : facedOnlyTo) {
                        if (!climbOrientation.hasVineOrientation(this.sp.p, i2, j2, k2) || !climbOrientation.isRemoteSolid(this.sp.p, i2, j2, k2)) continue;
                        ++result;
                        break;
                    }
                }
            }
            if (result < maxResult) continue;
            return result;
        }
        return result;
    }

    public boolean climbingUpIsBlockedByLadder() {
        int k2;
        int j2;
        int i2;
        Orientation orientation;
        if (this.sp.F && this.sp.G && !this.sp.E && this.esp.b.b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && Orientation.isLadder(this.sp.p.a(i2 = ig.c(this.sp.t), j2 = ig.c(this.sp.D.e), k2 = ig.c(this.sp.v)))) {
            return Orientation.getLadderOrientation(this.sp.p, i2, j2, k2) == orientation;
        }
        return false;
    }

    public boolean climbingUpIsBlockedByTrapDoor() {
        int k2;
        int j2;
        int i2;
        Orientation orientation;
        if (this.sp.F && this.sp.G && !this.sp.E && this.esp.b.b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && this.sp.p.a(i2 = ig.c(this.sp.t), j2 = ig.c(this.sp.D.e), k2 = ig.c(this.sp.v)) == aif.bk.ca) {
            return Orientation.getOpenTrapDoorOrientation(this.sp.p, i2, j2, k2) == orientation;
        }
        return false;
    }

    private List getPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        double minY = this.sp.D.b;
        double maxY = this.sp.D.e;
        this.sp.D.b = yMin;
        this.sp.D.e = yMax;
        List result = this.sp.p.a((jm)this.sp, horizontalTolerance == 0.0 ? this.sp.D : this.sp.D.e(-horizontalTolerance, 0.0, -horizontalTolerance));
        this.sp.D.b = minY;
        this.sp.D.e = maxY;
        return result;
    }

    protected boolean isPlayerInSolidBetween(double yMin, double yMax) {
        return this.getPlayerSolidBetween(yMin, yMax, 0.0).size() > 0;
    }

    protected double getMaxPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMin;
        for (int i2 = 0; i2 < solids.size(); ++i2) {
            ajm box = (ajm)solids.get(i2);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.max(result, box.e);
        }
        return Math.min(result, yMax);
    }

    protected double getMinPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMax;
        for (int i2 = 0; i2 < solids.size(); ++i2) {
            ajm box = (ajm)solids.get(i2);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.min(result, box.b);
        }
        return Math.max(result, yMin);
    }

    protected boolean isInLiquid() {
        return this.getMaxPlayerLiquidBetween(this.sp.D.b, this.sp.D.e) != this.sp.D.b || this.getMinPlayerLiquidBetween(this.sp.D.b, this.sp.D.e) != this.sp.D.e;
    }

    protected double getMaxPlayerLiquidBetween(double yMin, double yMax) {
        int i2 = ig.c(this.sp.t);
        int jMin = ig.c(yMin);
        int jMax = ig.c(yMax);
        int k2 = ig.c(this.sp.v);
        for (int j2 = jMax; j2 >= jMin; --j2) {
            float swimWaterBorder = this.getLiquidBorder(i2, j2, k2);
            if (!(swimWaterBorder > 0.0f)) continue;
            return (float)j2 + swimWaterBorder;
        }
        return yMin;
    }

    protected double getMinPlayerLiquidBetween(double yMin, double yMax) {
        int i2 = ig.c(this.sp.t);
        int jMin = ig.c(yMin);
        int jMax = ig.c(yMax);
        int k2 = ig.c(this.sp.v);
        for (int j2 = jMin; j2 <= jMax; ++j2) {
            float swimWaterBorder = this.getLiquidBorder(i2, j2, k2);
            if (!(swimWaterBorder > 0.0f)) continue;
            if ((double)j2 > yMin) {
                return j2;
            }
            if (!((double)((float)j2 + swimWaterBorder) > yMin)) continue;
            return yMin;
        }
        return yMax;
    }

    public boolean isCollided(ajm box, double yMin, double yMax, double horizontalTolerance) {
        return box.d >= this.sp.D.a - horizontalTolerance && box.a <= this.sp.D.d + horizontalTolerance && box.e >= yMin && box.b <= yMax && box.f >= this.sp.D.c - horizontalTolerance && box.c <= this.sp.D.f + horizontalTolerance;
    }

    private boolean isBlockTranslucent(int i2, int j2, int k2) {
        return this.sp.p.s(i2, j2, k2);
    }

    public boolean pushOutOfBlocks(double d2, double d1, double d22, boolean top) {
        int i2 = ig.c(d2);
        int j2 = ig.c(d1);
        int k2 = ig.c(d22);
        double d3 = d2 - (double)i2;
        double d4 = d22 - (double)k2;
        if (this.isBlockTranslucent(i2, j2, k2) || top && this.isBlockTranslucent(i2, j2 + 1, k2)) {
            boolean flag = !this.isBlockTranslucent(i2 - 1, j2, k2) && (!top || !this.isBlockTranslucent(i2 - 1, j2 + 1, k2));
            boolean flag1 = !this.isBlockTranslucent(i2 + 1, j2, k2) && (!top || !this.isBlockTranslucent(i2 + 1, j2 + 1, k2));
            boolean flag2 = !this.isBlockTranslucent(i2, j2, k2 - 1) && (!top || !this.isBlockTranslucent(i2, j2 + 1, k2 - 1));
            boolean flag3 = !this.isBlockTranslucent(i2, j2, k2 + 1) && (!top || !this.isBlockTranslucent(i2, j2 + 1, k2 + 1));
            int byte0 = -1;
            double d5 = 9999.0;
            if (flag && d3 < d5) {
                d5 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d5) {
                d5 = d4;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d4 < d5) {
                byte0 = 5;
            }
            float f2 = 0.1f;
            if (byte0 == 0) {
                this.sp.w = -f2;
            }
            if (byte0 == 1) {
                this.sp.w = f2;
            }
            if (byte0 == 4) {
                this.sp.y = -f2;
            }
            if (byte0 == 5) {
                this.sp.y = f2;
            }
        }
        return false;
    }

    public boolean isInsideOfMaterial(acn material) {
        if (SmartMovingOptions.hasFiniteLiquid && material == acn.g) {
            int k2;
            int j2;
            double d2 = this.sp.u + (double)this.sp.e();
            int i2 = ig.c(this.sp.t);
            int l2 = this.sp.p.a(i2, j2 = ig.d(ig.c(d2)), k2 = ig.c(this.sp.v));
            if (l2 != 0) {
                float f2;
                float border = this.getFiniteLiquidWaterBorder(i2, j2, k2, l2);
                if (f2 > 0.0f) {
                    float f3 = 1.0f - border - 0.1111111f;
                    float f1 = (float)(j2 + 1) - f3;
                    return d2 < (double)f1;
                }
            }
            return false;
        }
        return this.isp.localIsInsideOfMaterial(material);
    }

    public void correctOnUpdate(boolean isSmall, boolean reverseMaterialAcceleration) {
        double d2 = this.sp.t - this.sp.q;
        double d1 = this.sp.v - this.sp.s;
        float f2 = ig.a(d2 * d2 + d1 * d1);
        if (f2 < 0.05f && (double)f2 > 0.02 && isSmall) {
            boolean flag;
            float f5;
            float f4;
            float f1 = this.sp.aq;
            float f22 = 0.0f;
            f22 = f2 * 3.0f;
            f1 = (float)Math.atan2(d1, d2) * 180.0f / 3.141593f - 90.0f;
            if (this.sp.aJ > 0.0f) {
                f1 = this.sp.z;
            }
            for (f4 = f1 - this.sp.aq; f4 < -180.0f; f4 += 360.0f) {
            }
            while (f4 >= 180.0f) {
                f4 -= 360.0f;
            }
            float x2 = this.sp.aq + f4 * 0.3f;
            for (f5 = this.sp.z - x2; f5 < -180.0f; f5 += 360.0f) {
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            boolean bl2 = flag = f5 < -90.0f || f5 >= 90.0f;
            if (f5 < -75.0f) {
                f5 = -75.0f;
            }
            if (f5 >= 75.0f) {
                f5 = 75.0f;
            }
            this.sp.aq = this.sp.z - f5;
            if (f5 * f5 > 2500.0f) {
                this.sp.aq += f5 * 0.2f;
            }
            if (flag) {
                f22 *= -1.0f;
            }
            while (this.sp.aq - this.sp.ar < -180.0f) {
                this.sp.ar -= 360.0f;
            }
            while (this.sp.aq - this.sp.ar >= 180.0f) {
                this.sp.ar += 360.0f;
            }
        }
        if (reverseMaterialAcceleration) {
            this.reverseHandleMaterialAcceleration();
        }
    }

    protected double getGapUnderneight() {
        return this.sp.D.b - this.getMaxPlayerSolidBetween(this.sp.D.b - 1.1, this.sp.D.b, 0.0);
    }

    protected double getGapOverneight() {
        return this.getMinPlayerSolidBetween(this.sp.D.e, this.sp.D.e + 1.1, 0.0) - this.sp.D.e;
    }

    public double getOverGroundHeight(double maximum) {
        if (this.esp != null) {
            return this.sp.D.b - this.getMaxPlayerSolidBetween(this.sp.D.b - maximum, this.sp.D.b, 0.0);
        }
        return this.sp.D.b + 1.0 - this.getMaxPlayerSolidBetween(this.sp.D.b - maximum + 1.0, this.sp.D.b + 1.0, 0.1);
    }

    public int getOverGroundBlockId(double distance) {
        int x2 = ig.c(this.sp.t);
        int y2 = ig.c(this.sp.D.b);
        int z = ig.c(this.sp.v);
        int minY = y2 - (int)Math.ceil(distance);
        if (this.esp == null) {
            ++y2;
            ++minY;
        }
        while (y2 >= minY) {
            int id = this.sp.p.a(x2, y2, z);
            if (id > 0) {
                return id;
            }
            --y2;
        }
        return -1;
    }

    public void reverseHandleMaterialAcceleration() {
        int j1;
        ajm axisalignedbb = this.sp.D.b(0.0, -0.4f, 0.0).e(0.001, 0.001, 0.001);
        acn material = acn.g;
        of entity = this.sp;
        int i2 = ig.c(axisalignedbb.a);
        int j2 = ig.c(axisalignedbb.d + 1.0);
        int k2 = ig.c(axisalignedbb.b);
        int l2 = ig.c(axisalignedbb.e + 1.0);
        int i1 = ig.c(axisalignedbb.c);
        if (!entity.p.c(i2, k2, i1, j2, l2, j1 = ig.c(axisalignedbb.f + 1.0))) {
            return;
        }
        ajr vec3d = ajr.a(0.0, 0.0, 0.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    double d1;
                    aif block = aif.m[entity.p.a(k1, l1, i22)];
                    if (block == null || block.cp != material || !((double)l2 >= (d1 = (double)((float)(l1 + 1) - agn.d(entity.p.g(k1, l1, i22)))))) continue;
                    block.a(entity.p, k1, l1, i22, (jm)entity, vec3d);
                }
            }
        }
        if (vec3d.c() > 0.0) {
            vec3d = vec3d.b();
            double d2 = -0.014;
            entity.w += vec3d.a * d2;
            entity.x += vec3d.b * d2;
            entity.y += vec3d.c * d2;
        }
    }
}

