/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.move.IEntityPlayerSP;
import net.minecraft.move.SmartMovingBase;
import net.minecraft.move.render.RendererData;

public abstract class SmartMoving
extends SmartMovingBase {
    public boolean isSlow;
    public boolean isFast;
    public boolean isClimbing;
    public boolean isHandsVineClimbing;
    public boolean isFeetVineClimbing;
    public boolean isClimbJumping;
    public boolean isClimbBackJumping;
    public boolean isClimbCrawling;
    public boolean isCrawlClimbing;
    public boolean isCeilingClimbing;
    public boolean isDipping;
    public boolean isSwimming;
    public boolean isDiving;
    public boolean isLevitating;
    public boolean isHeadJumping;
    public boolean isCrawling;
    public boolean isSliding;
    public boolean isFlying;
    public int actualHandsClimbType;
    public int actualFeetClimbType;
    public int angleJumpType;
    public float heightOffset;
    public float field_705_Q_vertical;
    public float field_704_R_vertical;
    public float field_703_S_vertical;
    public float field_705_Q_all;
    public float field_704_R_all;
    public float field_703_S_all;
    protected float tickDistance;
    private float spawnSlindingParticle;
    private float spawnSwimmingParticle;
    private float distanceSwom;
    public final RendererData prevOuterRenderData = new RendererData();

    public SmartMoving(of sp2, IEntityPlayerSP isp) {
        super(sp2, isp);
    }

    public boolean isAngleJumping() {
        return this.angleJumpType > 1 && this.angleJumpType < 7;
    }

    public abstract boolean isJumping();

    public abstract boolean doFlyingAnimation();

    public abstract boolean doFallingAnimation();

    protected void calculateAllStats(boolean doOriginal) {
        double diffX = this.sp.t - this.sp.q;
        double diffY = this.sp.u - this.sp.r;
        double diffZ = this.sp.v - this.sp.s;
        if (doOriginal) {
            this.calculateHorizontalStats(diffX, diffZ);
        }
        this.calculateVerticalStats(diffY);
        this.calculateStats(diffX, diffY, diffZ);
    }

    private void calculateHorizontalStats(double diffX, double diffY) {
        this.sp.aY = this.sp.aZ;
        float total = ig.a(diffX * diffX + diffY * diffY) * 4.0f;
        this.sp.aZ += (total - this.sp.aZ) * 0.4f;
        this.sp.ba += this.sp.aZ;
    }

    private void calculateVerticalStats(double diffZ) {
        this.field_705_Q_vertical = this.field_704_R_vertical;
        float total = (float)Math.abs(diffZ) * 4.0f;
        this.field_704_R_vertical += (total - this.field_704_R_vertical) * 0.4f;
        this.field_703_S_vertical += this.field_704_R_vertical;
    }

    private void calculateStats(double diffX, double diffY, double diffZ) {
        this.field_705_Q_all = this.field_704_R_all;
        this.tickDistance = ig.a(diffX * diffX + diffY * diffY + diffZ * diffZ) * 4.0f;
        this.field_704_R_all += (this.tickDistance - this.field_704_R_all) * 0.4f;
        this.field_703_S_all += this.field_704_R_all;
    }

    protected void spawnParticles(Minecraft minecraft, double playerMotionX, double playerMotionZ) {
        int k2;
        int j2;
        int i2;
        int blockId;
        float horizontalSpeedSquare = 0.0f;
        if (this.isSliding || this.isSwimming) {
            horizontalSpeedSquare = (float)(playerMotionX * playerMotionX + playerMotionZ * playerMotionZ);
        }
        if (this.isSliding && (blockId = this.sp.p.a(i2 = ig.c(this.sp.t), j2 = ig.c(this.sp.D.b - (double)0.1f), k2 = ig.c(this.sp.v))) > 0) {
            double posY = this.sp.D.b + 0.1;
            double motionX = -playerMotionX * 4.0;
            double motionY = 1.5;
            double motionZ = -playerMotionZ * 4.0;
            this.spawnSlindingParticle += horizontalSpeedSquare;
            float maxSpawnSlindingParticle = ((Float)SmartMoving.Config._slideParticlePeriodFactor.value).floatValue() * 0.1f;
            while (this.spawnSlindingParticle > maxSpawnSlindingParticle) {
                double posX = this.sp.t + (double)this.getSpawnOffset();
                double posZ = this.sp.v + (double)this.getSpawnOffset();
                this.sp.p.a("tilecrack_" + blockId, posX, posY, posZ, motionX, motionY, motionZ);
                this.spawnSlindingParticle -= maxSpawnSlindingParticle;
            }
        }
        if (this.isSwimming) {
            int k3;
            int j3;
            float posY = (float)ig.c(this.sp.D.b) + 1.0f;
            int i3 = (int)Math.floor(this.sp.t);
            int blockId2 = this.sp.p.a(i3, j3 = (int)Math.floor((double)posY - 0.5), k3 = (int)Math.floor(this.sp.v));
            aif block = blockId2 > 0 ? aif.m[blockId2] : null;
            boolean isLava = block != null && this.isLava(block.ca);
            this.spawnSwimmingParticle += horizontalSpeedSquare;
            float maxSpawnSwimmingParticle = (isLava ? (Float)SmartMoving.Config._lavaSwimParticlePeriodFactor.value : (Float)SmartMoving.Config._swimParticlePeriodFactor.value).floatValue() * 0.01f;
            while (this.spawnSwimmingParticle > maxSpawnSwimmingParticle) {
                double posX = this.sp.t + (double)this.getSpawnOffset();
                double posZ = this.sp.v + (double)this.getSpawnOffset();
                atz splash = isLava ? new atx(this.sp.p, posX, posY, posZ) : new auh(this.sp.p, posX, posY, posZ, 0.0, 0.0, 0.0);
                splash.w = 0.0;
                splash.x = 0.2;
                splash.y = 0.0;
                minecraft.i.a(splash);
                this.spawnSwimmingParticle -= maxSpawnSwimmingParticle;
            }
        }
    }

    private float getSpawnOffset() {
        return (this.sp.au().nextFloat() - 0.5f) * 2.0f * this.sp.N;
    }

    protected void onStartClimbBackJump() {
        this.prevOuterRenderData.rotateAngleY = this.prevOuterRenderData.rotateAngleY + (this.isHeadJumping ? (float)Math.PI : 1.5707964f);
        this.isClimbBackJumping = true;
    }

    protected void playSounds(double distance) {
        if (this.isSwimming) {
            this.distanceSwom = (float)((double)this.distanceSwom + distance);
            if (this.distanceSwom > 1.4285715f) {
                Random rand = this.sp.au();
                this.sp.p.a((jm)this.sp, "random.splash", 0.05f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
                this.distanceSwom -= 1.4285715f;
            }
        }
    }
}

