/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Reflect {
    public static Object NewInstance(Class base, String name, String obfuscatedName) {
        try {
            return Reflect.LoadClass(base, name, obfuscatedName, true).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new RuntimeException(name, e2);
        }
    }

    public static boolean CheckClasses(Class base, String[] names, String[] obfuscatedNames) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (Reflect.LoadClass(base, names[i2], obfuscatedNames != null && obfuscatedNames.length > i2 ? obfuscatedNames[i2] : null, false) != null) continue;
            return false;
        }
        return true;
    }

    public static Class LoadClass(Class base, String name, String obfuscatedName, boolean throwException) {
        ClassLoader loader = base.getClassLoader();
        if (obfuscatedName != null) {
            try {
                return loader.loadClass(obfuscatedName);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (throwException) {
                throw new RuntimeException(cnfe);
            }
            return null;
        }
    }

    public static void copyFields(Class type, Object source, Object target) {
        Field[] fields = type.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field field = fields[i2];
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            Reflect.SetField(field, target, Reflect.GetField(field, source));
        }
    }

    public static void SetField(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Object GetField(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void SetField(Class theClass, Object object, String name, String obfuscatedName, Object value) {
        try {
            Reflect.GetField(theClass, name, obfuscatedName).set(object, value);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Object GetField(Class theClass, Object object, String name, String obfuscatedName) {
        try {
            return Reflect.GetField(theClass, name, obfuscatedName).get(object);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Field GetField(Class theClass, String name, String obfuscatedName) {
        return Reflect.GetField(theClass, name, obfuscatedName, true);
    }

    public static Field GetField(Class theClass, String name, String obfuscatedName, boolean throwException) {
        Field field;
        block2: {
            field = null;
            try {
                field = Reflect.GetRawField(theClass, name, obfuscatedName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException oe2) {
                if (!throwException) break block2;
                throw new RuntimeException(Reflect.GetFieldMessage(theClass, name, obfuscatedName), oe2);
            }
        }
        return field;
    }

    private static String GetFieldMessage(Class theClass, String name, String obfuscatedName) {
        Field[] fields = theClass.getDeclaredFields();
        StringBuffer message = Reflect.GetMessage(theClass, name, obfuscatedName, "field", "type");
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Reflect.AppendElement(message, fields[i2].getName(), fields[i2].getType());
        }
        return message.toString();
    }

    private static Field GetRawField(Class theClass, String name, String obfuscatedName) throws NoSuchFieldException {
        if (obfuscatedName != null) {
            try {
                return theClass.getDeclaredField(obfuscatedName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return theClass.getDeclaredField(name);
    }

    public static Method GetMethod(Class theClass, String name, String obfuscatedName, Class ... paramArrayOfClass) {
        return Reflect.GetMethod(theClass, name, obfuscatedName, true, paramArrayOfClass);
    }

    public static Method GetMethod(Class theClass, String name, String obfuscatedName, boolean throwException, Class ... paramArrayOfClass) {
        Method method;
        block2: {
            method = null;
            try {
                method = Reflect.GetRawMethod(theClass, name, obfuscatedName, paramArrayOfClass);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException oe2) {
                if (!throwException) break block2;
                throw new RuntimeException(Reflect.GetMethodMessage(theClass, name, obfuscatedName), oe2);
            }
        }
        return method;
    }

    private static String GetMethodMessage(Class theClass, String name, String obfuscatedName) {
        Method[] methods = theClass.getDeclaredMethods();
        StringBuffer message = Reflect.GetMessage(theClass, name, obfuscatedName, "method", "return type");
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Reflect.AppendElement(message, methods[i2].getName(), methods[i2].getReturnType());
        }
        return message.toString();
    }

    private static Method GetRawMethod(Class theClass, String name, String obfuscatedName, Class ... paramArrayOfClass) throws NoSuchMethodException {
        if (obfuscatedName != null) {
            try {
                return theClass.getDeclaredMethod(obfuscatedName, paramArrayOfClass);
            }
            catch (NoSuchMethodException oe2) {
                // empty catch block
            }
        }
        return theClass.getDeclaredMethod(name, paramArrayOfClass);
    }

    public static Object Invoke(Method method, Object paramObject, Object ... paramArrayOfObject) {
        try {
            return method.invoke(paramObject, paramArrayOfObject);
        }
        catch (Exception e2) {
            throw new RuntimeException(method.getName(), e2);
        }
    }

    private static StringBuffer GetMessage(Class theClass, String name, String obfuscatedName, String elementName, String typeName) {
        StringBuffer message = new StringBuffer().append("Can not find ").append(elementName).append(" \"").append(name).append("\"");
        if (obfuscatedName != null) {
            message.append(" (ofuscated \"").append(obfuscatedName).append("\")");
        }
        message.append(" in class \"").append(theClass.getName()).append("\".\nExisting ").append(elementName).append("s (<name>, <").append(typeName).append(">) are:");
        return message;
    }

    private static StringBuffer AppendElement(StringBuffer message, String name, Class type) {
        return message.append("\n\t\t(").append(name).append(", ").append(type.getName()).append(")");
    }
}

