/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.lang.reflect.Method;
import java.util.HashSet;
import net.minecraft.move.ClimbGap;
import net.minecraft.move.FeetClimbing;
import net.minecraft.move.HandsClimbing;
import net.minecraft.move.Reflect;
import net.minecraft.move.SmartMovingContext;
import net.minecraft.move.config.SmartMovingOptions;

public class Orientation
extends SmartMovingContext {
    public static final Orientation ZZ = new Orientation(0, 0);
    public static final Orientation PZ = new Orientation(1, 0);
    public static final Orientation ZP = new Orientation(0, 1);
    public static final Orientation NZ = new Orientation(-1, 0);
    public static final Orientation ZN = new Orientation(0, -1);
    public static final Orientation PP = new Orientation(1, 1);
    public static final Orientation NN = new Orientation(-1, -1);
    public static final Orientation PN = new Orientation(1, -1);
    public static final Orientation NP = new Orientation(-1, 1);
    public static final int DefaultMeta = -1;
    public static final int VineFrontMeta = 0;
    public static final int VineSideMeta = 1;
    private static final int top = 2;
    private static final int middle = 1;
    private static final int base = 0;
    private static final int sub = -1;
    private static final int subSub = -2;
    private static final int NoGrab = 0;
    private static final int HalfGrab = 1;
    private static final int AroundGrab = 2;
    protected int _i;
    protected int _k;
    private boolean _isDiagonal;
    private float _directionAngle;
    private float _mimimumClimbingAngle;
    private float _maximumClimbingAngle;
    private static HashSet _getClimbingOrientationsHashSet = null;
    private static final float _handClimbingHoldGap = Math.min(0.25f, 0.06f * Math.max(((Float)Orientation.Config._freeClimbingUpSpeedFactor.value).floatValue(), ((Float)Orientation.Config._freeClimbingDownSpeedFactor.value).floatValue()));
    private static ClimbGap _climbGapTemp = new ClimbGap();
    private static ClimbGap _climbGapOuterTemp = new ClimbGap();
    private static uo world;
    private static double base_jhd;
    private static double jh_offset;
    private static int all_j;
    private static int all_offset;
    private static int base_i;
    private static int base_k;
    private static double base_id;
    private static double base_kd;
    private static int remote_i;
    private static int remote_k;
    private static boolean crawl;
    private static int local_halfOffset;
    private static int local_half;
    private static int local_offset;
    private static boolean grabRemote;
    private static int grabType;
    private static int grabBlockId;
    private static int grabMeta;
    private static final Method _isLadder;
    private static final Method _canConnectFenceTo;

    private Orientation(int i2, int k2) {
        this._i = i2;
        this._k = k2;
        this._isDiagonal = this._i != 0 && this._k != 0;
        this.setClimbingAngles();
    }

    private Orientation rotate(int angle) {
        switch (angle) {
            case 45: {
                if (this == PZ) {
                    return PP;
                }
                if (this == PP) {
                    return ZP;
                }
                if (this == ZP) {
                    return NP;
                }
                if (this == NP) {
                    return NZ;
                }
                if (this == NZ) {
                    return NN;
                }
                if (this == NN) {
                    return ZN;
                }
                if (this == ZN) {
                    return PN;
                }
                if (this == PN) {
                    return PZ;
                }
                return null;
            }
            case -45: {
                if (this == PZ) {
                    return PN;
                }
                if (this == PN) {
                    return ZN;
                }
                if (this == ZN) {
                    return NN;
                }
                if (this == NN) {
                    return NZ;
                }
                if (this == NZ) {
                    return NP;
                }
                if (this == NP) {
                    return ZP;
                }
                if (this == ZP) {
                    return PP;
                }
                if (this == PP) {
                    return PZ;
                }
                return null;
            }
            case 90: {
                return this.rotate(45).rotate(45);
            }
            case -90: {
                return this.rotate(-45).rotate(-45);
            }
            case 135: {
                return this.rotate(180).rotate(-45);
            }
            case -135: {
                return this.rotate(-180).rotate(45);
            }
            case -180: 
            case 180: {
                if (this == PZ) {
                    return NZ;
                }
                if (this == PN) {
                    return NP;
                }
                if (this == ZN) {
                    return ZP;
                }
                if (this == NN) {
                    return PP;
                }
                if (this == NZ) {
                    return PZ;
                }
                if (this == NP) {
                    return PN;
                }
                if (this == ZP) {
                    return ZN;
                }
                if (this != PP) break;
                return NN;
            }
        }
        throw new RuntimeException("angle not supported");
    }

    public static Orientation getOrientation(of p2, float tolerance, boolean orthogonals, boolean diagonals) {
        float maximumRotation;
        float minimumRotation;
        float rotation = p2.z % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if ((minimumRotation = rotation - tolerance) < 0.0f) {
            minimumRotation += 360.0f;
        }
        if ((maximumRotation = rotation + tolerance) >= 360.0f) {
            maximumRotation -= 360.0f;
        }
        if (orthogonals) {
            if (NZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return NZ;
            }
            if (PZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return PZ;
            }
            if (ZN.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZN;
            }
            if (ZP.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZP;
            }
        }
        if (diagonals) {
            if (NP.isWithinAngle(minimumRotation, maximumRotation)) {
                return NP;
            }
            if (PN.isWithinAngle(minimumRotation, maximumRotation)) {
                return PN;
            }
            if (NN.isWithinAngle(minimumRotation, maximumRotation)) {
                return NN;
            }
            if (PP.isWithinAngle(minimumRotation, maximumRotation)) {
                return PP;
            }
        }
        return null;
    }

    public double getHorizontalBorderGap(jm entity) {
        return this.getHorizontalBorderGap(entity.t, entity.v);
    }

    private double getHorizontalBorderGap() {
        return this.getHorizontalBorderGap(base_id, base_kd);
    }

    private double getHorizontalBorderGap(double i2, double k2) {
        if (this == NZ) {
            return i2 % 1.0;
        }
        if (this == PZ) {
            return 1.0 - i2 % 1.0;
        }
        if (this == ZN) {
            return k2 % 1.0;
        }
        if (this == ZP) {
            return 1.0 - k2 % 1.0;
        }
        return 0.0;
    }

    public boolean isTunnelAhead(uo world, int i2, int j2, int k2) {
        acn aboveMaterial;
        int remoteId = world.a(i2 + this._i, j2 + 1, k2 + this._k);
        return Orientation.isFullEmpty(remoteId) && (aboveMaterial = world.f(i2 + this._i, j2 + 2, k2 + this._k)) != null && Orientation.isSolid(aboveMaterial);
    }

    public static HashSet getClimbingOrientations(of p2, boolean orthogonals, boolean diagonals) {
        float rotation = p2.z % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if (_getClimbingOrientationsHashSet == null) {
            _getClimbingOrientationsHashSet = new HashSet();
        } else {
            _getClimbingOrientationsHashSet.clear();
        }
        if (orthogonals) {
            NZ.addTo(rotation);
            PZ.addTo(rotation);
            ZN.addTo(rotation);
            ZP.addTo(rotation);
        }
        if (diagonals) {
            NP.addTo(rotation);
            PN.addTo(rotation);
            NN.addTo(rotation);
            PP.addTo(rotation);
        }
        return _getClimbingOrientationsHashSet;
    }

    private void addTo(float rotation) {
        if (this.isRotationForClimbing(rotation)) {
            _getClimbingOrientationsHashSet.add(this);
        }
    }

    public boolean isFeetLadderSubstitute(uo world, int bi2, int j2, int bk2) {
        int i2 = bi2 + this._i;
        int k2 = bk2 + this._k;
        return this.isLadderSubstitute(world, i2, j2, k2, 1) > 0 || this.isLadderSubstitute(world, i2, j2, k2, 0) > 0;
    }

    public boolean isHandsLadderSubstitute(uo world, int bi2, int j2, int bk2) {
        int i2 = bi2 + this._i;
        int k2 = bk2 + this._k;
        return this.isLadderSubstitute(world, i2, j2, k2, 1) > 0 || this.isLadderSubstitute(world, i2, j2, k2, 0) > 0 || this.isLadderSubstitute(world, i2, j2, k2, -1) > 0;
    }

    private int isLadderSubstitute(uo worldObj, int i2, int j2, int k2, int halfOffset) {
        world = worldObj;
        remote_i = i2;
        all_j = j2;
        remote_k = k2;
        all_offset = 0;
        return this.isLadderSubstitute(halfOffset, null);
    }

    public void seekClimbGap(float rotation, uo world, int i2, double id, double jhd, int k2, double kd2, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, HandsClimbing[] inout_handsClimbing, FeetClimbing[] inout_feetClimbing, ClimbGap out_handsClimbGap, ClimbGap out_feetClimbGap) {
        if (this.isRotationForClimbing(rotation)) {
            this.initialize(world, i2, id, jhd, k2, kd2);
            inout_handsClimbing[0] = inout_handsClimbing[0].max(this.handsClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_handsClimbGap, _climbGapOuterTemp);
            inout_feetClimbing[0] = inout_feetClimbing[0].max(this.feetClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_feetClimbGap, _climbGapOuterTemp);
        }
    }

    private HandsClimbing handsClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(3.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        HandsClimbing result = HandsClimbing.None;
        int gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0) {
            result = jh_offset > 1.0 - (double)_handClimbingHoldGap ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.None, out_climbGap, _climbGapTemp);
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = jh_offset < (double)_handClimbingHoldGap ? result.max(HandsClimbing.BottomHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(-1, _climbGapTemp);
        if (!(gap <= 0 || isCrawling && gap > 1)) {
            result = !isClimbCrawling && gap > 2 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (isClimbCrawling && gap > 1 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (jh_offset < (double)_handClimbingHoldGap ? (grabType == 2 ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp)) : (grabType == 2 ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp))));
        }
        if ((gap = this.isLadderSubstitute(-2, _climbGapTemp)) > 0 && !isCrawling && (gap > 2 && !isCrawlClimbing || grabType == 2 || gap > 1 && isClimbCrawling)) {
            result = jh_offset < (double)_handClimbingHoldGap && !isClimbCrawling ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : (isClimbCrawling ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp));
        }
        return result;
    }

    private FeetClimbing feetClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(0.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        FeetClimbing result = FeetClimbing.None;
        int gap = this.isLadderSubstitute(2, _climbGapTemp);
        if (gap > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0 && !isCrawling) {
            result = gap > 3 && !isClimbCrawling ? (!isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : ((isClimbCrawling || isCrawlClimbing) && gap > 1 ? (isCrawlClimbing ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp)) : (gap > 2 ? (!isClimbCrawling ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.TopWithHands, out_climbGap, _climbGapTemp)));
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = gap > 3 && !isCrawling && !isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : (gap > 2 && !isCrawling ? (!isClimbCrawling ? (jh_offset < (double)_handClimbingHoldGap ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.SlowUpWithSinkWithoutHands, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : (jh_offset < 1.0 - (double)_handClimbingHoldGap ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.BaseHold, out_climbGap, _climbGapTemp)));
        }
        if (this.isLadderSubstitute(-1, _climbGapTemp) > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        if (isCrawlClimbing || isCrawling) {
            result = result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp);
        }
        return result;
    }

    private int isLadderSubstitute(int local_Offset, ClimbGap out_climbGap) {
        int gap;
        Orientation.initializeLocal(local_Offset);
        if (local_half == 1) {
            if (this.hasHalfHold()) {
                if (!grabRemote) {
                    boolean overOverFullAccessible;
                    boolean overLadder = this.isOnLadderOrVine(0) || this.isOnOpenTrapDoor(0) || this.isRope(0) || this.isOnWallRope(0);
                    boolean overOverLadder = this.isOnLadderOrVine(1) || this.isOnOpenTrapDoor(1) || this.isRope(1) || this.isOnWallRope(1);
                    boolean overAccessible = this.isBaseAccessible(1, false, true);
                    boolean overOverAccessible = this.isBaseAccessible(2, false, true);
                    boolean overFullAccessible = overAccessible && this.isFullAccessible(1, grabRemote);
                    boolean bl2 = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(2, grabRemote);
                    gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverFullAccessible ? 5 : (crawl ? 3 : 5)) : (overOverLadder ? 5 : 1)) : 1);
                } else {
                    gap = this.isBaseAccessible(0) ? (this.isUpperHalfFrontEmpty(remote_i, 0, remote_k) ? (this.isFullAccessible(1, grabRemote) ? (this.isFullExtentAccessible(2, grabRemote) ? 5 : (this.isJustLowerHalfExtentAccessible(2) ? 4 : 3)) : 1) : 1) : 0;
                }
            } else {
                gap = 0;
            }
        } else if (this.hasBottomHold()) {
            if (!grabRemote) {
                boolean overOverFullAccessible;
                boolean overLadder = this.isOnLadderOrVine(0) || this.isOnOpenTrapDoor(0) || this.isRope(0) || this.isOnWallRope(0);
                boolean overOverLadder = this.isOnLadderOrVine(1) || this.isOnOpenTrapDoor(1) || this.isRope(1) || this.isOnWallRope(0);
                boolean overAccessible = this.isBaseAccessible(0, false, true);
                boolean overOverAccessible = this.isBaseAccessible(1, false, true);
                boolean overFullAccessible = overAccessible && this.isFullAccessible(0, grabRemote);
                boolean bl3 = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(1, grabRemote);
                gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverAccessible ? (overOverFullAccessible ? 4 : (crawl ? 2 : 4)) : 2) : (overOverLadder ? 2 : 1)) : 1);
            } else {
                gap = this.isBaseAccessible(0) ? (this.isFullAccessible(0, grabRemote) ? (this.isFullExtentAccessible(1, grabRemote) ? 4 : 2) : 1) : 0;
            }
        } else {
            gap = 0;
        }
        if (out_climbGap != null && gap > 0) {
            out_climbGap.BlockId = grabBlockId;
            out_climbGap.Meta = grabMeta;
            out_climbGap.CanStand = gap > 3;
            out_climbGap.MustCrawl = gap > 1 && gap < 4;
            out_climbGap.Direction = this;
        }
        return gap;
    }

    private boolean hasHalfHold() {
        int remoteMetadata;
        if (Config.isFreeBaseClimb() && this.isOnLadder(0) && this.isOnLadderFront(0)) {
            return this.setHalfGrabType(2, aif.aF.ca, false);
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            int id = this.getRopeId(0);
            if (id >= 0 && this.isHeadedToRope()) {
                return this.setHalfGrabType(2, id, false);
            }
            id = this.getAnchorId(0);
            if (id >= 0 && this.isOnAnchorFront(0)) {
                return this.setHalfGrabType(1, id, false);
            }
        }
        int remoteId = Orientation.getRemoteBlockId(0);
        if (this.isEmpty(base_i, 0, base_k) && remoteId == aif.bp.ca && this.headedToFrontWall(remote_i, 0, remote_k, remoteId)) {
            return this.setHalfGrabType(1, remoteId);
        }
        int wallId = Orientation.getWallBlockId(base_i, 0, base_k);
        if (wallId == aif.bp.ca && this.headedToBaseWall(0, wallId)) {
            return this.setHalfGrabType(1, wallId, false);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            int removeBelowId;
            if (Orientation.isFence(remoteId, remote_i, 0, remote_k) && this.headedToFrontWall(remote_i, 0, remote_k, remoteId)) {
                if (!Orientation.isFence(Orientation.getBaseBlockId(0), base_i, 0, base_k)) {
                    return this.setHalfGrabType(1, remoteId);
                }
                if (this.headedToFrontSideWall(remote_i, 0, remote_k, remoteId)) {
                    return this.setHalfGrabType(1, remoteId);
                }
            }
            if (Orientation.isFence(removeBelowId = Orientation.getRemoteBlockId(-1), remote_i, -1, remote_k) && this.headedToFrontWall(remote_i, -1, remote_k, removeBelowId)) {
                if (!Orientation.isFence(Orientation.getBaseBlockId(-1), remote_i, -1, remote_k)) {
                    return this.setHalfGrabType(1, remoteId);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, removeBelowId)) {
                    return this.setHalfGrabType(1, remoteId);
                }
            }
            if (Orientation.isFence(wallId, base_i, 0, base_k) && this.headedToBaseWall(0, wallId)) {
                return this.setHalfGrabType(1, wallId, false);
            }
            int belowWallId = Orientation.getWallBlockId(base_i, -1, base_k);
            if (Orientation.isFence(belowWallId, base_i, -1, base_k) && this.headedToBaseWall(-1, belowWallId)) {
                return this.setHalfGrabType(1, belowWallId, false);
            }
        }
        if (Orientation.isBottomHalfBlock(remoteId, remoteMetadata = Orientation.getRemoteBlockMetadata(0)) || Orientation.isStairCompact(remoteId) && this.isBottomStairCompactNotBack(remoteMetadata) && (!Orientation.isStairCompact(Orientation.getBaseBlockId(-1)) || !this.isBottomStairCompactFront(Orientation.getBaseBlockMetadata(-1)))) {
            return this.setHalfGrabType(1, remoteId);
        }
        if (remoteId == aif.bk.ca && Orientation.isClosedTrapDoor(Orientation.getRemoteBlockMetadata(0))) {
            return this.setHalfGrabType(1, aif.bk.ca);
        }
        int baseId = Orientation.getBaseBlockId(0);
        if (baseId == aif.bk.ca && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(0))) {
            return this.setHalfGrabType(1, aif.bk.ca, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setHalfGrabType(1, baseId, false);
            }
            if (Orientation.isASRope(remoteId) && this.rotate(180).isASGrapplingHookFront(remoteMetadata)) {
                return this.setHalfGrabType(1, remoteId, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
        }
        return this.setHalfGrabType(0, 0);
    }

    private boolean hasBottomHold() {
        int remoteMetadata;
        int belowWallBlockId;
        if (Config.isFreeBaseClimb() && (this.isOnLadder(-1) && this.isOnLadderFront(-1) || this.isOnLadder(0) && this.isOnLadderFront(0))) {
            return this.setBottomGrabType(2, aif.aF.ca, false);
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            int id = this.getRopeId(-1);
            if (id >= 0 && this.isHeadedToRope() || (id = this.getRopeId(0)) >= 0 && this.isHeadedToRope()) {
                return this.setBottomGrabType(2, id, false);
            }
            id = this.getAnchorId(-1);
            if (id >= 0 && this.isOnAnchorFront(-1) || (id = this.getAnchorId(0)) >= 0 && this.isOnAnchorFront(0)) {
                return this.setBottomGrabType(1, id, false);
            }
        }
        int remoteId = Orientation.getRemoteBlockId(0);
        int remoteBelowId = Orientation.getRemoteBlockId(-1);
        boolean remoteLowerHalfEmpty = this.isLowerHalfFrontFullEmpty(remote_i, 0, remote_k);
        if (SmartMovingOptions.hasRedPowerWire) {
            int coverSides;
            int coverSides2;
            if (Orientation.isRedPowerWire(remoteBelowId) && (this.isRedPowerWireFullFront(coverSides2 = Orientation.getRpCoverSides(remote_i, -1, remote_k)) || Orientation.isRedPowerWireTop(coverSides2)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            if (Orientation.isRedPowerWire(remoteId) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, 0, remote_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            int baseId = Orientation.getBaseBlockId(-1);
            if (Orientation.isRedPowerWire(baseId) && this.isRedPowerWireFullBack(coverSides = Orientation.getRpCoverSides(base_i, -1, base_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            if (Orientation.isRedPowerWire(remoteBelowId)) {
                return false;
            }
        }
        if (this.isEmpty(base_i, -1, base_k) && remoteBelowId == aif.bp.ca && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowId)) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            int baseBelowBlockId = Orientation.getBaseBlockId(-1);
            if (Orientation.isFence(remoteBelowId, remote_i, -1, remote_k) && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowId)) {
                if (!Orientation.isFence(baseBelowBlockId, base_i, -1, base_k)) {
                    return this.setBottomGrabType(1, remoteBelowId);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, remoteBelowId)) {
                    return this.setBottomGrabType(1, remoteBelowId);
                }
            }
        }
        if ((belowWallBlockId = Orientation.getWallBlockId(base_i, -1, base_k)) != -1) {
            if (this.isEmpty(base_i - this._i, 0, base_k - this._k) && this.isEmpty(base_i - this._i, -1, base_k - this._k)) {
                if (belowWallBlockId == aif.bp.ca && this.headedToBaseWall(-1, belowWallBlockId)) {
                    return this.setBottomGrabType(1, belowWallBlockId, false);
                }
                if (this.headedToBaseGrabWall(-1, belowWallBlockId)) {
                    return this.setBottomGrabType(1, belowWallBlockId, false);
                }
            }
            if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && Orientation.isFence(belowWallBlockId, base_i, -1, base_k) && this.headedToBaseWall(-1, belowWallBlockId)) {
                return this.setBottomGrabType(1, belowWallBlockId, false);
            }
            return false;
        }
        int remoteBelowMetadata = Orientation.getRemoteBlockMetadata(-1);
        if (!(!remoteLowerHalfEmpty || !this.isBaseAccessible(-1, true, false) || !this.isUpperHalfFrontAnySolid(remote_i, -1, remote_k) || Orientation.isBottomHalfBlock(remoteBelowId, remoteBelowMetadata) || Orientation.isStairCompact(remoteBelowId) && this.isBottomStairCompactFront(remoteBelowMetadata) || Orientation.isDoor(remoteBelowId) && !Orientation.isDoorTop(remoteBelowMetadata) || Orientation.isDoor(Orientation.getBaseBlockId(0)) && this.isDoorFrontBlocked(base_i, 0, base_k) || !((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && this.isFence(remote_i, -1, remote_k))) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        if (Orientation.isStairCompact(remoteId) && Orientation.isTopStairCompact(remoteMetadata = Orientation.getRemoteBlockMetadata(0)) && !this.isTopStairCompactBack(remoteMetadata) && this.isUpperHalfFrontFullSolid(remote_i, -1, remote_k)) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        int baseBelowId = Orientation.getBaseBlockId(-1);
        int baseBelowMetadata = Orientation.getBaseBlockMetadata(-1);
        if (Orientation.isTrapDoor(baseBelowId) && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(-1))) {
            return this.setBottomGrabType(1, aif.bk.ca, false);
        }
        if (Orientation.isDoor(baseBelowId) && Orientation.isDoorTop(baseBelowMetadata) && this.isDoorFrontBlocked(base_i, -1, base_k) && this.isBaseAccessible(0)) {
            return this.setBottomGrabType(1, aif.bk.ca, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseBelowId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setBottomGrabType(1, baseBelowId, false);
            }
            int baseId = Orientation.getBaseBlockId(0);
            if (Orientation.isASRope(baseId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setBottomGrabType(1, baseId, false);
            }
            if (Orientation.isASRope(remoteBelowId) && this.rotate(180).isASGrapplingHookFront(remoteBelowMetadata)) {
                return this.setHalfGrabType(1, remoteBelowId, true);
            }
            if (Orientation.isASRope(remoteId) && this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(0))) {
                return this.setHalfGrabType(1, remoteId, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
            meta = this.baseVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
            meta = this.remoteVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, aif.bu.ca, false, meta);
            }
        }
        return this.setBottomGrabType(0, 0);
    }

    private boolean setHalfGrabType(int type, int blockId) {
        return this.setHalfGrabType(type, blockId, true);
    }

    private boolean setHalfGrabType(int type, int blockId, boolean remote) {
        return this.setHalfGrabType(type, blockId, remote, -1);
    }

    private boolean setHalfGrabType(int type, int blockId, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl2 = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isUpperHalfFrontEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isUpperHalfFrontEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, blockId, remote, hasGrab, metaClimb);
    }

    private boolean setBottomGrabType(int type, int blockId) {
        return this.setBottomGrabType(type, blockId, true);
    }

    private boolean setBottomGrabType(int type, int blockId, boolean remote) {
        return this.setBottomGrabType(type, blockId, remote, -1);
    }

    private boolean setBottomGrabType(int type, int blockId, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl2 = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isLowerHalfFrontFullEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isLowerHalfFrontFullEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, blockId, remote, hasGrab, metaClimb);
    }

    private static boolean setGrabType(int type, int blockId, boolean remote, boolean hasGrab, int metaClimb) {
        grabRemote = remote;
        grabType = hasGrab ? type : 0;
        grabBlockId = blockId;
        grabMeta = metaClimb;
        return hasGrab;
    }

    private boolean setClimbingAngles() {
        switch (this._i) {
            case -1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(135.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(90.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(45.0f);
                    }
                }
                break;
            }
            case 0: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(180.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(0.0f, 360.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(0.0f);
                    }
                }
                break;
            }
            case 1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(225.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(270.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(315.0f);
                    }
                }
            }
        }
        return false;
    }

    private boolean setClimbingAngles(float directionAngle) {
        this._directionAngle = directionAngle;
        float halfAreaAngle = (this._isDiagonal ? (Float)Orientation.Config._freeClimbingDiagonalDirectionAngle.value : (Float)Orientation.Config._freeClimbingOrthogonalDirectionAngle.value).floatValue() / 2.0f;
        return this.setClimbingAngles(directionAngle - halfAreaAngle, directionAngle + halfAreaAngle);
    }

    private boolean setClimbingAngles(float mimimumClimbingAngle, float maximumClimbingAngle) {
        if (mimimumClimbingAngle < 0.0f) {
            mimimumClimbingAngle += 360.0f;
        }
        if (maximumClimbingAngle > 360.0f) {
            maximumClimbingAngle -= 360.0f;
        }
        this._mimimumClimbingAngle = mimimumClimbingAngle;
        this._maximumClimbingAngle = maximumClimbingAngle;
        return mimimumClimbingAngle != maximumClimbingAngle;
    }

    private boolean isWithinAngle(float minimumRotation, float maximumRotation) {
        return this.isWithinAngle(this._directionAngle, minimumRotation, maximumRotation);
    }

    private boolean isRotationForClimbing(float rotation) {
        return this.isWithinAngle(rotation, this._mimimumClimbingAngle, this._maximumClimbingAngle);
    }

    private boolean isWithinAngle(float rotation, float minimumRotation, float maximumRotation) {
        if (minimumRotation > maximumRotation) {
            return rotation >= minimumRotation || rotation <= maximumRotation;
        }
        return rotation >= minimumRotation && rotation <= maximumRotation;
    }

    private int baseVineClimbing(int j_offset) {
        boolean result = this.isOnVine(j_offset);
        if (result) {
            result = this.isOnVineFront(j_offset);
            if (result) {
                return 0;
            }
            if (this.baseVineClimbing(j_offset, PZ) || this.baseVineClimbing(j_offset, NZ) || this.baseVineClimbing(j_offset, ZP) || this.baseVineClimbing(j_offset, ZN)) {
                return 1;
            }
        }
        return -1;
    }

    private boolean baseVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        return orientation.rotate(180).hasVineOrientation(world, base_i, local_offset + j_offset, base_k) && orientation.getHorizontalBorderGap() >= 0.65;
    }

    private int remoteVineClimbing(int j_offset) {
        if (this.isBehindVine(j_offset) && this.isOnVineBack(j_offset)) {
            return 0;
        }
        if (this.remoteVineClimbing(j_offset, PZ) || this.remoteVineClimbing(j_offset, NZ) || this.remoteVineClimbing(j_offset, ZP) || this.remoteVineClimbing(j_offset, ZN)) {
            return 1;
        }
        return -1;
    }

    private boolean remoteVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        int i2 = base_i + orientation._i;
        int k2 = base_k + orientation._k;
        return Orientation.isVine(Orientation.getBlockId(i2, j_offset, k2)) && orientation.hasVineOrientation(world, i2, local_offset + j_offset, k2) && orientation.getHorizontalBorderGap() >= (double)0.65f;
    }

    private boolean isOnLadder(int j_offset) {
        return Orientation.getBaseBlockId(j_offset) == aif.aF.ca;
    }

    private boolean isOnVine(int j_offset) {
        return Orientation.getBaseBlockId(j_offset) == aif.bu.ca;
    }

    private boolean isBehindVine(int j_offset) {
        return Orientation.getRemoteBlockId(j_offset) == aif.bu.ca;
    }

    private boolean isOnLadderOrVine(int j_offset) {
        return Orientation.isLadderOrVine(Orientation.getBaseBlockId(j_offset)) || Orientation.isVine(grabBlockId);
    }

    public static boolean isLadder(int blockId) {
        return blockId == aif.aF.ca;
    }

    public static boolean isVine(int blockId) {
        return blockId == aif.bu.ca;
    }

    public static boolean isLadderOrVine(int blockId) {
        return blockId == aif.aF.ca || blockId == aif.bu.ca;
    }

    public static boolean isClimbable(uo world, int i2, int j2, int k2) {
        int blockId = world.a(i2, j2, k2);
        if (_isLadder != null) {
            return blockId > 0 && (Boolean)Reflect.Invoke(_isLadder, aif.m[blockId], world, i2, j2, k2) != false;
        }
        return Orientation.isLadderOrVine(blockId);
    }

    private boolean isOnLadderFront(int j_offset) {
        int metadata = Orientation.getBaseBlockMetadata(j_offset);
        if (this == NZ) {
            return metadata == 5;
        }
        if (this == PZ) {
            return metadata == 4;
        }
        if (this == ZP) {
            return metadata == 2;
        }
        if (this == ZN) {
            return metadata == 3;
        }
        return false;
    }

    private boolean isOnVineFront(int j_offset) {
        int metadata = Orientation.getBaseBlockMetadata(j_offset);
        if (this == NZ) {
            return (metadata & 2) != 0;
        }
        if (this == PZ) {
            return (metadata & 8) != 0;
        }
        if (this == ZP) {
            return (metadata & 1) != 0;
        }
        if (this == ZN) {
            return (metadata & 4) != 0;
        }
        return false;
    }

    private boolean isOnVineBack(int j_offset) {
        int metadata = Orientation.getRemoteBlockMetadata(j_offset);
        if (this == PZ) {
            return (metadata & 2) != 0;
        }
        if (this == NZ) {
            return (metadata & 8) != 0;
        }
        if (this == ZN) {
            return (metadata & 1) != 0;
        }
        if (this == ZP) {
            return (metadata & 4) != 0;
        }
        return false;
    }

    public static Orientation getLadderOrientation(uo world, int i2, int j2, int k2) {
        switch (world.g(i2, j2, k2)) {
            case 5: {
                return NZ;
            }
            case 4: {
                return PZ;
            }
            case 2: {
                return ZP;
            }
            case 3: {
                return ZN;
            }
        }
        return null;
    }

    public boolean hasVineOrientation(uo world, int i2, int j2, int k2) {
        int metaData = world.g(i2, j2, k2);
        if (this == PZ) {
            return (metaData & 8) != 0;
        }
        if (this == NZ) {
            return (metaData & 2) != 0;
        }
        if (this == ZN) {
            return (metaData & 4) != 0;
        }
        if (this == ZP) {
            return (metaData & 1) != 0;
        }
        return false;
    }

    public boolean isRemoteSolid(uo world, int i2, int j2, int k2) {
        return Orientation.isSolid(world.f(i2 + this._i, j2, k2 + this._k));
    }

    public static Orientation getOpenTrapDoorOrientation(uo world, int i2, int j2, int k2) {
        int metadata = world.g(i2, j2, k2);
        if (!Orientation.isClosedTrapDoor(metadata)) {
            switch (metadata & 3) {
                case 0: {
                    return ZP;
                }
                case 1: {
                    return ZN;
                }
                case 2: {
                    return PZ;
                }
                case 3: {
                    return NZ;
                }
            }
        }
        return null;
    }

    private boolean isHeadedToRope() {
        int iTriple = Orientation.getTriple(base_id, base_kd);
        int kTriple = Orientation.getTriple(base_kd, base_id);
        if (iTriple > 0) {
            if (kTriple > 0) {
                return this == NN;
            }
            if (kTriple < 0) {
                return this == NP;
            }
            return this == NZ;
        }
        if (iTriple < 0) {
            if (kTriple > 0) {
                return this == PN;
            }
            if (kTriple < 0) {
                return this == PP;
            }
            return this == PZ;
        }
        if (kTriple > 0) {
            return this == ZN;
        }
        if (kTriple < 0) {
            return this == ZP;
        }
        return this == ZZ;
    }

    private boolean isOnAnchorFront(int j_offset) {
        switch (Orientation.getBaseBlockMetadata(j_offset)) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return this._k == 1;
            }
            case 3: {
                return this._k == -1;
            }
            case 4: {
                return this._i == 1;
            }
            case 5: {
                return this._i == -1;
            }
        }
        return false;
    }

    private int getRopeId(int j_offset) {
        int id = Orientation.getBaseBlockId(j_offset);
        if (Orientation.isRopeId(id)) {
            return id;
        }
        return -1;
    }

    private boolean isRope(int j_offset) {
        return this.getRopeId(j_offset) >= 0;
    }

    private static boolean isRopeId(int id) {
        return SmartMovingOptions.hasBetterThanWolves && Orientation.hasBlockName(id, "tile.fcRopeBlock") || SmartMovingOptions.hasRopesPlus && Orientation.hasBlockName(id, "tile.rope");
    }

    private int getAnchorId(int j_offset) {
        int id = Orientation.getBaseBlockId(j_offset);
        if (Orientation.isAnchorId(id)) {
            return id;
        }
        return -1;
    }

    private static boolean isAnchorId(int id) {
        return Orientation.hasBlockName(id, "tile.fcAnchor");
    }

    private boolean isOnWallRope(int j_offset) {
        return (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(Orientation.getBaseBlockId(j_offset));
    }

    private static boolean isASRope(int id) {
        return Orientation.hasBlockName(id, "tile.blockRope");
    }

    private static boolean isASGrapplingHook(int id) {
        return Orientation.hasBlockName(id, "tile.blockGrapplingHook");
    }

    private boolean isASGrapplingHookFront(int metaData) {
        boolean iPos;
        boolean kPos = metaData % 2 != 0;
        boolean iNeg = metaData / 2 % 2 != 0;
        boolean kNeg = metaData / 4 % 2 != 0;
        boolean bl2 = iPos = metaData / 8 % 2 != 0;
        if (this._i > 0 && iPos || this._i < 0 && iNeg) {
            if (this._k > 0) {
                return kPos;
            }
            if (this._k < 0) {
                return kNeg;
            }
            return true;
        }
        if (this._k > 0 && kPos || this._k < 0 && kNeg) {
            if (this._i > 0) {
                return iPos;
            }
            if (this._i < 0) {
                return iNeg;
            }
            return true;
        }
        return false;
    }

    private boolean isOnOpenTrapDoor(int j_offset) {
        return Orientation.getBaseBlockId(j_offset) == aif.bk.ca && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(j_offset));
    }

    private boolean isTrapDoorFront(int trapDoorMetadata) {
        if (this == NZ) {
            return (trapDoorMetadata & 3) == 3;
        }
        if (this == PZ) {
            return (trapDoorMetadata & 3) == 2;
        }
        if (this == ZP) {
            return (trapDoorMetadata & 3) == 0;
        }
        if (this == ZN) {
            return (trapDoorMetadata & 3) == 1;
        }
        if (this == PN) {
            return (trapDoorMetadata & 3) == 2 || (trapDoorMetadata & 3) == 1;
        }
        if (this == PP) {
            return (trapDoorMetadata & 3) == 2 || (trapDoorMetadata & 3) == 0;
        }
        if (this == NN) {
            return (trapDoorMetadata & 3) == 3 || (trapDoorMetadata & 3) == 1;
        }
        if (this == NP) {
            return (trapDoorMetadata & 3) == 3 || (trapDoorMetadata & 3) == 0;
        }
        return false;
    }

    private boolean isBottomStairCompactNotBack(int stairMetadata) {
        return !Orientation.isTopStairCompact(stairMetadata) && !this.isStairCompactBack(stairMetadata);
    }

    private boolean isBottomStairCompactFront(int stairMetadata) {
        return !Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactFront(stairMetadata);
    }

    private boolean isTopStairCompactFront(int stairMetadata) {
        return Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactFront(stairMetadata);
    }

    private boolean isTopStairCompactBack(int stairMetadata) {
        return Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactBack(stairMetadata);
    }

    private boolean isStairCompactFront(int stairMetadata) {
        stairMetadata &= 3;
        if (this == NZ) {
            return stairMetadata == 1;
        }
        if (this == PZ) {
            return stairMetadata == 0;
        }
        if (this == ZP) {
            return stairMetadata == 2;
        }
        if (this == ZN) {
            return stairMetadata == 3;
        }
        if (this == PN) {
            return stairMetadata == 0 || stairMetadata == 3;
        }
        if (this == PP) {
            return stairMetadata == 0 || stairMetadata == 2;
        }
        if (this == NN) {
            return stairMetadata == 1 || stairMetadata == 3;
        }
        if (this == NP) {
            return stairMetadata == 1 || stairMetadata == 2;
        }
        return false;
    }

    private boolean isStairCompactBack(int stairMetadata) {
        stairMetadata &= 3;
        if (this == NZ) {
            return stairMetadata == 0;
        }
        if (this == PZ) {
            return stairMetadata == 1;
        }
        if (this == ZP) {
            return stairMetadata == 3;
        }
        if (this == ZN) {
            return stairMetadata == 2;
        }
        if (this == PN) {
            return stairMetadata == 1 || stairMetadata == 2;
        }
        if (this == PP) {
            return stairMetadata == 1 || stairMetadata == 3;
        }
        if (this == NN) {
            return stairMetadata == 0 || stairMetadata == 2;
        }
        if (this == NP) {
            return stairMetadata == 0 || stairMetadata == 3;
        }
        return false;
    }

    private static boolean isTopStairCompact(int stairMetadata) {
        return (stairMetadata & 4) != 0;
    }

    private static boolean isRedPowerWireTop(int coverSides) {
        return (coverSides >> 1) % 2 == 1;
    }

    private static boolean isRedPowerWireBottom(int coverSides) {
        return (coverSides >> 0) % 2 == 1;
    }

    private boolean isRedPowerWireFullFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireFullBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isFenceGateFront(int metaData) {
        int direction = metaData % 4;
        if (this == NZ) {
            return direction == 0 || direction == 2;
        }
        if (this == PZ) {
            return direction == 0 || direction == 2;
        }
        if (this == ZP) {
            return direction == 1 || direction == 3;
        }
        if (this == ZN) {
            return direction == 1 || direction == 3;
        }
        return false;
    }

    private boolean headedToFrontWall(int i2, int j_offset, int k2, int id) {
        aif block = aif.m[id];
        boolean zn2 = this.getWallFlag(ZN, i2, j_offset, k2, block);
        boolean zp2 = this.getWallFlag(ZP, i2, j_offset, k2, block);
        boolean nz2 = this.getWallFlag(NZ, i2, j_offset, k2, block);
        boolean pz2 = this.getWallFlag(PZ, i2, j_offset, k2, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn2 || zp2 || nz2 || pz2)) {
            pz2 = true;
            nz2 = true;
            zp2 = true;
            zn2 = true;
        }
        return this.headedToWall(NZ, pz2) || this.headedToWall(PZ, nz2) || this.headedToWall(ZN, zp2) || this.headedToWall(ZP, zn2);
    }

    private boolean headedToFrontSideWall(int i2, int j_offset, int k2, int id) {
        aif block = aif.m[id];
        boolean zn2 = this.getWallFlag(ZN, i2, j_offset, k2, block);
        boolean zp2 = this.getWallFlag(ZP, i2, j_offset, k2, block);
        boolean nz2 = this.getWallFlag(NZ, i2, j_offset, k2, block);
        boolean pz2 = this.getWallFlag(PZ, i2, j_offset, k2, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn2 || zp2 || nz2 || pz2)) {
            pz2 = true;
            nz2 = true;
            zp2 = true;
            zn2 = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToWall(NZ, zp2) || this.headedToWall(PZ, zp2) || this.headedToWall(ZN, pz2) || this.headedToWall(ZP, pz2);
            }
            return this.headedToWall(NZ, zn2) || this.headedToWall(PZ, zn2) || this.headedToWall(ZN, pz2) || this.headedToWall(ZP, pz2);
        }
        if (kTop) {
            return this.headedToWall(NZ, zp2) || this.headedToWall(PZ, zp2) || this.headedToWall(ZN, nz2) || this.headedToWall(ZP, nz2);
        }
        return this.headedToWall(NZ, zn2) || this.headedToWall(PZ, zn2) || this.headedToWall(ZN, nz2) || this.headedToWall(ZP, nz2);
    }

    private boolean headedToWall(Orientation base, boolean result) {
        if (this == base || this == base.rotate(45) || this == base.rotate(-45)) {
            return result;
        }
        return false;
    }

    private boolean headedToBaseWall(int j_offset, int id) {
        aif block = aif.m[id];
        boolean zn2 = this.getWallFlag(ZN, base_i, j_offset, base_k, block);
        boolean zp2 = this.getWallFlag(ZP, base_i, j_offset, base_k, block);
        boolean nz2 = this.getWallFlag(NZ, base_i, j_offset, base_k, block);
        boolean pz2 = this.getWallFlag(PZ, base_i, j_offset, base_k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn2 || zp2 || nz2 || pz2)) {
            pz2 = true;
            nz2 = true;
            zp2 = true;
            zn2 = true;
        }
        boolean leaf = zn2 || zp2 || nz2 || pz2;
        boolean coreOnly = !allOnNone && !leaf;
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToBaseWall(NN, NZ, ZN, zp2, nz2, pz2, zn2, coreOnly, leaf);
            }
            return this.headedToBaseWall(NP, NZ, ZP, zn2, nz2, pz2, zp2, coreOnly, leaf);
        }
        if (kTop) {
            return this.headedToBaseWall(PN, PZ, ZN, zp2, pz2, nz2, zn2, coreOnly, leaf);
        }
        return this.headedToBaseWall(PP, PZ, ZP, zn2, pz2, nz2, zp2, coreOnly, leaf);
    }

    private boolean headedToBaseWall(Orientation diagonal, Orientation left, Orientation right, boolean leftFront, boolean rightFrontOpposite, boolean rightFront, boolean leftFrontOpposite, boolean co2, boolean leaf) {
        if (this == diagonal) {
            return leaf || co2;
        }
        if (this == left) {
            return this.headedToBaseWall(leftFront, rightFrontOpposite, rightFront, leftFrontOpposite, co2);
        }
        if (this == right) {
            return this.headedToBaseWall(rightFront, leftFrontOpposite, leftFront, rightFrontOpposite, co2);
        }
        return false;
    }

    private boolean headedToBaseWall(boolean front, boolean sideOpposite, boolean side, boolean frontOpposite, boolean coreOnly) {
        return front || sideOpposite && !side || frontOpposite && !front && !side || coreOnly;
    }

    private boolean headedToBaseGrabWall(int j_offset, int id) {
        boolean azn;
        boolean azp;
        boolean anz2;
        boolean apz2;
        int aboveId;
        aif block = aif.m[id];
        boolean zn2 = this.getWallFlag(ZN, base_i, j_offset, base_k, block);
        boolean zp2 = this.getWallFlag(ZP, base_i, j_offset, base_k, block);
        boolean nz2 = this.getWallFlag(NZ, base_i, j_offset, base_k, block);
        boolean pz2 = this.getWallFlag(PZ, base_i, j_offset, base_k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn2 || zp2 || nz2 || pz2)) {
            pz2 = true;
            nz2 = true;
            zp2 = true;
            zn2 = true;
        }
        if (Orientation.isFullEmpty(aboveId = Orientation.getBlockId(base_i, j_offset + 1, base_k))) {
            apz2 = false;
            anz2 = false;
            azp = false;
            azn = false;
        } else if (Orientation.isWallBlock(aboveId, base_i, j_offset + 1, base_k)) {
            aif aboveBlock = aif.m[aboveId];
            azn = this.getWallFlag(ZN, base_i, j_offset + 1, base_k, aboveBlock);
            azp = this.getWallFlag(ZP, base_i, j_offset + 1, base_k, aboveBlock);
            anz2 = this.getWallFlag(NZ, base_i, j_offset + 1, base_k, aboveBlock);
            apz2 = this.getWallFlag(PZ, base_i, j_offset + 1, base_k, aboveBlock);
            boolean aboveAllOnNone = this.getAllWallsOnNoWall(aboveBlock);
            if (!(!aboveAllOnNone || azn || azp || anz2 || apz2)) {
                apz2 = true;
                anz2 = true;
                azp = true;
                azn = true;
            }
        } else {
            apz2 = true;
            anz2 = true;
            azp = true;
            azn = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToBaseGrabWall(-this._i, -this._k, zp2, pz2, nz2, zn2, azp, apz2, anz2, azn);
            }
            return this.headedToBaseGrabWall(-this._i, this._k, pz2, zn2, zp2, nz2, apz2, azn, azp, anz2);
        }
        if (kTop) {
            return this.headedToBaseGrabWall(this._i, -this._k, nz2, zp2, zn2, pz2, anz2, azp, azn, apz2);
        }
        return this.headedToBaseGrabWall(this._i, this._k, zn2, nz2, pz2, zp2, azn, anz2, apz2, azp);
    }

    private boolean headedToBaseGrabWall(int i2, int k2, boolean front, boolean side, boolean frontOpposite, boolean sideOpposite, boolean aboveFront, boolean aboveSide, boolean aboveFrontOpposite, boolean aboveSideOpposite) {
        if (sideOpposite && !aboveSideOpposite && !front && !aboveFront && i2 == 1) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !side && !aboveSide && k2 == 1) {
            return true;
        }
        if (side && !aboveSide && k2 >= 0) {
            return true;
        }
        if (front && !aboveFront && k2 >= 0) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !aboveFront && i2 == 1 && k2 >= 0) {
            return true;
        }
        return sideOpposite && !aboveSideOpposite && !aboveSide && k2 == 1 && i2 >= 0;
    }

    private boolean getWallFlag(Orientation direction, int i2, int j_offset, int k2, aif block) {
        if (block instanceof aie) {
            return ((aie)block).e(Orientation.getBlockId(i2 + direction._i, j_offset, k2 + direction._k));
        }
        if (Orientation.isFenceBase(block.ca)) {
            if (block instanceof afw) {
                return ((afw)block).d((uy)world, i2 + direction._i, local_offset + j_offset, k2 + direction._k);
            }
            if (SmartMovingOptions.hasBetterMisc && _canConnectFenceTo != null) {
                return (Boolean)Reflect.Invoke(_canConnectFenceTo, block, world, i2 + direction._i, local_offset + j_offset, k2 + direction._k);
            }
        } else if (Orientation.isFenceGate(block.ca)) {
            int metaData = Orientation.getBlockMetadata(i2, j_offset, k2);
            return Orientation.isClosedFenceGate(metaData) && this.isFenceGateFront(metaData);
        }
        return false;
    }

    private boolean getAllWallsOnNoWall(aif block) {
        return block instanceof aie;
    }

    private static boolean isTopHalf(double d2) {
        return (int)Math.abs(Math.floor(d2 * 2.0)) % 2 == 1;
    }

    private static int getTriple(double primary, double secondary) {
        primary = primary - Math.floor(primary) - 0.5;
        secondary = secondary - Math.floor(secondary) - 0.5;
        if (Math.abs(primary) * 2.0 < Math.abs(secondary)) {
            return 0;
        }
        if (primary > 0.0) {
            return 1;
        }
        if (primary < 0.0) {
            return -1;
        }
        return 0;
    }

    private static boolean isBottomHalfBlock(int id, int metadata) {
        if (id == aif.ak.ca && (metadata & 8) == 0 || id == aif.S.ca) {
            return true;
        }
        return SmartMovingOptions.hasBetterThanWolves && Orientation.isAnchorId(id) && metadata == 1;
    }

    private static boolean isTopHalfBlock(int id, int metadata) {
        return id == aif.ak.ca && (metadata & 8) != 0;
    }

    private static boolean isStairCompact(int id) {
        return aif.m[id] instanceof ahw;
    }

    private boolean isLowerHalfFrontFullEmpty(int i2, int j_offset, int k2) {
        int coverSides;
        int id = Orientation.getBlockId(i2, j_offset, k2);
        boolean empty = Orientation.isFullEmpty(id);
        if (!empty && SmartMovingOptions.hasRedPowerWire && Orientation.isRedPowerWire(id) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i2, j_offset, k2))) {
            empty = true;
        }
        if (!empty && SmartMovingOptions.hasBetterThanWolves && Orientation.isAnchorId(id)) {
            boolean bl2 = empty = Orientation.getBlockMetadata(i2, j_offset, k2) == 0;
        }
        if (!empty && Orientation.isStairCompact(id) && this.isTopStairCompactFront(Orientation.getBlockMetadata(i2, j_offset, k2))) {
            empty = true;
        }
        if (!empty && id == aif.ak.ca && Orientation.isTopHalfBlock(id, Orientation.getBlockMetadata(i2, j_offset, k2))) {
            empty = true;
        }
        if (!empty && Orientation.isWallBlock(id, i2, j_offset, k2) && !this.headedToFrontWall(i2, j_offset, k2, id)) {
            empty = true;
        }
        if (!empty && Orientation.isDoor(id) && !this.rotate(180).isDoorFrontBlocked(remote_i, j_offset, remote_k)) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(j_offset))) {
            empty = true;
        }
        return empty;
    }

    private boolean isUpperHalfFrontAnySolid(int i2, int j_offset, int k2) {
        int id = Orientation.getBlockId(i2, j_offset, k2);
        boolean solid = this.isUpperHalfFrontFullSolid(i2, j_offset, k2);
        if (solid && Orientation.isWallBlock(id, i2, j_offset, k2) && !this.headedToFrontWall(i2, j_offset, k2, id)) {
            solid = false;
        }
        return solid;
    }

    private boolean isUpperHalfFrontFullSolid(int i2, int j_offset, int k2) {
        int id = Orientation.getBlockId(i2, j_offset, k2);
        if (id <= 0) {
            return false;
        }
        aif block = aif.m[id];
        boolean solid = Orientation.isSolid(block.cp);
        if (solid && id == aif.aD.ca) {
            solid = false;
        }
        if (solid && id == aif.aI.ca) {
            solid = false;
        }
        if (solid && block instanceof ahd) {
            solid = false;
        }
        if (solid && id == aif.bk.ca) {
            solid = false;
        }
        if (solid && SmartMovingOptions.hasASGrapplingHook && Orientation.isASGrapplingHook(id)) {
            solid = false;
        }
        if (solid && this.isOpenFenceGate(id, Orientation.getBlockMetadata(i2, j_offset, k2))) {
            solid = false;
        }
        return solid;
    }

    private static boolean isFullEmpty(int id) {
        boolean empty;
        if (id <= 0) {
            return true;
        }
        aif block = aif.m[id];
        boolean bl2 = empty = !Orientation.isSolid(block.cp);
        if (!empty && id == aif.aD.ca) {
            empty = true;
        }
        if (!empty && id == aif.aI.ca) {
            empty = true;
        }
        if (!empty && block instanceof ahd) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASGrapplingHook(id)) {
            empty = true;
        }
        if (empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id)) {
            empty = false;
        }
        return empty;
    }

    private static boolean isFenceBase(int id) {
        return id == aif.aZ.ca || id == aif.bB.ca;
    }

    private static boolean isFence(int id, int i2, int j_offset, int k2) {
        return Orientation.isFenceBase(id) || Orientation.isClosedFenceGate(id, Orientation.getBlockMetadata(i2, j_offset, k2));
    }

    private boolean isFence(int i2, int j_offset, int k2) {
        return this.getFenceId(i2, j_offset, k2) != -1;
    }

    private int getFenceId(int i2, int j_offset, int k2) {
        int id = Orientation.getBlockId(i2, j_offset, k2);
        if (Orientation.isFenceBase(id) || Orientation.isClosedFenceGate(id, Orientation.getBlockMetadata(i2, j_offset, k2))) {
            return id;
        }
        return -1;
    }

    private static boolean isClosedFenceGate(int id, int metdata) {
        return Orientation.isFenceGate(id) && Orientation.isClosedFenceGate(metdata);
    }

    private static boolean isFenceGate(int id) {
        return id == aif.bv.ca;
    }

    private boolean isOpenFenceGate(int id, int metdata) {
        return id == aif.bv.ca && !Orientation.isClosedFenceGate(metdata);
    }

    private static boolean isClosedFenceGate(int metdata) {
        return (metdata & 4) == 0;
    }

    private boolean isOpenTrapDoor(int i2, int j_offset, int k2) {
        return Orientation.isTrapDoor(i2, j_offset, k2) && !Orientation.isClosedTrapDoor(Orientation.getBlockMetadata(i2, j_offset, k2));
    }

    private static boolean isClosedTrapDoor(int i2, int j_offset, int k2) {
        return Orientation.isTrapDoor(i2, j_offset, k2) && Orientation.isClosedTrapDoor(Orientation.getBlockMetadata(i2, j_offset, k2));
    }

    private static boolean isTrapDoor(int i2, int j_offset, int k2) {
        return Orientation.isTrapDoor(Orientation.getBlockId(i2, j_offset, k2));
    }

    private static boolean isTrapDoor(int id) {
        return id == aif.bk.ca;
    }

    public static boolean isClosedTrapDoor(int metaData) {
        return (metaData & 4) == 0;
    }

    private static boolean isDoor(int id) {
        return id == aif.aE.ca || id == aif.aL.ca;
    }

    private static boolean isDoorTop(int metaData) {
        return metaData == 8;
    }

    private boolean isDoorFrontBlocked(int i2, int j_offset, int k2) {
        int metaData = Orientation.getBlockMetadata(i2, j_offset, k2);
        switch (metaData) {
            case 8: {
                return this.isDoorFrontBlocked(i2, j_offset - 1, k2);
            }
            case 1: 
            case 4: {
                return this._k < 0;
            }
            case 2: 
            case 5: {
                return this._i > 0;
            }
            case 3: 
            case 6: {
                return this._k > 0;
            }
            case 0: 
            case 7: {
                return this._i < 0;
            }
        }
        return true;
    }

    private static int getWallBlockId(int i2, int j_offset, int k2) {
        int id = Orientation.getBlockId(i2, j_offset, k2);
        if (Orientation.isWallBlock(id, i2, j_offset, k2)) {
            return id;
        }
        return -1;
    }

    private static boolean isWallBlock(int id, int i2, int j_offset, int k2) {
        return id > 0 && aif.m[id] instanceof aie || Orientation.isFence(id, i2, j_offset, k2);
    }

    private boolean isBaseAccessible(int j_offset) {
        return this.isBaseAccessible(j_offset, false, false);
    }

    private boolean isBaseAccessible(int j_offset, boolean bottom, boolean full) {
        int id = Orientation.getBaseBlockId(j_offset);
        boolean accessible = this.isEmpty(base_i, j_offset, base_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(id)) {
            int coverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
            accessible = !Orientation.isRedPowerWireBottom(coverSides);
            int lowerId = Orientation.getBaseBlockId(j_offset - 1);
            if (Orientation.isRedPowerWire(lowerId)) {
                int lowerCoverSides = Orientation.getRpCoverSides(base_i, j_offset - 1, base_k);
                accessible &= !Orientation.isRedPowerWireTop(lowerCoverSides);
            }
        }
        if (!accessible && Orientation.isFullEmpty(id)) {
            accessible = true;
        }
        if (!accessible && this.isOpenTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && bottom && Orientation.isClosedTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && Orientation.isWallBlock(id, base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id)) {
            accessible = true;
        }
        if (!accessible && Orientation.isDoor(id)) {
            accessible = true;
        }
        return accessible;
    }

    private boolean isRemoteAccessible(int j_offset) {
        int id;
        boolean accessible = this.isEmpty(remote_i, j_offset, remote_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(id = Orientation.getRemoteBlockId(j_offset))) {
            int coverSides = Orientation.getRpCoverSides(remote_i, j_offset, remote_k);
            accessible = !this.isRedPowerWireAnyFront(coverSides);
            int baseId = Orientation.getBaseBlockId(j_offset);
            if (Orientation.isRedPowerWire(baseId)) {
                int baseCoverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
                accessible &= !this.isRedPowerWireAnyBack(baseCoverSides);
            }
        }
        if (accessible) {
            id = Orientation.getBaseBlockId(j_offset);
            if (Orientation.isTrapDoor(id)) {
                boolean bl2 = accessible = !this.isTrapDoorFront(Orientation.getBlockMetadata(base_i, j_offset, base_k));
            }
            if (accessible && Orientation.isDoor(id)) {
                boolean bl3 = accessible = !this.isDoorFrontBlocked(base_i, j_offset, base_k);
            }
        }
        if (!accessible && Orientation.isTrapDoor(remote_i, j_offset, remote_k)) {
            accessible = Orientation.isClosedTrapDoor(Orientation.getRemoteBlockMetadata(j_offset));
        }
        if (!accessible) {
            id = Orientation.getRemoteBlockId(j_offset);
            if (Orientation.isWallBlock(id, remote_i, j_offset, remote_k) && !this.headedToFrontWall(remote_i, j_offset, remote_k, id) && !this.isFence(remote_i, j_offset - 1, remote_k)) {
                accessible = true;
            }
            int belowId = Orientation.getRemoteBlockId(j_offset - 1);
            if (!accessible && Orientation.isFence(belowId, remote_i, j_offset - 1, remote_k) && (!this.headedToFrontWall(remote_i, j_offset - 1, remote_k, belowId) || Orientation.isWallBlock(Orientation.getBaseBlockId(j_offset - 1), base_i, j_offset - 1, base_k))) {
                accessible = true;
            }
            if (!accessible && Orientation.isDoor(id) && !this.rotate(180).isDoorFrontBlocked(remote_i, j_offset, remote_k)) {
                accessible = true;
            }
            if ((SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(j_offset))) {
                accessible = true;
            }
        }
        return accessible;
    }

    private boolean isAccessAccessible(int j_offset) {
        if (!this._isDiagonal) {
            return true;
        }
        return this.isEmpty(remote_i, j_offset, base_k) && this.isEmpty(base_i, j_offset, remote_k);
    }

    private boolean isFullExtentAccessible(int j_offset, boolean grabRemote) {
        boolean accessible = this.isFullAccessible(j_offset, grabRemote);
        if (SmartMovingOptions.hasRedPowerWire && accessible) {
            int coverSides;
            int bottomId;
            int coverSides2;
            int topId = Orientation.getRemoteBlockId(j_offset);
            if (Orientation.isRedPowerWire(topId) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, j_offset, remote_k))) {
                accessible = false;
            }
            if (Orientation.isRedPowerWire(bottomId = Orientation.getRemoteBlockId(j_offset - 1)) && Orientation.isRedPowerWireTop(coverSides = Orientation.getRpCoverSides(remote_i, j_offset - 1, remote_k))) {
                accessible = false;
            }
        }
        return accessible;
    }

    private boolean isJustLowerHalfExtentAccessible(int j_offset) {
        int remoteId = Orientation.getRemoteBlockId(j_offset);
        int remoteMetaData = Orientation.getRemoteBlockMetadata(j_offset);
        boolean accessible = false;
        if (!accessible) {
            accessible = Orientation.isTopHalfBlock(remoteId, remoteMetaData);
        }
        if (!accessible) {
            accessible = Orientation.isStairCompact(remoteId) && this.isTopStairCompactFront(remoteMetaData);
        }
        return accessible;
    }

    private boolean isFullAccessible(int j_offset, boolean grabRemote) {
        if (grabRemote) {
            return this.isBaseAccessible(j_offset) && this.isRemoteAccessible(j_offset) && this.isAccessAccessible(j_offset);
        }
        return this.isEmpty(base_i, j_offset, base_k);
    }

    private boolean isEmpty(int i2, int j_offset, int k2) {
        return Orientation.isFullEmpty(Orientation.getBlockId(i2, j_offset, k2)) && !this.isFence(i2, j_offset - 1, k2);
    }

    private boolean isUpperHalfFrontEmpty(int i2, int j_offset, int k2) {
        int wallId;
        int coverSides;
        int id = Orientation.getBlockId(i2, j_offset, k2);
        boolean empty = Orientation.isFullEmpty(id);
        if (!empty) {
            int metadata = Orientation.getBlockMetadata(i2, j_offset, k2);
            if (Orientation.isBottomHalfBlock(id, metadata)) {
                empty = true;
            }
            if (!empty && Orientation.isStairCompact(id) && this.isBottomStairCompactFront(metadata)) {
                empty = true;
            }
        }
        if (SmartMovingOptions.hasRedPowerWire && !empty && Orientation.isRedPowerWire(id) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i2, j_offset, k2))) {
            empty = true;
        }
        if (!empty && id == aif.bk.ca) {
            empty = true;
        }
        if (!(empty || (wallId = Orientation.getWallBlockId(i2, j_offset, k2)) <= 0 || this.headedToFrontWall(i2, j_offset, k2, wallId) && !Orientation.isWallBlock(Orientation.getBlockId(i2 - this._i, j_offset, k2 - this._k), i2 - this._i, j_offset, k2 - this._k))) {
            empty = true;
        }
        return empty;
    }

    private static int getRpCoverSides(int i2, int j_offset, int k2) {
        ajh tileEntity = Orientation.getBlockTileEntity(i2, j_offset, k2);
        Class<?> tileEntityClass = tileEntity.getClass();
        while (!tileEntityClass.getSimpleName().equals("TileCovered")) {
            tileEntityClass = tileEntityClass.getSuperclass();
        }
        return (Integer)Reflect.GetField(tileEntityClass, tileEntity, "CoverSides", "CoverSides");
    }

    private static boolean isRedPowerWire(int id) {
        return Orientation.hasBlockName(id, "tile.rpwire");
    }

    public static int getFiniteLiquidWater(int id) {
        String blockName = Orientation.getBlockName(id);
        if (blockName == null) {
            return 0;
        }
        if (blockName.equals("tile.nocean")) {
            return 2;
        }
        if (blockName.equals("tile.nwater_still")) {
            return 1;
        }
        return 0;
    }

    private static boolean isSolid(acn material) {
        return material.a() && !material.d();
    }

    private static int getBlockId(int i2, int j_offset, int k2) {
        return world.a(i2, local_offset + j_offset, k2);
    }

    private static int getBlockMetadata(int i2, int j_offset, int k2) {
        return world.g(i2, local_offset + j_offset, k2);
    }

    private static ajh getBlockTileEntity(int i2, int j_offset, int k2) {
        return world.p(i2, local_offset + j_offset, k2);
    }

    private static int getBaseBlockId(int j_offset) {
        return world.a(base_i, local_offset + j_offset, base_k);
    }

    private static int getBaseBlockMetadata(int j_offset) {
        return world.g(base_i, local_offset + j_offset, base_k);
    }

    private static int getRemoteBlockId(int j_offset) {
        return world.a(remote_i, local_offset + j_offset, remote_k);
    }

    private static int getRemoteBlockMetadata(int j_offset) {
        return world.g(remote_i, local_offset + j_offset, remote_k);
    }

    private static boolean hasBlockName(int blockId, String name) {
        String blockName = Orientation.getBlockName(blockId);
        return blockName != null && blockName.equals(name);
    }

    private static String getBlockName(int blockId) {
        if (blockId <= 0) {
            return null;
        }
        return aif.m[blockId].a();
    }

    private void initialize(uo w2, int i2, double id, double jhd, int k2, double kd2) {
        world = w2;
        base_i = i2;
        base_id = id;
        base_jhd = jhd;
        base_k = k2;
        base_kd = kd2;
        remote_i = i2 + this._i;
        remote_k = k2 + this._k;
    }

    private static void initializeOffset(double offset_halfs, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling) {
        crawl = isClimbCrawling || isCrawlClimbing || isCrawling;
        double offset_jhd = base_jhd + offset_halfs;
        int offset_jh = ig.c(offset_jhd);
        jh_offset = offset_jhd - (double)offset_jh;
        all_j = offset_jh / 2;
        all_offset = offset_jh % 2;
    }

    private static void initializeLocal(int localOffset) {
        local_halfOffset = localOffset + all_offset;
        local_half = Math.abs(local_halfOffset) % 2;
        local_offset = all_j + (local_halfOffset - local_half) / 2;
    }

    public String toString() {
        if (this == ZZ) {
            return "ZZ";
        }
        if (this == NZ) {
            return "NZ";
        }
        if (this == PZ) {
            return "PZ";
        }
        if (this == ZP) {
            return "ZP";
        }
        if (this == ZN) {
            return "ZN";
        }
        if (this == PN) {
            return "PN";
        }
        if (this == PP) {
            return "PP";
        }
        if (this == NN) {
            return "NN";
        }
        if (this == NP) {
            return "NP";
        }
        return "UNKNOWN";
    }

    static {
        _isLadder = Reflect.GetMethod(aif.class, "isLadder", null, false, uo.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        Class modFenceBlock = Reflect.LoadClass(aif.class, "net.minecraft.src.modBlockFence", "modBlockFence", false);
        _canConnectFenceTo = modFenceBlock != null ? Reflect.GetMethod(modFenceBlock, "canConnectFenceTo", null, false, uy.class, Integer.TYPE, Integer.TYPE, Integer.TYPE) : null;
    }
}

