/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.io.PrintStream;
import net.minecraft.move.ClimbGap;

public class HandsClimbing {
    public static final int MiddleGrab = 2;
    public static final int UpGrab = 1;
    public static final int NoGrab = 0;
    public static HandsClimbing None = new HandsClimbing(-3);
    public static HandsClimbing Sink = new HandsClimbing(-2);
    public static HandsClimbing TopHold = new HandsClimbing(-1);
    public static HandsClimbing BottomHold = new HandsClimbing(0);
    public static HandsClimbing Up = new HandsClimbing(1);
    public static HandsClimbing FastUp = new HandsClimbing(2);
    private int _value;

    private HandsClimbing(int value) {
        this._value = value;
    }

    public boolean IsRelevant() {
        return this._value > HandsClimbing.None._value;
    }

    public boolean IsUp() {
        return this == Up || this == FastUp;
    }

    public HandsClimbing ToUp() {
        if (this == BottomHold) {
            return Up;
        }
        return this;
    }

    public HandsClimbing ToDown() {
        if (this == TopHold) {
            return Sink;
        }
        return this;
    }

    public HandsClimbing max(HandsClimbing other, ClimbGap inout_thisClimbGap, ClimbGap otherClimbGap) {
        if (!otherClimbGap.SkipGaps) {
            inout_thisClimbGap.CanStand |= otherClimbGap.CanStand;
            inout_thisClimbGap.MustCrawl |= otherClimbGap.MustCrawl;
        }
        if (this._value < other._value) {
            inout_thisClimbGap.BlockId = otherClimbGap.BlockId;
            inout_thisClimbGap.Meta = otherClimbGap.Meta;
            inout_thisClimbGap.Direction = otherClimbGap.Direction;
        }
        return HandsClimbing.get(Math.max(this._value, other._value));
    }

    public String toString() {
        if (this._value <= HandsClimbing.None._value) {
            return "None";
        }
        if (this._value == HandsClimbing.Sink._value) {
            return "Sink";
        }
        if (this._value == HandsClimbing.BottomHold._value) {
            return "BottomHold";
        }
        if (this._value == HandsClimbing.TopHold._value) {
            return "TopHold";
        }
        if (this._value == HandsClimbing.Up._value) {
            return "Up";
        }
        return "FastUp";
    }

    public void print(String name) {
        PrintStream stream = System.err;
        if (name != null) {
            stream.print(name + " = ");
        }
        stream.println(this);
    }

    private static HandsClimbing get(int value) {
        if (value <= HandsClimbing.None._value) {
            return None;
        }
        if (value == HandsClimbing.Sink._value) {
            return Sink;
        }
        if (value == HandsClimbing.BottomHold._value) {
            return BottomHold;
        }
        if (value == HandsClimbing.TopHold._value) {
            return TopHold;
        }
        if (value == HandsClimbing.Up._value) {
            return Up;
        }
        return FastUp;
    }
}

