/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.move;

import java.io.PrintStream;
import net.minecraft.move.ClimbGap;

public class FeetClimbing {
    public static final int DownStep = 1;
    public static final int NoStep = 0;
    public static FeetClimbing None = new FeetClimbing(-3);
    public static FeetClimbing BaseHold = new FeetClimbing(-2);
    public static FeetClimbing BaseWithHands = new FeetClimbing(-1);
    public static FeetClimbing TopWithHands = new FeetClimbing(0);
    public static FeetClimbing SlowUpWithHoldWithoutHands = new FeetClimbing(1);
    public static FeetClimbing SlowUpWithSinkWithoutHands = new FeetClimbing(2);
    public static FeetClimbing FastUp = new FeetClimbing(3);
    private int _value;

    private FeetClimbing(int value) {
        this._value = value;
    }

    public boolean IsRelevant() {
        return this._value > FeetClimbing.None._value;
    }

    public boolean IsIndependentlyRelevant() {
        return this._value > FeetClimbing.BaseWithHands._value;
    }

    public boolean IsUp() {
        return this == SlowUpWithHoldWithoutHands || this == SlowUpWithSinkWithoutHands || this == FastUp;
    }

    public FeetClimbing max(FeetClimbing other, ClimbGap inout_thisClimbGap, ClimbGap otherClimbGap) {
        if (!otherClimbGap.SkipGaps) {
            inout_thisClimbGap.CanStand |= otherClimbGap.CanStand;
            inout_thisClimbGap.MustCrawl |= otherClimbGap.MustCrawl;
        }
        if (this._value < other._value) {
            inout_thisClimbGap.BlockId = otherClimbGap.BlockId;
            inout_thisClimbGap.Meta = otherClimbGap.Meta;
            inout_thisClimbGap.Direction = otherClimbGap.Direction;
        }
        return FeetClimbing.get(Math.max(this._value, other._value));
    }

    public String toString() {
        if (this._value <= FeetClimbing.None._value) {
            return "None";
        }
        if (this._value == FeetClimbing.BaseHold._value) {
            return "BaseHold";
        }
        if (this._value == FeetClimbing.BaseWithHands._value) {
            return "BaseWithHands";
        }
        if (this._value == FeetClimbing.TopWithHands._value) {
            return "TopWithHands";
        }
        if (this._value == FeetClimbing.SlowUpWithHoldWithoutHands._value) {
            return "SlowUpWithHoldWithoutHands";
        }
        if (this._value == FeetClimbing.SlowUpWithSinkWithoutHands._value) {
            return "SlowUpWithSinkWithoutHands";
        }
        return "FastUp";
    }

    public void print(String name) {
        PrintStream stream = System.err;
        if (name != null) {
            stream.print(name + " = ");
        }
        stream.println(this);
    }

    private static FeetClimbing get(int value) {
        if (value <= FeetClimbing.None._value) {
            return None;
        }
        if (value == FeetClimbing.BaseHold._value) {
            return BaseHold;
        }
        if (value == FeetClimbing.BaseWithHands._value) {
            return BaseWithHands;
        }
        if (value == FeetClimbing.TopWithHands._value) {
            return TopWithHands;
        }
        if (value == FeetClimbing.SlowUpWithHoldWithoutHands._value) {
            return SlowUpWithHoldWithoutHands;
        }
        if (value == FeetClimbing.SlowUpWithSinkWithoutHands._value) {
            return SlowUpWithSinkWithoutHands;
        }
        return FastUp;
    }
}

