/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.CustomAnimation;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.TextureFX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUtils {
    private static boolean animatedFire;
    private static boolean animatedLava;
    private static boolean animatedWater;
    private static boolean animatedPortal;
    private static boolean customFire;
    private static boolean customLava;
    private static boolean customWater;
    private static boolean customPortal;
    private static boolean customOther;
    public static final int LAVA_STILL_TEXTURE_INDEX = 237;
    public static final int LAVA_FLOWING_TEXTURE_INDEX = 238;
    public static final int WATER_STILL_TEXTURE_INDEX = 205;
    public static final int WATER_FLOWING_TEXTURE_INDEX = 206;
    public static final int FIRE_E_W_TEXTURE_INDEX = 31;
    public static final int FIRE_N_S_TEXTURE_INDEX = 47;
    public static final int PORTAL_TEXTURE_INDEX = 14;
    private static HashMap<String, Integer> expectedColumns;
    private static boolean useTextureCache;
    private static boolean reclaimGLMemory;
    private static boolean autoRefreshTextures;
    private static ayd lastTexturePack;
    private static HashMap<String, BufferedImage> cache;
    private static int textureRefreshCount;
    private static final String ALL_ITEMS = "/gui/allitems.png";
    private static final String ALL_ITEMSX = "/gui/allitemsx.png";
    public static boolean oldCreativeGui;
    private static boolean bindImageReentry;

    public static boolean setTileSize() {
        MCPatcherUtils.debug("\nchanging skin to %s", TextureUtils.getTexturePackName(TextureUtils.getSelectedTexturePack()));
        int size = TextureUtils.getTileSize();
        if (size == TileSize.int_size) {
            MCPatcherUtils.debug("tile size %d unchanged", size);
            return false;
        }
        MCPatcherUtils.debug("setting tile size to %d (was %d)", size, TileSize.int_size);
        TileSize.setTileSize(size);
        return true;
    }

    private static void setFontRenderer(Minecraft minecraft, aou fontRenderer, String filename) {
        boolean saveUnicode = fontRenderer.l;
        fontRenderer.initialize(minecraft.y, filename, minecraft.o);
        fontRenderer.l = saveUnicode;
    }

    public static void setFontRenderer() {
        MCPatcherUtils.debug("setFontRenderer()", new Object[0]);
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        TextureUtils.setFontRenderer(minecraft, minecraft.p, "/font/default.png");
        if (minecraft.q != minecraft.p) {
            TextureUtils.setFontRenderer(minecraft, minecraft.q, "/font/alternate.png");
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static void registerTextureFX(List textureList, axd textureFX) {
        axd fx2 = TextureUtils.refreshTextureFX(textureFX);
        if (fx2 != null) {
            MCPatcherUtils.debug("registering new TextureFX class %s", textureFX.getClass().getName());
            textureList.add(fx2);
            fx2.a();
        }
    }

    private static axd refreshTextureFX(axd textureFX) {
        if (textureFX instanceof axc || textureFX instanceof axb || textureFX instanceof axg || textureFX instanceof axf || textureFX instanceof axj || textureFX instanceof axi || textureFX instanceof axe || textureFX instanceof axh) {
            return null;
        }
        MCPatcherUtils.info("attempting to refresh unknown animation %s", textureFX.getClass().getName());
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        Class<?> textureFXClass = textureFX.getClass();
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                switch (i2) {
                    case 0: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class, Integer.TYPE);
                        return (axd)constructor.newInstance(minecraft, TileSize.int_size);
                    }
                    case 1: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class);
                        return (axd)constructor.newInstance(minecraft);
                    }
                    case 2: {
                        Constructor<?> constructor = textureFXClass.getConstructor(new Class[0]);
                        return (axd)constructor.newInstance(new Object[0]);
                    }
                }
                continue;
            }
            catch (NoSuchMethodException e2) {
                continue;
            }
            catch (IllegalAccessException e3) {
                continue;
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        if (textureFX.a.length != TileSize.int_numBytes) {
            MCPatcherUtils.debug("resizing %s buffer from %d to %d bytes", textureFXClass.getName(), textureFX.a.length, TileSize.int_numBytes);
            textureFX.a = new byte[TileSize.int_numBytes];
        }
        return textureFX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTextureFX(List<TextureFX> textureList) {
        boolean isDefault;
        MCPatcherUtils.debug("refreshTextureFX()", new Object[0]);
        ArrayList<axd> savedTextureFX = new ArrayList<axd>();
        for (axd axd2 : textureList) {
            axd fx2 = TextureUtils.refreshTextureFX(axd2);
            if (fx2 == null) continue;
            savedTextureFX.add(fx2);
        }
        textureList.clear();
        CustomAnimation.clear();
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        textureList.add((TextureFX)new axc(minecraft));
        textureList.add((TextureFX)new axb(minecraft));
        ayd ayd2 = TextureUtils.getSelectedTexturePack();
        boolean bl2 = isDefault = ayd2 == null || ayd2 instanceof aye;
        if (!isDefault && customLava) {
            CustomAnimation.addStripOrTile("/terrain.png", "lava_still", 237, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "lava_flowing", 238, 2, 3, 6);
        } else if (animatedLava) {
            textureList.add((TextureFX)new axg());
            textureList.add((TextureFX)new axf());
        }
        if (!isDefault && customWater) {
            CustomAnimation.addStripOrTile("/terrain.png", "water_still", 205, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "water_flowing", 206, 2, 0, 0);
        } else if (animatedWater) {
            textureList.add((TextureFX)new axj());
            textureList.add((TextureFX)new axi());
        }
        if (!isDefault && customFire && TextureUtils.hasResource("/anim/custom_fire_e_w.png") && TextureUtils.hasResource("/anim/custom_fire_n_s.png")) {
            CustomAnimation.addStrip("/terrain.png", "fire_n_s", 47, 1);
            CustomAnimation.addStrip("/terrain.png", "fire_e_w", 31, 1);
        } else if (animatedFire) {
            textureList.add((TextureFX)new axe(0));
            textureList.add((TextureFX)new axe(1));
        }
        if (!isDefault && customPortal && TextureUtils.hasResource("/anim/custom_portal.png")) {
            CustomAnimation.addStrip("/terrain.png", "portal", 14, 1);
        } else if (animatedPortal) {
            textureList.add((TextureFX)new axh());
        }
        if (customOther) {
            TextureUtils.addOtherTextureFX("/terrain.png", "terrain");
            TextureUtils.addOtherTextureFX("/gui/items.png", "item");
            if (!(ayd2 instanceof aye)) {
                File folder;
                if (ayd2 instanceof ayf) {
                    ayf custom = (ayf)ayd2;
                    for (ZipEntry zipEntry : Collections.list(custom.e.entries())) {
                        String name = "/" + zipEntry.getName();
                        if (!name.startsWith("/anim/") || !name.endsWith(".properties") || TextureUtils.isCustomTerrainItemResource(name)) continue;
                        InputStream inputStream = null;
                        try {
                            inputStream = custom.e.getInputStream(zipEntry);
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            CustomAnimation.addStrip(properties);
                        }
                        catch (IOException e2) {
                            try {
                                e2.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                MCPatcherUtils.close(inputStream);
                                throw throwable;
                            }
                            MCPatcherUtils.close(inputStream);
                            continue;
                        }
                        MCPatcherUtils.close(inputStream);
                    }
                } else if (ayd2 instanceof ayg && (folder = ((ayg)ayd2).getFolder()) != null && (folder = new File(folder, "anim")).isDirectory()) {
                    for (File file : folder.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".properties") && !TextureUtils.isCustomTerrainItemResource("/anim/" + name);
                        }
                    })) {
                        FileInputStream inputStream = null;
                        try {
                            inputStream = new FileInputStream(file);
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            CustomAnimation.addStrip(properties);
                        }
                        catch (IOException e3) {
                            try {
                                e3.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                MCPatcherUtils.close(inputStream);
                                throw throwable;
                            }
                            MCPatcherUtils.close(inputStream);
                            continue;
                        }
                        MCPatcherUtils.close(inputStream);
                    }
                }
            }
        }
        for (axd axd3 : savedTextureFX) {
            textureList.add((TextureFX)axd3);
        }
        for (axd axd4 : textureList) {
            axd4.a();
        }
        CustomAnimation.updateAll();
        if (vh.a != um.a) {
            TextureUtils.refreshColorizer(vh.a, "/misc/watercolor.png");
        }
        TextureUtils.refreshColorizer(un.a, "/misc/grasscolor.png");
        TextureUtils.refreshColorizer(um.a, "/misc/foliagecolor.png");
        System.gc();
    }

    private static void addOtherTextureFX(String textureName, String imageName) {
        for (int tileNum = 0; tileNum < 256; ++tileNum) {
            String resource = "/anim/custom_" + imageName + "_" + tileNum + ".png";
            if (!TextureUtils.hasResource(resource)) continue;
            CustomAnimation.addStrip(textureName, imageName + "_" + tileNum, tileNum, 1);
        }
    }

    public static ayd getSelectedTexturePack() {
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        return minecraft == null ? null : (minecraft.C == null ? null : minecraft.C.getSelectedTexturePack());
    }

    public static String getTexturePackName(ayd texturePack) {
        return texturePack == null ? "Default" : texturePack.e;
    }

    public static ByteBuffer getByteBuffer(ByteBuffer buffer, byte[] data) {
        buffer.clear();
        int have = buffer.capacity();
        int needed = data.length;
        if (needed > have || reclaimGLMemory && have >= 4 * needed) {
            buffer = ang.c(needed);
        }
        buffer.put(data);
        buffer.position(0).limit(needed);
        TileSize.int_glBufferSize = needed;
        return buffer;
    }

    public static boolean isRequiredResource(String resource) {
        return resource.equals("/terrain.png") || resource.equals("/gui/items.png");
    }

    static boolean isCustomTerrainItemResource(String resource) {
        return (resource = resource.replaceFirst("^/anim", "").replaceFirst("\\.(png|properties)$", "")).equals("/custom_lava_still") || resource.equals("/custom_lava_flowing") || resource.equals("/custom_water_still") || resource.equals("/custom_water_flowing") || resource.equals("/custom_fire_n_s") || resource.equals("/custom_fire_e_w") || resource.equals("/custom_portal") || resource.matches("^/custom_(terrain|item)_\\d+$");
    }

    public static InputStream getResourceAsStream(ayd texturePack, String resource) {
        InputStream is2 = null;
        if (oldCreativeGui && resource.equals(ALL_ITEMS) && (is2 = TextureUtils.getResourceAsStream(texturePack, ALL_ITEMSX)) != null) {
            return is2;
        }
        if (texturePack != null) {
            try {
                is2 = texturePack.a(resource);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (is2 == null) {
            is2 = TextureUtils.class.getResourceAsStream(resource);
        }
        if (is2 == null && resource.startsWith("/anim/custom_")) {
            is2 = TextureUtils.getResourceAsStream(texturePack, resource.substring(5));
        }
        if (is2 == null && TextureUtils.isRequiredResource(resource)) {
            is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            MCPatcherUtils.warn("falling back on thread class loader for %s: %s", resource, is2 == null ? "failed" : "success");
        }
        return is2;
    }

    public static InputStream getResourceAsStream(String resource) {
        return TextureUtils.getResourceAsStream(TextureUtils.getSelectedTexturePack(), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceAsBufferedImage(ayd texturePack, String resource) throws IOException {
        InputStream is2;
        BufferedImage image = null;
        boolean cached = false;
        if (useTextureCache && texturePack == lastTexturePack && (image = cache.get(resource)) != null) {
            cached = true;
        }
        if (image == null && (is2 = TextureUtils.getResourceAsStream(texturePack, resource)) != null) {
            try {
                image = ImageIO.read(is2);
            }
            finally {
                MCPatcherUtils.close(is2);
            }
        }
        if (image == null) {
            if (TextureUtils.isRequiredResource(resource)) {
                throw new IOException(resource + " image is null");
            }
            return null;
        }
        if (useTextureCache && !cached && texturePack != lastTexturePack) {
            MCPatcherUtils.debug("clearing texture cache (%d items)", cache.size());
            cache.clear();
        }
        MCPatcherUtils.debug("opened %s %dx%d from %s", resource, image.getWidth(), image.getHeight(), cached ? "cache" : TextureUtils.getTexturePackName(texturePack));
        if (!cached) {
            Integer i2 = TextureUtils.isCustomTerrainItemResource(resource) ? Integer.valueOf(1) : expectedColumns.get(resource);
            if (i2 != null && image.getWidth() != i2 * TileSize.int_size) {
                image = TextureUtils.resizeImage(image, i2 * TileSize.int_size);
            }
            if (useTextureCache) {
                lastTexturePack = texturePack;
                cache.put(resource, image);
            }
            if (resource.matches("^/mob/.*_eyes\\d*\\.png$")) {
                int p2 = 0;
                for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                    for (int y2 = 0; y2 < image.getHeight(); ++y2) {
                        int argb = image.getRGB(x2, y2);
                        if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                        image.setRGB(x2, y2, 0);
                        ++p2;
                    }
                }
                if (p2 > 0) {
                    MCPatcherUtils.debug("  fixed %d transparent pixels", p2, resource);
                }
            }
        }
        return image;
    }

    public static BufferedImage getResourceAsBufferedImage(String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(TextureUtils.getSelectedTexturePack(), resource);
    }

    public static BufferedImage getResourceAsBufferedImage(Object o1, String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(resource);
    }

    public static BufferedImage getResourceAsBufferedImage(Object o1, Object o2, String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTileSize(ayd texturePack) {
        int size = 0;
        for (Map.Entry<String, Integer> entry : expectedColumns.entrySet()) {
            InputStream is2;
            block5: {
                is2 = null;
                try {
                    is2 = TextureUtils.getResourceAsStream(texturePack, entry.getKey());
                    if (is2 == null) break block5;
                    BufferedImage bi2 = ImageIO.read(is2);
                    int newSize = bi2.getWidth() / entry.getValue();
                    MCPatcherUtils.debug("  %s tile size is %d", entry.getKey(), newSize);
                    size = Math.max(size, newSize);
                }
                catch (Exception e2) {
                    try {
                        e2.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        MCPatcherUtils.close(is2);
                        throw throwable;
                    }
                    MCPatcherUtils.close(is2);
                    continue;
                }
            }
            MCPatcherUtils.close(is2);
        }
        return size > 0 ? size : 16;
    }

    public static int getTileSize() {
        return TextureUtils.getTileSize(TextureUtils.getSelectedTexturePack());
    }

    public static boolean hasResource(ayd texturePack, String resource) {
        InputStream is2 = TextureUtils.getResourceAsStream(texturePack, resource);
        boolean has = is2 != null;
        MCPatcherUtils.close(is2);
        return has;
    }

    public static boolean hasResource(String s2) {
        return TextureUtils.hasResource(TextureUtils.getSelectedTexturePack(), s2);
    }

    static BufferedImage resizeImage(BufferedImage image, int width) {
        int height = image.getHeight() * width / image.getWidth();
        MCPatcherUtils.debug("  resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private static void refreshColorizer(int[] colorBuffer, String resource) {
        try {
            BufferedImage bi2 = TextureUtils.getResourceAsBufferedImage(resource);
            if (bi2 != null) {
                bi2.getRGB(0, 0, 256, 256, colorBuffer, 0, 256);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTexturePackFile(ayf pack) {
        block7: {
            if (!autoRefreshTextures || pack.e == null) {
                return;
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            ZipFile newZipFile = null;
            try {
                int nread;
                pack.lastModified = pack.a.lastModified();
                pack.tmpFile = File.createTempFile("tmpmc", ".zip");
                pack.tmpFile.deleteOnExit();
                MCPatcherUtils.close(pack.e);
                input = new FileInputStream(pack.a);
                output = new FileOutputStream(pack.tmpFile);
                byte[] buffer = new byte[65536];
                while ((nread = ((InputStream)input).read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, nread);
                }
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                newZipFile = new ZipFile(pack.tmpFile);
                pack.origZip = pack.e;
                pack.e = newZipFile;
                newZipFile = null;
                MCPatcherUtils.debug("copied %s to %s, lastModified = %d", pack.a.getPath(), pack.tmpFile.getPath(), pack.lastModified);
                MCPatcherUtils.close(input);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
            }
            finally {
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                MCPatcherUtils.close(newZipFile);
            }
            MCPatcherUtils.close(output);
            MCPatcherUtils.close(newZipFile);
        }
    }

    public static void closeTexturePackFile(ayf pack) {
        if (pack.origZip != null) {
            MCPatcherUtils.close(pack.e);
            pack.e = pack.origZip;
            pack.origZip = null;
            pack.tmpFile.delete();
            MCPatcherUtils.debug("deleted %s", pack.tmpFile.getPath());
            pack.tmpFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void checkTexturePackChange(Minecraft minecraft) {
        if (!autoRefreshTextures || ++textureRefreshCount < 16) {
            return;
        }
        textureRefreshCount = 0;
        ayi list = minecraft.C;
        if (!(list.getSelectedTexturePack() instanceof ayf)) {
            return;
        }
        ayf pack = (ayf)list.getSelectedTexturePack();
        long lastModified = pack.a.lastModified();
        if (lastModified == pack.lastModified || lastModified == 0L || pack.lastModified == 0L) {
            return;
        }
        MCPatcherUtils.debug("%s lastModified changed from %d to %d", pack.a.getPath(), pack.lastModified, lastModified);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(pack.a);
        }
        catch (IOException e2) {
            MCPatcherUtils.close(zipFile);
            return;
            catch (Throwable throwable) {
                MCPatcherUtils.close(zipFile);
                throw throwable;
            }
        }
        MCPatcherUtils.close(zipFile);
        pack.closeTexturePackFile();
        list.h();
        for (ayd tp2 : list.availableTexturePacks()) {
            if (!(tp2 instanceof ayf)) continue;
            ayf tpc = (ayf)tp2;
            if (!tpc.a.equals(pack.a)) continue;
            MCPatcherUtils.debug("setting new texture pack", new Object[0]);
            list.a(tpc);
            minecraft.o.setTileSize(minecraft);
            return;
        }
        MCPatcherUtils.debug("selected texture pack not found after refresh, switching to default", new Object[0]);
        list.a(list.getDefaultTexturePack());
        minecraft.o.setTileSize(minecraft);
    }

    public static boolean bindImageBegin() {
        if (bindImageReentry) {
            MCPatcherUtils.warn("caught TextureFX.bindImage recursion", new Object[0]);
            return false;
        }
        bindImageReentry = true;
        return true;
    }

    public static void bindImageEnd() {
        bindImageReentry = false;
    }

    static {
        expectedColumns = new HashMap();
        lastTexturePack = null;
        cache = new HashMap();
        animatedFire = MCPatcherUtils.getBoolean("HD Textures", "animatedFire", true);
        animatedLava = MCPatcherUtils.getBoolean("HD Textures", "animatedLava", true);
        animatedWater = MCPatcherUtils.getBoolean("HD Textures", "animatedWater", true);
        animatedPortal = MCPatcherUtils.getBoolean("HD Textures", "animatedPortal", true);
        customFire = MCPatcherUtils.getBoolean("HD Textures", "customFire", true);
        customLava = MCPatcherUtils.getBoolean("HD Textures", "customLava", true);
        customWater = MCPatcherUtils.getBoolean("HD Textures", "customWater", true);
        customPortal = MCPatcherUtils.getBoolean("HD Textures", "customPortal", true);
        customOther = MCPatcherUtils.getBoolean("HD Textures", "customOther", true);
        useTextureCache = MCPatcherUtils.getBoolean("HD Textures", "useTextureCache", false);
        reclaimGLMemory = MCPatcherUtils.getBoolean("HD Textures", "reclaimGLMemory", false);
        autoRefreshTextures = MCPatcherUtils.getBoolean("HD Textures", "autoRefreshTextures", false);
        expectedColumns.put("/terrain.png", 16);
        expectedColumns.put("/gui/items.png", 16);
        expectedColumns.put("/misc/dial.png", 1);
    }
}

