/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.BiomeHelper;
import com.pclewis.mcpatcher.mod.ColorMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class Colorizer {
    private static final String COLOR_PROPERTIES = "/color.properties";
    private static final String LIGHTMAP_FORMAT = "/environment/lightmap%d.png";
    private static final String REDSTONE_COLORS = "/misc/redstonecolor.png";
    private static final String STEM_COLORS = "/misc/stemcolor.png";
    private static final String LAVA_DROP_COLORS = "/misc/lavadropcolor.png";
    private static final String MYCELIUM_COLORS = "/misc/myceliumparticlecolor.png";
    private static final String XPORB_COLORS = "/misc/xporbcolor.png";
    private static final String PALETTE_BLOCK_KEY = "palette.block.";
    private static final String TEXT_KEY = "text.";
    private static final String TEXT_CODE_KEY = "text.code.";
    private static final int COLOR_CODE_UNSET = -2;
    public static final int COLOR_MAP_SWAMP_GRASS = 0;
    public static final int COLOR_MAP_SWAMP_FOLIAGE = 1;
    public static final int COLOR_MAP_PINE = 2;
    public static final int COLOR_MAP_BIRCH = 3;
    public static final int COLOR_MAP_FOLIAGE = 4;
    public static final int COLOR_MAP_WATER = 5;
    public static final int COLOR_MAP_UNDERWATER = 6;
    public static final int COLOR_MAP_FOG0 = 7;
    public static final int COLOR_MAP_SKY0 = 8;
    public static final int NUM_FIXED_COLOR_MAPS = 9;
    private static final String[] MAP_MATERIALS = new String[]{"air", "grass", "sand", "cloth", "tnt", "ice", "iron", "foliage", "snow", "clay", "dirt", "stone", "water", "wood"};
    private static Properties properties;
    private static final ColorMap[] fixedColorMaps;
    private static ColorMap[] blockColorMaps;
    private static final HashMap<Float, ColorMap> blockMetaColorMaps;
    private static int lilypadColor;
    private static float[] waterBaseColor;
    private static float[] lavaDropColors;
    private static int waterBottleColor;
    private static float[][] redstoneColor;
    private static int[] stemColors;
    private static ArrayList<jh> potions;
    private static final Random random;
    private static final boolean useWaterColors;
    private static final boolean useSwampColors;
    private static final boolean useTreeColors;
    private static final boolean usePotionColors;
    private static final boolean useParticleColors;
    private static final boolean useLightmaps;
    private static final boolean useFogColors;
    private static final boolean useCloudType;
    private static final boolean useRedstoneColors;
    private static final boolean useStemColors;
    private static final boolean useEggColors;
    private static final boolean useMapColors;
    private static final boolean useSheepColors;
    private static final boolean useBlockColors;
    private static final boolean useTextColors;
    private static final boolean useXPOrbColors;
    private static final int fogBlendRadius;
    private static final float fogBlendScale;
    private static final int blockBlendRadius;
    private static final float blockBlendScale;
    static ayd lastTexturePack;
    private static final int LIGHTMAP_SIZE = 16;
    private static final float LIGHTMAP_SCALE = 15.0f;
    private static HashMap<Integer, BufferedImage> lightmaps;
    public static final float[] setColor;
    public static float[] waterColor;
    public static float[] portalColor;
    private static final HashMap<Integer, String> entityNamesByID;
    private static final HashMap<Integer, Integer> spawnerEggShellColors;
    private static final HashMap<Integer, Integer> spawnerEggSpotColors;
    private static final int CLOUDS_DEFAULT = 0;
    private static final int CLOUDS_FAST = 1;
    private static final int CLOUDS_FANCY = 2;
    private static int cloudType;
    private static final ArrayList<vj> biomes;
    private static boolean biomesLogged;
    private static jm fogCamera;
    public static float[] netherFogColor;
    public static float[] endFogColor;
    public static int endSkyColor;
    private static int[] myceliumColors;
    private static int[] xpOrbColors;
    private static final HashMap<Integer, Integer> textColorMap;
    private static final int[] textCodeColors;
    private static int signTextColor;

    public static int colorizeBiome(int defaultColor, int index, double temperature, double rainfall) {
        return fixedColorMaps[index].colorize(defaultColor, temperature, rainfall);
    }

    public static int colorizeBiome(int defaultColor, int index) {
        return fixedColorMaps[index].colorize(defaultColor);
    }

    public static int colorizeBiome(int defaultColor, int index, int i2, int j2, int k2) {
        return fixedColorMaps[index].colorize(defaultColor, i2, j2, k2);
    }

    public static int colorizeBiomeWithBlending(int defaultColor, int index, int i2, int j2, int k2) {
        return Colorizer.colorizeWithBlending(fixedColorMaps[index], defaultColor, i2, j2, k2);
    }

    public static int colorizeWater(Object dummy, int i2, int k2) {
        return fixedColorMaps[5].colorize(BiomeHelper.instance.getWaterColorMultiplier(i2, 64, k2), i2, 64, k2);
    }

    public static int colorizeBlock(aif block, int i2, int j2, int k2, int metadata) {
        ColorMap colorMap = null;
        if (!blockMetaColorMaps.isEmpty()) {
            colorMap = blockMetaColorMaps.get(Float.valueOf(ColorMap.getBlockMetaKey(block.ca, metadata)));
        }
        if (colorMap == null && block.ca >= 0 && block.ca < blockColorMaps.length) {
            colorMap = blockColorMaps[block.ca];
        }
        return Colorizer.colorizeWithBlending(colorMap, 0xFFFFFF, i2, j2, k2);
    }

    private static int colorizeWithBlending(ColorMap colorMap, int defaultColor, int i2, int j2, int k2) {
        if (colorMap == null || !colorMap.isCustom() || !BiomeHelper.instance.useBlockBlending() || blockBlendRadius <= 0) {
            return defaultColor;
        }
        float[] sum = new float[3];
        float[] sample = new float[3];
        for (int di2 = -blockBlendRadius; di2 <= blockBlendRadius; ++di2) {
            for (int dk2 = -blockBlendRadius; dk2 <= blockBlendRadius; ++dk2) {
                int rgb = colorMap.colorize(defaultColor, i2 + di2, j2, k2 + dk2);
                Colorizer.intToFloat3(rgb, sample);
                sum[0] = sum[0] + sample[0];
                sum[1] = sum[1] + sample[1];
                sum[2] = sum[2] + sample[2];
            }
        }
        sum[0] = sum[0] * blockBlendScale;
        sum[1] = sum[1] * blockBlendScale;
        sum[2] = sum[2] * blockBlendScale;
        return Colorizer.float3ToInt(sum);
    }

    public static int colorizeBlock(aif block) {
        ColorMap colorMap = blockColorMaps[block.ca];
        if (colorMap == null) {
            return 0xFFFFFF;
        }
        return colorMap.colorize(0xFFFFFF);
    }

    public static int colorizeStem(int defaultColor, int blockMetadata) {
        if (stemColors == null) {
            return defaultColor;
        }
        return stemColors[blockMetadata & 7];
    }

    public static int colorizeSpawnerEgg(int defaultColor, int entityID, int spots) {
        String name;
        HashMap<Integer, Integer> eggMap;
        if (!useEggColors) {
            return defaultColor;
        }
        Integer value = null;
        HashMap<Integer, Integer> hashMap = eggMap = spots == 0 ? spawnerEggShellColors : spawnerEggSpotColors;
        if (eggMap.containsKey(entityID)) {
            value = eggMap.get(entityID);
        } else if (entityNamesByID.containsKey(entityID) && (name = entityNamesByID.get(entityID)) != null) {
            int[] tmp = new int[]{defaultColor};
            Colorizer.loadIntColor((spots == 0 ? "egg.shell." : "egg.spots.") + name, tmp, 0);
            eggMap.put(entityID, tmp[0]);
            value = tmp[0];
        }
        return value == null ? defaultColor : value;
    }

    public static int colorizeText(int defaultColor) {
        int high = defaultColor & 0xFF000000;
        Integer newColor = textColorMap.get(defaultColor &= 0xFFFFFF);
        if (newColor == null) {
            return high | defaultColor;
        }
        return high | newColor;
    }

    public static int colorizeText(int defaultColor, int index) {
        if (index < 0 || index >= textCodeColors.length || textCodeColors[index] == -2) {
            return defaultColor;
        }
        return defaultColor & 0xFF000000 | textCodeColors[index];
    }

    public static int colorizeSignText() {
        return signTextColor;
    }

    public static int colorizeXPOrb(int origColor, float timer) {
        if (xpOrbColors == null || xpOrbColors.length == 0) {
            return origColor;
        }
        return xpOrbColors[(int)((Math.sin((double)timer / 4.0) + 1.0) * (double)(xpOrbColors.length - 1) / 2.0)];
    }

    public static int getWaterBottleColor() {
        return waterBottleColor;
    }

    public static int getLilyPadColor() {
        return lilypadColor;
    }

    public static int getItemColorFromDamage(int defaultColor, int blockID, int damage) {
        if (blockID == 8 || blockID == 9) {
            return Colorizer.colorizeBiome(defaultColor, 5);
        }
        return defaultColor;
    }

    public static boolean computeLightmap(auv renderer, uo world) {
        BufferedImage image;
        if (world == null || !useLightmaps) {
            return false;
        }
        int worldType = world.w.g;
        String name = String.format(LIGHTMAP_FORMAT, worldType);
        if (lightmaps.containsKey(worldType)) {
            image = lightmaps.get(worldType);
        } else {
            image = MCPatcherUtils.readImage(lastTexturePack.a(name));
            lightmaps.put(worldType, image);
            if (image == null) {
                MCPatcherUtils.debug("using default lighting for world %d", worldType);
            } else {
                MCPatcherUtils.debug("using %s", name);
            }
        }
        if (image == null) {
            return false;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (height != 32) {
            MCPatcherUtils.error("%s must be exactly %d pixels high", name, 32);
            lightmaps.put(worldType, null);
            return false;
        }
        int[] origMap = new int[width * height];
        image.getRGB(0, 0, width, height, origMap, 0, width);
        int[] newMap = new int[256];
        float sun = Colorizer.clamp(world.s > 0 ? 1.0f : 1.1666666f * (world.b(1.0f) - 0.2f)) * (float)(width - 1);
        float torch = Colorizer.clamp(renderer.e + 0.5f) * (float)(width - 1);
        float gamma = Colorizer.clamp(MCPatcherUtils.getMinecraft().y.Y);
        float[] sunrgb = new float[48];
        float[] torchrgb = new float[48];
        float[] rgb = new float[3];
        for (int i2 = 0; i2 < 16; ++i2) {
            Colorizer.interpolate(origMap, i2 * width, sun, sunrgb, 3 * i2);
            Colorizer.interpolate(origMap, (i2 + 16) * width, torch, torchrgb, 3 * i2);
        }
        for (int s2 = 0; s2 < 16; ++s2) {
            for (int t2 = 0; t2 < 16; ++t2) {
                int k2;
                for (k2 = 0; k2 < 3; ++k2) {
                    rgb[k2] = Colorizer.clamp(sunrgb[3 * s2 + k2] + torchrgb[3 * t2 + k2]);
                }
                if (gamma != 0.0f) {
                    for (k2 = 0; k2 < 3; ++k2) {
                        float tmp = 1.0f - rgb[k2];
                        tmp = 1.0f - tmp * tmp * tmp * tmp;
                        rgb[k2] = gamma * tmp + (1.0f - gamma) * rgb[k2];
                    }
                }
                newMap[s2 * 16 + t2] = 0xFF000000 | Colorizer.float3ToInt(rgb);
            }
        }
        MCPatcherUtils.getMinecraft().o.a(newMap, 16, 16, renderer.d);
        return true;
    }

    public static boolean computeRedstoneWireColor(int current) {
        if (redstoneColor == null) {
            return false;
        }
        System.arraycopy(redstoneColor[Math.max(Math.min(current, 15), 0)], 0, setColor, 0, 3);
        return true;
    }

    public static int colorizeRedstoneWire(uy blockAccess, int i2, int j2, int k2, int defaultColor) {
        if (redstoneColor == null) {
            return defaultColor;
        }
        int metadata = Math.max(Math.min(blockAccess.g(i2, j2, k2), 15), 0);
        return Colorizer.float3ToInt(redstoneColor[metadata]);
    }

    public static boolean computeWaterColor(double x2, double y2, double z) {
        if (useParticleColors && fixedColorMaps[5].isCustom()) {
            int rgb = Colorizer.colorizeBiome(0xFFFFFF, 5, (int)x2, (int)y2, (int)z);
            float[] multiplier = new float[3];
            Colorizer.intToFloat3(rgb, multiplier);
            for (int i2 = 0; i2 < 3; ++i2) {
                Colorizer.waterColor[i2] = multiplier[i2] * waterBaseColor[i2];
            }
            return true;
        }
        return false;
    }

    public static void computeWaterColor() {
        int rgb = Colorizer.colorizeBiome(0xFFFFFF, 5);
        Colorizer.intToFloat3(rgb, waterColor);
    }

    public static void colorizeWaterBlockGL(int blockID) {
        if (blockID == 8 || blockID == 9) {
            Colorizer.computeWaterColor();
            GL11.glColor4f((float)waterColor[0], (float)waterColor[1], (float)waterColor[2], (float)1.0f);
        }
    }

    public static boolean computeLavaDropColor(int age2) {
        if (lavaDropColors == null) {
            return false;
        }
        int offset = 3 * Math.max(Math.min(lavaDropColors.length / 3 - 1, age2), 0);
        System.arraycopy(lavaDropColors, offset, setColor, 0, 3);
        return true;
    }

    public static void setupBlockAccess(uy blockAccess, boolean newBiomes) {
        Colorizer.checkUpdate();
        BiomeHelper.instance = blockAccess == null ? new BiomeHelper.Stub() : (newBiomes ? new BiomeHelper.New(blockAccess) : new BiomeHelper.Old(blockAccess));
    }

    public static void setupForFog(jm entity) {
        fogCamera = entity;
        if (!biomesLogged) {
            biomesLogged = true;
            for (vj biome : biomes) {
                int x2 = ColorMap.getX(biome.F, biome.G);
                int y2 = ColorMap.getY(biome.F, biome.G);
                MCPatcherUtils.debug("setupBiome #%d \"%s\" %06x (%d,%d)", biome.M, biome.y, biome.H, x2, y2);
            }
        }
    }

    public static boolean computeFogColor(int index) {
        if (index < 0 || index >= fixedColorMaps.length || fogCamera == null || !fixedColorMaps[index].isCustom()) {
            return false;
        }
        float[] f2 = new float[3];
        int x2 = (int)Colorizer.fogCamera.t;
        int y2 = (int)Colorizer.fogCamera.u;
        int z = (int)Colorizer.fogCamera.v;
        Colorizer.setColor[0] = 0.0f;
        Colorizer.setColor[1] = 0.0f;
        Colorizer.setColor[2] = 0.0f;
        for (int i2 = -fogBlendRadius; i2 <= fogBlendRadius; ++i2) {
            for (int j2 = -fogBlendRadius; j2 <= fogBlendRadius; ++j2) {
                int rgb = Colorizer.colorizeBiome(0xFFFFFF, index, x2 + i2, y2, z + j2);
                Colorizer.intToFloat3(rgb, f2);
                setColor[0] = setColor[0] + f2[0];
                setColor[1] = setColor[1] + f2[1];
                setColor[2] = setColor[2] + f2[2];
            }
        }
        setColor[0] = setColor[0] * fogBlendScale;
        setColor[1] = setColor[1] * fogBlendScale;
        setColor[2] = setColor[2] * fogBlendScale;
        return true;
    }

    public static boolean computeFogColor(uo world, float f2) {
        if (world.w.g == 0 && Colorizer.computeFogColor(7)) {
            Colorizer.computeLightningFlash(world, f2);
            return true;
        }
        return false;
    }

    public static boolean computeSkyColor(uo world, float f2) {
        if (world.w.g == 0 && Colorizer.computeFogColor(8)) {
            Colorizer.computeLightningFlash(world, f2);
            return true;
        }
        return false;
    }

    private static void computeLightningFlash(uo world, float f2) {
        if (world.s > 0) {
            f2 = 0.45f * Colorizer.clamp((float)world.s - f2);
            Colorizer.setColor[0] = setColor[0] * (1.0f - f2) + 0.8f * f2;
            Colorizer.setColor[1] = setColor[1] * (1.0f - f2) + 0.8f * f2;
            Colorizer.setColor[2] = setColor[2] * (1.0f - f2) + 0.8f * f2;
        }
    }

    public static boolean computeMyceliumParticleColor() {
        if (myceliumColors == null) {
            return false;
        }
        Colorizer.setColorF(myceliumColors[random.nextInt(myceliumColors.length)]);
        return true;
    }

    public static void setColorF(int color) {
        Colorizer.intToFloat3(color, setColor);
    }

    public static void setupBiome(vj biome) {
        biomes.add(biome);
    }

    public static void setupPotion(jh potion) {
        MCPatcherUtils.debug("setupPotion #%d \"%s\" %06x", potion.H, potion.I, potion.N);
        potion.origColor = potion.N;
        potions.add(potion);
    }

    public static void setupSpawnerEgg(String entityName, int entityID, int defaultShellColor, int defaultSpotColor) {
        MCPatcherUtils.debug("setupSpawnerEgg #%d \"%s\" %06x %06x", entityID, entityName, defaultShellColor, defaultSpotColor);
        entityNamesByID.put(entityID, entityName);
    }

    public static boolean drawFancyClouds(boolean fancyGraphics) {
        switch (cloudType) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return fancyGraphics;
    }

    private static void checkUpdate() {
        if (lastTexturePack == MCPatcherUtils.getMinecraft().C.getSelectedTexturePack()) {
            return;
        }
        lastTexturePack = MCPatcherUtils.getMinecraft().C.getSelectedTexturePack();
        Colorizer.reset();
        Colorizer.reloadColorProperties();
        if (useFogColors) {
            Colorizer.reloadFogColors();
        }
        if (usePotionColors) {
            Colorizer.reloadPotionColors();
        }
        if (useSwampColors) {
            Colorizer.reloadSwampColors();
        }
        if (useBlockColors) {
            Colorizer.reloadBlockColors();
        }
        if (useParticleColors) {
            Colorizer.reloadParticleColors();
        }
        if (useRedstoneColors) {
            Colorizer.reloadRedstoneColors();
        }
        if (useStemColors) {
            Colorizer.reloadStemColors();
        }
        if (useCloudType) {
            Colorizer.reloadCloudType();
        }
        if (useMapColors) {
            Colorizer.reloadMapColors();
        }
        if (useSheepColors) {
            Colorizer.reloadSheepColors();
        }
        if (useTextColors) {
            Colorizer.reloadTextColors();
        }
        if (useXPOrbColors) {
            Colorizer.reloadXPOrbColors();
        }
    }

    private static void reset() {
        properties = new Properties();
        Colorizer.fixedColorMaps[0] = new ColorMap(useSwampColors, "/misc/swampgrasscolor.png", 0x4E4E4E);
        Colorizer.fixedColorMaps[1] = new ColorMap(useSwampColors, "/misc/swampfoliagecolor.png", 0x4E4E4E);
        Colorizer.fixedColorMaps[2] = new ColorMap(useTreeColors, "/misc/pinecolor.png", 0x619961);
        Colorizer.fixedColorMaps[3] = new ColorMap(useTreeColors, "/misc/birchcolor.png", 8431445);
        Colorizer.fixedColorMaps[4] = new ColorMap(useTreeColors, "/misc/foliagecolor.png", 4764952);
        fixedColorMaps[4].clear();
        Colorizer.fixedColorMaps[5] = new ColorMap(useWaterColors, "/misc/watercolorX.png", 0xFFFFFF);
        Colorizer.fixedColorMaps[6] = new ColorMap(useWaterColors, "/misc/underwatercolor.png", 329011);
        Colorizer.fixedColorMaps[7] = new ColorMap(useFogColors, "/misc/fogcolor0.png", 12638463);
        Colorizer.fixedColorMaps[8] = new ColorMap(useFogColors, "/misc/skycolor0.png", 0xFFFFFF);
        netherFogColor = new float[]{0.2f, 0.03f, 0.03f};
        endFogColor = new float[]{0.075f, 0.075f, 0.094f};
        endSkyColor = 0x181818;
        blockColorMaps = new ColorMap[aif.m.length];
        blockMetaColorMaps.clear();
        lilypadColor = 2129968;
        waterBaseColor = new float[]{0.2f, 0.3f, 1.0f};
        waterColor = new float[]{0.2f, 0.3f, 1.0f};
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        lavaDropColors = null;
        waterBottleColor = 3694022;
        redstoneColor = null;
        stemColors = null;
        lightmaps.clear();
        spawnerEggShellColors.clear();
        spawnerEggSpotColors.clear();
        cloudType = 0;
        for (jh potion : potions) {
            potion.N = potion.origColor;
        }
        for (acp mapColor : acp.a) {
            if (mapColor == null) continue;
            mapColor.p = mapColor.origColorValue;
        }
        mt.d = (float[][])mt.origFleeceColorTable.clone();
        myceliumColors = null;
        xpOrbColors = null;
        textColorMap.clear();
        for (int i2 = 0; i2 < textCodeColors.length; ++i2) {
            Colorizer.textCodeColors[i2] = -2;
        }
        signTextColor = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadColorProperties() {
        InputStream inputStream = null;
        try {
            inputStream = lastTexturePack.a(COLOR_PROPERTIES);
            if (inputStream != null) {
                MCPatcherUtils.debug("reloading %s", COLOR_PROPERTIES);
                properties.load(inputStream);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            MCPatcherUtils.close(inputStream);
        }
    }

    private static void reloadFogColors() {
        Colorizer.loadFloatColor("fog.nether", netherFogColor);
        Colorizer.loadFloatColor("fog.end", endFogColor);
        endSkyColor = Colorizer.loadIntColor("sky.end", endSkyColor);
    }

    private static void reloadPotionColors() {
        for (jh potion : potions) {
            Colorizer.loadIntColor(potion.I, potion);
        }
        int[] temp = new int[]{waterBottleColor};
        Colorizer.loadIntColor("potion.water", temp, 0);
        waterBottleColor = temp[0];
    }

    private static void reloadSwampColors() {
        int[] temp = new int[]{lilypadColor};
        Colorizer.loadIntColor("lilypad", temp, 0);
        lilypadColor = temp[0];
    }

    private static void reloadBlockColors() {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ColorMap colorMap;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(PALETTE_BLOCK_KEY) || !(colorMap = new ColorMap(true, key = key.substring(PALETTE_BLOCK_KEY.length()).trim(), 0xFFFFFF)).isCustom()) continue;
            block7: for (String idString : value.split("\\s+")) {
                String[] tokens = idString.split(":");
                int[] tokensInt = new int[tokens.length];
                try {
                    for (int i2 = 0; i2 < tokens.length; ++i2) {
                        tokensInt[i2] = Integer.parseInt(tokens[i2]);
                    }
                }
                catch (NumberFormatException e2) {
                    continue;
                }
                switch (tokensInt.length) {
                    case 1: {
                        if (tokensInt[0] < 0 || tokensInt[0] >= blockColorMaps.length) continue block7;
                        Colorizer.blockColorMaps[tokensInt[0]] = colorMap;
                        break;
                    }
                    case 2: {
                        blockMetaColorMaps.put(Float.valueOf(ColorMap.getBlockMetaKey(tokensInt[0], tokensInt[1])), colorMap);
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                MCPatcherUtils.debug("using %s for block %s, default color %06x", key, idString, colorMap.colorize());
            }
        }
    }

    private static void reloadParticleColors() {
        Colorizer.loadFloatColor("drop.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.portal", portalColor);
        int[] rgb = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(lastTexturePack.a(LAVA_DROP_COLORS)));
        if (rgb != null) {
            lavaDropColors = new float[3 * rgb.length];
            for (int i2 = 0; i2 < rgb.length; ++i2) {
                Colorizer.intToFloat3(rgb[i2], lavaDropColors, 3 * i2);
            }
        }
        myceliumColors = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(lastTexturePack.a(MYCELIUM_COLORS)));
    }

    private static void reloadRedstoneColors() {
        int[] rgb = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(lastTexturePack.a(REDSTONE_COLORS)));
        if (rgb != null && rgb.length >= 16) {
            redstoneColor = new float[16][];
            for (int i2 = 0; i2 < 16; ++i2) {
                float[] f2 = new float[3];
                Colorizer.intToFloat3(rgb[i2], f2);
                Colorizer.redstoneColor[i2] = f2;
            }
        }
    }

    private static void reloadStemColors() {
        int[] rgb = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(lastTexturePack.a(STEM_COLORS)));
        if (rgb != null && rgb.length >= 8) {
            stemColors = rgb;
        }
    }

    private static void reloadCloudType() {
        String value = properties.getProperty("clouds", "").trim().toLowerCase();
        if (value.equals("fast")) {
            cloudType = 1;
        } else if (value.equals("fancy")) {
            cloudType = 2;
        }
    }

    private static void reloadMapColors() {
        for (int i2 = 0; i2 < acp.a.length; ++i2) {
            if (acp.a[i2] == null) continue;
            int[] rgb = new int[]{acp.a[i2].origColorValue};
            Colorizer.loadIntColor("map." + Colorizer.getStringKey(MAP_MATERIALS, i2), rgb, 0);
            acp.a[i2].p = rgb[0];
        }
    }

    private static void reloadSheepColors() {
        for (int i2 = 0; i2 < mt.d.length; ++i2) {
            Colorizer.loadFloatColor("sheep." + Colorizer.getStringKey(qu.a, mt.d.length - 1 - i2), mt.d[i2]);
        }
    }

    private static void reloadTextColors() {
        for (int i2 = 0; i2 < textCodeColors.length; ++i2) {
            Colorizer.loadIntColor(TEXT_CODE_KEY + i2, textCodeColors, i2);
            if (textCodeColors[i2] == -2 || i2 + 16 >= textCodeColors.length) continue;
            Colorizer.textCodeColors[i2 + 16] = (textCodeColors[i2] & 0xFCFCFC) >> 2;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(TEXT_KEY) || key.startsWith(TEXT_CODE_KEY)) continue;
            key = key.substring(TEXT_KEY.length()).trim();
            try {
                int oldColor = key.equals("xpbar") ? 8453920 : (key.equals("boss") ? 0xFF00FF : Integer.parseInt(key, 16));
                int newColor = Integer.parseInt(value, 16);
                textColorMap.put(oldColor, newColor);
            }
            catch (NumberFormatException e2) {}
        }
        signTextColor = Colorizer.loadIntColor("text.sign", 0);
    }

    private static void reloadXPOrbColors() {
        xpOrbColors = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(lastTexturePack.a(XPORB_COLORS)));
    }

    private static String getStringKey(String[] keys, int index) {
        if (keys != null && index >= 0 && index < keys.length && keys[index] != null) {
            return keys[index];
        }
        return "" + index;
    }

    private static void loadIntColor(String key, jh potion) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                potion.N = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void loadIntColor(String key, int[] color, int index) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                color[index] = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
    }

    private static int loadIntColor(String key, int color) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                color = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private static void loadFloatColor(String key, float[] color) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                Colorizer.intToFloat3(Integer.parseInt(value, 16), color);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static float[] loadFloatColor(String key) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                float[] color = new float[3];
                Colorizer.intToFloat3(Integer.parseInt(value, 16), color);
                return color;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void intToFloat3(int rgb, float[] f2, int offset) {
        f2[offset] = (float)(rgb & 0xFF0000) / 1.671168E7f;
        f2[offset + 1] = (float)(rgb & 0xFF00) / 65280.0f;
        f2[offset + 2] = (float)(rgb & 0xFF) / 255.0f;
    }

    private static void intToFloat3(int rgb, float[] f2) {
        Colorizer.intToFloat3(rgb, f2, 0);
    }

    private static int float3ToInt(float[] f2, int offset) {
        return (int)(255.0f * f2[offset]) << 16 | (int)(255.0f * f2[offset + 1]) << 8 | (int)(255.0f * f2[offset + 2]);
    }

    private static int float3ToInt(float[] f2) {
        return Colorizer.float3ToInt(f2, 0);
    }

    private static float clamp(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    static double clamp(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    private static void clamp(float[] f2) {
        for (int i2 = 0; i2 < f2.length; ++i2) {
            f2[i2] = Colorizer.clamp(f2[i2]);
        }
    }

    private static void interpolate(int[] map, int offset1, float x2, float[] rgb, int offset2) {
        int x1;
        int x0 = (int)Math.floor(x2);
        if (x0 == (x1 = (int)Math.ceil(x2))) {
            Colorizer.intToFloat3(map[offset1 + x0], rgb, offset2);
        } else {
            float xf2 = x2 - (float)x0;
            float xg = 1.0f - xf2;
            float[] rgb0 = new float[3];
            float[] rgb1 = new float[3];
            Colorizer.intToFloat3(map[offset1 + x0], rgb0);
            Colorizer.intToFloat3(map[offset1 + x1], rgb1);
            for (int i2 = 0; i2 < 3; ++i2) {
                rgb[offset2 + i2] = xg * rgb0[i2] + xf2 * rgb1[i2];
            }
        }
    }

    private static float getBlendScale(int radius) {
        return 1.0f / (float)((2 * radius + 1) * (2 * radius + 1));
    }

    static {
        fixedColorMaps = new ColorMap[9];
        blockMetaColorMaps = new HashMap();
        potions = new ArrayList();
        random = new Random();
        useWaterColors = MCPatcherUtils.getBoolean("Custom Colors", "water", true);
        useSwampColors = MCPatcherUtils.getBoolean("Custom Colors", "swamp", true);
        useTreeColors = MCPatcherUtils.getBoolean("Custom Colors", "tree", true);
        usePotionColors = MCPatcherUtils.getBoolean("Custom Colors", "potion", true);
        useParticleColors = MCPatcherUtils.getBoolean("Custom Colors", "particle", true);
        useLightmaps = MCPatcherUtils.getBoolean("Custom Colors", "lightmaps", true);
        useFogColors = MCPatcherUtils.getBoolean("Custom Colors", "fog", true);
        useCloudType = MCPatcherUtils.getBoolean("Custom Colors", "clouds", true);
        useRedstoneColors = MCPatcherUtils.getBoolean("Custom Colors", "redstone", true);
        useStemColors = MCPatcherUtils.getBoolean("Custom Colors", "stem", true);
        useEggColors = MCPatcherUtils.getBoolean("Custom Colors", "egg", true);
        useMapColors = MCPatcherUtils.getBoolean("Custom Colors", "map", true);
        useSheepColors = MCPatcherUtils.getBoolean("Custom Colors", "sheep", true);
        useBlockColors = MCPatcherUtils.getBoolean("Custom Colors", "otherBlocks", true);
        useTextColors = MCPatcherUtils.getBoolean("Custom Colors", "text", true);
        useXPOrbColors = MCPatcherUtils.getBoolean("Custom Colors", "xporb", true);
        fogBlendRadius = MCPatcherUtils.getInt("Custom Colors", "fogBlendRadius", 7);
        fogBlendScale = Colorizer.getBlendScale(fogBlendRadius);
        blockBlendRadius = MCPatcherUtils.getInt("Custom Colors", "blockBlendRadius", 1);
        blockBlendScale = Colorizer.getBlendScale(blockBlendRadius);
        lightmaps = new HashMap();
        setColor = new float[3];
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        entityNamesByID = new HashMap();
        spawnerEggShellColors = new HashMap();
        spawnerEggSpotColors = new HashMap();
        cloudType = 0;
        biomes = new ArrayList();
        textColorMap = new HashMap();
        textCodeColors = new int[32];
    }
}

