/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;

abstract class BiomeHelper {
    static BiomeHelper instance;
    uy blockAccess;

    BiomeHelper(uy blockAccess) {
        this.blockAccess = blockAccess;
    }

    boolean useBlockBlending() {
        return false;
    }

    abstract vj getBiomeGenAt(int var1, int var2, int var3);

    abstract float getTemperature(int var1, int var2, int var3);

    abstract float getRainfall(int var1, int var2, int var3);

    abstract int getWaterColorMultiplier(int var1, int var2, int var3);

    static class New
    extends BiomeHelper {
        private static boolean logged;
        private vj lastBiome;
        private int lastI;
        private int lastK;

        New(uy blockAccess) {
            super(blockAccess);
            if (!logged) {
                logged = true;
                MCPatcherUtils.debug("biomes v1.2 detected", new Object[0]);
            }
        }

        boolean useBlockBlending() {
            return true;
        }

        vj getBiomeGenAt(int i2, int j2, int k2) {
            if (this.lastBiome == null || i2 != this.lastI || k2 != this.lastK) {
                this.lastI = i2;
                this.lastK = k2;
                this.lastBiome = this.blockAccess.a(i2, k2);
            }
            return this.lastBiome;
        }

        float getTemperature(int i2, int j2, int k2) {
            return this.getBiomeGenAt(i2, j2, k2).j();
        }

        float getRainfall(int i2, int j2, int k2) {
            return this.getBiomeGenAt(i2, j2, k2).i();
        }

        int getWaterColorMultiplier(int i2, int j2, int k2) {
            return this.getBiomeGenAt((int)i2, (int)j2, (int)k2).H;
        }
    }

    static class Old
    extends BiomeHelper {
        vo chunkManager;

        Old(uy blockAccess) {
            super(blockAccess);
            this.chunkManager = blockAccess.getWorldChunkManager();
        }

        vj getBiomeGenAt(int i2, int j2, int k2) {
            return this.chunkManager.a(i2, k2);
        }

        float getTemperature(int i2, int j2, int k2) {
            return this.chunkManager.getTemperature(i2, j2, k2);
        }

        float getRainfall(int i2, int j2, int k2) {
            return this.chunkManager.getRainfall(i2, k2);
        }

        int getWaterColorMultiplier(int i2, int j2, int k2) {
            return this.getBiomeGenAt((int)i2, (int)j2, (int)k2).H;
        }
    }

    static class Stub
    extends BiomeHelper {
        Stub() {
            super(null);
        }

        vj getBiomeGenAt(int i2, int j2, int k2) {
            return null;
        }

        float getTemperature(int i2, int j2, int k2) {
            return 0.5f;
        }

        float getRainfall(int i2, int j2, int k2) {
            return 1.0f;
        }

        int getWaterColorMultiplier(int i2, int j2, int k2) {
            return 0xFFFFFF;
        }
    }
}

