/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;

public class FontUtils {
    private static final int ROWS = 16;
    private static final int COLS = 16;
    public static final char[] AVERAGE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123467890".toCharArray();
    public static final int[] SPACERS = new int[]{33721342, 0x2808080, 0xDFFFFFF};
    private static final boolean showLines = false;
    private static Method getResource;

    public static float[] computeCharWidths(String filename, BufferedImage image, int[] rgb, int[] charWidth) {
        int ch2;
        MCPatcherUtils.debug("computeCharWidths(%s)", filename);
        float[] charWidthf = new float[charWidth.length];
        int width = image.getWidth();
        int height = image.getHeight();
        int colWidth = width / 16;
        int rowHeight = height / 16;
        block2: for (ch2 = 0; ch2 < charWidth.length; ++ch2) {
            int row = ch2 / 16;
            int col = ch2 % 16;
            for (int colIdx = colWidth - 1; colIdx >= 0; --colIdx) {
                int x2 = col * colWidth + colIdx;
                for (int rowIdx = 0; rowIdx < rowHeight; ++rowIdx) {
                    int y2 = row * rowHeight + rowIdx;
                    int pixel = rgb[x2 + y2 * width];
                    if (!FontUtils.isOpaque(pixel)) continue;
                    if (FontUtils.printThis(ch2)) {
                        MCPatcherUtils.debug("'%c' pixel (%d, %d) = %08x, colIdx = %d", Character.valueOf((char)ch2), x2, y2, pixel, colIdx);
                    }
                    charWidthf[ch2] = 128.0f * (float)(colIdx + 1) / (float)width + 1.0f;
                    continue block2;
                }
            }
        }
        for (ch2 = 0; ch2 < charWidthf.length; ++ch2) {
            if (charWidthf[ch2] <= 0.0f) {
                charWidthf[ch2] = 2.0f;
                continue;
            }
            if (!(charWidthf[ch2] >= 7.99f)) continue;
            charWidthf[ch2] = 7.99f;
        }
        boolean[] isOverride = new boolean[charWidth.length];
        try {
            FontUtils.getCharWidthOverrides(filename, charWidthf, isOverride);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        if (!isOverride[32]) {
            charWidthf[32] = FontUtils.defaultSpaceWidth(charWidthf);
        }
        for (int ch3 = 0; ch3 < charWidth.length; ++ch3) {
            charWidth[ch3] = Math.round(charWidthf[ch3]);
            if (!FontUtils.printThis(ch3)) continue;
            MCPatcherUtils.debug("charWidth['%c'] = %f", Character.valueOf((char)ch3), Float.valueOf(charWidthf[ch3]));
        }
        return charWidthf;
    }

    public static float getCharWidthf(aou fontRenderer, char ch2) {
        float width = fontRenderer.a(ch2);
        if (width < 0.0f || ch2 >= fontRenderer.charWidthf.length || ch2 < '\u0000') {
            return width;
        }
        return fontRenderer.charWidthf[ch2];
    }

    public static float getStringWidthf(aou fontRenderer, String s2) {
        float totalWidth = 0.0f;
        if (s2 != null) {
            boolean isLink = false;
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char c2 = s2.charAt(i2);
                float cWidth = fontRenderer.a(c2);
                if (cWidth < 0.0f && i2 < s2.length() - 1) {
                    c2 = s2.charAt(i2 + 1);
                    if (c2 == 'l' || c2 == 'L') {
                        isLink = true;
                    } else if (c2 == 'r' || c2 == 'R' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') {
                        isLink = false;
                    }
                    cWidth = fontRenderer.a(c2);
                }
                totalWidth += cWidth;
                if (!isLink) continue;
                totalWidth += 1.0f;
            }
        }
        return totalWidth;
    }

    private static boolean isOpaque(int pixel) {
        for (int i2 : SPACERS) {
            if (pixel != i2) continue;
            return false;
        }
        return (pixel >> 24 & 0xF0) > 0;
    }

    private static boolean printThis(int ch2) {
        return "ABCDEF abcdef".indexOf(ch2) >= 0;
    }

    private static float defaultSpaceWidth(float[] charWidthf) {
        float sum = 0.0f;
        int n2 = 0;
        for (char ch2 : AVERAGE_CHARS) {
            if (!(charWidthf[ch2] > 0.0f)) continue;
            sum += charWidthf[ch2];
            ++n2;
        }
        if (n2 > 0) {
            return sum / (float)n2 * 0.5f;
        }
        return 4.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getCharWidthOverrides(String font, float[] charWidthf, boolean[] isOverride) {
        InputStream is2;
        if (getResource == null) {
            return;
        }
        String textFile = font.replace(".png", ".properties");
        try {
            Object o2 = getResource.invoke(null, textFile);
            if (!(o2 instanceof InputStream)) {
                return;
            }
            is2 = (InputStream)o2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        MCPatcherUtils.debug("reading character widths from %s", textFile);
        try {
            Properties props = new Properties();
            props.load(is2);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString().trim();
                String value = entry.getValue().toString().trim();
                if (!key.matches("^width\\.\\d+$") || value.equals("")) continue;
                try {
                    int ch2 = Integer.parseInt(key.substring(6));
                    float width = Float.parseFloat(value);
                    if (ch2 < 0 || ch2 >= charWidthf.length) continue;
                    MCPatcherUtils.debug("    setting charWidthf[%d] to %f", ch2, Float.valueOf(width));
                    charWidthf[ch2] = width;
                    isOverride[ch2] = true;
                }
                catch (NumberFormatException e3) {}
            }
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        finally {
            MCPatcherUtils.close(is2);
        }
    }

    static {
        try {
            Class<?> utils = Class.forName("com.pclewis.mcpatcher.mod.TextureUtils");
            try {
                getResource = utils.getDeclaredMethod("getResourceAsStream", String.class);
            }
            catch (NoSuchMethodException e2) {
                e2.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

