/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.TextureUtils;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class CustomAnimation {
    private static final String CLASS_NAME = CustomAnimation.class.getSimpleName();
    private static Random rand = new Random();
    private static final ArrayList<CustomAnimation> animations = new ArrayList();
    private final String textureName;
    private final String srcName;
    private final int textureID;
    private final ByteBuffer imageData;
    private final int tileCount;
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private int currentFrame;
    private int currentDelay;
    private int numFrames;
    private Delegate delegate;

    public static void updateAll() {
        for (CustomAnimation animation : animations) {
            animation.update();
        }
    }

    static void clear() {
        animations.clear();
    }

    static void addStrip(Properties properties) {
        try {
            String textureName = properties.getProperty("to", "");
            String srcName = properties.getProperty("from", "");
            int tileCount = Integer.parseInt(properties.getProperty("tiles", "1"));
            int x2 = Integer.parseInt(properties.getProperty("x", ""));
            int y2 = Integer.parseInt(properties.getProperty("y", ""));
            int w2 = Integer.parseInt(properties.getProperty("w", ""));
            int h2 = Integer.parseInt(properties.getProperty("h", ""));
            if (!"".equals(textureName) && !"".equals(srcName)) {
                CustomAnimation.add(CustomAnimation.newStrip(textureName, tileCount, srcName, TextureUtils.getResourceAsBufferedImage(srcName), x2, y2, w2, h2, properties));
            }
        }
        catch (IOException e2) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static void addStripOrTile(String textureName, String name, int tileNumber, int tileCount, int minScrollDelay, int maxScrollDelay) {
        if (!CustomAnimation.addStrip(textureName, name, tileNumber, tileCount)) {
            CustomAnimation.add(CustomAnimation.newTile(textureName, tileCount, tileNumber, minScrollDelay, maxScrollDelay));
        }
    }

    static boolean addStrip(String textureName, String name, int tileNumber, int tileCount) {
        String srcName = "/anim/custom_" + name + ".png";
        if (TextureUtils.hasResource(srcName)) {
            try {
                BufferedImage srcImage = TextureUtils.getResourceAsBufferedImage(srcName);
                if (srcImage != null) {
                    CustomAnimation.add(CustomAnimation.newStrip(textureName, tileCount, srcName, srcImage, tileNumber % 16 * TileSize.int_size, tileNumber / 16 * TileSize.int_size, TileSize.int_size, TileSize.int_size, null));
                    return true;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }

    private static void add(CustomAnimation animation) {
        if (animation != null) {
            animations.add(animation);
            MCPatcherUtils.debug("new %s %s %dx%d -> %s @ %d,%d (%d frames)", CLASS_NAME, animation.srcName, animation.w, animation.h, animation.textureName, animation.x, animation.y, animation.numFrames);
        }
    }

    private static CustomAnimation newStrip(String textureName, int tileCount, String srcName, BufferedImage srcImage, int x2, int y2, int w2, int h2, Properties properties) throws IOException {
        if (x2 < 0 || y2 < 0 || w2 <= 0 || h2 <= 0 || tileCount <= 0) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d,count=%d", CLASS_NAME, srcName, x2, y2, w2, h2, tileCount);
            return null;
        }
        int textureID = MCPatcherUtils.getMinecraft().o.b(textureName);
        if (textureID <= 0) {
            MCPatcherUtils.error("%s: invalid id %d for texture %s", CLASS_NAME, textureID, textureName);
            return null;
        }
        GL11.glBindTexture((int)3553, (int)textureID);
        int destWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int destHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (x2 + tileCount * w2 > destWidth || y2 + tileCount * h2 > destHeight) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d,count=%d", CLASS_NAME, srcName, x2, y2, w2, h2, tileCount);
            return null;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        if (width != w2) {
            srcImage = TextureUtils.resizeImage(srcImage, w2);
            width = srcImage.getWidth();
            height = srcImage.getHeight();
        }
        if (width != w2 || height < h2) {
            MCPatcherUtils.error("%s: %s dimensions %dx%d do not match %dx%d", CLASS_NAME, srcName, width, height, w2, h2);
            return null;
        }
        ByteBuffer imageData = ByteBuffer.allocateDirect(4 * width * height);
        int[] argb = new int[width * height];
        byte[] rgba = new byte[4 * width * height];
        srcImage.getRGB(0, 0, width, height, argb, 0, width);
        CustomAnimation.ARGBtoRGBA(argb, rgba);
        imageData.put(rgba);
        return new CustomAnimation(srcName, textureName, textureID, tileCount, x2, y2, w2, h2, imageData, height / h2, properties);
    }

    private static CustomAnimation newTile(String textureName, int tileCount, int tileNumber, int minScrollDelay, int maxScrollDelay) {
        int x2 = tileNumber % 16 * TileSize.int_size;
        int y2 = tileNumber / 16 * TileSize.int_size;
        int w2 = TileSize.int_size;
        int h2 = TileSize.int_size;
        if (x2 < 0 || y2 < 0 || w2 <= 0 || h2 <= 0 || x2 + tileCount * w2 > 16 * TileSize.int_size || y2 + tileCount * h2 > 16 * TileSize.int_size) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d", CLASS_NAME, textureName, x2, y2, w2, h2);
            return null;
        }
        int textureID = MCPatcherUtils.getMinecraft().o.b(textureName);
        if (textureID <= 0) {
            MCPatcherUtils.error("%s: invalid id %d for texture %s", CLASS_NAME, textureID, textureName);
            return null;
        }
        try {
            return new CustomAnimation(textureName, textureID, tileCount, x2, y2, w2, h2, minScrollDelay, maxScrollDelay);
        }
        catch (IOException e2) {
            return null;
        }
    }

    private CustomAnimation(String srcName, String textureName, int textureID, int tileCount, int x2, int y2, int w2, int h2, ByteBuffer imageData, int numFrames, Properties properties) {
        this.srcName = srcName;
        this.textureName = textureName;
        this.textureID = textureID;
        this.tileCount = tileCount;
        this.x = x2;
        this.y = y2;
        this.w = w2;
        this.h = h2;
        this.imageData = imageData;
        this.numFrames = numFrames;
        this.currentFrame = -1;
        this.delegate = new Strip(properties);
    }

    private CustomAnimation(String textureName, int textureID, int tileCount, int x2, int y2, int w2, int h2, int minScrollDelay, int maxScrollDelay) throws IOException {
        this.srcName = textureName;
        this.textureName = textureName;
        this.textureID = textureID;
        this.tileCount = tileCount;
        this.x = x2;
        this.y = y2;
        this.w = w2;
        this.h = h2;
        this.imageData = ByteBuffer.allocateDirect(4 * w2 * h2);
        this.numFrames = h2;
        this.currentFrame = -1;
        this.delegate = new Tile(minScrollDelay, maxScrollDelay);
    }

    void update() {
        if (--this.currentDelay > 0) {
            return;
        }
        if (++this.currentFrame >= this.numFrames) {
            this.currentFrame = 0;
        }
        for (int i2 = 0; i2 < this.tileCount; ++i2) {
            for (int j2 = 0; j2 < this.tileCount; ++j2) {
                this.delegate.update(i2 * this.w, j2 * this.h);
            }
        }
        this.currentDelay = this.delegate.getDelay();
    }

    static void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i2 = 0; i2 < src.length; ++i2) {
            int v2 = src[i2];
            dest[i2 * 4 + 3] = (byte)(v2 >> 24 & 0xFF);
            dest[i2 * 4 + 0] = (byte)(v2 >> 16 & 0xFF);
            dest[i2 * 4 + 1] = (byte)(v2 >> 8 & 0xFF);
            dest[i2 * 4 + 2] = (byte)(v2 >> 0 & 0xFF);
        }
    }

    private class Strip
    implements Delegate {
        private int[] tileOrder;
        private int[] tileDelay;
        private final int numTiles;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Strip(Properties properties) {
            this.numTiles = CustomAnimation.this.numFrames;
            InputStream inputStream = null;
            if (properties == null) {
                block5: {
                    try {
                        inputStream = TextureUtils.getResourceAsStream(CustomAnimation.this.srcName.replaceFirst("\\.png$", ".properties"));
                        if (inputStream == null) break block5;
                        properties = new Properties();
                        properties.load(inputStream);
                    }
                    catch (IOException e2) {
                        try {
                            e2.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            MCPatcherUtils.close(inputStream);
                            throw throwable;
                        }
                        MCPatcherUtils.close(inputStream);
                    }
                }
                MCPatcherUtils.close(inputStream);
            }
            this.loadProperties(properties);
        }

        private void loadProperties(Properties properties) {
            int i2;
            this.loadTileOrder(properties);
            if (this.tileOrder == null) {
                this.tileOrder = new int[CustomAnimation.this.numFrames];
                for (i2 = 0; i2 < CustomAnimation.this.numFrames; ++i2) {
                    this.tileOrder[i2] = i2 % this.numTiles;
                }
            }
            this.tileDelay = new int[CustomAnimation.this.numFrames];
            this.loadTileDelay(properties);
            for (i2 = 0; i2 < CustomAnimation.this.numFrames; ++i2) {
                this.tileDelay[i2] = Math.max(this.tileDelay[i2], 1);
            }
        }

        private void loadTileOrder(Properties properties) {
            if (properties == null) {
                return;
            }
            int i2 = 0;
            while (this.getIntValue(properties, "tile.", i2) != null) {
                ++i2;
            }
            if (i2 > 0) {
                CustomAnimation.this.numFrames = i2;
                this.tileOrder = new int[CustomAnimation.this.numFrames];
                for (i2 = 0; i2 < CustomAnimation.this.numFrames; ++i2) {
                    this.tileOrder[i2] = Math.abs(this.getIntValue(properties, "tile.", i2)) % this.numTiles;
                }
            }
        }

        private void loadTileDelay(Properties properties) {
            if (properties == null) {
                return;
            }
            Integer defaultValue = this.getIntValue(properties, "duration");
            for (int i2 = 0; i2 < CustomAnimation.this.numFrames; ++i2) {
                Integer value = this.getIntValue(properties, "duration.", i2);
                if (value != null) {
                    this.tileDelay[i2] = value;
                    continue;
                }
                if (defaultValue == null) continue;
                this.tileDelay[i2] = defaultValue;
            }
        }

        private Integer getIntValue(Properties properties, String key) {
            try {
                String value = properties.getProperty(key);
                if (value != null && value.matches("^\\d+$")) {
                    return Integer.parseInt(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        private Integer getIntValue(Properties properties, String prefix, int index) {
            return this.getIntValue(properties, prefix + index);
        }

        public void update(int dx2, int dy2) {
            GL11.glBindTexture((int)3553, (int)CustomAnimation.this.textureID);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx2), (int)(CustomAnimation.this.y + dy2), (int)CustomAnimation.this.w, (int)CustomAnimation.this.h, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(4 * CustomAnimation.this.w * CustomAnimation.this.h * this.tileOrder[CustomAnimation.this.currentFrame])));
        }

        public int getDelay() {
            return this.tileDelay[CustomAnimation.this.currentFrame];
        }
    }

    private class Tile
    implements Delegate {
        private final int minScrollDelay;
        private final int maxScrollDelay;
        private final boolean isScrolling;

        Tile(int minScrollDelay, int maxScrollDelay) throws IOException {
            this.minScrollDelay = minScrollDelay;
            this.maxScrollDelay = maxScrollDelay;
            this.isScrolling = this.minScrollDelay >= 0;
            BufferedImage tiles = TextureUtils.getResourceAsBufferedImage(CustomAnimation.this.textureName);
            int[] rgbInt = new int[CustomAnimation.this.w * CustomAnimation.this.h];
            byte[] rgbByte = new byte[4 * CustomAnimation.this.w * CustomAnimation.this.h];
            tiles.getRGB(CustomAnimation.this.x, CustomAnimation.this.y, CustomAnimation.this.w, CustomAnimation.this.h, rgbInt, 0, CustomAnimation.this.w);
            CustomAnimation.ARGBtoRGBA(rgbInt, rgbByte);
            CustomAnimation.this.imageData.put(rgbByte);
        }

        public void update(int dx2, int dy2) {
            if (this.isScrolling) {
                GL11.glBindTexture((int)3553, (int)CustomAnimation.this.textureID);
                int rowOffset = CustomAnimation.this.h - CustomAnimation.this.currentFrame;
                GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx2), (int)(CustomAnimation.this.y + dy2 + CustomAnimation.this.h - rowOffset), (int)CustomAnimation.this.w, (int)rowOffset, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(0)));
                GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx2), (int)(CustomAnimation.this.y + dy2), (int)CustomAnimation.this.w, (int)(CustomAnimation.this.h - rowOffset), (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(4 * CustomAnimation.this.w * rowOffset)));
            }
        }

        public int getDelay() {
            if (this.maxScrollDelay > 0) {
                return rand.nextInt(this.maxScrollDelay - this.minScrollDelay + 1) + this.minScrollDelay;
            }
            return 0;
        }
    }

    private static interface Delegate {
        public void update(int var1, int var2);

        public int getDelay();
    }
}

