/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.BiomeHelper;
import com.pclewis.mcpatcher.mod.Colorizer;

final class ColorMap {
    private static final int COLORMAP_SIZE = 256;
    private static final float COLORMAP_SCALE = 255.0f;
    private int[] map;
    private int mapDefault;

    static int getX(double temperature, double rainfall) {
        return (int)(255.0 * (1.0 - Colorizer.clamp(temperature)));
    }

    static int getY(double temperature, double rainfall) {
        return (int)(255.0 * (1.0 - Colorizer.clamp(rainfall) * Colorizer.clamp(temperature)));
    }

    static float getBlockMetaKey(int blockID, int metadata) {
        return (float)blockID + (float)(metadata & 0xFF) / 256.0f;
    }

    ColorMap(boolean useCustom, String filename, int defaultColor) {
        this.mapDefault = defaultColor;
        if (!useCustom) {
            return;
        }
        this.map = MCPatcherUtils.getImageRGB(MCPatcherUtils.readImage(Colorizer.lastTexturePack.a(filename)));
        if (this.map == null) {
            return;
        }
        if (this.map.length != 65536) {
            MCPatcherUtils.error("%s must be %dx%d", filename, 256, 256);
            this.map = null;
            return;
        }
        this.mapDefault = this.colorize(0xFFFFFF, 0.5, 1.0);
        MCPatcherUtils.debug("using %s, default color %06x", filename, this.mapDefault);
    }

    boolean isCustom() {
        return this.map != null;
    }

    void clear() {
        this.map = null;
    }

    int colorize() {
        return this.mapDefault;
    }

    int colorize(int defaultColor) {
        return this.map == null ? defaultColor : this.mapDefault;
    }

    int colorize(int defaultColor, double temperature, double rainfall) {
        if (this.map == null) {
            return defaultColor;
        }
        return this.map[256 * ColorMap.getY(temperature, rainfall) + ColorMap.getX(temperature, rainfall)];
    }

    int colorize(int defaultColor, int i2, int j2, int k2) {
        return this.colorize(defaultColor, BiomeHelper.instance.getTemperature(i2, j2, k2), BiomeHelper.instance.getRainfall(i2, j2, k2));
    }
}

